/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aifs.business.picknumber;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.aifs.business.picknumber.BalanceQueryParam;

public class GlPickNumber {
    private static final Log logger = LogFactory.getLog(GlPickNumber.class);

    public Map<String, Object> SearchData(Map<String, Object> parameters) {
        String qData;
        int begindate;
        QFilter f2;
        List queryData = null;
        HashMap<String, Object> backData = new HashMap<String, Object>();
        int year = (Integer)parameters.get("year");
        int period = (Integer)parameters.get("period");
        String orgId = String.valueOf(parameters.get("entity"));
        long accountTableId = Long.parseLong(String.valueOf(parameters.get("accounttable_id")));
        long currencyId = Long.parseLong(String.valueOf(parameters.get("currencyfield_id")));
        long accountId = Long.parseLong(String.valueOf(parameters.get("accountfield_id")));
        String[] fetch = this.matchFetchType(String.valueOf(parameters.get("fetchType")));
        String asstactType = String.valueOf(parameters.get("flexfield"));
        String asstactString = String.valueOf(parameters.get("asstact"));
        long asstact = 0L;
        if (asstactString != null && asstactString.length() > 0 && !asstactString.equals("null")) {
            asstact = Long.parseLong(asstactString);
        }
        String fetchType = fetch[0];
        String fetchField = fetch[1];
        String currencyNumber = this.getCurrencyNumberByid(currencyId);
        QFilter f1 = new QFilter("org.id", "=", (Object)Long.parseLong(orgId));
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"basecurrency.id,basecurrency.name,periodType,bookstype.id,accounttable.id,accounttable.masterid,startperiod.number begindate,startperiod.id beginperiodId,isbizunit", (QFilter[])new QFilter[]{f1, f2 = new QFilter("bookstype.accounttype", "=", (Object)"1")});
        if (book == null) {
            throw new KDBizException(String.format("AIFS%s", ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u8d26\u7c3f", (String)"GlPickNumber_0", (String)"fi-aifs-business", (Object[])new Object[0])));
        }
        int queryPeriod = year * 100 + period;
        Boolean isbizunit = book.getBoolean("isbizunit");
        if (isbizunit.booleanValue()) {
            begindate = Integer.parseInt((String)book.get("begindate"));
        } else {
            QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)book.getLong("periodType"));
            DynamicObjectCollection periodGL = QueryServiceHelper.query((String)"bd_period", (String)"number", (QFilter[])new QFilter[]{periodTypeFilter}, (String)"number");
            String earlyPeriod = ((DynamicObject)periodGL.get(0)).getString("number");
            begindate = Integer.parseInt(earlyPeriod);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        int nowData = Integer.parseInt(df.format(new Date()));
        if (queryPeriod < begindate) {
            throw new KDBizException(String.format("AIFS%s", ResManager.loadKDString((String)"\u67e5\u8be2\u671f\u95f4\u65e9\u4e8e\u542f\u7528\u671f\u95f4", (String)"GlPickNumber_1", (String)"fi-aifs-business", (Object[])new Object[0])));
        }
        if (queryPeriod > nowData) {
            throw new KDBizException(String.format("AIFS%s", ResManager.loadKDString((String)"\u67e5\u8be2\u671f\u95f4\u5927\u4e8e\u542f\u7528\u5f53\u524d\u7cfb\u7edf\u671f\u95f4", (String)"GlPickNumber_2", (String)"fi-aifs-business", (Object[])new Object[0])));
        }
        DynamicObject periodGL = this.getPeriodByYearAndMon(year, period, book.getLong("periodtype"));
        if (periodGL == null) {
            throw new KDBizException(String.format("AIFS%s%s%s%s%s", year, ResManager.loadKDString((String)"\u5e74", (String)"GlPickNumber_3", (String)"fi-aifs-business", (Object[])new Object[0]), period, ResManager.loadKDString((String)"\u6708", (String)"GlPickNumber_4", (String)"fi-aifs-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u540e\u518d\u67e5\u8be2", (String)"GlPickNumber_5", (String)"fi-aifs-business", (Object[])new Object[0])));
        }
        BalanceQueryParam param = new BalanceQueryParam();
        param.setBookTypeId(book.getLong("bookstype.id"));
        param.setCurrencyId(currencyId);
        param.setOrgId(Long.parseLong((String)parameters.get("entity")));
        param.setPeriodId(periodGL.getLong("id"));
        param.addSelector(fetchField);
        param.setAccountTableId(accountTableId);
        param.addGroupBy("account");
        if (fetchType.equals("FS") || fetchType.equals("LJ")) {
            param.addGroupBy("account.dc dc");
        }
        ArrayList<Map<String, Long>> assgrp = new ArrayList<Map<String, Long>>();
        if (asstactType != null && asstactType.length() > 0 && !asstactType.equals("null")) {
            HashMap<String, Long> ass = new HashMap<String, Long>();
            ass.put(asstactType, asstact);
            assgrp.add(ass);
        }
        param.setAccountAssgrp(accountId, assgrp);
        if (!isbizunit.booleanValue()) {
            List<Long> list = this.getChildOrgId("10", this.getOrgViewId(), param.getOrgId());
            param.setOrgIds(list.stream().mapToLong(Long::longValue).toArray());
        }
        if ((qData = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{param.toString()})) != null && !qData.equals("null") && !qData.equals("[]")) {
            try {
                queryData = (List)JSONUtils.cast((String)qData, List.class);
            }
            catch (IOException e) {
                throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            Double data = Double.valueOf(((Map)queryData.get(0)).get(fetchField).toString());
            BigDecimal dd = BigDecimal.valueOf(data);
            if (dd.compareTo(BigDecimal.ZERO) != 0) {
                backData.put("data", dd);
                backData.put("currency", currencyNumber);
            }
        }
        logger.info("GlPickNumber.SearchData param: " + ((Object)backData).toString());
        return backData;
    }

    public String[] matchFetchType(String value) {
        String fetchType = null;
        String fetFiled = null;
        switch (value) {
            case "1": {
                fetchType = "JF";
                fetFiled = "debitlocal";
                break;
            }
            case "2": {
                fetchType = "DF";
                fetFiled = "creditlocal";
                break;
            }
            case "3": {
                fetchType = "JL";
                fetFiled = "yeardebitlocal";
                break;
            }
            case "4": {
                fetchType = "DL";
                fetFiled = "yearcreditlocal";
                break;
            }
            case "5": {
                fetchType = "C";
                fetFiled = "beginlocal";
                break;
            }
            case "6": {
                fetchType = "Y";
                fetFiled = "endlocal";
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"AIFS\u4e0d\u5b58\u5728\u8be5\u53d6\u6570\u7c7b\u578b", (String)"GlPickNumber_6", (String)"fi-aifs-business", (Object[])new Object[0]));
            }
        }
        return new String[]{fetchType, fetFiled};
    }

    public List<String> getAccountItem(long accounttable, String accountNum) {
        ArrayList<String> list = new ArrayList<String>();
        QFilter acTableFilter = new QFilter("accounttable.id", "=", (Object)accounttable);
        QFilter acNumberFilter = new QFilter("number", "=", (Object)accountNum);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,name,masterid", (QFilter[])new QFilter[]{acNumberFilter, acTableFilter});
        if (accounts == null) {
            throw new KDBizException(ResManager.loadKDString((String)"AIFS\u8be5\u79d1\u76ee\u5c1a\u672a\u8bbe\u7f6e", (String)"GlPickNumber_7", (String)"fi-aifs-business", (Object[])new Object[0]));
        }
        for (DynamicObject dyn : accounts) {
            if (list.contains(dyn.getString("masterid"))) continue;
            list.add(dyn.getString("masterid"));
        }
        return list;
    }

    private DynamicObject getPeriodByYearAndMon(int year, int month, Long periodType) {
        QFilter fyFilter = new QFilter("periodyear", "=", (Object)year);
        QFilter periodFilter = new QFilter("periodnumber", "=", (Object)month);
        QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObject periodGL = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fyFilter, periodFilter, periodTypeFilter});
        return periodGL;
    }

    public String getCurrencyNumberByid(long currencyId) {
        QFilter idf = new QFilter("id", "=", (Object)currencyId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_currency", (String)"number", (QFilter[])new QFilter[]{idf});
        return dyn.getString("number");
    }

    public List<Long> getChildOrgId(String ovType, long iOrgViewId, long parentid) {
        ArrayList<Long> childOrgs = new ArrayList<Long>();
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter fovType = new QFilter("view.treetype", "=", (Object)"10");
        QFilter fisdefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter fparentId = new QFilter("parent", "=", (Object)parentid);
        DynamicObjectCollection orgids = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id id", (QFilter[])new QFilter[]{fovType, fparentId, freezeFilter, fisdefault});
        for (DynamicObject orgid : orgids) {
            childOrgs.add(orgid.getLong("id"));
            List<Long> children = this.getChildOrgId(ovType, iOrgViewId, orgid.getLong("id"));
            if (children == null || children.size() <= 0) continue;
            childOrgs.addAll(children);
        }
        return childOrgs;
    }

    public Long getOrgViewId() {
        QFilter defaultFilter = new QFilter("isdefault", "=", (Object)"1");
        QFilter treetypeFilter = new QFilter("treetype", "=", (Object)"10");
        DynamicObjectCollection dyncll = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id", (QFilter[])new QFilter[]{defaultFilter, treetypeFilter});
        return (Long)((DynamicObject)dyncll.get(0)).get("id");
    }

    public boolean isEntityOrg(Long orgId) {
        return true;
    }
}

