/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.service.EditInBulkService;

public class ApEditInBulkService
extends EditInBulkService {
    public ApEditInBulkService(IFormView parentView, String pluginName) {
        super(parentView, pluginName);
    }

    public ApEditInBulkService(IFormView view) {
        super(view);
    }

    public void returnParent(DynamicObjectCollection returnEntrys, Map<String, List<Integer>> srcEntryRowMap) {
        super.returnParent(returnEntrys, srcEntryRowMap);
        IDataModel parentModel = this.parentView.getModel();
        boolean includeTax = (Boolean)parentModel.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)parentModel.getValue("currency");
        int precision = currency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)parentModel.getValue("exchangerate");
        String quotation = (String)parentModel.getValue("quotation");
        if (rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        DynamicObject basecurrency = (DynamicObject)parentModel.getValue("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal taxlocalamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        for (int row = 0; row < returnEntrys.size(); ++row) {
            DynamicObject returnEntry = (DynamicObject)returnEntrys.get(row);
            if (!returnEntry.getBoolean("e_ischange")) continue;
            BigDecimal newtax = returnEntry.getBigDecimal("e_tax");
            BigDecimal newamount = returnEntry.getBigDecimal("e_amount");
            BigDecimal newpricetaxtotal = returnEntry.getBigDecimal("e_pricetaxtotal");
            tax = tax.add(newtax);
            amount = amount.add(newamount);
            pricetaxtotal = pricetaxtotal.add(newpricetaxtotal);
            String key = returnEntry.getString("e_key");
            List<Integer> srcEntryRowList = srcEntryRowMap.get(key);
            for (int i = srcEntryRowList.size() - 1; i >= 0; --i) {
                DynamicObject parentEntry = (DynamicObject)this.parentEntrys.get(srcEntryRowList.get(i).intValue());
                BigDecimal qty = parentEntry.getBigDecimal("quantity");
                BigDecimal unitPrice = returnEntry.getBigDecimal("e_unitprice");
                BigDecimal taxRate = returnEntry.getBigDecimal("e_taxrate");
                BigDecimal taxUnitPrice = returnEntry.getBigDecimal("e_taxunitprice");
                String discountMode = returnEntry.getString("e_discountmode");
                BigDecimal discountRate = returnEntry.getBigDecimal("e_discountrate");
                BigDecimal e_newTax = parentEntry.getBigDecimal("e_tax");
                BigDecimal e_newTaxLocAmt = parentEntry.getBigDecimal("e_taxlocalamt");
                BigDecimal e_newAmount = parentEntry.getBigDecimal("e_amount");
                BigDecimal e_newLocalAmt = parentEntry.getBigDecimal("e_amountbase");
                BigDecimal e_newPricetaxtotal = parentEntry.getBigDecimal("e_pricetaxtotal");
                BigDecimal e_newPricetaxtotalbase = parentEntry.getBigDecimal("e_pricetaxtotalbase");
                tax = tax.subtract(e_newTax);
                amount = amount.subtract(e_newAmount);
                localamt = localamt.subtract(e_newLocalAmt);
                pricetaxtotal = pricetaxtotal.subtract(e_newPricetaxtotal);
                taxlocalamt = taxlocalamt.subtract(e_newTaxLocAmt);
                pricetaxtotalbase = pricetaxtotalbase.subtract(e_newPricetaxtotalbase);
                if (unitPrice.compareTo(parentEntry.getBigDecimal("price")) == 0 && taxRate.compareTo(parentEntry.getBigDecimal("taxrate")) == 0 && taxUnitPrice.compareTo(parentEntry.getBigDecimal("pricetax")) == 0 && discountMode.equals(parentEntry.getString("discountmode")) && discountRate.compareTo(parentEntry.getBigDecimal("discountrate")) == 0) {
                    if (i == 0) {
                        parentEntry.set("e_tax", (Object)newtax);
                        parentEntry.set("e_amount", (Object)newamount);
                        parentEntry.set("e_unverifyamount", (Object)newamount);
                        if ("1".equals(quotation)) {
                            e_newLocalAmt = newamount.divide(rate, localprecision, RoundingMode.HALF_UP);
                            e_newTaxLocAmt = newtax.divide(rate, localprecision, RoundingMode.HALF_UP);
                            e_newPricetaxtotalbase = newpricetaxtotal.divide(rate, localprecision, RoundingMode.HALF_UP);
                        } else {
                            e_newLocalAmt = newamount.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                            e_newTaxLocAmt = newtax.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                            e_newPricetaxtotalbase = newpricetaxtotal.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                        }
                        parentEntry.set("e_amountbase", (Object)e_newLocalAmt);
                        parentEntry.set("e_taxlocalamt", (Object)e_newTaxLocAmt);
                        parentEntry.set("e_pricetaxtotal", (Object)newpricetaxtotal);
                        parentEntry.set("unsettleamt", (Object)newpricetaxtotal);
                        parentEntry.set("unlockamt", (Object)newpricetaxtotal);
                        parentEntry.set("e_pricetaxtotalbase", (Object)e_newPricetaxtotalbase);
                        parentEntry.set("unsettleamtbase", (Object)e_newPricetaxtotalbase);
                        parentEntry.set("e_uninvoicedamt", (Object)newpricetaxtotal);
                    } else {
                        newtax = newtax.subtract(e_newTax);
                        newamount = newamount.subtract(e_newAmount);
                        newpricetaxtotal = newpricetaxtotal.subtract(e_newPricetaxtotal);
                    }
                } else {
                    Object calculator = null;
                    calculator = includeTax ? new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision) : new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
                    PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
                    localCalculator.calculate();
                    parentEntry.set("price", (Object)unitPrice);
                    parentEntry.set("pricetax", (Object)taxUnitPrice);
                    parentEntry.set("taxrateid", (Object)returnEntry.getDynamicObject("e_taxrateid"));
                    parentEntry.set("taxrate", (Object)taxRate);
                    parentEntry.set("discountmode", (Object)discountMode);
                    parentEntry.set("discountrate", (Object)discountRate);
                    parentEntry.set("actprice", (Object)localCalculator.getActunitprice());
                    parentEntry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
                    parentEntry.set("discountamount", (Object)localCalculator.getDiscountamount());
                    parentEntry.set("discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                    e_newTax = localCalculator.getTax();
                    e_newTaxLocAmt = localCalculator.getTaxlocal();
                    e_newAmount = localCalculator.getAmount();
                    e_newLocalAmt = localCalculator.getAmountlocal();
                    e_newPricetaxtotal = localCalculator.getPricetaxtotal();
                    e_newPricetaxtotalbase = localCalculator.getPricetaxtotallocal();
                    if (i == 0) {
                        e_newTax = newtax;
                        e_newAmount = newamount;
                        e_newPricetaxtotal = newpricetaxtotal;
                        if ("1".equals(quotation)) {
                            e_newLocalAmt = e_newLocalAmt.divide(rate, localprecision, RoundingMode.HALF_UP);
                            e_newTaxLocAmt = e_newTax.divide(rate, localprecision, RoundingMode.HALF_UP);
                            e_newPricetaxtotalbase = e_newPricetaxtotal.divide(rate, localprecision, RoundingMode.HALF_UP);
                        } else {
                            e_newLocalAmt = e_newAmount.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                            e_newTaxLocAmt = e_newTax.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                            e_newPricetaxtotalbase = e_newPricetaxtotal.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                        }
                    } else {
                        newtax = newtax.subtract(e_newTax);
                        newamount = newamount.subtract(e_newAmount);
                        newpricetaxtotal = newpricetaxtotal.subtract(e_newPricetaxtotal);
                    }
                    parentEntry.set("e_tax", (Object)e_newTax);
                    parentEntry.set("e_amount", (Object)e_newAmount);
                    parentEntry.set("e_unverifyamount", (Object)e_newAmount);
                    parentEntry.set("e_amountbase", (Object)e_newLocalAmt);
                    parentEntry.set("e_taxlocalamt", (Object)e_newTaxLocAmt);
                    parentEntry.set("e_pricetaxtotal", (Object)e_newPricetaxtotal);
                    parentEntry.set("unsettleamt", (Object)e_newPricetaxtotal);
                    parentEntry.set("unlockamt", (Object)e_newPricetaxtotal);
                    parentEntry.set("e_pricetaxtotalbase", (Object)e_newPricetaxtotalbase);
                    parentEntry.set("unsettleamtbase", (Object)e_newPricetaxtotalbase);
                    parentEntry.set("e_uninvoicedamt", (Object)e_newPricetaxtotal);
                }
                localamt = localamt.add(e_newLocalAmt);
                taxlocalamt = taxlocalamt.add(e_newTaxLocAmt);
                pricetaxtotalbase = pricetaxtotalbase.add(e_newPricetaxtotalbase);
            }
        }
        parentModel.beginInit();
        parentModel.setValue("tax", (Object)tax.add((BigDecimal)parentModel.getValue("tax")));
        BigDecimal newamount = amount.add((BigDecimal)parentModel.getValue("amount"));
        parentModel.setValue("amount", (Object)newamount);
        parentModel.setValue("unverifyamount", (Object)newamount);
        parentModel.setValue("amountbase", (Object)localamt.add((BigDecimal)parentModel.getValue("amountbase")));
        parentModel.setValue("taxlocamt", (Object)taxlocalamt.add((BigDecimal)parentModel.getValue("taxlocamt")));
        BigDecimal newpricetaxtotal = pricetaxtotal.add((BigDecimal)parentModel.getValue("pricetaxtotal"));
        parentModel.setValue("unsettleamount", (Object)newpricetaxtotal);
        BigDecimal newpricetaxtotalbase = pricetaxtotalbase.add((BigDecimal)parentModel.getValue("pricetaxtotalbase"));
        parentModel.setValue("pricetaxtotalbase", (Object)newpricetaxtotalbase);
        parentModel.setValue("unsettleamountbase", (Object)newpricetaxtotalbase);
        parentModel.setValue("uninvoicedamt", (Object)newpricetaxtotal);
        parentModel.endInit();
        parentModel.setValue("pricetaxtotal", (Object)newpricetaxtotal);
    }
}

