/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.ap.business.invoice.Invoice4CloudResolveService;
import kd.fi.ap.business.invoice.articulate.IInvoiceArticulateService;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.business.pojo.InvoiceArticulateBillParam;
import kd.fi.ap.business.pojo.InvoiceArticulateContext;
import kd.fi.ap.business.pojo.InvoiceResolveParam;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.util.ErStdConfig;

public class CoordinationInvoiceService {
    private static final Log logger = LogFactory.getLog(CoordinationInvoiceService.class);
    private static final String RIGHT_STATUS = "0";
    private static final String CANCEL_STATUS = "6";
    private static final String REDROCK_STATUS = "3";

    public void coordinationInvoice(Map<String, Object> coordinateParam) {
        if (ObjectUtils.isEmpty(coordinateParam)) {
            return;
        }
        logger.info("CoordinationInvoiceService coordinationInvoice begin, coordinateParam is :" + coordinateParam);
        try (TXHandle tx = TX.required((String)"ap_invoice_coordination");){
            try {
                Object invoiceStatus = coordinateParam.get("invoicestatus");
                logger.info("CoordinationInvoiceService coordinationInvoice invoiceStatus is : " + invoiceStatus);
                if (RIGHT_STATUS.equals(invoiceStatus)) {
                    this.issueInvoice(coordinateParam);
                } else if (CANCEL_STATUS.equals(invoiceStatus) || REDROCK_STATUS.equals(invoiceStatus)) {
                    this.writeOffInv(coordinateParam);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        logger.info("CoordinationInvoiceService coordinationInvoice end. ");
    }

    public void articulate(List<Long> apBillIds) {
        logger.info("CoordinationInvoiceService articulate begin. ");
        if (ObjectUtils.isEmpty(apBillIds)) {
            return;
        }
        logger.info("CoordinationInvoiceService articulate apBillIds is" + apBillIds);
        Map<Long, Long> finAp4AdjustBillMap = this.getFinAp4AdjustBillMap(apBillIds);
        logger.info("CoordinationInvoiceService articulate finAp4AdjustBillMap is" + finAp4AdjustBillMap);
        if (ObjectUtils.isEmpty(finAp4AdjustBillMap)) {
            return;
        }
        this.adjustBillArticulate(finAp4AdjustBillMap);
        logger.info("CoordinationInvoiceService articulate end. ");
    }

    private void issueInvoice(Map<String, Object> coordinateParam) {
        logger.info("CoordinationInvoiceService coordinateInv begin. ");
        Long orgId = (Long)coordinateParam.get("orgid");
        boolean isCoorDinate = SystemParameterHelper.getAPBooleanParam((long)orgId, (String)"ap_023");
        logger.info("CoordinationInvoiceService coordinateInv isCoorDinate is : " + isCoorDinate);
        if (!isCoorDinate) {
            return;
        }
        String invoiceCloudXh = ErStdConfig.get((String)"invoicecloud.invoicecloudxh");
        logger.info("CoordinationInvoiceService issueInvoice invoicecloud.invoicecloudxh is : " + invoiceCloudXh);
        if (!"true".equals(invoiceCloudXh)) {
            return;
        }
        DynamicObject invoice = this.downloadInvoiceAndSave(coordinateParam);
        if (invoice == null) {
            this.downloadInvoiceSendMessage(coordinateParam);
            String invoiceCodeAndNoMessage = this.getInvoiceCodeAndNoMessage(coordinateParam.get("invoiceno"), coordinateParam.get("invoicecode"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fdb\u9879\u7968\u6c60\u4e0d\u5b58\u5728\u4ee5\u4e0b\u53d1\u7968\uff0c\u81ea\u52a8\u6536\u7968\u5931\u8d25\u3002%1$s\u3002", (String)"CoordinationInvoiceService_10", (String)"fi-ap-business", (Object[])new Object[0]), invoiceCodeAndNoMessage));
        }
        if (!RIGHT_STATUS.equals(invoice.getString("invoicestatus"))) {
            return;
        }
        String serialNo = invoice.getString("serialno");
        logger.info("CoordinationInvoiceService coordinateInv right status serialNo is : " + serialNo);
        this.coordination(coordinateParam, serialNo);
        logger.info("CoordinationInvoiceService coordinateInv end. ");
    }

    private void writeOffInv(Map<String, Object> coordinateParam) {
        logger.info("CoordinationInvoiceService writeOffInv begin. ");
        String invoiceCode = (String)coordinateParam.get("invoicecode");
        String invoiceNo = (String)coordinateParam.get("invoiceno");
        Object invoiceStatus = coordinateParam.get("invoicestatus");
        QFilter filter = new QFilter("invoicecode", "=", (Object)invoiceCode);
        filter.and("invoiceno", "=", (Object)invoiceNo);
        DynamicObject lockInvoice = QueryServiceHelper.queryOne((String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (lockInvoice == null) {
            return;
        }
        HashSet<Long> invoiceIds = new HashSet<Long>(2);
        invoiceIds.add(lockInvoice.getLong("id"));
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_invoice", (String)"ap_invoice_coordination_red", invoiceIds, (boolean)false);
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ap_invoice", (String)"org,id,invoicestatus,isreffin,businesssource,invoicecode,invoiceno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)lockInvoice.getLong("id"))});
        if (invoice == null) {
            return;
        }
        InvoiceHelper.updateInvoiceStatus((Long[])new Long[]{invoice.getLong("id")});
        List<DynamicObject> finApBills = this.getNeedProcessFinApBills(invoice);
        logger.info("CoordinationInvoiceService writeOffInv finApBills size is : " + finApBills.size());
        if (finApBills.isEmpty()) {
            return;
        }
        HashMap<Long, Set<Long>> bill4InvoiceMap = new HashMap<Long, Set<Long>>(8);
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            HashSet<Long> coorInvoiceIds = new HashSet<Long>(8);
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                if (invoice.getLong("id") != invId || !InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(invRow.getString("i_srctype"))) continue;
                coorInvoiceIds.add(invId);
            }
            if (coorInvoiceIds.isEmpty()) continue;
            bill4InvoiceMap.put(finApBill.getLong("id"), coorInvoiceIds);
        }
        logger.info("CoordinationInvoiceService writeOffInv bill4InvoiceMap is : " + bill4InvoiceMap);
        if (!bill4InvoiceMap.isEmpty()) {
            InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
            deleteParam.setBill4InvoiceMap(bill4InvoiceMap);
            IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
            deleteService.deleteInvoiceRow(deleteParam);
        }
        logger.info("CoordinationInvoiceService writeOffInv end. ");
    }

    private void adjustBillArticulate(Map<Long, Long> finAp4AdjustBillMap) {
        logger.info("CoordinationInvoiceService adjustBillArticulate begin. ");
        ArrayList<Long> allFinApBillIds = new ArrayList<Long>(32);
        allFinApBillIds.addAll(finAp4AdjustBillMap.keySet());
        allFinApBillIds.addAll(finAp4AdjustBillMap.values());
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,pricetaxtotal,i_srctype,invid,i_billno,i_invoicetypef7,i_invoicetype,i_invoicecode,i_invoiceno,i_invoicedate,i_pricetaxtotal,i_taxrate,i_tax,i_amount,i_asstactname,i_buyername,i_istaxdeduction,i_remark,i_issupplement,i_serialno,i_canuseamt,i_currency", (QFilter[])new QFilter[]{new QFilter("id", "in", allFinApBillIds)});
        Map finApBillMap = Arrays.stream(finApBills).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
        Map<Long, DynamicObject> invoiceMap = this.getCoordinateInvoiceMap(finApBills);
        ArrayList<InvoiceArticulateBillParam> finApParams = new ArrayList<InvoiceArticulateBillParam>(32);
        long[] accurateIds = DB.genGlobalLongIds((int)finApBills.length);
        int i = 0;
        ArrayList<DynamicObject> needAutoAssignBills = new ArrayList<DynamicObject>(8);
        ArrayList<Long> needAutoAssignBillIds = new ArrayList<Long>(8);
        for (Map.Entry<Long, Long> entrySet : finAp4AdjustBillMap.entrySet()) {
            DynamicObject invoice;
            Long finApBillId = entrySet.getKey();
            Long adjustBillId = entrySet.getValue();
            DynamicObject finApBill = (DynamicObject)finApBillMap.get(finApBillId);
            DynamicObject adjustBill = (DynamicObject)finApBillMap.get(adjustBillId);
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            long invId = 0L;
            for (DynamicObject invRow : invEntry) {
                if (!InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(invRow.getString("i_srctype"))) continue;
                invId = invRow.getLong("invid");
                break;
            }
            if ((invoice = invoiceMap.get(invId)) == null) continue;
            long accurateId = accurateIds[i++];
            if (finApBill.getBigDecimal("pricetaxtotal").signum() == adjustBill.getBigDecimal("pricetaxtotal").signum()) {
                this.finApInvEntrySetValue(adjustBill, invoice, invoice.getBigDecimal("pricetaxtotal"));
                needAutoAssignBills.add(adjustBill);
                needAutoAssignBillIds.add(adjustBillId);
                continue;
            }
            InvoiceArticulateBillParam blueFinApParam = new InvoiceArticulateBillParam();
            blueFinApParam.setBillId(finApBillId).setAccurateArticulateId(accurateId);
            finApParams.add(blueFinApParam);
            InvoiceArticulateBillParam redFinApParam = new InvoiceArticulateBillParam();
            redFinApParam.setBillId(adjustBillId).setAccurateArticulateId(accurateId);
            finApParams.add(redFinApParam);
        }
        logger.info("CoordinationInvoiceService adjustBillArticulate needAutoAssignBillIds is  : " + needAutoAssignBillIds);
        if (!needAutoAssignBills.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needAutoAssignBills.toArray(new DynamicObject[0]));
            OperateOption assginOption = OperateOption.create();
            assginOption.setVariableValue("invPks", "");
            OperationResult assignResult = OperationServiceHelper.executeOperate((String)"assign", (String)"ap_finapbill", (Object[])needAutoAssignBillIds.toArray(new Long[0]), (OperateOption)assginOption);
            OperationHelper.assertResult((OperationResult)assignResult);
        }
        logger.info("CoordinationInvoiceService adjustBillArticulate finApParams is  :  " + finApParams);
        if (!finApParams.isEmpty()) {
            InvoiceArticulateContext articulateContext = new InvoiceArticulateContext();
            articulateContext.setAccurateArticulate(true).setFilerOnlyApArticulate(false);
            IInvoiceArticulateService articulateService = (IInvoiceArticulateService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOICEARTICULATEFINAP.getValue());
            articulateService.articulate(articulateContext, new ArrayList<InvoiceArticulateBillParam>(2), finApParams);
        }
        logger.info("CoordinationInvoiceService adjustBillArticulate end. ");
    }

    private Map<Long, Long> getFinAp4AdjustBillMap(List<Long> apBillIds) {
        QFilter filter = new QFilter("sourcebillid", "in", apBillIds);
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("pricetaxtotal", "!=", (Object)BigDecimal.ZERO));
        filter.and(new QFilter("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue()));
        filter.and(new QFilter("sourcebilltype", "=", (Object)"ap_finapbill"));
        filter.and(QFilter.of((String)"pricetaxtotal = uninvoicedamt", (Object[])new Object[0]));
        DynamicObjectCollection adjustBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> finAp4AdjustBillMap = new HashMap<Long, Long>(16);
        for (DynamicObject adjustBill : adjustBills) {
            finAp4AdjustBillMap.put(adjustBill.getLong("sourcebillid"), adjustBill.getLong("id"));
        }
        return finAp4AdjustBillMap;
    }

    private Map<Long, DynamicObject> getCoordinateInvoiceMap(DynamicObject[] finApBills) {
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                if (!InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(invRow.getString("i_srctype"))) continue;
                invoiceIds.add(invRow.getLong("invid"));
            }
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"billno,invoicetype,invoicetypef7,invoicecode,invoiceno,issuedate,pricetaxtotal,tax,taxrate,amount,invoicetype,asstactname,buyername,istaxdeduction,remark,serialno,currency", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        return Arrays.stream(invoices).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
    }

    private List<DynamicObject> getNeedProcessFinApBills(DynamicObject invoice) {
        QFilter filter1 = new QFilter("org", "=", (Object)invoice.getLong("org.id"));
        filter1.and("inventry.i_srctype", "=", (Object)InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue());
        filter1.and("inventry.invid", "=", (Object)invoice.getLong("id"));
        filter1.and("billsrctype", "<>", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue());
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"sourcebilltype,billstatus,invid,i_srctype,creator,billno", (QFilter[])new QFilter[]{filter1});
        List finApBillIds = Arrays.stream(finApBills).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        QFilter filter2 = new QFilter("sourcebillid", "in", finApBillIds);
        filter2.and("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue());
        filter2.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection apAdjustBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"sourcebillid", (QFilter[])new QFilter[]{filter2});
        Set noNeedProcessFinApBillIds = apAdjustBills.stream().map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toSet());
        ArrayList<DynamicObject> needProcessFinApBills = new ArrayList<DynamicObject>(8);
        HashSet<Long> userIds = new HashSet<Long>(8);
        ArrayList<String> billNos = new ArrayList<String>(8);
        for (DynamicObject finApBill : finApBills) {
            if (noNeedProcessFinApBillIds.contains(finApBill.getLong("id"))) continue;
            if ("A".equals(finApBill.getString("billstatus"))) {
                needProcessFinApBills.add(finApBill);
            }
            userIds.add(finApBill.getLong("creator.id"));
            billNos.add(finApBill.getString("billno"));
        }
        if (!userIds.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u53d1\u7968\u7ea2\u51b2/\u4f5c\u5e9f\u63d0\u9192", (String)"CoordinationInvoiceService_8", (String)"fi-ap-business", (Object[])new Object[0]);
            String invoiceCodeAndNoMessage = this.getInvoiceCodeAndNoMessage(invoice.getString("invoiceno"), invoice.getString("invoicecode"));
            String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\u3002\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u5173\u8054\u7684\u53d1\u7968\uff08%2$s\uff09\u5df2\u88ab\u7ea2\u51b2\uff08\u6216\u4f5c\u5e9f\uff09\u3002\u8bf7\u5173\u6ce8\u8d22\u52a1\u5e94\u4ed8\u5355\u662f\u5426\u9700\u8981\u8865\u7968\u3002", (String)"CoordinationInvoiceService_9", (String)"fi-ap-business", (Object[])new Object[0]), String.join((CharSequence)",", billNos), invoiceCodeAndNoMessage);
            this.sendMCMessage(title, content, new ArrayList<Long>(userIds));
        }
        return needProcessFinApBills;
    }

    private void coordination(Map<String, Object> coordinateParam, String serialNo) {
        logger.info("CoordinationInvoiceService coordination begin");
        DynamicObject lockInvoice = QueryServiceHelper.queryOne((String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{new QFilter("serialno", "=", (Object)serialNo)});
        if (lockInvoice == null) {
            return;
        }
        HashSet<Long> invoiceIds = new HashSet<Long>(2);
        invoiceIds.add(lockInvoice.getLong("id"));
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_invoice", (String)"ap_invoice_coordination_right", invoiceIds, (boolean)false);
        DynamicObject invoice = this.getInvoices(serialNo);
        Tuple<Map<Long, List<Map<String, Object>>>, Map<Long, BigDecimal>> tuple = this.constructCoordinationMap(invoice);
        logger.info("CoordinationInvoiceService coordination tuple is : " + tuple);
        if (tuple == null) {
            return;
        }
        Map invoiceEntryCoreInfoMap = (Map)tuple.item1;
        Map finAr4ApInvoiceAmtMap = (Map)tuple.item2;
        Map<Long, BigDecimal> finAp4InvoiceAmtMap = this.getFinAp4InvoiceAmtMap(finAr4ApInvoiceAmtMap, invoice);
        logger.info("CoordinationInvoiceService coordination finAp4InvoiceAmtMap is : " + finAp4InvoiceAmtMap);
        this.writeBackFinApAndInvoice(finAp4InvoiceAmtMap, invoiceEntryCoreInfoMap, invoice, coordinateParam);
        this.articulate(new ArrayList<Long>(finAp4InvoiceAmtMap.keySet()));
        logger.info("CoordinationInvoiceService coordination end");
    }

    private void writeBackFinApAndInvoice(Map<Long, BigDecimal> finAp4InvoiceAmtMap, Map<Long, List<Map<String, Object>>> invoiceEntryCoreInfoMap, DynamicObject invoice, Map<String, Object> coordinateParam) {
        logger.info("CoordinationInvoiceService writeBackFinApAndInvoice begin");
        Tuple<List<Long>, Boolean> tuple = this.writeBackFinApAndSendMessage(finAp4InvoiceAmtMap, invoice, coordinateParam);
        logger.info("CoordinationInvoiceService writeBackFinApAndInvoice needAssignFinApIds is : " + tuple);
        this.writeBackInvoice(invoiceEntryCoreInfoMap, invoice);
        this.executeBillOperate(tuple, invoice.getLong("id"));
        logger.info("CoordinationInvoiceService writeBackFinApAndInvoice end");
    }

    private Map<Long, BigDecimal> getFinAp4InvoiceAmtMap(Map<Long, BigDecimal> finAr4ApInvoiceAmtMap, DynamicObject invoice) {
        logger.info("CoordinationInvoiceService getFinAp4InvoiceAmtMap begin ");
        HashMap<Long, BigDecimal> finAp4InvoiceAmtMap = new HashMap<Long, BigDecimal>(8);
        long orgId = invoice.getLong("org.id");
        ArrayList<Long> finArBillIds = new ArrayList<Long>(finAr4ApInvoiceAmtMap.keySet());
        QFilter filter = new QFilter("sourcebillid", "in", finArBillIds);
        filter.and(new QFilter("relationpay", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("org", "=", (Object)orgId));
        filter.and(new QFilter("sourcebilltype", "=", (Object)"ar_finarbill"));
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"quer_coor_finap", (String)"ap_finapbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter}, (String)"");
        for (Row finApRow : finApDataSet) {
            Long finArBillId = finApRow.getLong("sourcebillid");
            BigDecimal canUseAmt = finAr4ApInvoiceAmtMap.get(finArBillId);
            if (canUseAmt == null) continue;
            finArBillIds.remove(finArBillId);
            finAp4InvoiceAmtMap.put(finApRow.getLong("id"), canUseAmt);
        }
        logger.info("CoordinationInvoiceService getFinAp4InvoiceAmtMap finArBillIds is : " + finArBillIds);
        if (finArBillIds.isEmpty()) {
            return finAp4InvoiceAmtMap;
        }
        QFilter filter1 = new QFilter("id", "in", finArBillIds);
        filter1.and(new QFilter("relationpay", "=", (Object)Boolean.TRUE));
        filter1.and(new QFilter("sourcebilltype", "=", (Object)"ap_finapbill"));
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar", (String)"ar_finarbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter1}, (String)"");
        HashMap<Long, Long> finAp4FinArIdMap = new HashMap<Long, Long>(8);
        for (Row finArRow : finArDataSet) {
            String sourceBillId = finArRow.getString("sourcebillid");
            if (ObjectUtils.isEmpty((Object)sourceBillId)) continue;
            finAp4FinArIdMap.put(Long.parseLong(sourceBillId), finArRow.getLong("id"));
        }
        logger.info("CoordinationInvoiceService getFinAp4InvoiceAmtMap finAp4FinArIdMap is : " + finAp4FinArIdMap);
        if (finAp4FinArIdMap.isEmpty()) {
            return finAp4InvoiceAmtMap;
        }
        QFilter filter2 = new QFilter("id", "in", finAp4FinArIdMap.keySet());
        filter2.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet finApDataSet1 = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter2}, (String)"");
        for (Row finApRow : finApDataSet1) {
            BigDecimal canUseAmt;
            Long finApBillId = finApRow.getLong("id");
            Long finArBillId = (Long)finAp4FinArIdMap.get(finApBillId);
            if (finArBillId == null || (canUseAmt = finAr4ApInvoiceAmtMap.get(finArBillId)) == null) continue;
            finAp4InvoiceAmtMap.put(finApBillId, canUseAmt);
        }
        logger.info("CoordinationInvoiceService getFinAp4InvoiceAmtMap end");
        return finAp4InvoiceAmtMap;
    }

    private void executeBillOperate(Tuple<List<Long>, Boolean> tuple, long invoiceId) {
        if (tuple == null) {
            return;
        }
        logger.info("CoordinationInvoiceService executeBillOperate begin");
        List needAssignFinApIds = (List)tuple.item1;
        Boolean isNeedAudit = (Boolean)tuple.item2;
        if (Boolean.TRUE.equals(isNeedAudit)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isreffin", "true");
            operateOption.setVariableValue("WF", "false");
            if (!ObjectUtils.isEmpty((Object)needAssignFinApIds)) {
                QFilter filter = new QFilter("id", "in", (Object)needAssignFinApIds);
                DynamicObject finApBill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"id,billno", (QFilter[])new QFilter[]{filter});
                if (finApBill != null) {
                    operateOption.setVariableValue("finBillno", finApBill.getString("billno"));
                }
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_invoice", (Object[])new Long[]{invoiceId}, (OperateOption)operateOption);
            OperationHelper.assertResult((OperationResult)result);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_invoice", (Object[])new Long[]{invoiceId}, (OperateOption)operateOption);
            OperationHelper.assertResult((OperationResult)auditResult);
        }
        if (!ObjectUtils.isEmpty((Object)needAssignFinApIds)) {
            OperateOption assginOption = OperateOption.create();
            assginOption.setVariableValue("invPks", "");
            OperationResult assignResult = OperationServiceHelper.executeOperate((String)"assign", (String)"ap_finapbill", (Object[])needAssignFinApIds.toArray(new Long[0]), (OperateOption)assginOption);
            OperationHelper.assertResult((OperationResult)assignResult);
        }
        logger.info("CoordinationInvoiceService executeBillOperate end");
    }

    private Tuple<List<Long>, Boolean> writeBackFinApAndSendMessage(Map<Long, BigDecimal> finAp4InvoiceAmtMap, DynamicObject invoice, Map<String, Object> coordinateParam) {
        logger.info("CoordinationInvoiceService writeBackFinApAndSendMessage begin");
        if (ObjectUtils.isEmpty(finAp4InvoiceAmtMap)) {
            return null;
        }
        String selectors = "id,billstatus,sourcebillid,asstact,inventry.invid,inventry.i_usedamt,inventry.i_billno,inventry.i_invoicetype,inventry.i_invoicetypef7,inventry.i_invoicecode,inventry.i_invoiceno,inventry.i_invoicedate,inventry.i_pricetaxtotal,inventry.i_taxrate,inventry.i_tax,inventry.i_amount,inventry.i_asstactname,inventry.i_buyername,inventry.i_istaxdeduction,inventry.i_remark,inventry.i_srctype,inventry.i_issupplement,inventry.i_serialno,inventry.i_canuseamt,inventry.i_currency,inventry.i_invoicestatus,org,invoicebiztype,istaxdeduction,iswrittenoff,ispremium,istanspay,e_amountbase,taxrate,e_farmproducts,e_pricetaxtotalbase,deductiblerate,basecurrency,curdeductibleamt,intercostamt,sourcebilltype,creator,uninvoicedamt,pricetaxtotal,billno,asstacttype,currency";
        Object[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", finAp4InvoiceAmtMap.keySet())});
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return null;
        }
        HashSet<Long> failInvUserIds = new HashSet<Long>(8);
        HashSet<String> failInvApBillNos = new HashSet<String>(8);
        ArrayList<Long> needAssignFinApIds = new ArrayList<Long>(8);
        String invoiceBillNo = invoice.getString("billno");
        for (Object finApBill : finApBills) {
            BigDecimal canUseAmt;
            long coorInvNumber;
            long creatorId = finApBill.getLong("creator.id");
            String billStatus = finApBill.getString("billstatus");
            String billNo = finApBill.getString("billno");
            boolean isArCoorAp = "ar_finarbill".equals(finApBill.getString("sourcebilltype"));
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            if (!invEntry.isEmpty() && (coorInvNumber = invEntry.stream().filter(invRow -> InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(invRow.getString("i_srctype"))).count()) != (long)invEntry.size()) {
                failInvUserIds.add(creatorId);
                failInvApBillNos.add(billNo);
                continue;
            }
            if (finApBill.getLong("currency.id") != invoice.getLong("currency.id")) {
                failInvUserIds.add(creatorId);
                failInvApBillNos.add(billNo);
                continue;
            }
            if (isArCoorAp) {
                if ("C".equals(billStatus)) {
                    failInvUserIds.add(creatorId);
                    failInvApBillNos.add(billNo);
                    continue;
                }
            } else if (!"C".equals(billStatus)) {
                failInvUserIds.add(creatorId);
                failInvApBillNos.add(billNo);
                continue;
            }
            if ((canUseAmt = finAp4InvoiceAmtMap.get(finApBill.getLong("id"))) == null) continue;
            this.finApInvEntrySetValue((DynamicObject)finApBill, invoice, canUseAmt);
            invoice.set("receivablessupp", (Object)finApBill.getDynamicObject("asstact"));
            invoice.set("asstacttype", (Object)finApBill.getString("asstacttype"));
            invoice.set("isreffin", (Object)Boolean.TRUE);
            invoice.set("businesssource", (Object)"ap_finapbill");
            if ("A".equals(billStatus)) continue;
            needAssignFinApIds.add(finApBill.getLong("id"));
        }
        Boolean isNeedAudit = Boolean.FALSE;
        if (finApBills.length > 1) {
            Set billStatusSet = Arrays.stream(finApBills).map(bill -> bill.getString("billstatus")).collect(Collectors.toSet());
            if (billStatusSet.contains("C") || billStatusSet.contains("B")) {
                isNeedAudit = Boolean.TRUE;
            }
        } else if ("ar_finarbill".equals(finApBills[0].getString("sourcebilltype"))) {
            if ("B".equals(finApBills[0].getString("billstatus"))) {
                isNeedAudit = Boolean.TRUE;
            }
        } else {
            isNeedAudit = Boolean.TRUE;
        }
        InvoiceHelper.updateFinTaxDeductionLogic((DynamicObject[])finApBills, (boolean)false);
        SaveServiceHelper.save((DynamicObject[])finApBills);
        this.sendMessageByInvFail(failInvUserIds, failInvApBillNos, invoiceBillNo);
        logger.info("CoordinationInvoiceService writeBackFinApAndSendMessage end");
        return Tuple.create(needAssignFinApIds, (Object)isNeedAudit);
    }

    private void writeBackInvoice(Map<Long, List<Map<String, Object>>> invoiceEntryCoreInfoMap, DynamicObject invoice) {
        if (ObjectUtils.isEmpty(invoiceEntryCoreInfoMap)) {
            return;
        }
        logger.info("CoordinationInvoiceService updateInvoices begin");
        DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
        for (DynamicObject invRow : entry) {
            List<Map<String, Object>> coreInfoMaps = invoiceEntryCoreInfoMap.get(invRow.getLong("id"));
            if (ObjectUtils.isEmpty(coreInfoMaps)) continue;
            Map<String, Object> coreInfoMap = coreInfoMaps.get(0);
            Object eCoreBillType = coreInfoMap.get("e_corebilltype");
            Object eCoreBillNo = coreInfoMap.get("e_corebillno");
            Object eCoreBillEntrySeq = coreInfoMap.get("e_corebillentryseq");
            if (!ObjectUtils.isEmpty((Object)eCoreBillType)) {
                invRow.set("corebilltype", eCoreBillType);
            }
            invRow.set("corebillno", eCoreBillNo);
            invRow.set("corebillentryseq", eCoreBillEntrySeq);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
        logger.info("CoordinationInvoiceService updateInvoices end");
    }

    private Tuple<Map<Long, List<Map<String, Object>>>, Map<Long, BigDecimal>> constructCoordinationMap(DynamicObject invoice) {
        logger.info("CoordinationInvoiceService constructCoordinationMap begin");
        QFilter filter = new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode"));
        filter.and(new QFilter("invoiceno", "=", (Object)invoice.getString("invoiceno")));
        DynamicObjectCollection simVatInvoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id,invoicecode,invoiceno,items.id,items.seq", (QFilter[])new QFilter[]{filter});
        if (simVatInvoices.isEmpty()) {
            return null;
        }
        HashMap<Long, Integer> vatInvEntryId4SeqMap = new HashMap<Long, Integer>(16);
        for (DynamicObject simVatInvoice : simVatInvoices) {
            long itemId = simVatInvoice.getLong("items.id");
            vatInvEntryId4SeqMap.put(itemId, simVatInvoice.getInt("items.seq"));
        }
        logger.info("CoordinationInvoiceService constructCoordinationMap vatInvEntryId4SeqMap is :" + vatInvEntryId4SeqMap);
        DynamicObjectCollection vatInvRelations = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)"tdetailid,sdetailid,sbillid,amount,tax", (QFilter[])new QFilter[]{new QFilter("tdetailid", "in", vatInvEntryId4SeqMap.keySet())});
        ArrayList<Long> simOriginalBillIds = new ArrayList<Long>(16);
        HashMap<Long, List> vatInvEntry4SimOriginalEntryMap = new HashMap<Long, List>(16);
        HashMap<Long, BigDecimal> originalEntry4TotalInvAmtMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject vatInvRelation : vatInvRelations) {
            long originalBillId = vatInvRelation.getLong("sbillid");
            long originalEntryId = vatInvRelation.getLong("sdetailid");
            simOriginalBillIds.add(originalBillId);
            long vatInvEntryId = vatInvRelation.getLong("tdetailid");
            List originalEntryIds = vatInvEntry4SimOriginalEntryMap.getOrDefault(vatInvEntryId, new ArrayList(8));
            originalEntryIds.add(originalEntryId);
            vatInvEntry4SimOriginalEntryMap.put(vatInvEntryId, originalEntryIds);
            BigDecimal invAmount = vatInvRelation.getBigDecimal("amount").add(vatInvRelation.getBigDecimal("tax"));
            BigDecimal totalInvAmount = originalEntry4TotalInvAmtMap.getOrDefault(originalEntryId, BigDecimal.ZERO);
            totalInvAmount = totalInvAmount.add(invAmount);
            originalEntry4TotalInvAmtMap.put(originalEntryId, totalInvAmount);
        }
        logger.info("CoordinationInvoiceService constructCoordinationMap vatInvEntry4SimOriginalEntryMap is :" + vatInvEntry4SimOriginalEntryMap);
        logger.info("CoordinationInvoiceService constructCoordinationMap originalEntry4TotalInvAmtMap is :" + originalEntry4TotalInvAmtMap);
        Map simOriginalEntry4ArBFRowIdMap = BOTPHelper.loadNearSrcBFRowIdMap((String)"sim_original_bill", (String)"sim_original_bill_item", (Long[])simOriginalBillIds.toArray(new Long[0]), (Long[])originalEntry4TotalInvAmtMap.keySet().toArray(new Long[0]), (String)"ar_finarbill");
        HashMap<Long, Long> simOriginalEntry4ArEntryMap = new HashMap<Long, Long>(32);
        HashSet<Long> allFinArBillIds = new HashSet<Long>(32);
        for (Map.Entry entrySet : simOriginalEntry4ArBFRowIdMap.entrySet()) {
            Long simOriginalEntryId = (Long)entrySet.getKey();
            BFRowId finArBfRowId = (BFRowId)entrySet.getValue();
            simOriginalEntry4ArEntryMap.put(simOriginalEntryId, finArBfRowId.getEntryId());
            allFinArBillIds.add(finArBfRowId.getBillId());
        }
        QFilter filter1 = new QFilter("entry.id", "in", simOriginalEntry4ArEntryMap.values());
        filter1.and(new QFilter("relationpay", "=", (Object)Boolean.TRUE));
        filter1.and(new QFilter("id", "in", allFinArBillIds));
        String selectors = "id,entry.id,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq";
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)selectors, (QFilter[])new QFilter[]{filter1});
        HashMap finArCoreInfoMap = new HashMap(32);
        HashMap<Long, Long> finArEntry4BillIdMap = new HashMap<Long, Long>(32);
        for (DynamicObject finArBill : finArBills) {
            finArEntry4BillIdMap.put(finArBill.getLong("entry.id"), finArBill.getLong("id"));
            String coreBillType = finArBill.getString("entry.e_corebilltype");
            String string = finArBill.getString("entry.e_corebillno");
            int coreBillEntrySeq = finArBill.getInt("entry.e_corebillentryseq");
            HashMap<String, Object> coreInfoMap = new HashMap<String, Object>(4);
            coreInfoMap.put("e_corebilltype", coreBillType);
            coreInfoMap.put("e_corebillno", string);
            coreInfoMap.put("e_corebillentryseq", coreBillEntrySeq);
            finArCoreInfoMap.put(finArBill.getLong("entry.id"), coreInfoMap);
        }
        HashMap<Long, List> invoiceEntryCoreInfoMap = new HashMap<Long, List>(8);
        HashMap<Integer, List> simVatSeq4CoreInfoMap = new HashMap<Integer, List>(8);
        for (Map.Entry entry : vatInvEntryId4SeqMap.entrySet()) {
            Long itemId = (Long)entry.getKey();
            Integer simVatSeq = (Integer)entry.getValue();
            List tempSimOriginalEntryIds = (List)vatInvEntry4SimOriginalEntryMap.get(itemId);
            if (ObjectUtils.isEmpty((Object)tempSimOriginalEntryIds)) continue;
            for (Long tempSimOriginalEntryId : tempSimOriginalEntryIds) {
                Map coreInfoMap;
                Long finArEntryId = (Long)simOriginalEntry4ArEntryMap.get(tempSimOriginalEntryId);
                if (ObjectUtils.isEmpty((Object)finArEntryId) || ObjectUtils.isEmpty((Object)(coreInfoMap = (Map)finArCoreInfoMap.get(finArEntryId)))) continue;
                List coreInfoMaps = simVatSeq4CoreInfoMap.getOrDefault(simVatSeq, new ArrayList(8));
                coreInfoMaps.add(coreInfoMap);
                simVatSeq4CoreInfoMap.put(simVatSeq, coreInfoMaps);
            }
        }
        DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
        for (DynamicObject invRow : entry) {
            int eInvEntrySeq = invRow.getInt("e_inventryseq");
            List coreInfoMaps = (List)simVatSeq4CoreInfoMap.get(eInvEntrySeq);
            if (ObjectUtils.isEmpty((Object)coreInfoMaps)) continue;
            invoiceEntryCoreInfoMap.put(invRow.getLong("id"), coreInfoMaps);
        }
        logger.info("CoordinationInvoiceService constructCoordinationMap invoiceEntryCoreInfoMap is :" + invoiceEntryCoreInfoMap);
        HashMap<Long, BigDecimal> hashMap = new HashMap<Long, BigDecimal>(8);
        for (Map.Entry entrySet : simOriginalEntry4ArEntryMap.entrySet()) {
            Long finArBillId;
            Long simOriginalEntryId = (Long)entrySet.getKey();
            Long finArEntryId = (Long)entrySet.getValue();
            BigDecimal simOriginalEntryTotalInvAmt = (BigDecimal)originalEntry4TotalInvAmtMap.get(simOriginalEntryId);
            if (simOriginalEntryTotalInvAmt == null || (finArBillId = (Long)finArEntry4BillIdMap.get(finArEntryId)) == null) continue;
            BigDecimal finArTotalInvAmt = hashMap.getOrDefault(finArBillId, BigDecimal.ZERO);
            finArTotalInvAmt = finArTotalInvAmt.add(simOriginalEntryTotalInvAmt);
            hashMap.put(finArBillId, finArTotalInvAmt);
        }
        logger.info("CoordinationInvoiceService constructCoordinationMap finAr4ApInvoiceAmtMap is :" + hashMap);
        logger.info("CoordinationInvoiceService constructCoordinationMap end");
        return Tuple.create(invoiceEntryCoreInfoMap, hashMap);
    }

    private void finApInvEntrySetValue(DynamicObject finApBill, DynamicObject invoice, BigDecimal canUseAmt) {
        DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
        DynamicObject invRow = invEntry.addNew();
        invRow.set("invid", (Object)invoice.getLong("id"));
        invRow.set("i_billno", (Object)invoice.getString("billno"));
        invRow.set("i_invoicetype", (Object)invoice.getString("invoicetype"));
        invRow.set("i_invoicetypef7", invoice.get("invoicetypef7"));
        invRow.set("i_invoicecode", (Object)invoice.getString("invoicecode"));
        invRow.set("i_invoiceno", (Object)invoice.getString("invoiceno"));
        invRow.set("i_invoicedate", (Object)invoice.getDate("issuedate"));
        invRow.set("i_pricetaxtotal", (Object)invoice.getBigDecimal("pricetaxtotal"));
        invRow.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)invoice));
        invRow.set("i_tax", (Object)invoice.getBigDecimal("tax"));
        invRow.set("i_amount", (Object)invoice.getBigDecimal("amount"));
        String invoiceType = invoice.getString("invoicetype");
        if ("PLANE".equals(invoiceType) || "PAYLETTER".equals(invoiceType)) {
            invRow.set("i_amount", (Object)invoice.getBigDecimal("pricetaxtotal").subtract(invoice.getBigDecimal("tax")));
        }
        invRow.set("i_asstactname", (Object)invoice.getString("asstactname"));
        invRow.set("i_buyername", (Object)invoice.getString("buyername"));
        invRow.set("i_istaxdeduction", (Object)invoice.getBoolean("istaxdeduction"));
        invRow.set("i_remark", (Object)invoice.getString("remark"));
        invRow.set("i_srctype", (Object)InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue());
        invRow.set("i_issupplement", (Object)RIGHT_STATUS);
        invRow.set("i_serialno", (Object)invoice.getString("serialno"));
        invRow.set("i_canuseamt", (Object)canUseAmt);
        invRow.set("i_currency", (Object)invoice.getDynamicObject("currency"));
    }

    private DynamicObject getInvoices(String serialNo) {
        String selectors = "invoicecode,invoiceno,e_inventryseq,billno,invoicetype,invoicetypef7,issuedate,pricetaxtotal,taxrate,tax,amount,asstactname,buyername,istaxdeduction,remark,serialno,currency,receivablessupp,isreffin,businesssource,org,corebilltype,corebillno,corebillentryseq";
        return BusinessDataServiceHelper.loadSingle((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("serialno", "=", (Object)serialNo)});
    }

    private DynamicObject downloadInvoiceAndSave(Map<String, Object> invoiceParam) {
        long orgId = (Long)invoiceParam.get("orgid");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((DynamicObject)org);
        String buyerTaxNo = config.getTaxRegnum();
        ArrayList<InvoiceVO> invoiceVOs = new ArrayList<InvoiceVO>();
        invoiceParam.put("buyerTaxNo", buyerTaxNo);
        APIHelper.invDownloadByNo(invoiceParam, invoiceVOs);
        if (invoiceVOs.isEmpty()) {
            return null;
        }
        Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
        InvoiceResolveParam resolveParam = new InvoiceResolveParam();
        resolveParam.setOrgId(orgId).setBizType((String)invoiceParam.get("biztype"));
        List<DynamicObject> invoices = resolveService.genInvoice(resolveParam, invoiceVOs);
        return ObjectUtils.isEmpty(invoices) ? null : invoices.get(0);
    }

    private void sendMessageByInvFail(Set<Long> failInvUserIds, Set<String> failInvApBillNos, String invoiceBillNo) {
        logger.info("CoordinationInvoiceService sendMessageByInvFail failInvUserIds is : " + failInvUserIds);
        if (failInvUserIds.isEmpty()) {
            return;
        }
        String title = ResManager.loadKDString((String)"\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u53d1\u7968\u5173\u8054\u5e94\u4ed8\u5931\u8d25\u63d0\u9192\u3002", (String)"CoordinationInvoiceService_1", (String)"fi-ap-business", (Object[])new Object[0]);
        String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\u3002\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\uff0c\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u5168\u989d\u5f00\u7968\u5e76\u751f\u6210\u6536\u7968\u5355%2$s\uff0c\u7531\u4e8e\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u6ee1\u8db3\u81ea\u52a8\u5173\u8054\u53d1\u7968\u6761\u4ef6\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u5e76\u624b\u5de5\u5173\u8054\u3002\u5e94\u4ed8\u81ea\u52a8\u5173\u8054\u53d1\u7968\u6761\u4ef6\uff1a", (String)"CoordinationInvoiceService_2", (String)"fi-ap-business", (Object[])new Object[0]), String.join((CharSequence)",", failInvApBillNos), invoiceBillNo) + "\n" + ResManager.loadKDString((String)"\u5e94\u6536\u534f\u540c\u751f\u6210\u5e94\u4ed8\uff1a\u8d22\u52a1\u5e94\u4ed8\u5355\u5355\u636e\u72b6\u6001=\u6682\u5b58\u6216\u5df2\u63d0\u4ea4 \u5e76\u4e14 \u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u5173\u8054\u53d1\u7968\uff1b", (String)"CoordinationInvoiceService_3", (String)"fi-ap-business", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u5e94\u4ed8\u534f\u540c\u751f\u6210\u5e94\u6536\uff1a\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u5173\u8054\u53d1\u7968\u3002", (String)"CoordinationInvoiceService_4", (String)"fi-ap-business", (Object[])new Object[0]);
        this.sendMCMessage(title, content, new ArrayList<Long>(failInvUserIds));
    }

    private void downloadInvoiceSendMessage(Map<String, Object> coordinateParam) {
        DataSet finApDataSet;
        Object invoiceNo = coordinateParam.get("invoiceno");
        Object invoiceCode = coordinateParam.get("invoicecode");
        QFilter filter = new QFilter("invoicecode", "=", invoiceCode);
        filter.and(new QFilter("invoiceno", "=", invoiceNo));
        DynamicObjectCollection simVatInvoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"items.id", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> itemIds = new ArrayList<Long>(16);
        for (DynamicObject simVatInvoice : simVatInvoices) {
            itemIds.add(simVatInvoice.getLong("items.id"));
        }
        DynamicObjectCollection vatInvRelations = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)"tdetailid,sdetailid,sbillid", (QFilter[])new QFilter[]{new QFilter("tdetailid", "in", itemIds)});
        ArrayList<Long> simOriginalBillIds = new ArrayList<Long>(16);
        ArrayList<Long> simOriginalEntryIds = new ArrayList<Long>(16);
        for (DynamicObject vatInvRelation : vatInvRelations) {
            long originalBillId = vatInvRelation.getLong("sbillid");
            long originalEntryId = vatInvRelation.getLong("sdetailid");
            simOriginalBillIds.add(originalBillId);
            simOriginalEntryIds.add(originalEntryId);
        }
        Map simOriginal4ArBillMap = BOTPNewHelper.loadNearSourceBillIds((String)"sim_original_bill", (String)"sim_original_bill_item", (Long[])simOriginalBillIds.toArray(new Long[0]), (Long[])simOriginalEntryIds.toArray(new Long[0]), (String)"ar_finarbill");
        ArrayList allFinArBillIds = new ArrayList(16);
        for (Map.Entry entrySet : simOriginal4ArBillMap.entrySet()) {
            allFinArBillIds.addAll((Collection)entrySet.getValue());
        }
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar", (String)"ar_finarbill", (String)"id,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", allFinArBillIds)}, (String)"");
        ArrayList<Long> apArCoorApIds = new ArrayList<Long>(8);
        ArrayList<Long> arApCoorArIds = new ArrayList<Long>(8);
        ArrayList<Long> userIds = new ArrayList<Long>(8);
        for (Object arRow : finArDataSet) {
            if ("ap_finapbill".equals(arRow.getString("sourcebilltype"))) {
                apArCoorApIds.add(Long.parseLong(arRow.getString("sourcebillid")));
                continue;
            }
            arApCoorArIds.add(arRow.getLong("id"));
        }
        if (!arApCoorArIds.isEmpty()) {
            finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"creator", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", arApCoorArIds)}, (String)"");
            for (Row apRow : finApDataSet) {
                userIds.add(apRow.getLong("creator"));
            }
        }
        if (!apArCoorApIds.isEmpty()) {
            finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"creator", (QFilter[])new QFilter[]{new QFilter("id", "in", apArCoorApIds)}, (String)"");
            for (Row apRow : finApDataSet) {
                userIds.add(apRow.getLong("creator"));
            }
        }
        if (!userIds.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u53d1\u7968\u53d1\u7968\u4e0b\u8f7d\u5931\u8d25\u63d0\u9192", (String)"CoordinationInvoiceService_11", (String)"fi-ap-business", (Object[])new Object[0]);
            String invoiceCodeAndNoMessage = this.getInvoiceCodeAndNoMessage(invoiceNo, invoiceCode);
            String content = String.format(ResManager.loadKDString((String)"\u8fdb\u9879\u7968\u6c60\u4e0d\u5b58\u5728\u4ee5\u4e0b\u53d1\u7968\uff0c\u81ea\u52a8\u6536\u7968\u5931\u8d25\u3002%1$s\u3002", (String)"CoordinationInvoiceService_10", (String)"fi-ap-business", (Object[])new Object[0]), invoiceCodeAndNoMessage);
            this.sendMCMessage(title, content, new ArrayList<Long>(userIds));
        }
    }

    private void sendMCMessage(String title, String content, List<Long> userIds) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setTitle(title);
        messageInfo.setContent(content);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderName(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"CoordinationInvoiceService_5", (String)"fi-ap-business", (Object[])new Object[0]));
        messageInfo.setTag(ResManager.loadKDString((String)"\u5fc5\u8bfb", (String)"CoordinationInvoiceService_0", (String)"fi-ap-business", (Object[])new Object[0]));
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        messageInfo.setNestAppid("ap");
        messageInfo.setSource("ap");
        Map result = MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(messageInfo));
        logger.info("CoordinationInvoiceService sendMCMessage result : " + result);
    }

    private String getInvoiceCodeAndNoMessage(Object invoiceNo, Object invoiceCode) {
        String invoiceCodeAndNoMessage = null;
        invoiceCodeAndNoMessage = ObjectUtils.isEmpty((Object)invoiceNo) && !ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s", (String)"CoordinationInvoiceService_12", (String)"fi-ap-business", (Object[])new Object[0]), invoiceCode) : (!ObjectUtils.isEmpty((Object)invoiceNo) && ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s", (String)"CoordinationInvoiceService_13", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\uff0c\u53d1\u7968\u4ee3\u7801\uff1a%2$s", (String)"CoordinationInvoiceService_14", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo, invoiceCode));
        return invoiceCodeAndNoMessage;
    }
}

