/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.invoice.IViewInvoicePlugin;
import kd.bos.ext.fi.invoice.param.InvoiceResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.ErStdConfig;

public class GlInvoiceViewImpl
implements IViewInvoicePlugin {
    protected static final Log logger = LogFactory.getLog(GlInvoiceViewImpl.class);

    public List<InvoiceResult> view(Map<String, List<Long>> billMap) {
        ArrayList<InvoiceResult> results = new ArrayList<InvoiceResult>(8);
        if (ObjectUtils.isEmpty(billMap)) {
            return results;
        }
        logger.info("GlInvoiceViewImpl view billMap  : " + billMap);
        Map<String, Map<Long, List<Long>>> entityOrgForBillIdMap = this.getEntityOrgForBillIdMap(billMap);
        if (entityOrgForBillIdMap.isEmpty()) {
            return results;
        }
        boolean isXH = "true".equals(ErStdConfig.get((String)"invoicecloud.invoicecloudxh"));
        String viewInvoicePageEntity = isXH ? "rim_view_invoice" : "er_invoicecloudpage_pc";
        for (Map.Entry<String, Map<Long, List<Long>>> entrySet : entityOrgForBillIdMap.entrySet()) {
            String entityName = entrySet.getKey();
            Map<Long, List<Long>> orgForBillIdMap = entrySet.getValue();
            for (Map.Entry<Long, List<Long>> entrySet1 : orgForBillIdMap.entrySet()) {
                List<Long> sameOrgBillIds = entrySet1.getValue();
                InvoiceResult invoiceResult = new InvoiceResult();
                invoiceResult.setEntityId(entityName);
                invoiceResult.setBillId(sameOrgBillIds.get(0));
                Map viewInvoiceParam = CallCloudHelper.buildViewInvoiceParam(sameOrgBillIds, (String)entityName, new ArrayList(2));
                if (ObjectUtils.isEmpty((Object)viewInvoiceParam)) {
                    invoiceResult.setSuccess(false);
                    invoiceResult.setErrorMsg(ResManager.loadKDString((String)"\u65e0\u6cd5\u67e5\u770b\u53d1\u7968\uff0c\u5f53\u524d\u5355\u636e\u672a\u5173\u8054\u53d1\u7968\u3002", (String)"GlInvoiceViewImpl_0", (String)"fi-ap-business", (Object[])new Object[0]));
                } else {
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId(viewInvoicePageEntity);
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setCustomParams(viewInvoiceParam);
                    parameter.setShowTitle(false);
                    invoiceResult.setSuccess(true);
                    invoiceResult.setFormShowParameter(parameter);
                }
                results.add(invoiceResult);
            }
        }
        logger.info("GlInvoiceViewImpl view results size : " + results.size());
        return results;
    }

    private Map<String, Map<Long, List<Long>>> getEntityOrgForBillIdMap(Map<String, List<Long>> billMap) {
        HashMap<String, Map<Long, List<Long>>> entityOrgForBillIdMap = new HashMap<String, Map<Long, List<Long>>>(8);
        HashSet<Long> hasUseInvIds = new HashSet<Long>(16);
        for (Map.Entry<String, List<Long>> entrySet : billMap.entrySet()) {
            String entityName = entrySet.getKey();
            List<Long> billIds = entrySet.getValue();
            if (!"ap_finapbill".equals(entityName) && !"ap_payapply".equals(entityName)) continue;
            String selector = "ap_finapbill".equals(entityName) ? "org,id,inventry.invid" : "settleorg,id,inventry.invid";
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityName, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
            HashMap<Long, List> orgForBillIdMap = new HashMap<Long, List>(8);
            for (DynamicObject bill : bills) {
                DynamicObjectCollection invEntry = bill.getDynamicObjectCollection("inventry");
                if (invEntry.isEmpty()) continue;
                long orgId = bill.getLong("ap_finapbill".equals(entityName) ? "org.id" : "settleorg.id");
                List orgForBillIds = orgForBillIdMap.getOrDefault(orgId, new ArrayList(8));
                orgForBillIds.add(bill.getLong("id"));
                orgForBillIdMap.put(orgId, orgForBillIds);
                for (DynamicObject invRow : invEntry) {
                    hasUseInvIds.add(invRow.getLong("invid"));
                }
            }
            if (orgForBillIdMap.isEmpty()) continue;
            entityOrgForBillIdMap.put(entityName, orgForBillIdMap);
        }
        List<Long> invoiceIds = billMap.get("ap_invoice");
        if (!ObjectUtils.isEmpty(invoiceIds)) {
            invoiceIds.removeAll(hasUseInvIds);
            if (!invoiceIds.isEmpty()) {
                HashMap<Long, List<Long>> orgForBillIdMap = new HashMap<Long, List<Long>>(8);
                for (Long invoiceId : invoiceIds) {
                    orgForBillIdMap.put(invoiceId, Collections.singletonList(invoiceId));
                }
                entityOrgForBillIdMap.put("ap_invoice", orgForBillIdMap);
            }
        }
        return entityOrgForBillIdMap;
    }
}

