/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.pojo.InvoiceResolveParam;
import kd.fi.ap.enums.PZInvTypeEnum;
import kd.fi.arapcommon.business.piaozone.info.InvoiceItemVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.enums.BillOperationEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.DiscountModeEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;

public class Invoice4CloudResolveService {
    private static final Log logger = LogFactory.getLog(Invoice4CloudResolveService.class);
    private InvoiceResolveParam resolveParam;
    private final Map<BigDecimal, DynamicObject> taxRateMap = new HashMap<BigDecimal, DynamicObject>(8);
    private final Map<Long, DynamicObject> currencyMap = new HashMap<Long, DynamicObject>(8);

    public List<DynamicObject> genInvoice(InvoiceResolveParam resolveParam, List<InvoiceVO> vos) {
        if (ObjectUtils.isEmpty(vos) || ObjectUtils.isEmpty((Object)resolveParam)) {
            return new ArrayList<DynamicObject>(2);
        }
        this.resolveParam = resolveParam;
        logger.info("Invoice4CloudResolveService genInvoice vos size " + vos.size() + " : resolveParam is : " + resolveParam);
        List<InvoiceVO> invoiceVOS = this.filterErrorInvoices(vos);
        logger.info("Invoice4CloudResolveService filterErrorInvoices genInvoice vos size " + vos.size());
        if (invoiceVOS.isEmpty()) {
            return new ArrayList<DynamicObject>(2);
        }
        return this.jsonConvertInvoice(invoiceVOS);
    }

    public List<DynamicObject> importInvoice4Cloud(IFormView view, Object returnData, String actionId) {
        logger.info("Invoice4CloudResolveService importInvoice4Cloud returnData" + returnData);
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return new ArrayList<DynamicObject>(2);
        }
        Map cloudJsonMap = (Map)returnData;
        String serialNosStr = this.getInvoiceSerialNos(cloudJsonMap);
        logger.info("Invoice4CloudResolveService---\u524d\u6bb5\u8fd4\u56de\u7684\u53d1\u7968\u6d41\u6c34\u53f7\u662f" + serialNosStr);
        if (ObjectUtils.isEmpty((Object)serialNosStr)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u53d1\u7968", (String)"Invoice4CloudResolveService_0", (String)"fi-ap-business", (Object[])new Object[0]));
            return new ArrayList<DynamicObject>(2);
        }
        List<String> serialNos = Arrays.stream(serialNosStr.split(",")).distinct().collect(Collectors.toList());
        if (serialNos.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u53d1\u7968", (String)"Invoice4CloudResolveService_1", (String)"fi-ap-business", (Object[])new Object[0]));
            return new ArrayList<DynamicObject>(2);
        }
        InvoiceResolveParam invoiceResolveParam = this.initInvoiceResolveParam(view, serialNos, actionId);
        HashMap<Long, String> orgForSerialMap = new HashMap<Long, String>(2);
        orgForSerialMap.put(invoiceResolveParam.getOrgId(), serialNosStr);
        List invoiceVOS = CallCloudHelper.queryCloudInvoice(orgForSerialMap);
        this.invoiceVOPostProcess(invoiceVOS, view.getModel());
        List<DynamicObject> downloadInvoices = this.genInvoice(invoiceResolveParam, invoiceVOS);
        BizExtendHelper.afterImportInvoice((List)invoiceVOS, downloadInvoices);
        logger.info("Invoice4CloudResolveService importInvoice4Cloud downloadInvoices size " + downloadInvoices.size());
        return downloadInvoices;
    }

    private List<InvoiceVO> filterErrorInvoices(List<InvoiceVO> invoiceVOS) {
        HashSet<String> invoiceCodes = new HashSet<String>(8);
        HashSet<String> invoiceNos = new HashSet<String>(8);
        HashSet<String> serialNos = new HashSet<String>(8);
        for (InvoiceVO invoiceVO : invoiceVOS) {
            invoiceCodes.add(invoiceVO.getInvoiceCode());
            invoiceNos.add(invoiceVO.getInvoiceNo());
            serialNos.add(invoiceVO.getSerialNo());
        }
        DataSet hasExistInvoiceCodeDataSet = QueryServiceHelper.queryDataSet((String)"query_exist_inv", (String)"ap_invoice", (String)"invoicecode, invoiceno", (QFilter[])new QFilter[]{new QFilter("invoicecode", "in", invoiceCodes)}, (String)"");
        DataSet hasExistInvoiceNoDataSet = QueryServiceHelper.queryDataSet((String)"query_exist_inv", (String)"ap_invoice", (String)"invoicecode, invoiceno", (QFilter[])new QFilter[]{new QFilter("invoiceno", "in", invoiceNos)}, (String)"");
        DataSet hasExistInvoiceDataSet = hasExistInvoiceCodeDataSet.union(hasExistInvoiceNoDataSet).distinct();
        HashSet<String> hasExistInvCodeAndNos = new HashSet<String>(8);
        for (Object invoice : hasExistInvoiceDataSet) {
            String invoiceCode = invoice.getString("invoicecode");
            String invoiceNo = invoice.getString("invoiceno");
            if (!ObjectUtils.isEmpty((Object)invoiceCode) && !ObjectUtils.isEmpty((Object)invoiceNo)) {
                hasExistInvCodeAndNos.add(invoiceCode + invoiceNo);
                continue;
            }
            if (!ObjectUtils.isEmpty((Object)invoiceCode)) {
                hasExistInvCodeAndNos.add(invoiceCode);
                continue;
            }
            hasExistInvCodeAndNos.add(invoiceNo);
        }
        hasExistInvoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_exist_inv", (String)"ap_invoice", (String)"serialno", (QFilter[])new QFilter[]{new QFilter("serialno", "in", serialNos)}, (String)"");
        HashSet<String> hasExistSerialNos = new HashSet<String>(8);
        for (Row invoice : hasExistInvoiceDataSet) {
            hasExistSerialNos.add(invoice.getString("serialno"));
        }
        Iterator<InvoiceVO> iterator = invoiceVOS.iterator();
        while (iterator.hasNext()) {
            InvoiceVO invoiceVO = iterator.next();
            String codeAndNoNum = !ObjectUtils.isEmpty((Object)invoiceVO.getInvoiceCode()) && !ObjectUtils.isEmpty((Object)invoiceVO.getInvoiceNo()) ? invoiceVO.getInvoiceCode() + invoiceVO.getInvoiceNo() : (!ObjectUtils.isEmpty((Object)invoiceVO.getInvoiceCode()) ? invoiceVO.getInvoiceCode() : invoiceVO.getInvoiceNo());
            if (!hasExistSerialNos.contains(invoiceVO.getSerialNo()) && !hasExistInvCodeAndNos.contains(codeAndNoNum)) continue;
            iterator.remove();
        }
        return invoiceVOS;
    }

    private List<DynamicObject> jsonConvertInvoice(List<InvoiceVO> invoiceVOS) {
        ArrayList<DynamicObject> invoices = new ArrayList<DynamicObject>(invoiceVOS.size());
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.resolveParam.getOrgId(), (String)"bos_org", (String)"id, number, name");
        DynamicObject newBill = BusinessDataServiceHelper.newDynamicObject((String)"ap_invoice");
        if (!CodeRuleServiceHelper.isExist((String)"ap_invoice", (DynamicObject)newBill, (String)org.getPkValue().toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u6536\u7968\u5355\u7f16\u7801\u89c4\u5219\u518d\u8fdb\u884c\u91c7\u96c6\u53d1\u7968\u3002", (String)"InvoiceCloudHelper_0", (String)"fi-ap-common", (Object[])new Object[0]));
        }
        for (InvoiceVO vo : invoiceVOS) {
            invoices.add(this.buildInvoice(org, vo));
        }
        CodeRuleServiceHelper.injectNumbers((String)"ap_invoice", invoices);
        if (this.resolveParam.getInvoiceId() != null) {
            ((DynamicObject)invoices.get(0)).set("id", (Object)this.resolveParam.getInvoiceId());
        }
        if (this.resolveParam.getSerialNoMap() != null) {
            for (DynamicObject invoice : invoices) {
                String serialno = invoice.getString("serialno");
                Long pk = this.resolveParam.getSerialNoMap().get(serialno);
                if (pk == null) continue;
                invoice.set("id", (Object)pk);
            }
        }
        logger.info("Invoice4CloudResolveService jsonConvertInvoice invoices size " + invoices.size());
        if (this.resolveParam.isNeedSave() && !invoices.isEmpty()) {
            boolean operationPermission = OperationUtils.hasOperationPermission((String)this.resolveParam.getAppId(), (String)"ap_invoice", (BillOperationEnum)BillOperationEnum.SAVE);
            if (operationPermission) {
                OperateOption option = OperateOption.create();
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_invoice", (DynamicObject[])invoices.toArray(new DynamicObject[0]), (OperateOption)option);
                logger.info("---result.success---" + result.isSuccess());
                OperationHelper.assertResult((OperationResult)result);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6536\u7968\u5355\u7684\u4fdd\u5b58\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceCloudHelper_1", (String)"fi-ap-common", (Object[])new Object[0]));
            }
        }
        logger.info("Invoice4CloudResolveService jsonConvertInvoice invoices size " + invoices.size());
        return invoices;
    }

    private DynamicObject buildInvoice(DynamicObject org, InvoiceVO vo) {
        DynamicObject currency;
        MainEntityType invoiceEntityType = EntityMetadataCache.getDataEntityType((String)"ap_invoice");
        DynamicObject inv = new DynamicObject((DynamicObjectType)invoiceEntityType);
        inv.set("creator", (Object)this.resolveParam.getUserId());
        inv.set("createtime", (Object)new Date());
        inv.set("modifier", (Object)this.resolveParam.getUserId());
        inv.set("modifytime", (Object)new Date());
        inv.set("org", (Object)org);
        Long currencyId = vo.getCurrencyId();
        if (!ObjectUtils.isEmpty((Object)currencyId) && currencyId != 0L) {
            currency = this.currencyMap.get(currencyId);
            if (currency == null) {
                currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
                this.currencyMap.put(currencyId, currency);
            }
        } else {
            currency = this.currencyMap.get(currencyId);
            if (currency == null) {
                currency = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bd_currency");
                this.currencyMap.put(currencyId, currency);
            }
        }
        inv.set("currency", (Object)currency);
        Date invoiceDate = vo.getInvoiceDate();
        InitHelper init = new InitHelper(this.resolveParam.getOrgId(), "ap_init");
        DynamicObject basecurrency = init.getStandardCurrency();
        long srcCurrencyId = currency.getLong("id");
        long destCurrencyId = basecurrency.getLong("id");
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)invoiceDate);
        String quotation = isIndirect ? "1" : "0";
        int amtprecision = basecurrency.getInt("amtprecision");
        this.buildHeader(vo, inv, org, init);
        BigDecimal exchangerate = BigDecimal.ONE;
        if (!currency.getPkValue().equals(basecurrency.getPkValue()) && ObjectUtils.isEmpty((Object)(exchangerate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)invoiceDate)))) {
            isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)invoiceDate);
            quotation = isIndirect ? "1" : "0";
            exchangerate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)new Date());
        }
        Map<String, DynamicObject> entryMap = this.getMapperMap(vo.getSalerTaxNo());
        DynamicObjectCollection entries = inv.getDynamicObjectCollection("entry");
        EntryProp prop = (EntryProp)invoiceEntityType.findProperty("entry");
        DynamicObjectType entryDT = prop.getDynamicCollectionItemPropertyType();
        List<InvoiceItemVO> mergeItems = this.getMergeItems(vo.getItems());
        if (mergeItems != null && !mergeItems.isEmpty()) {
            for (int i = 0; i < mergeItems.size(); ++i) {
                InvoiceItemVO item = mergeItems.get(i);
                DynamicObject entry = this.buildEntry(entryDT, item, entryMap, exchangerate, amtprecision, quotation, i + 1);
                entries.add((Object)entry);
            }
        } else {
            entries.add((Object)this.buildEntry4Quota(entryDT, exchangerate, amtprecision, vo, quotation));
        }
        this.calculatorEntryAmt(inv, entries);
        return inv;
    }

    private void calculatorEntryAmt(DynamicObject inv, DynamicObjectCollection entries) {
        DynamicObject currency = inv.getDynamicObject("currency");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecurrency = inv.getDynamicObject("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal rate = inv.getBigDecimal("exchangerate");
        PriceLocalCalculator localCalculator = null;
        PriceTaxTotalCalculator calculator = null;
        for (DynamicObject entry : entries) {
            BigDecimal qty = entry.getBigDecimal("quantity");
            BigDecimal taxRate = entry.getBigDecimal("taxrate");
            String discountMode = entry.getString("discountmode");
            BigDecimal discountRate = entry.getBigDecimal("discountrate");
            BigDecimal pricetaxtotal = entry.getBigDecimal("e_pricetaxtotal");
            calculator = new PriceTaxTotalCalculator(qty, pricetaxtotal, taxRate, discountMode, discountRate, precision);
            localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision);
            localCalculator.calculate();
            entry.set("actprice", (Object)localCalculator.getActunitprice());
            entry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
        }
    }

    private DynamicObject buildEntry4Quota(DynamicObjectType entryDT, BigDecimal exchangerate, int amtprecision, InvoiceVO vo, String quotation) {
        BigDecimal taxRate;
        DynamicObject entry = new DynamicObject(entryDT);
        entry.set("seq", (Object)1);
        entry.set("e_invname", (Object)PZInvTypeEnum.getName((String)vo.getInvoiceType()));
        BigDecimal amount = vo.getInvoiceAmount() != null ? vo.getInvoiceAmount() : (vo.getInvoiceMoney() != null ? vo.getInvoiceMoney() : vo.getAmount());
        BigDecimal totalAmount = vo.getTotalAmount();
        BigDecimal taxAmount = vo.getTaxAmount() != null ? vo.getTaxAmount() : vo.getTotalTaxAmount();
        String invoiceType = (String)StringUtils.defaultIfEmpty((CharSequence)InvoiceType.getValue((String)vo.getInvoiceType()), (CharSequence)vo.getInvoiceType());
        if ("PLANE".equals(invoiceType) || "PAYLETTER".equals(invoiceType)) {
            amount = totalAmount.subtract(taxAmount);
        }
        if (amount == null && taxAmount == null) {
            amount = totalAmount;
            taxAmount = BigDecimal.ZERO;
        } else if (amount == null && taxAmount != null) {
            amount = totalAmount.subtract(taxAmount);
        } else {
            taxAmount = totalAmount.subtract(amount);
        }
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            entry.set("price", (Object)amount);
        } else {
            entry.set("price", (Object)amount.negate());
        }
        entry.set("e_amount", (Object)amount);
        entry.set("quantity", (Object)(amount.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ONE : BigDecimal.ONE.negate()));
        BigDecimal bigDecimal = taxRate = EmptyUtils.isNotEmpty((Object)vo.getTaxRate()) ? vo.getTaxRate().multiply(new BigDecimal(100)) : BigDecimal.ZERO;
        if (EmptyUtils.isNotEmpty((Object)amount) && amount.compareTo(BigDecimal.ZERO) > 0 && taxRate.compareTo(BigDecimal.ZERO) == 0) {
            taxRate = taxAmount.divide(amount, amtprecision, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        if (taxRate.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject taxrateObj = this.taxRateMap.get(taxRate);
            if (taxrateObj == null) {
                taxrateObj = BusinessDataServiceHelper.loadSingle((String)"bd_taxrate", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("taxrate", "=", (Object)taxRate)});
                this.taxRateMap.put(taxRate, taxrateObj);
            }
            if (!ObjectUtils.isEmpty((Object)taxrateObj)) {
                entry.set("taxrateid", (Object)taxrateObj);
            }
        }
        entry.set("taxrate", (Object)taxRate);
        entry.set("e_tax", (Object)taxAmount);
        entry.set("e_pricetaxtotal", (Object)totalAmount);
        entry.set("e_unrelatedamt", (Object)totalAmount);
        entry.set("discountmode", (Object)DiscountModeEnum.NULL.getValue());
        if (exchangerate != null) {
            if ("0".equals(quotation)) {
                entry.set("e_pricetaxtotalbase", (Object)totalAmount.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
            } else {
                entry.set("e_pricetaxtotalbase", (Object)totalAmount.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
            }
        }
        return entry;
    }

    private Map<String, DynamicObject> getMapperMap(String taxNo) {
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
        String select = "entry.e_invname, entry.e_invspectype, entry.e_invunit, entry.e_material, entry.e_spectype, entry.e_measureunit, entry.e_expenseitem";
        QFilter qFilter = new QFilter("org", "=", (Object)this.resolveParam.getOrgId());
        qFilter.and(new QFilter("number", "=", (Object)taxNo));
        DynamicObject mapper = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_invoicemapper", (String)select, (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object)mapper)) {
            DynamicObjectCollection entries = mapper.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                String key = entry.getString("e_invname") + entry.getString("e_invspectype") + entry.getString("e_invunit");
                entryMap.put(key.replaceAll(" ", ""), entry);
            }
        }
        return entryMap;
    }

    private DynamicObject buildEntry(DynamicObjectType entryDT, InvoiceItemVO item, Map<String, DynamicObject> entryMap, BigDecimal exchangerate, int amtprecision, String quotation, int seq) {
        DynamicObject taxclass;
        DynamicObject entry = new DynamicObject(entryDT);
        entry.set("seq", (Object)seq);
        entry.set("e_inventryseq", (Object)item.getSeq());
        entry.set("e_invname", (Object)item.getGoodsName());
        entry.set("e_invspectype", (Object)item.getSpecModel());
        entry.set("e_invunit", (Object)item.getUnit());
        String key = item.getGoodsName() + item.getSpecModel() + item.getUnit();
        if (entryMap.containsKey(key.replaceAll(" ", ""))) {
            DynamicObject mapperEntry = entryMap.get(key.replaceAll(" ", ""));
            if ("PUR".equals(this.resolveParam.getBizType())) {
                entry.set("material", (Object)mapperEntry.getDynamicObject("e_material"));
                entry.set("spectype", mapperEntry.get("e_spectype"));
            } else {
                entry.set("expenseitem", (Object)mapperEntry.getDynamicObject("e_expenseitem"));
            }
            entry.set("measureunit", (Object)mapperEntry.getDynamicObject("e_measureunit"));
        }
        BigDecimal quantity = item.getNum();
        BigDecimal amount = item.getDetailAmount();
        if (EmptyUtils.isEmpty((Object)quantity) && EmptyUtils.isEmpty((Object)item.getUnitPrice())) {
            if (amount.compareTo(BigDecimal.ZERO) >= 0) {
                entry.set("quantity", (Object)BigDecimal.ONE);
                entry.set("price", (Object)amount);
            } else {
                entry.set("quantity", (Object)BigDecimal.ONE.negate());
                entry.set("price", (Object)amount.negate());
            }
        } else {
            entry.set("quantity", (Object)(EmptyUtils.isEmpty((Object)quantity) ? (amount.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ONE : BigDecimal.ONE.negate()) : quantity));
            entry.set("price", (Object)(EmptyUtils.isEmpty((Object)item.getUnitPrice()) ? amount : item.getUnitPrice()));
        }
        entry.set("e_amount", (Object)amount);
        BigDecimal taxRate = item.getTaxRate().multiply(new BigDecimal(100));
        DynamicObject taxrateObj = this.taxRateMap.get(taxRate);
        if (taxrateObj == null) {
            taxrateObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("taxrate", "=", (Object)taxRate)});
            this.taxRateMap.put(taxRate, taxrateObj);
        }
        if (!ObjectUtils.isEmpty((Object)taxrateObj)) {
            entry.set("taxrateid", (Object)taxrateObj);
        }
        entry.set("taxrate", (Object)taxRate);
        BigDecimal tax = item.getTaxAmount();
        entry.set("e_tax", (Object)tax);
        BigDecimal discountAmt = item.getDiscountAmt();
        if (!ObjectUtils.isEmpty((Object)discountAmt) && discountAmt.compareTo(BigDecimal.ZERO) != 0) {
            entry.set("discountamt", (Object)discountAmt);
            if (exchangerate != null) {
                if ("0".equals(quotation)) {
                    entry.set("discountlocalamt", (Object)discountAmt.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
                } else {
                    entry.set("discountlocalamt", (Object)discountAmt.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
                }
            }
            entry.set("discountmode", (Object)DiscountModeEnum.PERUNIT.getValue());
            BigDecimal discountRate = discountAmt.divide(entry.getBigDecimal("quantity"), 10, RoundingMode.HALF_UP);
            entry.set("discountrate", (Object)discountRate);
            BigDecimal price = entry.getBigDecimal("price");
            if (price == null || price.compareTo(BigDecimal.ZERO) == 0 || EmptyUtils.isEmpty((Object)item.getUnitPrice())) {
                PriceTaxTotalCalculator calculator = new PriceTaxTotalCalculator(false, price, BigDecimal.ZERO, entry.getBigDecimal("quantity"), amount.add(tax), taxRate, DiscountModeEnum.PERUNIT.getValue(), discountRate, amtprecision, BigDecimal.ZERO, discountAmt);
                PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangerate, amtprecision, quotation);
                localCalculator.calculate();
                entry.set("price", (Object)localCalculator.getUnitprice());
            }
        } else {
            entry.set("discountmode", (Object)DiscountModeEnum.NULL.getValue());
        }
        BigDecimal pricetaxtotal = amount.add(tax);
        entry.set("e_pricetaxtotal", (Object)pricetaxtotal);
        entry.set("e_unrelatedamt", (Object)pricetaxtotal);
        if (exchangerate != null) {
            if ("0".equals(quotation)) {
                entry.set("e_pricetaxtotalbase", (Object)pricetaxtotal.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
            } else {
                entry.set("e_pricetaxtotalbase", (Object)pricetaxtotal.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
            }
        }
        if (!ObjectUtils.isEmpty((Object)(taxclass = BusinessDataServiceHelper.loadSingleFromCache((String)"er_taxclasscode", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("mergecode", "=", (Object)item.getGoodsCode())})))) {
            entry.set("e_taxclass", (Object)taxclass);
        }
        return entry;
    }

    private List<InvoiceItemVO> getMergeItems(List<InvoiceItemVO> items) {
        ArrayList<InvoiceItemVO> mergeItems = new ArrayList();
        if (items != null && items.size() > 1) {
            int count = items.size();
            for (int i = 0; i < count; ++i) {
                InvoiceItemVO current = items.get(i);
                String discountType = current.getDiscountType();
                if ("2".equals(discountType)) {
                    int j = i + 1;
                    if (j >= count) continue;
                    InvoiceItemVO next = items.get(j);
                    InvoiceItemVO merge = this.buildMergeItem(current, next);
                    if (merge != null) {
                        mergeItems.add(merge);
                        ++i;
                        continue;
                    }
                    mergeItems.add(current);
                    continue;
                }
                if (discountType != null && !"0".equals(discountType)) continue;
                mergeItems.add(current);
            }
        } else {
            mergeItems = items;
        }
        return mergeItems;
    }

    private InvoiceItemVO buildMergeItem(InvoiceItemVO current, InvoiceItemVO next) {
        InvoiceItemVO merge = null;
        if ("1".equals(next.getDiscountType()) && current.getGoodsCode().equals(next.getGoodsCode())) {
            merge = current;
            merge.setDetailAmount(merge.getDetailAmount().add(next.getDetailAmount()));
            merge.setTaxAmount(merge.getTaxAmount().add(next.getTaxAmount()));
            merge.setDiscountAmt(next.getDetailAmount().add(next.getTaxAmount()).abs());
        }
        return merge;
    }

    private void buildHeader(InvoiceVO vo, DynamicObject inv, DynamicObject org, InitHelper init) {
        String quotation;
        String buyerName;
        QFilter qfilter;
        Map buyerMap;
        inv.set("serialno", (Object)vo.getSerialNo());
        inv.set("invoicestatus", (Object)vo.getInvoiceStatus());
        inv.set("checkstatus", (Object)vo.getCheckStatus());
        inv.set("invoicecode", (Object)vo.getInvoiceCode());
        inv.set("invoiceno", (Object)vo.getInvoiceNo());
        Date invoiceDate = vo.getInvoiceDate();
        inv.set("issuedate", (Object)invoiceDate);
        inv.set("receivedate", (Object)new Date());
        inv.set("biztype", (Object)this.resolveParam.getBizType());
        String invoiceType = (String)StringUtils.defaultIfEmpty((CharSequence)InvoiceType.getValue((String)vo.getInvoiceType()), (CharSequence)vo.getInvoiceType());
        inv.set("invoicetype", (Object)invoiceType);
        inv.set("invoicetypef7", (Object)InvoiceTypeHelper.getInvoiceTypePK((String)vo.getInvoiceType()));
        inv.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        inv.set("remark", (Object)StringUtils.trim((String)vo.getRemark()));
        if (InvoiceType.OVERSEAS.getValue().equals(invoiceType)) {
            inv.set("isincludetax", (Object)Boolean.FALSE);
        }
        if (!ObjectUtils.isEmpty((Object)(buyerMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{qfilter = new QFilter("name", "=", (Object)(buyerName = vo.getBuyerName()))})))) {
            inv.set("buyer", (Object)buyerMap.values().toArray(new DynamicObject[0])[0]);
        }
        inv.set("buyername", (Object)vo.getBuyerName());
        inv.set("buyertin", (Object)vo.getBuyerTaxNo());
        String buyerAddressPhone = vo.getBuyerAddressPhone();
        int max = this.getNumberMaxPosition(buyerAddressPhone, "-");
        if (max == -1) {
            inv.set("buyertel", (Object)buyerAddressPhone);
        } else {
            inv.set("buyeraddr", (Object)StringUtils.substring((String)buyerAddressPhone, (int)0, (int)(max + 1)));
            inv.set("buyertel", (Object)StringUtils.substring((String)buyerAddressPhone, (int)(max + 1)));
        }
        String buyerAccount = vo.getBuyerAccount();
        int max2 = this.getNumberMaxPosition(buyerAccount, null);
        if (max2 == -1) {
            inv.set("buyeracct", (Object)buyerAccount);
        } else {
            inv.set("buyerbank", (Object)StringUtils.substring((String)buyerAccount, (int)0, (int)(max2 + 1)));
            inv.set("buyeracct", (Object)StringUtils.substring((String)buyerAccount, (int)(max2 + 1)));
        }
        String salerTaxNo = vo.getSalerTaxNo();
        String salerName = vo.getSalerName();
        Map<String, Object> asstMap = this.getAsstact(salerTaxNo, salerName, invoiceType);
        if (asstMap != null) {
            inv.set("asstacttype", asstMap.get("asstActType"));
            inv.set("asstact", asstMap.get("asstAct"));
            inv.set("receivablessupp", asstMap.get("asstAct"));
            inv.set("receivablesacct", asstMap.get("acctBank"));
        } else {
            inv.set("asstacttype", (Object)"bd_supplier");
        }
        inv.set("asstactname", (Object)salerName);
        inv.set("sellertin", (Object)salerTaxNo);
        String salerAddressPhone = vo.getSalerAddressPhone();
        int s_max = this.getNumberMaxPosition(salerAddressPhone, "-");
        if (s_max == -1) {
            inv.set("sellertel", (Object)salerAddressPhone);
        } else {
            inv.set("selleraddr", (Object)StringUtils.substring((String)salerAddressPhone, (int)0, (int)(s_max + 1)));
            inv.set("sellertel", (Object)StringUtils.substring((String)salerAddressPhone, (int)(s_max + 1)));
        }
        String salerAccount = vo.getSalerAccount();
        int s_max2 = this.getNumberMaxPosition(salerAccount, null);
        if (s_max2 == -1) {
            inv.set("selleracct", (Object)salerAccount);
        } else {
            inv.set("sellerbank", (Object)StringUtils.substring((String)salerAccount, (int)0, (int)(s_max2 + 1)));
            inv.set("selleracct", (Object)StringUtils.substring((String)salerAccount, (int)(s_max2 + 1)));
        }
        DynamicObject basecurrency = init.getStandardCurrency();
        inv.set("basecurrency", (Object)basecurrency);
        DynamicObject exratetable = init.getExrateTable();
        inv.set("exratetable", (Object)exratetable);
        inv.set("exratedate", (Object)invoiceDate);
        DynamicObject currency = inv.getDynamicObject("currency");
        long srcCurrencyId = (Long)currency.getPkValue();
        long destCurrencyId = (Long)basecurrency.getPkValue();
        BigDecimal exchangeRate = BigDecimal.ONE;
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)invoiceDate);
        String string = quotation = isIndirect ? "1" : "0";
        if (!currency.getPkValue().equals(basecurrency.getPkValue()) && ObjectUtils.isEmpty((Object)(exchangeRate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)invoiceDate)))) {
            isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)new Date());
            quotation = isIndirect ? "1" : "0";
            exchangeRate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)new Date());
        }
        inv.set("exchangerate", (Object)exchangeRate);
        inv.set("quotation", (Object)quotation);
        BigDecimal amount = vo.getInvoiceAmount() != null ? vo.getInvoiceAmount() : ((vo.getInvoiceMoney() != null ? vo.getInvoiceMoney() : vo.getAmount()) != null ? vo.getAmount() : vo.getTotalAmount());
        int amtPrecision = basecurrency.getInt("amtprecision");
        inv.set("amount", (Object)amount);
        inv.set("tax", (Object)(vo.getTaxAmount() != null ? vo.getTaxAmount() : vo.getTotalTaxAmount()));
        inv.set("pricetaxtotal", (Object)vo.getTotalAmount());
        inv.set("unrelatedamt", (Object)vo.getTotalAmount());
        if (exchangeRate != null) {
            if ("0".equals(quotation)) {
                inv.set("amountbase", (Object)amount.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP));
                inv.set("pricetaxtotalbase", (Object)vo.getTotalAmount().multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP));
            } else {
                inv.set("amountbase", (Object)amount.divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP));
                inv.set("pricetaxtotalbase", (Object)vo.getTotalAmount().divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP));
            }
        }
        if ("PLANE".equals(invoiceType) || "PAYLETTER".equals(invoiceType)) {
            inv.set("amount", (Object)inv.getBigDecimal("pricetaxtotal").subtract(inv.getBigDecimal("tax")));
        }
        inv.set("payorg", (Object)org);
        MainEntityType invoiceEntityType = EntityMetadataCache.getDataEntityType((String)"ap_invoice");
        ComboProp paymentTypeProp = (ComboProp)invoiceEntityType.getAllFields().get("paymenttype");
        inv.set("paymenttype", paymentTypeProp.getDefValue());
        inv.set("purorg", (Object)org);
        inv.set("lastpaydate", (Object)vo.getDueDate());
        inv.set("payee", (Object)vo.getPayee());
        inv.set("checker", (Object)vo.getReviewer());
        inv.set("drawer", (Object)vo.getDrawer());
        inv.set("originalgraphurl", (Object)vo.getOriginalGraphUrl());
        inv.set("istaxdeduction", (Object)("1".equals(vo.getCanBeDeduction()) ? Boolean.TRUE : Boolean.FALSE));
        if (!inv.getBoolean("istaxdeduction")) {
            inv.set("istaxdeduction", (Object)("1".equals(vo.getDeductionFlag()) ? Boolean.TRUE : Boolean.FALSE));
        }
        inv.set("synstatus", (Object)"notsynchro");
        inv.set("isreffin", (Object)this.resolveParam.isSrcCollect());
        if (this.resolveParam.isSrcCollect()) {
            inv.set("businesssource", (Object)this.resolveParam.getInvoiceOrigin());
        }
        Map extFields = vo.getExtFields();
        List fields = inv.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        if (EmptyUtils.isNotEmpty((Object)extFields)) {
            for (Map.Entry entry : extFields.entrySet()) {
                if (!fields.contains(entry.getKey())) continue;
                inv.set((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private Map<String, Object> getAsstact(String taxNo, String salerName, String invoiceType) {
        QFilter qfilter;
        HashMap<String, Object> asstactMap = null;
        long orgPk = this.resolveParam.getOrgId();
        String asstActType = null;
        Long asstAct = null;
        String acctBank = null;
        if (this.resolveParam.getAsstactType() != null && this.resolveParam.getAsstactId() != 0L) {
            asstActType = this.resolveParam.getAsstactType();
            asstAct = this.resolveParam.getAsstactId();
        } else if (!InvoiceType.OVERSEAS.getValue().equals(invoiceType)) {
            DynamicObjectCollection suppliers;
            if (EmptyUtils.isEmpty((Object)taxNo)) {
                return asstactMap;
            }
            qfilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            qfilter.and("status", "=", (Object)"C");
            qfilter.and(new QFilter("tx_register_no", "=", (Object)taxNo));
            QFilter qfilter_2 = new QFilter("enable", "=", (Object)Boolean.TRUE);
            qfilter_2.and("status", "=", (Object)"C");
            qfilter_2.and(new QFilter("societycreditcode", "=", (Object)taxNo));
            qfilter_2.and(new QFilter("tx_register_no", "=", (Object)""));
            if ("PUR".equals(this.resolveParam.getBizType())) {
                suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
                if (ObjectUtils.isEmpty((Object)suppliers)) {
                    suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
                }
                if (!ObjectUtils.isEmpty((Object)suppliers)) {
                    asstActType = "bd_supplier";
                    asstAct = ((DynamicObject[])suppliers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
                }
            } else {
                suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
                if (ObjectUtils.isEmpty((Object)suppliers)) {
                    suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
                }
                if (!ObjectUtils.isEmpty((Object)suppliers)) {
                    asstActType = "bd_supplier";
                    asstAct = ((DynamicObject[])suppliers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
                } else {
                    DynamicObjectCollection customers = BaseDataServiceHelper.queryBaseData((String)"bd_customer", (Long)orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
                    if (ObjectUtils.isEmpty((Object)customers)) {
                        customers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
                    }
                    if (!ObjectUtils.isEmpty((Object)customers)) {
                        asstActType = "bd_customer";
                        asstAct = ((DynamicObject[])customers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
                    }
                }
            }
            if (asstAct == null) {
                QFilter filter = new QFilter("number", "=", (Object)taxNo);
                filter.and("asstact.status", "=", (Object)"C");
                filter.and("asstact.enable", "=", (Object)Boolean.TRUE);
                Map sellerMap = BusinessDataServiceHelper.loadFromCache((String)"ap_seller", (String)"id, asstacttype, asstact", (QFilter[])new QFilter[]{filter});
                if (!ObjectUtils.isEmpty((Object)sellerMap)) {
                    DynamicObject seller = sellerMap.values().toArray(new DynamicObject[0])[0];
                    asstActType = seller.getString("asstacttype");
                    asstAct = seller.getLong("asstact.id");
                }
            }
        } else if (salerName != null && !"".equals(salerName)) {
            qfilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            qfilter.and("status", "=", (Object)"C");
            qfilter.and("name", "=", (Object)salerName);
            DynamicObjectCollection suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
            if (ObjectUtils.isEmpty((Object)suppliers)) {
                QFilter qfilter_2 = new QFilter("enable", "=", (Object)Boolean.TRUE);
                qfilter_2.and("status", "=", (Object)"C");
                qfilter_2.and(new QFilter("name", "ftlike", (Object)salerName));
                suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
            }
            if (!ObjectUtils.isEmpty((Object)suppliers)) {
                asstActType = "bd_supplier";
                asstAct = ((DynamicObject[])suppliers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
            }
        }
        if (asstActType != null || asstAct != null) {
            asstactMap = new HashMap<String, Object>();
            if (!"bos_user".equals(asstActType)) {
                DynamicObject asst;
                DynamicObjectCollection bankColls;
                if (asstAct != null && (bankColls = (asst = BusinessDataServiceHelper.loadSingleFromCache((Object)asstAct, (String)asstActType)).getDynamicObjectCollection("entry_bank")) != null && bankColls.size() > 0) {
                    if (bankColls.size() == 1) {
                        DynamicObject bankInfo = (DynamicObject)bankColls.get(0);
                        acctBank = bankInfo.getString("bankaccount");
                    } else {
                        for (int i = 0; i < bankColls.size(); ++i) {
                            DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                            if (bankInfo.getBoolean("isdefault_bank")) {
                                acctBank = bankInfo.getString("bankaccount");
                                break;
                            }
                            if (i != 0) continue;
                            acctBank = bankInfo.getString("bankaccount");
                        }
                    }
                }
                asstactMap.put("acctBank", acctBank);
            }
            asstactMap.put("asstActType", asstActType);
            asstactMap.put("asstAct", asstAct);
        }
        return asstactMap;
    }

    private int getNumberMaxPosition(String txt, String containStr) {
        int max = -1;
        if (EmptyUtils.isNotEmpty((Object)txt)) {
            for (int i = txt.length() - 1; i > 0; --i) {
                boolean flag;
                String s = String.valueOf(txt.charAt(i));
                boolean bl = StringUtils.isEmpty((CharSequence)containStr) ? this.isNumber(s) : (flag = this.isNumber(s) || StringUtils.equals((CharSequence)containStr, (CharSequence)s));
                if (flag || i <= max) continue;
                max = i;
            }
        }
        return max;
    }

    private boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("\\d+");
        return pattern.matcher(str).matches();
    }

    private void invoiceVOPostProcess(List<InvoiceVO> invoiceVOs, IDataModel model) {
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        HashMap<String, Object> extMap = new HashMap<String, Object>(8);
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!name.endsWith("ext")) continue;
            extMap.put(name, model.getValue(name));
        }
        invoiceVOs.forEach(v -> v.setExtFields(extMap));
    }

    private InvoiceResolveParam initInvoiceResolveParam(IFormView view, List<String> serialNos, String actionId) {
        DynamicObject asstact;
        DynamicObject org;
        InvoiceResolveParam resolveParam = new InvoiceResolveParam();
        IDataModel model = view.getModel();
        String entityName = model.getDataEntityType().getName();
        if ("ap_finapbill".equals(entityName)) {
            DynamicObject asstact2 = (DynamicObject)model.getValue("asstact");
            DynamicObject org2 = (DynamicObject)model.getValue("org");
            resolveParam.setAsstactType((String)model.getValue("asstacttype"));
            resolveParam.setAsstactId(asstact2.getLong("id"));
            resolveParam.setOrgId(org2.getLong("id"));
            resolveParam.setBizType("bd_supplier".equals(model.getValue("asstacttype")) ? "PUR" : "FEE");
            resolveParam.setSrcCollect(true);
            resolveParam.setNeedSave(false);
        } else if ("ap_payapply".equals(entityName)) {
            org = (DynamicObject)model.getValue("settleorg");
            asstact = (DynamicObject)model.getValue("e_asstact", 0);
            resolveParam.setAsstactType((String)model.getValue("e_asstacttype", 0));
            resolveParam.setAsstactId(asstact.getLong("id"));
            resolveParam.setOrgId(org.getLong("id"));
            resolveParam.setBizType("bd_supplier".equals(model.getValue("e_asstacttype", 0)) ? "PUR" : "FEE");
            resolveParam.setSrcCollect(true);
            resolveParam.setNeedSave(false);
        } else if ("ap_replaceinvapply".equals(entityName)) {
            org = (DynamicObject)model.getValue("org");
            asstact = (DynamicObject)model.getValue("asstact");
            resolveParam.setAsstactType((String)model.getValue("asstacttype"));
            resolveParam.setAsstactId(asstact.getLong("id"));
            resolveParam.setOrgId(org.getLong("id"));
            resolveParam.setBizType("bd_supplier".equals(model.getValue("asstacttype")) ? "PUR" : "FEE");
            resolveParam.setSrcCollect(true);
            resolveParam.setNeedSave(false);
        } else {
            org = (DynamicObject)model.getValue("org");
            resolveParam.setOrgId(org.getLong("id"));
            resolveParam.setBizType((String)model.getValue("biztype"));
        }
        HashMap<String, Long> serialNoMap = new HashMap<String, Long>(8);
        String[] str = actionId.split("_");
        Long pk = Long.valueOf(str[1]);
        serialNoMap.put(serialNos.get(0), pk);
        resolveParam.setSerialNoMap(serialNoMap);
        resolveParam.setAppId(view.getFormShowParameter().getAppId());
        return resolveParam;
    }

    private String getInvoiceSerialNos(Map<String, String> cloudJsonMap) {
        String serialNosStr = cloudJsonMap.get("msg");
        if (ObjectUtils.isEmpty((Object)serialNosStr)) {
            StringBuilder buf = new StringBuilder();
            logger.info("Invoice4CloudResolveService---\u4f20\u9012\u8fc7\u6765\u7684invoiceData\u662f" + JSON.toJSONString((Object)cloudJsonMap.get("invoiceData")));
            JSONArray invoiceData = JSON.parseArray((String)JSON.toJSONString((Object)cloudJsonMap.get("invoiceData")));
            if (invoiceData != null && invoiceData.size() > 0) {
                for (Object invoiceDatum : invoiceData) {
                    JSONObject invoice = (JSONObject)invoiceDatum;
                    if (invoice == null) continue;
                    String serialNo = invoice.get((Object)"serialNo").toString();
                    buf.append(serialNo);
                    buf.append(',');
                }
                serialNosStr = buf.toString();
            }
        }
        return serialNosStr;
    }
}

