/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.enums.AsstactTypeEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceAssignService {
    private static final Log logger = LogFactory.getLog(InvoiceAssignService.class);

    public ListShowParameter showInvoiceF7(IFormView iFormView, DynamicObject[] entities) {
        String message;
        if (EmptyUtils.isEmpty((Object)entities)) {
            return null;
        }
        String entityName = entities[0].getDataEntityType().getName();
        String string = message = "ap_finapbill".equals(entityName) ? this.validateFin(entities) : this.validateApply(entities[0]);
        if (EmptyUtils.isEmpty((Object)message)) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ap_invoice", (boolean)true, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            QFilter filter = "ap_finapbill".equals(entityName) ? this.constructQFilterByFinAp(entities[0]) : this.constructQFilterByApply(entities[0]);
            lfp.setFilter(filter);
            lsp.setListFilterParameter(lfp);
            if ("ap_finapbill".equals(entityName)) {
                QFilter tempQFilter = new QFilter("invoicestatus", "=", (Object)"7");
                tempQFilter.and(filter);
                DataSet partRedInvDataSet = QueryServiceHelper.queryDataSet((String)"query_partredinv", (String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{tempQFilter}, (String)"");
                lsp.setCustomParam("apassigncontianspartredinv", (Object)String.valueOf(partRedInvDataSet.hasNext()));
            }
            return lsp;
        }
        iFormView.showErrorNotification(message);
        return null;
    }

    public ListShowParameter showFinApF7(IFormView iFormView, DynamicObject[] invoices) {
        if (EmptyUtils.isEmpty((Object)invoices)) {
            return null;
        }
        String message = this.validateInvoice(invoices);
        if (EmptyUtils.isEmpty((Object)message)) {
            ListShowParameter listShowParameter = this.showFinApForm(invoices[0], invoices.length <= 1);
            for (DynamicObject invoice : invoices) {
                if (!"7".equals(invoice.getString("invoicestatus"))) continue;
                listShowParameter.setCustomParam("apassigncontianspartredinv", (Object)"true");
                break;
            }
            return listShowParameter;
        }
        iFormView.showErrorNotification(message);
        return null;
    }

    public void closedCallBack(AbstractFormPlugin plugin, String actionId, Object returnData) {
        if (EmptyUtils.isEmpty((Object)actionId) || EmptyUtils.isEmpty((Object)returnData)) {
            return;
        }
        logger.info("InvoiceAssginHelper#closedCallBack actionId is : " + actionId);
        boolean isBillAssignInv = "invoiceF7".equals(actionId);
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)returnData;
        Set<Long> finPks = new HashSet(64);
        Set<Long> invPks = new HashSet(64);
        for (ListSelectedRow listSelectedRow : rowList) {
            Long billId = (Long)listSelectedRow.getPrimaryKeyValue();
            if (isBillAssignInv) {
                invPks.add(billId);
                continue;
            }
            finPks.add(billId);
        }
        if (isBillAssignInv) {
            finPks = (Set)JsonUtils.jsonToObj((String)plugin.getPageCache().get("finPks"), Set.class);
        } else {
            invPks = (Set)JsonUtils.jsonToObj((String)plugin.getPageCache().get("invPks"), Set.class);
        }
        logger.info(String.format("InvoiceAssginHelper#closedCallBack finPks:%s,invPks:%s", finPks, invPks));
        if (EmptyUtils.isEmpty(finPks) || EmptyUtils.isEmpty(invPks)) {
            return;
        }
        String businessSource = "ap_payapply".equals(plugin.getPageCache().get("businessSource")) ? "ap_payapply" : "ap_finapbill";
        OperateOption operate = OperateOption.create();
        if (isBillAssignInv) {
            operate.setVariableValue("invPks", JsonUtils.objToJson(invPks));
        } else {
            operate.setVariableValue("finPks", JsonUtils.objToJson(finPks));
        }
        if (!(plugin instanceof AbstractListPlugin) && !"ap_payapply".equals(businessSource)) {
            plugin.getView().invokeOperation("refresh");
        }
        plugin.getView().invokeOperation("assign", operate);
    }

    public String validateFin(DynamicObject[] finApBills) {
        for (DynamicObject finApBill : finApBills) {
            if (BigDecimal.ZERO.compareTo(finApBill.getBigDecimal("uninvoicedamt")) == 0) {
                return ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u201c%s\u201d\u8868\u5934\u7684\u201c\u672a\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u201d\u4e3a0\uff0c\u65e0\u6cd5\u6307\u5b9a\u3002", (String)"InvoiceAssignService_2", (String)"fi-ap-business", (Object[])new Object[]{finApBill.getString("billno")});
            }
            if ("ap_invoice".equals(finApBill.getString("sourcebilltype"))) {
                return ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u5df2\u662f\u6536\u7968\u5355\uff0c\u65e0\u6cd5\u6307\u5b9a\u53d1\u7968\u3002", (String)"InvoiceAssignService_3", (String)"fi-ap-business", (Object[])new Object[0]);
            }
            if (BillStatusEnum.SAVE.getValue().equals(finApBill.getString("billstatus"))) {
                return ResManager.loadKDString((String)"\u6682\u5b58\u6001\u7684\u5355\u636e\u65e0\u6cd5\u6307\u5b9a\u53d1\u7968\u3002", (String)"InvoiceAssignService_4", (String)"fi-ap-business", (Object[])new Object[0]);
            }
            if (!BillSrcTypeEnum.FROMEAS.getValue().equals(finApBill.getString("billsrctype"))) continue;
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u4e3aEAS\u96c6\u6210\u65b9\u6848\u540c\u6b65\u7684\u5355\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u53d1\u7968\u3002", (String)"InvoiceAssignService_26", (String)"fi-ap-business", (Object[])new Object[0]), finApBill.getString("billno"));
        }
        return null;
    }

    public String validateApply(DynamicObject applyBill) {
        if (!"A".equals(applyBill.getString("billstatus"))) {
            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u975e\u6682\u5b58\u6001\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u53d1\u7968\u3002", (String)"InvoiceAssignService_18", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        if (!applyBill.getBoolean("isprepayinvoice")) {
            return ResManager.loadKDString((String)"\u201c\u5230\u7968\u9884\u4ed8\u201d\u6253\u5f00\u65f6\uff0c\u624d\u53ef\u6307\u5b9a\u53d1\u7968\u3002", (String)"InvoiceAssignService_19", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        DynamicObject org = applyBill.getDynamicObject("settleorg");
        if (org == null) {
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceAssignService_14", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        DynamicObject currency = applyBill.getDynamicObject("settlecurrency");
        if (currency == null) {
            return ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceAssignService_15", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
        boolean isExistNullAsstact = false;
        HashSet<Long> asstactIds = new HashSet<Long>(8);
        HashSet<String> asstactTypes = new HashSet<String>(4);
        for (DynamicObject applyRow : entry) {
            asstactTypes.add(applyRow.getString("e_asstacttype"));
            DynamicObject eAsstact = applyRow.getDynamicObject("e_asstact");
            if (eAsstact == null) {
                isExistNullAsstact = true;
                continue;
            }
            asstactIds.add(eAsstact.getLong("masterid"));
        }
        if (entry.isEmpty() || isExistNullAsstact) {
            return ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InvoiceAssignService_16", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        if (asstactIds.size() != 1 || asstactTypes.size() != 1) {
            return ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u4ee5\u4e0b\u524d\u63d0\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"InvoiceAssignService_17", (String)"fi-ap-business", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u660e\u7ec6\u884c\u5f80\u6765\u7c7b\u578b\u9700\u4e3a\u4f9b\u5e94\u5546\u3001\u5ba2\u6237\u6216\u5458\u5de5\uff1b", (String)"InvoiceAssignService_20", (String)"fi-ap-business", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u5f80\u6765\u7c7b\u578b\u9700\u4e00\u81f4\uff1b", (String)"InvoiceAssignService_21", (String)"fi-ap-business", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u6536\u6b3e\u4f9b\u5e94\u5546\u9700\u4e00\u81f4\u3002", (String)"InvoiceAssignService_22", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        String asstactType = ((DynamicObject)entry.get(0)).getString("e_asstacttype");
        if (!("bd_supplier".equals(asstactType) || "bos_user".equals(asstactType) || "bd_customer".equals(asstactType))) {
            return ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u4ee5\u4e0b\u524d\u63d0\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"InvoiceAssignService_17", (String)"fi-ap-business", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u660e\u7ec6\u884c\u5f80\u6765\u7c7b\u578b\u9700\u4e3a\u4f9b\u5e94\u5546\u3001\u5ba2\u6237\u6216\u5458\u5de5\uff1b", (String)"InvoiceAssignService_20", (String)"fi-ap-business", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u5f80\u6765\u7c7b\u578b\u9700\u4e00\u81f4\uff1b", (String)"InvoiceAssignService_21", (String)"fi-ap-business", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u5f80\u6765\u6237\u9700\u4e00\u81f4\u3002", (String)"InvoiceAssignService_23", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        return null;
    }

    public String validateInvoice(DynamicObject[] invoices) {
        HashSet<Long> orgIds = new HashSet<Long>(8);
        HashSet<String> asstactTypes = new HashSet<String>(8);
        HashSet<Long> asstactIds = new HashSet<Long>(8);
        HashSet<Long> currencyIds = new HashSet<Long>(8);
        HashMap<Long, String> invoiceBillNoMap = new HashMap<Long, String>(8);
        for (DynamicObject invoice : invoices) {
            BigDecimal unRelatedAmt = invoice.getBigDecimal("unrelatedamt");
            if (BigDecimal.ZERO.compareTo(invoice.getBigDecimal("unrelatedamt")) == 0) {
                return ResManager.loadKDString((String)"\u6536\u7968\u5355\u201c%s\u201d\u8868\u5934\u672a\u5173\u8054\u91d1\u989d\u4e3a0\uff0c\u65e0\u6cd5\u6307\u5b9a\u3002", (String)"InvoiceAssignService_5", (String)"fi-ap-business", (Object[])new Object[]{invoice.getString("billno")});
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(invoice.getString("billstatus"))) {
                return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u5ba1\u6838\u201d\u7684\u5355\u636e\u3002", (String)"InvoiceAssignService_6", (String)"fi-ap-business", (Object[])new Object[0]);
            }
            String invoiceStatus = invoice.getString("invoicestatus");
            if (StringUtils.isNotEmpty((String)invoiceStatus) && !"0".equals(invoiceStatus) && !"7".equals(invoiceStatus)) {
                return ResManager.loadKDString((String)"%s\uff1a\u53d1\u7968\u72b6\u6001\u4e3a\u201c\u5f02\u5e38\u201d/\u201c\u7ea2\u51b2\u201d/\u201c\u4f5c\u5e9f\u201d/\u201c\u5931\u63a7\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u5e94\u4ed8\u3002", (String)"InvoiceAssignService_7", (String)"fi-ap-business", (Object[])new Object[]{invoice.getString("billno")});
            }
            if (invoice.getBoolean("ismatched")) {
                return ResManager.loadKDString((String)"\u6536\u7968\u5355%s\u5df2\u5b58\u5728\u5339\u914d\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6307\u5b9a\u5e94\u4ed8\u64cd\u4f5c\u3002", (String)"InvoiceAssignService_9", (String)"fi-ap-business", (Object[])new Object[]{invoice.getString("billno")});
            }
            orgIds.add(invoice.getLong("org.id"));
            if (invoices.length > 1) {
                asstactTypes.add(invoice.getString("asstacttype"));
                asstactIds.add(invoice.getLong("receivablessupp.id"));
                currencyIds.add(invoice.getLong("currency.id"));
            }
            invoiceBillNoMap.put(invoice.getLong("id"), invoice.getString("billno"));
        }
        Map onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_invoice", orgIds, new ArrayList(invoiceBillNoMap.keySet()));
        if (!onTheWayInvoiceIdsMap.isEmpty()) {
            Map.Entry next = onTheWayInvoiceIdsMap.entrySet().iterator().next();
            DynamicObject replaceBill = QueryServiceHelper.queryOne((String)"ap_replaceinvapply", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", next.getValue())});
            String replaceBillNo = " ";
            if (replaceBill != null) {
                replaceBillNo = replaceBill.getString("billno");
            }
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u5df2\u5173\u8054\u672a\u5ba1\u6838\u7684\u6362\u7968\u7533\u8bf7\uff08%2$s\uff09\uff0c\u8bf7\u901a\u8fc7\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u7533\u8bf7\u540e\u91cd\u8bd5\u3002", (String)"InvoiceAssignService_25", (String)"fi-ap-business", (Object[])new Object[0]), invoiceBillNoMap.get(next.getKey()), replaceBillNo);
        }
        if (invoices.length == 1) {
            return null;
        }
        if (orgIds.size() > 1 || asstactTypes.size() > 1 || asstactIds.size() > 1 || currencyIds.size() > 1) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u3001\u201c\u5f80\u6765\u7c7b\u578b\u201d\u3001\u201c\u5f80\u6765\u6237\u201d\u548c\u201c\u7ed3\u7b97\u5e01\u201d\u90fd\u76f8\u540c\u7684\u6536\u7968\u5355\u8fdb\u884c\u6307\u5b9a\u5e94\u4ed8\u3002", (String)"InvoiceAssignService_10", (String)"fi-ap-business", (Object[])new Object[0]);
        }
        return null;
    }

    private QFilter constructQFilterByFinAp(DynamicObject finApBill) {
        DynamicObject asstact;
        DynamicObject org = finApBill.getDynamicObject("org");
        QFilter qfilter = new QFilter("org", "=", org.getPkValue());
        qfilter.and(new QFilter("unrelatedamt", "!=", (Object)BigDecimal.ZERO));
        qfilter.and(new QFilter("invoicestatus", "in", (Object)new String[]{"0", "", "7"}));
        qfilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qfilter.and(new QFilter("ismatched", "=", (Object)Boolean.FALSE));
        String asstacttype = finApBill.getString("asstacttype");
        if (!EmptyUtils.isEmpty((Object)asstacttype)) {
            qfilter.and(new QFilter("asstacttype", "=", (Object)asstacttype));
        }
        if (!ObjectUtils.isEmpty((Object)(asstact = finApBill.getDynamicObject("asstact")))) {
            if (AsstactTypeEnum.bd_supplier.getValue().equals(asstacttype)) {
                qfilter.and(new QFilter("receivablessupp.masterid", "=", asstact.get("masterid")));
            } else {
                qfilter.and(new QFilter("receivablessupp", "=", asstact.getPkValue()));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f80\u6765\u6237", (String)"InvoiceAssignService_12", (String)"fi-ap-business", (Object[])new Object[0]));
        }
        qfilter.and(new QFilter("currency", "=", (Object)finApBill.getLong("currency.id")));
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_finap_assign_inv", (String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"");
        ArrayList<Long> invoiceIds = new ArrayList<Long>(32);
        for (Row invoiceRow : invoiceDataSet) {
            invoiceIds.add(invoiceRow.getLong("id"));
        }
        if (!invoiceIds.isEmpty()) {
            HashSet<Long> orgIds = new HashSet<Long>(2);
            orgIds.add(org.getLong("id"));
            Map onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_invoice", orgIds, invoiceIds);
            for (Long invId : onTheWayInvoiceIdsMap.keySet()) {
                invoiceIds.remove(invId);
            }
        }
        return new QFilter("id", "in", invoiceIds);
    }

    public QFilter constructQFilterByApply(DynamicObject applyBill) {
        DynamicObject org = applyBill.getDynamicObject("settleorg");
        QFilter qfilter = new QFilter("org", "=", (Object)org.getLong("id"));
        qfilter.and(new QFilter("invoicestatus", "in", (Object)new String[]{"0", ""}));
        qfilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qfilter.and(new QFilter("ismatched", "=", (Object)Boolean.FALSE));
        DynamicObject applyRow = (DynamicObject)applyBill.getDynamicObjectCollection("entry").get(0);
        String eAsstactType = applyRow.getString("e_asstacttype");
        qfilter.and(new QFilter("asstacttype", "=", (Object)eAsstactType));
        if ("bd_supplier".equals(eAsstactType)) {
            qfilter.and(new QFilter("receivablessupp.masterid", "=", (Object)applyRow.getLong("e_asstact.masterid")));
        } else {
            qfilter.and(new QFilter("receivablessupp", "=", (Object)applyRow.getLong("e_asstact.id")));
        }
        BigDecimal applyAmount = applyBill.getBigDecimal("applyamount");
        if (applyAmount.compareTo(BigDecimal.ZERO) > 0) {
            qfilter.and(new QFilter("unrelatedamt", ">", (Object)BigDecimal.ZERO));
        } else if (applyAmount.compareTo(BigDecimal.ZERO) < 0) {
            qfilter.and(new QFilter("unrelatedamt", "<", (Object)BigDecimal.ZERO));
        }
        qfilter.and(new QFilter("currency", "=", (Object)applyBill.getLong("settlecurrency.id")));
        qfilter.and(QFilter.of((String)"unrelatedamt == pricetaxtotal", (Object[])new Object[0]));
        qfilter.and(new QFilter("businesssource", "in", Arrays.asList("", " ")));
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_apply_assign_inv", (String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"");
        ArrayList<Long> invoiceIds = new ArrayList<Long>(32);
        for (Row invoiceRow : invoiceDataSet) {
            invoiceIds.add(invoiceRow.getLong("id"));
        }
        if (!invoiceIds.isEmpty()) {
            HashSet<Long> orgIds = new HashSet<Long>(2);
            orgIds.add(org.getLong("id"));
            Map onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_invoice", orgIds, invoiceIds);
            for (Long invId : onTheWayInvoiceIdsMap.keySet()) {
                invoiceIds.remove(invId);
            }
        }
        return new QFilter("id", "in", invoiceIds);
    }

    private ListShowParameter showFinApForm(DynamicObject invoice, boolean isMultiSelect) {
        DynamicObject asstact;
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ap_finapbill", (boolean)isMultiSelect, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        DynamicObject org = invoice.getDynamicObject("org");
        QFilter qfilter = new QFilter("org", "=", org.getPkValue());
        qfilter.and(new QFilter("billstatus", "=", (Object)"C"));
        String asstacttype = invoice.getString("asstacttype");
        qfilter.and(new QFilter("uninvoicedamt", "!=", (Object)BigDecimal.ZERO));
        if (!EmptyUtils.isEmpty((Object)asstacttype)) {
            qfilter.and(new QFilter("asstacttype", "=", (Object)asstacttype));
        }
        if (!ObjectUtils.isEmpty((Object)(asstact = invoice.getDynamicObject("receivablessupp")))) {
            if ("bd_supplier".equals(asstacttype)) {
                qfilter.and(new QFilter("asstact.masterid", "=", (Object)asstact.getLong("masterid")));
            } else {
                qfilter.and(new QFilter("asstact", "=", (Object)asstact.getLong("id")));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f80\u6765\u6237", (String)"InvoiceAssignService_12", (String)"fi-ap-business", (Object[])new Object[0]));
        }
        qfilter.and(new QFilter("currency", "=", (Object)invoice.getLong("currency.id")));
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_onetheway_fin", (String)"ap_finapbill", (String)"id,org", (QFilter[])new QFilter[]{qfilter}, (String)"");
        if (finApDataSet.hasNext()) {
            ArrayList<Long> billIds = new ArrayList<Long>(32);
            HashSet<Long> orgIds = new HashSet<Long>(2);
            for (Row finApRow : finApDataSet) {
                billIds.add(finApRow.getLong("id"));
                orgIds.add(finApRow.getLong("org"));
            }
            Map onTheWayFinApIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_finapbill", orgIds, billIds);
            for (Map.Entry entrySet : onTheWayFinApIdsMap.entrySet()) {
                billIds.remove(entrySet.getKey());
            }
            lfp.setFilter(new QFilter("id", "in", billIds));
        } else {
            lfp.setFilter(qfilter);
        }
        lsp.setListFilterParameter(lfp);
        return lsp;
    }
}

