/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.pojo.AttachData;
import kd.fi.ap.business.pojo.AttachmentData;
import kd.fi.ap.business.pojo.SimpleXhInvoiceVO;
import kd.fi.ap.enums.AttachTypeEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.business.piaozone.info.InvoiceAttachmentVo;
import kd.fi.arapcommon.business.piaozone.kingdee.HttpServiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.action.InvoiceFilesAction;
import kd.fi.arapcommon.service.log.ServiceInvokeLog;
import kd.fi.arapcommon.util.ErStdConfig;
import org.apache.commons.lang3.StringUtils;

public class InvoiceSynAttachmentService {
    private static final Log logger = LogFactory.getLog(InvoiceSynAttachmentService.class);
    private InvoiceCollectParam collectParam;
    private static final String UID_PREFIX_XH = "rc-upload-ix-";
    private static final String UID_PREFIX_AWS = "rc-upload-ia-";

    @ServiceInvokeLog
    public void synAttachment(InvoiceCollectParam collectParam) {
        if (collectParam == null) {
            return;
        }
        this.initParam(collectParam);
        try {
            if ("true".equals(ErStdConfig.get((String)"invoicecloud.invoicecloudxh"))) {
                this.saveXHAttachData();
            } else {
                this.saveAWSAttachData();
            }
        }
        catch (Exception e) {
            collectParam.getFormView().showTipNotification(e.getMessage());
            logger.error("\u53d1\u7968\u96c6\u6210,AbstractImportInvoicePlugin_getInvoiceAttachments: \u4ece\u53d1\u7968\u4e91\u62c9\u53d6\u9644\u4ef6\u5931\u8d25: ", (Throwable)e);
        }
        finally {
            collectParam.getFormView().updateView("attachmentpanel");
        }
    }

    private void initParam(InvoiceCollectParam collectParam) {
        this.collectParam = collectParam;
    }

    private void saveXHAttachData() {
        logger.info("InvoiceAttachmentService saveXHAttachData begin ");
        Map returnData = this.collectParam.getReturnData();
        IFormView view = this.collectParam.getFormView();
        IDataModel model = view.getModel();
        if (ObjectUtils.isEmpty((Object)returnData) || !(returnData instanceof JSONObject)) {
            return;
        }
        logger.info("InvoiceAttachmentService saveXHAttachData begin to analysis json ");
        JSONObject importInvoiceReturnData = (JSONObject)returnData;
        String jsonString = importInvoiceReturnData.toJSONString();
        SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)jsonString, SimpleXhInvoiceVO.class);
        List<AttachData> attachDatas = simpleXhInvoiceVO.getAttachData();
        if (ObjectUtils.isEmpty(attachDatas)) {
            return;
        }
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
        if (filePanel == null) {
            return;
        }
        List attachmentRowDataInBill = filePanel.getAttachmentData();
        logger.info("InvoiceSynAttachmentService,\u540c\u6b65\u9644\u4ef6-->\u5f53\u524d\u5355\u636e\u4e0a\u5df2\u6709\u7684\u9644\u4ef6\u4fe1\u606f:" + attachmentRowDataInBill);
        List attachmentDataInBill = JSON.parseArray((String)JSONArray.toJSONString((Object)attachmentRowDataInBill), AttachmentData.class);
        Set oldUids = attachmentDataInBill.stream().map(AttachmentData::getUid).collect(Collectors.toSet());
        List needAppendAttachDatas = attachDatas.stream().filter(attachData -> !oldUids.contains(UID_PREFIX_XH + attachData.getAttachNo())).collect(Collectors.toList());
        logger.info("InvoiceSynAttachmentService,\u540c\u6b65\u9644\u4ef6-->\u672c\u6b21\u8ffd\u52a0\u7684\u9644\u4ef6:" + needAppendAttachDatas);
        ArrayList<Map> newAttachmentDatas = new ArrayList<Map>(attachDatas.size());
        if (ObjectUtils.isEmpty((Object)needAppendAttachDatas.size())) {
            return;
        }
        logger.info("InvoiceAttachmentService saveXHAttachData update bill attachments");
        long currentTimeMillis = System.currentTimeMillis();
        for (AttachData attachDataFromInvoiceCloud : needAppendAttachDatas) {
            String decodeUrl;
            int lastIndexOfDot;
            AttachmentData attachmentDataForUpload = new AttachmentData();
            attachmentDataForUpload.setBillPkId(String.valueOf(model.getDataEntity().getPkValue()));
            String attachmentName = attachDataFromInvoiceCloud.getAttachName();
            String attachUrl = attachDataFromInvoiceCloud.getAttachUrl();
            String type = StringUtils.isNotBlank((CharSequence)attachUrl) ? ((lastIndexOfDot = attachUrl.lastIndexOf(46)) >= 0 ? attachUrl.substring(lastIndexOfDot + 1) : ((lastIndexOfDot = (decodeUrl = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(attachUrl)).lastIndexOf(46)) >= 0 ? decodeUrl.substring(lastIndexOfDot + 1) : AttachTypeEnum.getExtByType((String)attachDataFromInvoiceCloud.getAttachType()))) : AttachTypeEnum.getExtByType((String)attachDataFromInvoiceCloud.getAttachType());
            attachmentDataForUpload.setType(type);
            if (!attachmentName.endsWith("." + type)) {
                attachmentName = attachmentName + "." + type;
            }
            attachmentDataForUpload.setName(attachmentName);
            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = attachmentFileService.getInputStream(attachDataFromInvoiceCloud.getAttachUrl());
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                String filePath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachmentName, (InputStream)new ByteArrayInputStream(bytes), 30000);
                attachmentDataForUpload.setUrl(filePath);
                attachmentDataForUpload.setSize(bytes.length);
            }
            catch (IOException e) {
                logger.error("InvoiceSynAttachmentService,", (Throwable)e);
                view.showErrorNotification(ResManager.loadKDString((String)"\u4ece\u53d1\u7968\u4e91\u62c9\u53d6\u9644\u4ef6\u5931\u8d25!", (String)"AbstractImportInvoicePlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            attachmentDataForUpload.setClient("web");
            attachmentDataForUpload.setUid(UID_PREFIX_XH + attachDataFromInvoiceCloud.getAttachNo());
            attachmentDataForUpload.setEntityNum(model.getDataEntityType().getName());
            attachmentDataForUpload.setStatus("success");
            attachmentDataForUpload.setLastModified(currentTimeMillis);
            attachmentDataForUpload.setCreatedate(currentTimeMillis);
            newAttachmentDatas.add((Map)JSON.toJSON((Object)attachmentDataForUpload));
        }
        filePanel.upload(newAttachmentDatas);
        logger.info("InvoiceAttachmentService saveXHAttachData end ");
    }

    private void saveAWSAttachData() {
        logger.info("InvoiceAttachmentService saveAWSAttachData begin ");
        IFormView view = this.collectParam.getFormView();
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        List<Object> invoiceAttachments = this.getTempInvoiceAttachments(dataEntity);
        if (ObjectUtils.isEmpty(invoiceAttachments)) {
            logger.info("InvoiceSynAttachmentService \u540c\u6b65\u9644\u4ef6-->\u7ed3\u675f,\u6ca1\u6709\u9644\u4ef6\u6570\u636e");
            return;
        }
        if (ObjectUtils.isEmpty(invoiceAttachments = invoiceAttachments.stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            logger.info("InvoiceSynAttachmentService \u540c\u6b65\u9644\u4ef6-->\u7ed3\u675f,\u6ca1\u6709\u9644\u4ef6\u6570\u636e");
            return;
        }
        invoiceAttachments.forEach(e -> e.setSerialNo(UID_PREFIX_AWS + e.getSerialNo()));
        Map<String, InvoiceAttachmentVo> invoiceAttachmentsMap = invoiceAttachments.stream().collect(Collectors.toMap(InvoiceAttachmentVo::getSerialNo, e -> e));
        logger.info("InvoiceSynAttachmentService \u540c\u6b65\u9644\u4ef6-->\u67e5\u8be2\u51fa\u6765\u7684\u9644\u4ef6\u96c6\u5408:" + invoiceAttachmentsMap);
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
        List billAttachmentData = filePanel.getAttachmentData();
        logger.info("InvoiceSynAttachmentService \u540c\u6b65\u9644\u4ef6-->\u5355\u636e\u4e0a\u539f\u6709\u7684\u9644\u4ef6," + billAttachmentData);
        Map<String, Map> billAttachmentMap = billAttachmentData.stream().filter(e -> e != null && StringUtils.startsWith((CharSequence)((String)e.get("uid")), (CharSequence)UID_PREFIX_AWS)).collect(Collectors.toMap(e -> (String)e.get("uid"), e -> e));
        HashSet<String> uids = new HashSet<String>(billAttachmentMap.keySet());
        HashSet<String> invoiceAttachmentSerialNos = new HashSet<String>(invoiceAttachmentsMap.keySet());
        for (String uid : uids) {
            if (!invoiceAttachmentSerialNos.contains(uid)) {
                Map needRemoveFile = billAttachmentMap.get(uid);
                logger.info("InvoiceSynAttachmentService \u540c\u6b65\u9644\u4ef6-->\u5355\u636e\u4e0a\u9700\u5220\u9664\u6389\u7684\u9644\u4ef6uid:" + needRemoveFile);
                filePanel.remove(needRemoveFile);
            }
            invoiceAttachmentsMap.remove(uid);
        }
        logger.info("InvoiceSynAttachmentService \u540c\u6b65\u9644\u4ef6-->\u672c\u6b21\u8ffd\u52a0\u7684\u9644\u4ef6:" + invoiceAttachmentsMap);
        Iterator<Map.Entry<String, InvoiceAttachmentVo>> iterator = invoiceAttachmentsMap.entrySet().iterator();
        ArrayList<Map<String, Object>> newAttachments = new ArrayList<Map<String, Object>>(invoiceAttachmentsMap.size());
        while (iterator.hasNext()) {
            Map.Entry<String, InvoiceAttachmentVo> invoiceAttachment = iterator.next();
            InvoiceAttachmentVo attachment = invoiceAttachment.getValue();
            Map<String, Object> invoiceAttachmentMap = this.buildInvoiceAttachmentMap(attachment);
            if (invoiceAttachmentMap == null || invoiceAttachmentMap.isEmpty()) continue;
            newAttachments.add(invoiceAttachmentMap);
        }
        filePanel.upload(newAttachments);
        logger.info("InvoiceAttachmentService saveAWSAttachData end ");
    }

    private Map<String, Object> buildInvoiceAttachmentMap(InvoiceAttachmentVo attachment) {
        Map urlData = HttpServiceHelper.doGetInputStream((String)attachment.getLocalUrl());
        if (urlData == null) {
            return new HashMap<String, Object>(8);
        }
        InputStream attachStream = (InputStream)urlData.get("in");
        if (attachStream == null) {
            return null;
        }
        Long size = (Long)urlData.get("size");
        logger.info(String.format("urlData size: %d", size));
        try {
            size = size == null || size <= 0L ? Long.valueOf(attachStream.available()) : size;
            logger.info(String.format("attachStream.available() : %d", attachStream.available()));
        }
        catch (Exception e) {
            logger.info("\u53d1\u7968\u96c6\u6210,\u6587\u4ef6\u5927\u5c0f\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        String fileName = attachment.getOriginalFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = (String)StringUtils.defaultIfBlank((CharSequence)attachment.getAttachmentName(), (CharSequence)"default");
            String attType = attachment.getAttachmentType();
            int lastIndexOfDot = fileName.lastIndexOf(46);
            if (lastIndexOfDot < 0 && StringUtils.isNotBlank((CharSequence)attType)) {
                fileName = fileName + "." + AttachTypeEnum.getExtByType((String)attType);
            }
        }
        String filePath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName, attachStream, 3000);
        if (size == null || size <= 0L) {
            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = attachmentFileService.getInputStream(filePath);
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                size = bytes.length;
                logger.info(String.format("FileServiceFactory.getAttachmentFileService() file size : %d", size));
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u9644\u4ef6\u6587\u4ef6\u5927\u5c0f\u5931\u8d25", (Throwable)e);
                size = 1024L;
            }
        }
        String uid = attachment.getSerialNo();
        HashMap<String, Object> filePanelMap = new HashMap<String, Object>(8);
        filePanelMap.put("name", fileName);
        filePanelMap.put("size", size);
        filePanelMap.put("type", "pdf");
        filePanelMap.put("status", "success");
        filePanelMap.put("url", filePath);
        filePanelMap.put("uid", uid);
        filePanelMap.put("description", attachment.getRemark());
        return filePanelMap;
    }

    private List<InvoiceAttachmentVo> getTempInvoiceAttachments(DynamicObject dataEntity) {
        HashSet<String> serialNos = new HashSet<String>(8);
        DynamicObjectCollection invEntry = dataEntity.getDynamicObjectCollection("inventry");
        for (DynamicObject invRow : invEntry) {
            if (!InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype"))) continue;
            serialNos.add(invRow.getString("i_serialno"));
        }
        logger.info("InvoiceSynAttachmentService getTempInvoiceAttachments serialNos: " + serialNos);
        if (serialNos.isEmpty()) {
            return new ArrayList<InvoiceAttachmentVo>(2);
        }
        ArrayList<InvoiceAttachmentVo> attachments = new ArrayList<InvoiceAttachmentVo>(8);
        for (String serialNo : serialNos) {
            JSONArray attachmentJSonArray;
            HashSet<String> tempSerialNos = new HashSet<String>(8);
            tempSerialNos.add(serialNo);
            InvoiceFilesAction filesAction = new InvoiceFilesAction(dataEntity, tempSerialNos);
            String executeResult = filesAction.execute();
            JSONObject resultJson = JSON.parseObject((String)executeResult);
            if (resultJson == null || !"0000".equals(resultJson.getString("errcode")) || (attachmentJSonArray = resultJson.getJSONArray("data")) == null) continue;
            attachments.addAll(JSON.parseArray((String)attachmentJSonArray.toJSONString(), InvoiceAttachmentVo.class));
        }
        return attachments;
    }
}

