/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.articulate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.invoice.articulate.IInvoiceArticulateService;
import kd.fi.ap.business.pojo.InvoiceArticulateBillDTO;
import kd.fi.ap.business.pojo.InvoiceArticulateBillParam;
import kd.fi.ap.business.pojo.InvoiceArticulateContext;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public abstract class AbstractInvoiceArticulateService
implements IInvoiceArticulateService {
    protected static final Log logger = LogFactory.getLog(AbstractInvoiceArticulateService.class);

    @Override
    public List<Object> articulate(InvoiceArticulateContext articulateContext, Long[] invoiceIds, Long[] asstIds) {
        if (ObjectUtils.isEmpty((Object)articulateContext) || ObjectUtils.isEmpty((Object[])invoiceIds) && ObjectUtils.isEmpty((Object[])asstIds)) {
            return new ArrayList<Object>(2);
        }
        ArrayList<InvoiceArticulateBillParam> invoiceBillParams = new ArrayList<InvoiceArticulateBillParam>(invoiceIds.length);
        for (Long invoiceId : invoiceIds) {
            InvoiceArticulateBillParam invoiceBillParam = new InvoiceArticulateBillParam();
            invoiceBillParam.setBillId(invoiceId);
            invoiceBillParams.add(invoiceBillParam);
        }
        ArrayList<InvoiceArticulateBillParam> asstBillParams = new ArrayList<InvoiceArticulateBillParam>(invoiceIds.length);
        for (Long asstId : asstIds) {
            InvoiceArticulateBillParam asstBillParam = new InvoiceArticulateBillParam();
            asstBillParam.setBillId(asstId);
            asstBillParams.add(asstBillParam);
        }
        return this.articulate(articulateContext, invoiceBillParams, asstBillParams);
    }

    @Override
    public List<Object> articulate(InvoiceArticulateContext articulateContext, Map<Long, List<Long>> invoiceRowIdMap, Map<Long, List<Long>> asstRowIdMap) {
        if (ObjectUtils.isEmpty((Object)articulateContext) || ObjectUtils.isEmpty(invoiceRowIdMap) && ObjectUtils.isEmpty(asstRowIdMap)) {
            return new ArrayList<Object>(2);
        }
        ArrayList<InvoiceArticulateBillParam> invoiceBillParams = new ArrayList<InvoiceArticulateBillParam>(32);
        for (Map.Entry<Long, List<Long>> entrySet : invoiceRowIdMap.entrySet()) {
            Long invoiceId = entrySet.getKey();
            List<Long> invoiceRowIds = entrySet.getValue();
            for (Long invoiceRowId : invoiceRowIds) {
                InvoiceArticulateBillParam invoiceBillParam = new InvoiceArticulateBillParam();
                invoiceBillParam.setBillId(invoiceId).setEntryId(invoiceRowId);
                invoiceBillParams.add(invoiceBillParam);
            }
        }
        ArrayList<InvoiceArticulateBillParam> asstBillParams = new ArrayList<InvoiceArticulateBillParam>(32);
        for (Map.Entry<Long, List<Long>> entrySet : asstRowIdMap.entrySet()) {
            Long asstId = entrySet.getKey();
            List<Long> asstRowIds = entrySet.getValue();
            for (Long asstRowId : asstRowIds) {
                InvoiceArticulateBillParam invoiceBillParam = new InvoiceArticulateBillParam();
                invoiceBillParam.setBillId(asstId).setEntryId(asstRowId);
                asstBillParams.add(invoiceBillParam);
            }
        }
        return this.articulate(articulateContext, invoiceBillParams, asstBillParams);
    }

    @Override
    public List<Object> articulate(InvoiceArticulateContext articulateContext, List<InvoiceArticulateBillParam> invoiceBillParams, List<InvoiceArticulateBillParam> asstBillParams) {
        if (ObjectUtils.isEmpty((Object)articulateContext) || ObjectUtils.isEmpty(invoiceBillParams) && ObjectUtils.isEmpty(asstBillParams)) {
            return new ArrayList<Object>(2);
        }
        logger.info("AbstractInvoiceArticulateService articulate articulateContext is : " + articulateContext);
        logger.info("AbstractInvoiceArticulateService articulate invoiceBillParams is : " + invoiceBillParams);
        logger.info("AbstractInvoiceArticulateService articulate asstBillParams is : " + asstBillParams);
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"ap_invoice_articulate");){
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0121", null, (Object[])new Object[]{invoiceBillParams, asstBillParams});
            articulateContext.setArticulate(true);
            this.addControlByMatch(invoiceBillParams, asstBillParams);
            List<InvoiceArticulateBillDTO> mainBillVOs = this.getMainBillVOs(articulateContext, invoiceBillParams);
            List<InvoiceArticulateBillDTO> asstBillVOs = this.getAsstBillVOs(articulateContext, asstBillParams);
            Object[] matchRecords = this.executeArticulate(articulateContext, mainBillVOs, asstBillVOs);
            if (ObjectUtils.isEmpty((Object[])matchRecords)) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                return arrayList;
            }
            this.writeBack(articulateContext, (DynamicObject[])matchRecords);
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0121", null, (Object[])new Object[]{invoiceBillParams, asstBillParams});
            List<Object> list = this.saveMatchRecord((DynamicObject[])matchRecords);
            return list;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public List<Object> unArticulate(List<Long> recordIds) {
        return this.unArticulate(new InvoiceArticulateContext(), recordIds);
    }

    @Override
    public List<Object> unArticulate(InvoiceArticulateContext articulateContext, List<Long> recordIds) {
        if (ObjectUtils.isEmpty((Object)articulateContext) || ObjectUtils.isEmpty(recordIds)) {
            return new ArrayList<Object>(2);
        }
        logger.info("AbstractInvoiceArticulateService unArticulate articulateContext is : " + articulateContext);
        logger.info("AbstractInvoiceArticulateService unArticulate recordIds is : " + recordIds);
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"ap_invoice_unarticulate");){
            articulateContext.setArticulate(false);
            QFilter filter = new QFilter("id", "in", recordIds);
            DynamicObject[] matchRecords = BusinessDataServiceHelper.load((String)"ap_matchrecord_verify", (String)String.join((CharSequence)",", this.getMatchRecordSelectors()), (QFilter[])new QFilter[]{filter});
            this.addControlByUnMatch(matchRecords);
            this.writeBack(articulateContext, matchRecords);
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0122", null, (Object[])new Object[]{matchRecords});
            List<Object> list = this.deleteMatchRecord(recordIds.toArray(new Long[0]));
            return list;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected abstract List<InvoiceArticulateBillDTO> getMainBillVOs(InvoiceArticulateContext var1, List<InvoiceArticulateBillParam> var2);

    protected abstract List<InvoiceArticulateBillDTO> getAsstBillVOs(InvoiceArticulateContext var1, List<InvoiceArticulateBillParam> var2);

    protected abstract DynamicObject[] executeArticulate(InvoiceArticulateContext var1, List<InvoiceArticulateBillDTO> var2, List<InvoiceArticulateBillDTO> var3);

    protected abstract void writeBack(InvoiceArticulateContext var1, DynamicObject[] var2);

    private Set<String> getMatchRecordSelectors() {
        HashSet<String> selectors = new HashSet<String>(32);
        selectors.add("entry.billtype");
        selectors.add("entry.billid");
        selectors.add("entry.assbilltype");
        selectors.add("entry.assbillid");
        selectors.add("writeofftypeid");
        selectors.add("billentryid");
        selectors.add("matchamt");
        selectors.add("assbillentryid");
        selectors.add("assmatchamt");
        return selectors;
    }

    private void addControlByMatch(List<InvoiceArticulateBillParam> invoiceBillParams, List<InvoiceArticulateBillParam> asstBillParams) {
        Set invoiceIds = invoiceBillParams.stream().map(InvoiceArticulateBillParam::getBillId).collect(Collectors.toSet());
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_invoice", (String)"ap_invoice_articulate_lock", invoiceIds, (boolean)true);
        Set asstIds = asstBillParams.stream().map(InvoiceArticulateBillParam::getBillId).collect(Collectors.toSet());
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_finapbill", (String)"ap_invoice_articulate_lock", asstIds, (boolean)true);
    }

    private void addControlByUnMatch(DynamicObject[] matchRecords) {
        HashMap<String, Set> billTypeIdMap = new HashMap<String, Set>(4);
        for (DynamicObject matchRecord : matchRecords) {
            DynamicObjectCollection entry = matchRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String mainBillType = row.getString("billtype.number");
                Set mainBillIds = billTypeIdMap.getOrDefault(mainBillType, new HashSet(32));
                mainBillIds.add(row.getLong("billid"));
                billTypeIdMap.put(mainBillType, mainBillIds);
                String assBillType = row.getString("assbilltype.number");
                Set asstBillIds = billTypeIdMap.getOrDefault(assBillType, new HashSet(32));
                asstBillIds.add(row.getLong("assbillid"));
                billTypeIdMap.put(assBillType, asstBillIds);
            }
        }
        for (Map.Entry entry : billTypeIdMap.entrySet()) {
            ConcurrencyCtrlUtil.addCtrlInTX((String)((String)entry.getKey()), (String)"ap_invoice_articulate_lock", (Set)((Set)entry.getValue()), (boolean)true);
        }
    }

    private List<Object> saveMatchRecord(DynamicObject[] matchRecords) {
        OperateOption operateOption = OperateOption.create();
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_matchrecord_verify", (DynamicObject[])matchRecords, (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)saveResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_matchrecord_verify", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)auditResult);
        return auditResult.getSuccessPkIds();
    }

    private List<Object> deleteMatchRecord(Long[] recordIds) {
        OperateOption operateOption = OperateOption.create();
        OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_matchrecord_verify", (Object[])recordIds, (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)unAuditResult);
        OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ap_matchrecord_verify", (Object[])recordIds, (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)deleteResult);
        return deleteResult.getSuccessPkIds();
    }
}

