/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.articulate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.articulate.AbstractInvoiceArticulateService;
import kd.fi.ap.business.pojo.InvoiceArticulateBillDTO;
import kd.fi.ap.business.pojo.InvoiceArticulateBillParam;
import kd.fi.ap.business.pojo.InvoiceArticulateContext;
import kd.fi.ap.business.pojo.InvoiceArticulateRowDTO;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;

public class FinApInvoiceArticulateServiceImpl
extends AbstractInvoiceArticulateService {
    @Override
    protected List<InvoiceArticulateBillDTO> getMainBillVOs(InvoiceArticulateContext articulateContext, List<InvoiceArticulateBillParam> invoiceParams) {
        return this.constructMainBillDTOByBill(invoiceParams);
    }

    @Override
    protected List<InvoiceArticulateBillDTO> getAsstBillVOs(InvoiceArticulateContext articulateContext, List<InvoiceArticulateBillParam> asstParams) {
        return this.constructAsstBillDTOByBill(asstParams);
    }

    @Override
    protected DynamicObject[] executeArticulate(InvoiceArticulateContext articulateContext, List<InvoiceArticulateBillDTO> invoiceBillVOs, List<InvoiceArticulateBillDTO> finApBillVOs) {
        ArrayList<DynamicObject> articulateRecords = new ArrayList<DynamicObject>(64);
        articulateRecords.addAll(this.articulateByRow(finApBillVOs, 1893666267970144256L));
        logger.info("FinApInvoiceArticulateServiceImpl articulateByRow1 articulateRecords size :" + articulateRecords.size());
        articulateRecords.addAll(this.finApRedAndBlueArticulate(articulateContext, finApBillVOs));
        logger.info("FinApInvoiceArticulateServiceImpl finApRedAndBlueArticulate articulateRecords size :" + articulateRecords.size());
        articulateRecords.addAll(this.articulateByRow(invoiceBillVOs, 1893666802358029312L));
        logger.info("FinApInvoiceArticulateServiceImpl articulateByRow2 articulateRecords size :" + articulateRecords.size());
        articulateRecords.addAll(this.invoiceRedAndBlueArticulate(articulateContext, invoiceBillVOs));
        logger.info("FinApInvoiceArticulateServiceImpl invoiceRedAndBlueArticulate articulateRecords size :" + articulateRecords.size());
        articulateRecords.addAll(this.invoiceArticulateFinAp(articulateContext, invoiceBillVOs, finApBillVOs));
        logger.info("FinApInvoiceArticulateServiceImpl invoiceArticulateFinAp articulateRecords size :" + articulateRecords.size());
        this.setArticulateRecordOtherFieldValue(articulateRecords);
        if (articulateContext.isFilerOnlyApArticulate()) {
            DynamicObject[] records = this.filterUnArticulateInvoiceRecords(articulateRecords);
            logger.info("FinApInvoiceArticulateServiceImpl filterUnArticulateInvoiceRecords records size :" + records.length);
            return records;
        }
        return articulateRecords.toArray(new DynamicObject[0]);
    }

    @Override
    protected void writeBack(InvoiceArticulateContext articulateContext, DynamicObject[] articulateRecords) {
        HashMap<Long, BigDecimal> finApRowWriteBackAmtMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, BigDecimal> invoiceRowWriteBackAmtMap = new HashMap<Long, BigDecimal>(64);
        HashSet<Long> finApBillIds = new HashSet<Long>(64);
        HashSet<Long> invoiceBillIds = new HashSet<Long>(64);
        for (DynamicObject articulateRecord : articulateRecords) {
            DynamicObjectCollection entry = articulateRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal invoiceRpwWriteBackAmt;
                BigDecimal finApRpwWriteBackAmt;
                String mainBillType = row.getString("billtype.number");
                long mainBillId = row.getLong("billid");
                long mainEntryId = row.getLong("billentryid");
                BigDecimal mainArticulateAmt = row.getBigDecimal("matchamt");
                String asstBillType = row.getString("assbilltype.number");
                long asstBillId = row.getLong("assbillid");
                long asstEntryId = row.getLong("assbillentryid");
                BigDecimal asstArticulateAmt = row.getBigDecimal("assmatchamt");
                if ("ap_finapbill".equals(mainBillType)) {
                    finApRpwWriteBackAmt = finApRowWriteBackAmtMap.getOrDefault(mainEntryId, BigDecimal.ZERO);
                    finApRpwWriteBackAmt = finApRpwWriteBackAmt.add(mainArticulateAmt);
                    finApRowWriteBackAmtMap.put(mainEntryId, finApRpwWriteBackAmt);
                    finApBillIds.add(mainBillId);
                } else {
                    invoiceRpwWriteBackAmt = invoiceRowWriteBackAmtMap.getOrDefault(mainEntryId, BigDecimal.ZERO);
                    invoiceRpwWriteBackAmt = invoiceRpwWriteBackAmt.add(mainArticulateAmt);
                    invoiceRowWriteBackAmtMap.put(mainEntryId, invoiceRpwWriteBackAmt);
                    invoiceBillIds.add(mainBillId);
                }
                if ("ap_finapbill".equals(asstBillType)) {
                    finApRpwWriteBackAmt = finApRowWriteBackAmtMap.getOrDefault(asstEntryId, BigDecimal.ZERO);
                    finApRpwWriteBackAmt = finApRpwWriteBackAmt.add(asstArticulateAmt);
                    finApRowWriteBackAmtMap.put(asstEntryId, finApRpwWriteBackAmt);
                    finApBillIds.add(asstBillId);
                    continue;
                }
                invoiceRpwWriteBackAmt = invoiceRowWriteBackAmtMap.getOrDefault(asstEntryId, BigDecimal.ZERO);
                invoiceRpwWriteBackAmt = invoiceRpwWriteBackAmt.add(asstArticulateAmt);
                invoiceRowWriteBackAmtMap.put(asstEntryId, invoiceRpwWriteBackAmt);
                invoiceBillIds.add(asstBillId);
            }
        }
        this.writeBackFinAp(finApBillIds, finApRowWriteBackAmtMap, articulateContext.isArticulate());
        this.writeBackInvoice(invoiceBillIds, invoiceRowWriteBackAmtMap, articulateContext.isArticulate());
    }

    private void writeBackFinAp(Set<Long> finApBillIds, Map<Long, BigDecimal> finApRowWriteBackAmtMap, boolean isAccurate) {
        DynamicObject[] finApBills;
        if (ObjectUtils.isEmpty(finApBillIds) || ObjectUtils.isEmpty(finApRowWriteBackAmtMap)) {
            return;
        }
        String selectors = "uninvoicedamt,e_invoicedamt,e_uninvoicedamt";
        for (DynamicObject finApBill : finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)})) {
            BigDecimal totalWriteBackAmt = BigDecimal.ZERO;
            DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detail : detailEntry) {
                BigDecimal finApRowWriteBackAmt = finApRowWriteBackAmtMap.get(detail.getLong("id"));
                if (finApRowWriteBackAmt == null || finApRowWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal eInvoicedAmt = detail.getBigDecimal("e_invoicedamt");
                BigDecimal eUnInvoicedAmt = detail.getBigDecimal("e_uninvoicedamt");
                if (isAccurate) {
                    eInvoicedAmt = eInvoicedAmt.add(finApRowWriteBackAmt);
                    eUnInvoicedAmt = eUnInvoicedAmt.subtract(finApRowWriteBackAmt);
                } else {
                    eInvoicedAmt = eInvoicedAmt.subtract(finApRowWriteBackAmt);
                    eUnInvoicedAmt = eUnInvoicedAmt.add(finApRowWriteBackAmt);
                }
                detail.set("e_invoicedamt", (Object)eInvoicedAmt);
                detail.set("e_uninvoicedamt", (Object)eUnInvoicedAmt);
                totalWriteBackAmt = totalWriteBackAmt.add(finApRowWriteBackAmt);
            }
            BigDecimal unInvoicedAmt = finApBill.getBigDecimal("uninvoicedamt");
            unInvoicedAmt = isAccurate ? unInvoicedAmt.subtract(totalWriteBackAmt) : unInvoicedAmt.add(totalWriteBackAmt);
            finApBill.set("uninvoicedamt", (Object)unInvoicedAmt);
        }
        SaveServiceHelper.save((DynamicObject[])finApBills);
    }

    private void writeBackInvoice(Set<Long> invoiceBillIds, Map<Long, BigDecimal> invoiceRowWriteBackAmtMap, boolean isAccurate) {
        DynamicObject[] invoiceBills;
        if (ObjectUtils.isEmpty(invoiceBillIds) || ObjectUtils.isEmpty(invoiceRowWriteBackAmtMap)) {
            return;
        }
        String selectors = "unrelatedamt,e_relatedamt,e_unrelatedamt";
        for (DynamicObject invoice : invoiceBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceBillIds)})) {
            BigDecimal totalWriteBackAmt = BigDecimal.ZERO;
            DynamicObjectCollection detailEntry = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject detail : detailEntry) {
                BigDecimal invoiceRowWriteBackAmt = invoiceRowWriteBackAmtMap.get(detail.getLong("id"));
                if (invoiceRowWriteBackAmt == null || invoiceRowWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal eRelatedAmt = detail.getBigDecimal("e_relatedamt");
                BigDecimal eUnRelatedAmt = detail.getBigDecimal("e_unrelatedamt");
                if (isAccurate) {
                    eRelatedAmt = eRelatedAmt.add(invoiceRowWriteBackAmt);
                    eUnRelatedAmt = eUnRelatedAmt.subtract(invoiceRowWriteBackAmt);
                } else {
                    eRelatedAmt = eRelatedAmt.subtract(invoiceRowWriteBackAmt);
                    eUnRelatedAmt = eUnRelatedAmt.add(invoiceRowWriteBackAmt);
                }
                detail.set("e_relatedamt", (Object)eRelatedAmt);
                detail.set("e_unrelatedamt", (Object)eUnRelatedAmt);
                totalWriteBackAmt = totalWriteBackAmt.add(invoiceRowWriteBackAmt);
            }
            BigDecimal unInvoicedAmt = invoice.getBigDecimal("unrelatedamt");
            unInvoicedAmt = isAccurate ? unInvoicedAmt.subtract(totalWriteBackAmt) : unInvoicedAmt.add(totalWriteBackAmt);
            invoice.set("unrelatedamt", (Object)unInvoicedAmt);
        }
        SaveServiceHelper.save((DynamicObject[])invoiceBills);
    }

    private List<DynamicObject> invoiceArticulateFinAp(InvoiceArticulateContext articulateContext, List<InvoiceArticulateBillDTO> invoiceBillVOs, List<InvoiceArticulateBillDTO> finApBillVOs) {
        if (articulateContext.isAccurateArticulate()) {
            long accurateArticulateId;
            ArrayList<DynamicObject> articulateRecords = new ArrayList<DynamicObject>(32);
            HashMap<Long, List> sameAccurateIdInvoiceVOMap = new HashMap<Long, List>(16);
            HashMap<Long, List> sameAccurateIdFinApVOMap = new HashMap<Long, List>(16);
            for (InvoiceArticulateBillDTO invoiceArticulateBillDTO : invoiceBillVOs) {
                accurateArticulateId = invoiceArticulateBillDTO.getAccurateArticulateId();
                List sameAccurateIdInvoiceVos = sameAccurateIdInvoiceVOMap.getOrDefault(accurateArticulateId, new ArrayList(32));
                sameAccurateIdInvoiceVos.add(invoiceArticulateBillDTO);
                sameAccurateIdInvoiceVOMap.put(accurateArticulateId, sameAccurateIdInvoiceVos);
            }
            for (InvoiceArticulateBillDTO invoiceArticulateBillDTO : finApBillVOs) {
                accurateArticulateId = invoiceArticulateBillDTO.getAccurateArticulateId();
                List sameAccurateIdFinApVos = sameAccurateIdFinApVOMap.getOrDefault(accurateArticulateId, new ArrayList(32));
                sameAccurateIdFinApVos.add(invoiceArticulateBillDTO);
                sameAccurateIdFinApVOMap.put(accurateArticulateId, sameAccurateIdFinApVos);
            }
            for (Map.Entry entry : sameAccurateIdInvoiceVOMap.entrySet()) {
                List sameAccurateIdFinApVos = (List)sameAccurateIdFinApVOMap.get(entry.getKey());
                if (ObjectUtils.isEmpty((Object)sameAccurateIdFinApVos)) continue;
                List sameAccurateIdInvoiceVos = (List)entry.getValue();
                articulateRecords.addAll(this.articulateByBill(sameAccurateIdInvoiceVos, sameAccurateIdFinApVos, 1893667005572058112L));
            }
            return articulateRecords;
        }
        return this.articulateByBill(invoiceBillVOs, finApBillVOs, 1893667005572058112L);
    }

    private List<DynamicObject> invoiceRedAndBlueArticulate(InvoiceArticulateContext articulateContext, List<InvoiceArticulateBillDTO> invoiceBillVOs) {
        ArrayList<DynamicObject> invoiceBillArticulateRecords = new ArrayList<DynamicObject>(32);
        HashMap<Long, Object> groupByAccurateIdMap = new HashMap<Long, Object>(8);
        if (articulateContext.isAccurateArticulate()) {
            for (InvoiceArticulateBillDTO invoiceArticulateBillDTO : invoiceBillVOs) {
                long accurateArticulateId = invoiceArticulateBillDTO.getAccurateArticulateId();
                Iterator sameAccurateIdVos = groupByAccurateIdMap.getOrDefault(accurateArticulateId, new ArrayList(32));
                sameAccurateIdVos.add(invoiceArticulateBillDTO);
                groupByAccurateIdMap.put(accurateArticulateId, sameAccurateIdVos);
            }
        } else {
            groupByAccurateIdMap.put(0L, invoiceBillVOs);
        }
        for (Map.Entry entry : groupByAccurateIdMap.entrySet()) {
            List sameAccurateIdVos = (List)entry.getValue();
            HashMap<String, List> assignInvoiceISrcTypeMap = new HashMap<String, List>(8);
            for (InvoiceArticulateBillDTO invoiceBillVO : sameAccurateIdVos) {
                String iSrcType = invoiceBillVO.getBillOriginType();
                List sameISrcTypeInvoices = assignInvoiceISrcTypeMap.getOrDefault(iSrcType, new ArrayList(32));
                sameISrcTypeInvoices.add(invoiceBillVO);
                assignInvoiceISrcTypeMap.put(iSrcType, sameISrcTypeInvoices);
            }
            for (Map.Entry entrySet2 : assignInvoiceISrcTypeMap.entrySet()) {
                List sameISrcTypeInvoices = (List)entrySet2.getValue();
                ArrayList<InvoiceArticulateBillDTO> mainBillArticulateVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
                ArrayList<InvoiceArticulateBillDTO> asstBillArticulateVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
                for (InvoiceArticulateBillDTO invoiceBillVo : sameISrcTypeInvoices) {
                    if (invoiceBillVo.getCanArticulateAmt().compareTo(BigDecimal.ZERO) > 0) {
                        mainBillArticulateVOs.add(invoiceBillVo);
                        continue;
                    }
                    if (invoiceBillVo.getCanArticulateAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                    asstBillArticulateVOs.add(invoiceBillVo);
                }
                invoiceBillArticulateRecords.addAll(this.articulateByBill(mainBillArticulateVOs, asstBillArticulateVOs, 1893666802358029312L));
            }
            ArrayList<InvoiceArticulateBillDTO> mainBillVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
            ArrayList<InvoiceArticulateBillDTO> asstBillVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
            for (InvoiceArticulateBillDTO invoiceBillVO : sameAccurateIdVos) {
                BigDecimal canArticulateBasic = invoiceBillVO.getCanArticulateAmt();
                if (canArticulateBasic.compareTo(BigDecimal.ZERO) > 0) {
                    mainBillVOs.add(invoiceBillVO);
                    continue;
                }
                if (canArticulateBasic.compareTo(BigDecimal.ZERO) >= 0) continue;
                asstBillVOs.add(invoiceBillVO);
            }
            invoiceBillArticulateRecords.addAll(this.articulateByBill(mainBillVOs, asstBillVOs, 1893666802358029312L));
        }
        return invoiceBillArticulateRecords;
    }

    private List<DynamicObject> finApRedAndBlueArticulate(InvoiceArticulateContext articulateContext, List<InvoiceArticulateBillDTO> billVOS) {
        ArrayList<DynamicObject> finApBillArticulateRecords = new ArrayList<DynamicObject>(32);
        HashMap<Long, List<InvoiceArticulateBillDTO>> groupByAccurateIdMap = new HashMap<Long, List<InvoiceArticulateBillDTO>>(8);
        if (articulateContext.isAccurateArticulate()) {
            for (InvoiceArticulateBillDTO invoiceArticulateBillDTO : billVOS) {
                long accurateArticulateId = invoiceArticulateBillDTO.getAccurateArticulateId();
                List sameAccurateIdVos = groupByAccurateIdMap.getOrDefault(accurateArticulateId, new ArrayList(32));
                sameAccurateIdVos.add(invoiceArticulateBillDTO);
                groupByAccurateIdMap.put(accurateArticulateId, sameAccurateIdVos);
            }
        } else {
            groupByAccurateIdMap.put(0L, billVOS);
        }
        for (Map.Entry entry : groupByAccurateIdMap.entrySet()) {
            List sameAccurateIdVos = (List)entry.getValue();
            ArrayList<InvoiceArticulateBillDTO> mainBillArticulateVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
            ArrayList<InvoiceArticulateBillDTO> asstBillArticulateVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
            for (InvoiceArticulateBillDTO billVO : sameAccurateIdVos) {
                if (billVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) > 0) {
                    mainBillArticulateVOs.add(billVO);
                    continue;
                }
                if (billVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                asstBillArticulateVOs.add(billVO);
            }
            finApBillArticulateRecords.addAll(this.articulateByBill(mainBillArticulateVOs, asstBillArticulateVOs, 1893666267970144256L));
        }
        return finApBillArticulateRecords;
    }

    private List<DynamicObject> articulateByRow(List<InvoiceArticulateBillDTO> billVOs, long writeOffTypeId) {
        ArrayList<DynamicObject> entrySelfRecords = new ArrayList<DynamicObject>(32);
        for (InvoiceArticulateBillDTO billVO : billVOs) {
            List<InvoiceArticulateRowDTO> entryArticulateVOs = billVO.getEntryArticulateVOs();
            ArrayList<InvoiceArticulateRowDTO> mainEntryVOs = new ArrayList<InvoiceArticulateRowDTO>(32);
            ArrayList<InvoiceArticulateRowDTO> asstEntryVOs = new ArrayList<InvoiceArticulateRowDTO>(32);
            for (InvoiceArticulateRowDTO entryVO : entryArticulateVOs) {
                if (entryVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) > 0) {
                    mainEntryVOs.add(entryVO);
                    continue;
                }
                if (entryVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                asstEntryVOs.add(entryVO);
            }
            if (mainEntryVOs.isEmpty() || asstEntryVOs.isEmpty()) continue;
            DynamicObject record = this.createNewArticulateRecord(billVO, writeOffTypeId);
            Iterator asstEntryIterator = asstEntryVOs.iterator();
            InvoiceArticulateRowDTO nowAsstEntryVO = (InvoiceArticulateRowDTO)asstEntryIterator.next();
            for (InvoiceArticulateRowDTO mainEntryVO : mainEntryVOs) {
                BigDecimal mainArticulateAmt = mainEntryVO.getCanArticulateAmt();
                while (nowAsstEntryVO != null) {
                    BigDecimal asstArticulateAmt = nowAsstEntryVO.getCanArticulateAmt();
                    BigDecimal articulateAmt = BigDecimal.ZERO;
                    articulateAmt = mainArticulateAmt.abs().compareTo(asstArticulateAmt.abs()) >= 0 ? asstArticulateAmt.negate() : mainArticulateAmt;
                    mainArticulateAmt = mainArticulateAmt.subtract(articulateAmt);
                    asstArticulateAmt = asstArticulateAmt.add(articulateAmt);
                    nowAsstEntryVO.setCanArticulateAmt(asstArticulateAmt);
                    this.createNewArticulateRecordRow(record, articulateAmt, billVO, mainEntryVO, billVO, nowAsstEntryVO);
                    if (asstArticulateAmt.compareTo(BigDecimal.ZERO) == 0) {
                        InvoiceArticulateRowDTO invoiceArticulateRowDTO = nowAsstEntryVO = asstEntryIterator.hasNext() ? (InvoiceArticulateRowDTO)asstEntryIterator.next() : null;
                    }
                    if (mainArticulateAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                    break;
                }
                mainEntryVO.setCanArticulateAmt(mainArticulateAmt);
                if (nowAsstEntryVO != null) continue;
                break;
            }
            entrySelfRecords.add(record);
        }
        return entrySelfRecords;
    }

    private List<DynamicObject> articulateByBill(List<InvoiceArticulateBillDTO> mainBillVOs, List<InvoiceArticulateBillDTO> asstBillVOs, long writeOffTypeId) {
        ArrayList<DynamicObject> articulateRecords = new ArrayList<DynamicObject>(32);
        if (mainBillVOs.isEmpty() || asstBillVOs.isEmpty()) {
            return articulateRecords;
        }
        Iterator<InvoiceArticulateBillDTO> asstBillIterator = asstBillVOs.iterator();
        InvoiceArticulateBillDTO nowAsstBillVO = asstBillIterator.next();
        Iterator<InvoiceArticulateRowDTO> asstBillEntryIterator = nowAsstBillVO.getEntryArticulateVOs().iterator();
        InvoiceArticulateRowDTO nowAsstEntryVO = asstBillEntryIterator.next();
        for (InvoiceArticulateBillDTO mainBillVO : mainBillVOs) {
            BigDecimal mainHeadArticulateAmt = mainBillVO.getCanArticulateAmt();
            if (mainHeadArticulateAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            List<InvoiceArticulateRowDTO> mainEntryVOs = mainBillVO.getEntryArticulateVOs();
            for (InvoiceArticulateRowDTO mainEntryVO : mainEntryVOs) {
                BigDecimal mainRowArticulateAmt;
                BigDecimal beforeArticulateRowAmt = mainRowArticulateAmt = mainEntryVO.getCanArticulateAmt().abs().compareTo(mainHeadArticulateAmt.abs()) > 0 ? mainHeadArticulateAmt : mainEntryVO.getCanArticulateAmt();
                if (mainRowArticulateAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                while (nowAsstBillVO != null) {
                    BigDecimal asstHeadArticulateAmt = nowAsstBillVO.getCanArticulateAmt();
                    while (nowAsstEntryVO != null) {
                        BigDecimal asstRowArticulateAmt;
                        BigDecimal bigDecimal = asstRowArticulateAmt = nowAsstEntryVO.getCanArticulateAmt().abs().compareTo(asstHeadArticulateAmt.abs()) > 0 ? asstHeadArticulateAmt : nowAsstEntryVO.getCanArticulateAmt();
                        if (asstRowArticulateAmt.compareTo(BigDecimal.ZERO) == 0) {
                            nowAsstEntryVO = asstBillEntryIterator.hasNext() ? asstBillEntryIterator.next() : null;
                            continue;
                        }
                        BigDecimal articulateAmt = BigDecimal.ZERO;
                        if (1893667005572058112L == writeOffTypeId) {
                            articulateAmt = mainRowArticulateAmt.abs().compareTo(asstRowArticulateAmt.abs()) >= 0 ? asstRowArticulateAmt : mainRowArticulateAmt;
                            nowAsstEntryVO.setCanArticulateAmt(nowAsstEntryVO.getCanArticulateAmt().subtract(articulateAmt));
                            asstHeadArticulateAmt = asstHeadArticulateAmt.subtract(articulateAmt);
                        } else {
                            articulateAmt = mainRowArticulateAmt.abs().compareTo(asstRowArticulateAmt.abs()) >= 0 ? asstRowArticulateAmt.negate() : mainRowArticulateAmt;
                            nowAsstEntryVO.setCanArticulateAmt(nowAsstEntryVO.getCanArticulateAmt().add(articulateAmt));
                            asstHeadArticulateAmt = asstHeadArticulateAmt.add(articulateAmt);
                        }
                        mainRowArticulateAmt = mainRowArticulateAmt.subtract(articulateAmt);
                        mainHeadArticulateAmt = mainHeadArticulateAmt.subtract(articulateAmt);
                        DynamicObject articulateRecord = this.createNewArticulateRecord(mainBillVO, writeOffTypeId);
                        this.createNewArticulateRecordRow(articulateRecord, articulateAmt, mainBillVO, mainEntryVO, nowAsstBillVO, nowAsstEntryVO);
                        articulateRecords.add(articulateRecord);
                        if (nowAsstEntryVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) == 0) {
                            InvoiceArticulateRowDTO invoiceArticulateRowDTO = nowAsstEntryVO = asstBillEntryIterator.hasNext() ? asstBillEntryIterator.next() : null;
                        }
                        if (mainRowArticulateAmt.compareTo(BigDecimal.ZERO) != 0 && mainHeadArticulateAmt.compareTo(BigDecimal.ZERO) != 0 && asstHeadArticulateAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        break;
                    }
                    nowAsstBillVO.setCanArticulateAmt(asstHeadArticulateAmt);
                    if (nowAsstEntryVO == null || asstHeadArticulateAmt.compareTo(BigDecimal.ZERO) == 0) {
                        InvoiceArticulateBillDTO invoiceArticulateBillDTO = nowAsstBillVO = asstBillIterator.hasNext() ? asstBillIterator.next() : null;
                        if (nowAsstBillVO != null) {
                            asstBillEntryIterator = nowAsstBillVO.getEntryArticulateVOs().iterator();
                            nowAsstEntryVO = asstBillEntryIterator.next();
                        }
                    }
                    if (mainRowArticulateAmt.compareTo(BigDecimal.ZERO) != 0 && mainHeadArticulateAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                    break;
                }
                BigDecimal happenArticulateRowAmt = beforeArticulateRowAmt.subtract(mainRowArticulateAmt);
                mainEntryVO.setCanArticulateAmt(mainEntryVO.getCanArticulateAmt().subtract(happenArticulateRowAmt));
                if (nowAsstBillVO != null && mainHeadArticulateAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            mainBillVO.setCanArticulateAmt(mainHeadArticulateAmt);
            if (nowAsstBillVO != null) continue;
            break;
        }
        return articulateRecords;
    }

    private DynamicObject[] filterUnArticulateInvoiceRecords(List<DynamicObject> articulateRecords) {
        HashSet<Long> articulateInvoiceFinApIds = new HashSet<Long>(32);
        HashMap<Long, Set> finBillSelfRecordIdMap = new HashMap<Long, Set>(16);
        HashSet<Long> hasFinRowSelfBillIds = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : articulateRecords) {
            long l = dynamicObject.getLong("writeofftypeid.id");
            DynamicObject row = (DynamicObject)dynamicObject.getDynamicObjectCollection("entry").get(0);
            long mainBillId = row.getLong("billid");
            long assBillId = row.getLong("assbillid");
            if (1893667005572058112L == l) {
                articulateInvoiceFinApIds.add(assBillId);
                continue;
            }
            if (1893666267970144256L == l && mainBillId != assBillId) {
                Set asstBillIds = finBillSelfRecordIdMap.getOrDefault(mainBillId, new HashSet(4));
                asstBillIds.add(assBillId);
                finBillSelfRecordIdMap.put(mainBillId, asstBillIds);
                Set mainBillIds = finBillSelfRecordIdMap.getOrDefault(assBillId, new HashSet(4));
                mainBillIds.add(mainBillId);
                finBillSelfRecordIdMap.put(assBillId, mainBillIds);
                continue;
            }
            if (1893666267970144256L != l) continue;
            hasFinRowSelfBillIds.add(mainBillId);
        }
        HashMap needRemoveFinBillSelfBillIdMap = new HashMap(16);
        for (Map.Entry entry : finBillSelfRecordIdMap.entrySet()) {
            Long finApBillId = (Long)entry.getKey();
            if (articulateInvoiceFinApIds.contains(finApBillId)) continue;
            Set otherFinApBillIds = (Set)entry.getValue();
            HashSet<Long> needOtherFinApBillIds = new HashSet<Long>(8);
            for (Long otherFinApBillId : otherFinApBillIds) {
                if (articulateInvoiceFinApIds.contains(otherFinApBillId)) continue;
                needOtherFinApBillIds.add(otherFinApBillId);
            }
            if (needOtherFinApBillIds.isEmpty()) continue;
            needRemoveFinBillSelfBillIdMap.put(entry.getKey(), needOtherFinApBillIds);
        }
        for (Long l : hasFinRowSelfBillIds) {
            if (articulateInvoiceFinApIds.contains(l)) continue;
            Set needRemoveOtherFinBillIds = (Set)needRemoveFinBillSelfBillIdMap.get(l);
            Set allOtherFinApBillIds = (Set)finBillSelfRecordIdMap.get(l);
            if ((needRemoveOtherFinBillIds != null || allOtherFinApBillIds != null) && (needRemoveOtherFinBillIds == null || allOtherFinApBillIds == null || allOtherFinApBillIds.size() != needRemoveOtherFinBillIds.size())) continue;
            Set billIds = needRemoveFinBillSelfBillIdMap.getOrDefault(l, new HashSet(2));
            billIds.add(l);
            needRemoveFinBillSelfBillIdMap.put(l, billIds);
        }
        if (needRemoveFinBillSelfBillIdMap.isEmpty()) {
            return articulateRecords.toArray(new DynamicObject[0]);
        }
        Iterator<DynamicObject> iterator = articulateRecords.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = iterator.next();
            long writeOffTypeId = dynamicObject.getLong("writeofftypeid.id");
            if (1893666267970144256L != writeOffTypeId) continue;
            DynamicObject row = (DynamicObject)dynamicObject.getDynamicObjectCollection("entry").get(0);
            long mainBillId = row.getLong("billid");
            long assBillId = row.getLong("assbillid");
            Set needRemoverAssBillIds = (Set)needRemoveFinBillSelfBillIdMap.get(mainBillId);
            if (!ObjectUtils.isEmpty((Object)needRemoverAssBillIds) && needRemoverAssBillIds.contains(assBillId)) {
                iterator.remove();
                continue;
            }
            Set needRemoverMainBillIds = (Set)needRemoveFinBillSelfBillIdMap.get(assBillId);
            if (ObjectUtils.isEmpty((Object)needRemoverMainBillIds) || !needRemoverMainBillIds.contains(mainBillId)) continue;
            iterator.remove();
        }
        return articulateRecords.toArray(new DynamicObject[0]);
    }

    private DynamicObject createNewArticulateRecord(InvoiceArticulateBillDTO billVO, long writeOffTypeId) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"ap_matchrecord_verify");
        record.getDynamicObjectCollection("entry").clear();
        record.set("writeofftypeid", (Object)writeOffTypeId);
        record.set("createtime", (Object)new Date());
        record.set("org", (Object)billVO.getOrgId());
        return record;
    }

    private void createNewArticulateRecordRow(DynamicObject record, BigDecimal articulateAmt, InvoiceArticulateBillDTO mainBillArticulateVO, InvoiceArticulateRowDTO mainEntryArticulateVO, InvoiceArticulateBillDTO asstBillArticulateVO, InvoiceArticulateRowDTO asstEntryArticulateVO) {
        long writeOffTypeId = record.getLong("writeofftypeid");
        DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
        DynamicObject newRow = entry.addNew();
        newRow.set("seq", (Object)(entry.size() + 1));
        newRow.set("matchamt", (Object)articulateAmt);
        if (1893666267970144256L == writeOffTypeId) {
            newRow.set("billtype", (Object)"ap_finapbill");
            newRow.set("assbilltype", (Object)"ap_finapbill");
            newRow.set("assmatchamt", (Object)articulateAmt.negate());
        } else if (1893666802358029312L == writeOffTypeId) {
            newRow.set("billtype", (Object)"ap_invoice");
            newRow.set("assbilltype", (Object)"ap_invoice");
            newRow.set("assmatchamt", (Object)articulateAmt.negate());
        } else {
            newRow.set("billtype", (Object)"ap_invoice");
            newRow.set("assbilltype", (Object)"ap_finapbill");
            newRow.set("assmatchamt", (Object)articulateAmt);
        }
        newRow.set("billentryid", (Object)mainEntryArticulateVO.getEntryId());
        newRow.set("billno", (Object)mainBillArticulateVO.getBillNo());
        newRow.set("billid", (Object)mainBillArticulateVO.getBillId());
        newRow.set("currency", (Object)mainBillArticulateVO.getCurrencyId());
        newRow.set("basecurrency", (Object)mainBillArticulateVO.getBaseCurrencyId());
        newRow.set("assbillid", (Object)asstBillArticulateVO.getBillId());
        newRow.set("assbillentryid", (Object)asstEntryArticulateVO.getEntryId());
        newRow.set("assbillno", (Object)asstBillArticulateVO.getBillNo());
        newRow.set("asscurrency", (Object)asstBillArticulateVO.getCurrencyId());
        newRow.set("assbasecurrency", (Object)asstBillArticulateVO.getBaseCurrencyId());
    }

    private List<InvoiceArticulateBillDTO> constructMainBillDTOByBill(List<InvoiceArticulateBillParam> invoiceParams) {
        List<Object> invoiceRows;
        if (ObjectUtils.isEmpty(invoiceParams)) {
            return new ArrayList<InvoiceArticulateBillDTO>(2);
        }
        HashMap<Long, List> invoiceParamMap = new HashMap<Long, List>(64);
        for (InvoiceArticulateBillParam invoiceParam : invoiceParams) {
            List invoiceArticulateBillParamList = invoiceParamMap.getOrDefault(invoiceParam.getBillId(), new ArrayList(8));
            invoiceArticulateBillParamList.add(invoiceParam);
            invoiceParamMap.put(invoiceParam.getBillId(), invoiceArticulateBillParamList);
        }
        String selectors = "id,entry.id,unrelatedamt,entry.e_unrelatedamt,entry.e_pricetaxtotal,pricetaxtotal,currency,basecurrency,billno,entry.seq,org";
        QFilter filter = new QFilter("id", "in", invoiceParamMap.keySet());
        filter.and(new QFilter("entry.e_unrelatedamt", "!=", (Object)BigDecimal.ZERO));
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{filter}, (String)"billno,entry.seq");
        HashMap<Long, ArrayList<DynamicObject>> invoiceRowMap = new HashMap<Long, ArrayList<DynamicObject>>(64);
        ArrayList<Long> invoiceIds = new ArrayList<Long>(64);
        for (DynamicObject invoiceRow : invoiceCollection) {
            Long invoiceId = invoiceRow.getLong("id");
            invoiceRows = (ArrayList<DynamicObject>)invoiceRowMap.get(invoiceId);
            if (invoiceRows == null) {
                invoiceRows = new ArrayList<DynamicObject>(32);
                invoiceIds.add(invoiceId);
            }
            invoiceRows.add(invoiceRow);
            invoiceRowMap.put(invoiceId, (ArrayList<DynamicObject>)invoiceRows);
        }
        ArrayList<InvoiceArticulateBillDTO> invoiceArticulateBillVOs = new ArrayList<InvoiceArticulateBillDTO>(64);
        for (Long invoiceId : invoiceIds) {
            invoiceRows = (List)invoiceRowMap.get(invoiceId);
            if (ObjectUtils.isEmpty(invoiceRows)) continue;
            DynamicObject headInvoiceVo = (DynamicObject)invoiceRows.get(0);
            BigDecimal unRelatedAmt = headInvoiceVo.getBigDecimal("unrelatedamt");
            List invoiceArticulateBillParamList = (List)invoiceParamMap.get(invoiceId);
            if (ObjectUtils.isEmpty((Object)invoiceArticulateBillParamList)) continue;
            ArrayList<InvoiceArticulateBillDTO> tempInvoiceArticulateBillVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
            for (InvoiceArticulateBillParam invoiceArticulateBillParam : invoiceArticulateBillParamList) {
                BigDecimal canArticulateAmount;
                if (invoiceArticulateBillParam.getCanArticulateAmt().multiply(unRelatedAmt).compareTo(BigDecimal.ZERO) < 0) continue;
                InvoiceArticulateBillDTO invoiceArticulateBillDTO = new InvoiceArticulateBillDTO();
                BigDecimal bigDecimal = canArticulateAmount = invoiceArticulateBillParam.getCanArticulateAmt().compareTo(BigDecimal.ZERO) == 0 ? unRelatedAmt : invoiceArticulateBillParam.getCanArticulateAmt();
                if (canArticulateAmount.abs().compareTo(unRelatedAmt.abs()) > 0) {
                    canArticulateAmount = unRelatedAmt;
                }
                invoiceArticulateBillDTO.setBillId(invoiceId).setBillOriginType(invoiceArticulateBillParam.getBillOriginType()).setCanArticulateAmt(canArticulateAmount).setAccurateArticulateId(invoiceArticulateBillParam.getAccurateArticulateId()).setArticulateOrder(invoiceArticulateBillParam.getArticulateOrder());
                invoiceArticulateBillDTO.setCurrencyId(headInvoiceVo.getLong("currency")).setBaseCurrencyId(headInvoiceVo.getLong("basecurrency")).setOrgId(headInvoiceVo.getLong("org")).setBillNo(headInvoiceVo.getString("billno"));
                tempInvoiceArticulateBillVOs.add(invoiceArticulateBillDTO);
            }
            ArrayList<InvoiceArticulateRowDTO> entryArticulateVOs = new ArrayList<InvoiceArticulateRowDTO>(16);
            for (DynamicObject invoiceRow : invoiceRows) {
                InvoiceArticulateRowDTO invoiceArticulateRowDTO = new InvoiceArticulateRowDTO();
                invoiceArticulateRowDTO.setBillId(invoiceId).setEntryId(invoiceRow.getLong("entry.id")).setCanArticulateAmt(invoiceRow.getBigDecimal("entry.e_unrelatedamt"));
                entryArticulateVOs.add(invoiceArticulateRowDTO);
            }
            tempInvoiceArticulateBillVOs.forEach(vo -> vo.setEntryArticulateVOs(entryArticulateVOs));
            invoiceArticulateBillVOs.addAll(tempInvoiceArticulateBillVOs);
        }
        this.invoiceBillVosSort(invoiceArticulateBillVOs);
        return invoiceArticulateBillVOs;
    }

    private List<InvoiceArticulateBillDTO> constructAsstBillDTOByBill(List<InvoiceArticulateBillParam> asstParams) {
        List<Object> finApRows;
        if (ObjectUtils.isEmpty(asstParams)) {
            return new ArrayList<InvoiceArticulateBillDTO>(2);
        }
        HashMap<Long, List> finApParamMap = new HashMap<Long, List>(64);
        for (InvoiceArticulateBillParam invoiceParam : asstParams) {
            List invoiceArticulateBillParamList = finApParamMap.getOrDefault(invoiceParam.getBillId(), new ArrayList(8));
            invoiceArticulateBillParamList.add(invoiceParam);
            finApParamMap.put(invoiceParam.getBillId(), invoiceArticulateBillParamList);
        }
        String selectors = "id,detailentry.id,uninvoicedamt,detailentry.e_uninvoicedamt,currency,pricetaxtotal,detailentry.e_pricetaxtotal,basecurrency,billno,detailentry.seq,org";
        QFilter filter = new QFilter("id", "in", finApParamMap.keySet());
        filter.and(new QFilter("detailentry.e_uninvoicedamt", "!=", (Object)BigDecimal.ZERO));
        DynamicObjectCollection finApCollection = QueryServiceHelper.query((String)"ap_finapbill", (String)selectors, (QFilter[])new QFilter[]{filter}, (String)"bizdate,id,detailentry.seq");
        HashMap<Long, ArrayList<DynamicObject>> finApRowMap = new HashMap<Long, ArrayList<DynamicObject>>(32);
        ArrayList<Long> billIds = new ArrayList<Long>(64);
        for (DynamicObject finApRow : finApCollection) {
            Long billId = finApRow.getLong("id");
            finApRows = (ArrayList<DynamicObject>)finApRowMap.get(billId);
            if (finApRows == null) {
                finApRows = new ArrayList<DynamicObject>(32);
                billIds.add(billId);
            }
            finApRows.add(finApRow);
            finApRowMap.put(billId, (ArrayList<DynamicObject>)finApRows);
        }
        ArrayList<InvoiceArticulateBillDTO> finApArticulateBillVOs = new ArrayList<InvoiceArticulateBillDTO>(64);
        for (Long billId : billIds) {
            finApRows = (List)finApRowMap.get(billId);
            if (ObjectUtils.isEmpty(finApRows)) continue;
            DynamicObject headFinApVo = (DynamicObject)finApRows.get(0);
            BigDecimal unInvoicedAmt = headFinApVo.getBigDecimal("uninvoicedamt");
            List invoiceArticulateBillParamList = (List)finApParamMap.get(billId);
            if (ObjectUtils.isEmpty((Object)invoiceArticulateBillParamList)) continue;
            ArrayList<InvoiceArticulateBillDTO> tempFinApArticulateBillVOs = new ArrayList<InvoiceArticulateBillDTO>(8);
            for (InvoiceArticulateBillParam invoiceArticulateBillParam : invoiceArticulateBillParamList) {
                BigDecimal canArticulateAmount;
                if (invoiceArticulateBillParam.getCanArticulateAmt().multiply(unInvoicedAmt).compareTo(BigDecimal.ZERO) < 0) continue;
                InvoiceArticulateBillDTO invoiceArticulateBillDTO = new InvoiceArticulateBillDTO();
                BigDecimal bigDecimal = canArticulateAmount = invoiceArticulateBillParam.getCanArticulateAmt().compareTo(BigDecimal.ZERO) == 0 ? unInvoicedAmt : invoiceArticulateBillParam.getCanArticulateAmt();
                if (canArticulateAmount.abs().compareTo(unInvoicedAmt.abs()) > 0) {
                    canArticulateAmount = unInvoicedAmt;
                }
                invoiceArticulateBillDTO.setBillId(billId).setBillOriginType(invoiceArticulateBillParam.getBillOriginType()).setCanArticulateAmt(canArticulateAmount).setAccurateArticulateId(invoiceArticulateBillParam.getAccurateArticulateId()).setArticulateOrder(invoiceArticulateBillParam.getArticulateOrder());
                invoiceArticulateBillDTO.setCurrencyId(headFinApVo.getLong("currency")).setOrgId(headFinApVo.getLong("org")).setBaseCurrencyId(headFinApVo.getLong("basecurrency")).setBillNo(headFinApVo.getString("billno"));
                tempFinApArticulateBillVOs.add(invoiceArticulateBillDTO);
            }
            ArrayList<InvoiceArticulateRowDTO> entryArticulateVOs = new ArrayList<InvoiceArticulateRowDTO>(64);
            for (DynamicObject finApRow : finApRows) {
                InvoiceArticulateRowDTO invoiceArticulateRowDTO = new InvoiceArticulateRowDTO();
                invoiceArticulateRowDTO.setBillId(billId).setEntryId(finApRow.getLong("detailentry.id")).setCanArticulateAmt(finApRow.getBigDecimal("detailentry.e_uninvoicedamt"));
                entryArticulateVOs.add(invoiceArticulateRowDTO);
            }
            tempFinApArticulateBillVOs.forEach(vo -> vo.setEntryArticulateVOs(entryArticulateVOs));
            finApArticulateBillVOs.addAll(tempFinApArticulateBillVOs);
        }
        this.finApBillVoSort(finApArticulateBillVOs);
        return finApArticulateBillVOs;
    }

    private void invoiceBillVosSort(List<InvoiceArticulateBillDTO> invoiceBillVOs) {
        if (invoiceBillVOs.isEmpty()) {
            return;
        }
        boolean isOrderByOriginType = !ObjectUtils.isEmpty((Object)invoiceBillVOs.get(0).getBillOriginType());
        boolean isOrderByArg = invoiceBillVOs.stream().anyMatch(billVo -> billVo.getArticulateOrder() != -1);
        if (!isOrderByOriginType && !isOrderByArg) {
            return;
        }
        invoiceBillVOs.sort((o1, o2) -> {
            if (isOrderByOriginType) {
                String o1billOriginType = o1.getBillOriginType();
                String o2billOriginType = o2.getBillOriginType();
                if (InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(o1billOriginType) || InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue().equals(o1billOriginType)) {
                    return -1;
                }
                if (InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(o2billOriginType) || InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue().equals(o2billOriginType)) {
                    return 1;
                }
                if (InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(o1billOriginType)) {
                    return -1;
                }
                if (InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(o2billOriginType)) {
                    return 1;
                }
            }
            if (isOrderByArg) {
                int o2ArticulateOrder;
                int o1ArticulateOrder = o1.getArticulateOrder();
                if (o1ArticulateOrder == (o2ArticulateOrder = o2.getArticulateOrder())) {
                    return 0;
                }
                return o1ArticulateOrder > o2ArticulateOrder ? -1 : 1;
            }
            return 0;
        });
    }

    private void finApBillVoSort(List<InvoiceArticulateBillDTO> finApArticulateBillVOs) {
        if (finApArticulateBillVOs.isEmpty()) {
            return;
        }
        boolean isOrderByArg = finApArticulateBillVOs.stream().anyMatch(billVo -> billVo.getArticulateOrder() != -1);
        if (!isOrderByArg) {
            return;
        }
        finApArticulateBillVOs.sort((o1, o2) -> {
            int o2ArticulateOrder;
            int o1ArticulateOrder = o1.getArticulateOrder();
            if (o1ArticulateOrder == (o2ArticulateOrder = o2.getArticulateOrder())) {
                return 0;
            }
            return o1ArticulateOrder > o2ArticulateOrder ? -1 : 1;
        });
    }

    private void setArticulateRecordOtherFieldValue(List<DynamicObject> articulateRecords) {
        Map writeOffTypeMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])new QFilter[]{new QFilter("id", "in", Arrays.asList(1893666267970144256L, 1893667005572058112L, 1893666802358029312L))});
        Map entityObjectTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("id", "in", Arrays.asList("ap_finapbill", "ap_invoice"))});
        String wfSeq = String.valueOf(DB.genGlobalLongId());
        for (DynamicObject articulateRecord : articulateRecords) {
            DynamicObjectCollection entry = articulateRecord.getDynamicObjectCollection("entry");
            articulateRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
            articulateRecord.set("wfseq", (Object)wfSeq);
            articulateRecord.set("wfnumber", (Object)((DynamicObject)entry.get(0)).getString("billno"));
            articulateRecord.set("writeofftypeid", writeOffTypeMap.get(articulateRecord.getLong("writeofftypeid")));
            for (DynamicObject row : entry) {
                row.set("billtype", entityObjectTypeMap.get(row.getString("billtype")));
                row.set("assbilltype", entityObjectTypeMap.get(row.getString("assbilltype")));
            }
        }
    }
}

