/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.assign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.assign.AbstractAssignInvoiceService;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.business.pojo.InvoiceArticulateBillParam;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public class ApplyAssignInvoiceServiceImpl
extends AbstractAssignInvoiceService {
    @Override
    protected void autoAssign(AssignInvoiceParam assignInvoiceParam) {
        logger.info("ApplyAssignInvoiceServiceImpl autoAssign begin.");
        List<Long> applyBillIds = assignInvoiceParam.getBillIds();
        DynamicObject[] applyBills = this.getApplyBills(applyBillIds);
        HashMap<Long, List> needSaveBotpMap = new HashMap<Long, List>(8);
        HashSet<Long> invoiceIds = new HashSet<Long>(8);
        for (DynamicObject applyBill : applyBills) {
            long applyBillId = applyBill.getLong("id");
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                if (!ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype"))) continue;
                List sourceBillIds = needSaveBotpMap.getOrDefault(applyBillId, new ArrayList(4));
                sourceBillIds.add(invRow.getLong("invid"));
                needSaveBotpMap.put(applyBillId, sourceBillIds);
                invoiceIds.add(invRow.getLong("invid"));
            }
        }
        this.updateInvoiceSynStatus(invoiceIds);
        this.createBOTPRelation("ap_payapply", assignInvoiceParam.getBillIds());
    }

    @Override
    protected void handleAssign(AssignInvoiceParam assignInvoiceParam) {
        logger.info("ApplyAssignInvoiceServiceImpl handleAssign begin.");
        this.filterErrorInvoice(assignInvoiceParam);
        if (ObjectUtils.isEmpty(assignInvoiceParam.getInvoiceIds())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u4f20\u53d1\u7968\u5df2\u7ecf\u88ab\u6307\u5b9a\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u53d1\u7968\u3002", (String)"ApplyAssignInvoiceServiceImpl_0", (String)"fi-ap-business", (Object[])new Object[0]));
        }
        List<Long> applyBillIds = assignInvoiceParam.getBillIds();
        DynamicObject[] applyBills = this.getApplyBills(applyBillIds);
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(assignInvoiceParam.getInvoiceIds());
        if (assignInvoiceParam.getInvoiceBillParams().isEmpty() && assignInvoiceParam.getAsstBillParams().isEmpty()) {
            DynamicObject applyBill = applyBills[0];
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (Map.Entry<Long, DynamicObject> entrySet : invoiceMap.entrySet()) {
                DynamicObject invoice = entrySet.getValue();
                long invoiceId = invoice.getLong("id");
                DynamicObject invRow = invEntry.addNew();
                invRow.set("invid", (Object)invoiceId);
                invRow.set("i_serialno", (Object)invoice.getString("serialno"));
                Map<Long, String> assignInvSrcTypeMap = assignInvoiceParam.getBillAssignInvSrcTypeMap().get(applyBill.getLong("id"));
                if (!ObjectUtils.isEmpty(assignInvSrcTypeMap) && !ObjectUtils.isEmpty((Object)assignInvSrcTypeMap.get(invoiceId))) {
                    invRow.set("i_srctype", (Object)assignInvSrcTypeMap.get(invoiceId));
                } else {
                    invRow.set("i_srctype", (Object)ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue());
                }
                invoice.set("businesssource", (Object)"ap_payapply");
                if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
                invoice.set("synstatus", (Object)"waitsynchro");
                invoice.set("changesynstatustime", (Object)new Date());
            }
        } else {
            HashMap<Long, Set> articulateId4InvIdMap = new HashMap<Long, Set>(8);
            for (InvoiceArticulateBillParam invoiceBillParam : assignInvoiceParam.getInvoiceBillParams()) {
                Set invoiceIds = articulateId4InvIdMap.getOrDefault(invoiceBillParam.getAccurateArticulateId(), new HashSet(8));
                invoiceIds.add(invoiceBillParam.getBillId());
                articulateId4InvIdMap.put(invoiceBillParam.getAccurateArticulateId(), invoiceIds);
            }
            Map applyBillMap = Arrays.stream(applyBills).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
            for (InvoiceArticulateBillParam applyParam : assignInvoiceParam.getAsstBillParams()) {
                Set invoiceIds;
                DynamicObject applyBill = (DynamicObject)applyBillMap.get(applyParam.getBillId());
                if (applyBill == null || ObjectUtils.isEmpty((Object)(invoiceIds = (Set)articulateId4InvIdMap.get(applyParam.getAccurateArticulateId())))) continue;
                DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
                for (Long invoiceId : invoiceIds) {
                    DynamicObject invoice = invoiceMap.get(invoiceId);
                    if (invoice == null) continue;
                    DynamicObject invRow = invEntry.addNew();
                    invRow.set("invid", (Object)invoice.getLong("id"));
                    invRow.set("i_serialno", (Object)invoice.getString("serialno"));
                    Map<Long, String> assignInvSrcTypeMap = assignInvoiceParam.getBillAssignInvSrcTypeMap().get(applyBill.getLong("id"));
                    if (!ObjectUtils.isEmpty(assignInvSrcTypeMap) && !ObjectUtils.isEmpty((Object)assignInvSrcTypeMap.get(invoiceId))) {
                        invRow.set("i_srctype", (Object)assignInvSrcTypeMap.get(invoiceId));
                    } else {
                        invRow.set("i_srctype", (Object)ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue());
                    }
                    if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
                    invoice.set("synstatus", (Object)"waitsynchro");
                    invoice.set("changesynstatustime", (Object)new Date());
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])applyBills);
        SaveServiceHelper.save((DynamicObject[])invoiceMap.values().toArray(new DynamicObject[0]));
        this.createBOTPRelation("ap_payapply", assignInvoiceParam.getBillIds());
    }

    @Override
    protected void autoAntiAssign(AssignInvoiceParam assignInvoiceParam) {
        logger.info("ApplyAssignInvoiceServiceImpl autoAntiAssign begin.");
        List<Long> applyBillIds = assignInvoiceParam.getBillIds();
        DynamicObject[] applyBills = this.getApplyBills(applyBillIds);
        HashSet<Long> needUnAuditInvoiceIds = new HashSet<Long>(8);
        ArrayList paramList = new ArrayList(32);
        HashSet<Long> invoiceIds = new HashSet<Long>(64);
        for (DynamicObject applyBill : applyBills) {
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                String iSrcType = invRow.getString("i_srctype");
                long invId = invRow.getLong("invid");
                if (!ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType)) continue;
                needUnAuditInvoiceIds.add(invId);
                HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
                paramMap.put("srcBillId", invId);
                paramMap.put("tarBillId", applyBill.getLong("id"));
                paramList.add(paramMap);
                invoiceIds.add(invId);
            }
        }
        this.updateInvoiceSynStatus(invoiceIds);
        if (!needUnAuditInvoiceIds.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"nocheckunaudit", (String)"ap_invoice", (Object[])needUnAuditInvoiceIds.toArray(new Long[0]), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)operationResult);
        }
        for (Map map : paramList) {
            long srcBillId = (Long)map.get("srcBillId");
            long tarBillId = (Long)map.get("tarBillId");
            InvoiceHelper.deleteRelation((String)"ap_payapply", (Long)tarBillId, (Long)srcBillId);
        }
    }

    @Override
    protected void handleAntiAssign(AssignInvoiceParam assignInvoiceParam) {
        logger.info("ApplyAssignInvoiceServiceImpl handleAntiAssign begin.");
        List<Long> applyBillIds = assignInvoiceParam.getBillIds();
        DynamicObject[] applyBills = this.getApplyBills(applyBillIds);
        HashMap<Long, Set<Long>> apply4InvoiceMap = new HashMap<Long, Set<Long>>(8);
        for (DynamicObject applyBill : applyBills) {
            Long applyId = applyBill.getLong("id");
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                if (!ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue().equals(invRow.getString("i_srctype"))) continue;
                Set deleteInvoiceIds = apply4InvoiceMap.getOrDefault(applyId, new HashSet(8));
                deleteInvoiceIds.add(invRow.getLong("invid"));
                apply4InvoiceMap.put(applyId, deleteInvoiceIds);
            }
        }
        if (apply4InvoiceMap.isEmpty()) {
            return;
        }
        InvEntryDeleteParam entryDeleteParam = new InvEntryDeleteParam();
        entryDeleteParam.setBill4InvoiceMap(apply4InvoiceMap);
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(entryDeleteParam);
    }

    @Override
    protected void addCtrlControl(AssignInvoiceParam assignInvoiceParam, String bizString) {
        super.addCtrlControl(assignInvoiceParam, bizString);
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_payapply", (String)bizString, new HashSet<Long>(assignInvoiceParam.getBillIds()), (boolean)false);
    }

    private void updateInvoiceSynStatus(Set<Long> invoiceIds) {
        DynamicObject[] invoices;
        for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"synstatus,changesynstatustime,serialno", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)})) {
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            invoice.set("synstatus", (Object)"waitsynchro");
            invoice.set("changesynstatustime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])invoices);
    }

    private void filterErrorInvoice(AssignInvoiceParam assignInvoiceParam) {
        List<Long> invoiceIds = assignInvoiceParam.getInvoiceIds();
        DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply", (String)"ap_payapply", (String)"id,inventry.invid", (QFilter[])new QFilter[]{new QFilter("inventry.invid", "in", invoiceIds)}, (String)"");
        if (!applyDataSet.hasNext()) {
            return;
        }
        for (Row applyRow : applyDataSet) {
            invoiceIds.remove(applyRow.getLong("inventry.invid"));
        }
    }

    private DynamicObject[] getApplyBills(List<Long> applyBillIds) {
        return BusinessDataServiceHelper.load((String)"ap_payapply", (String)"id,invid,i_serialno,i_srctype,invid", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)});
    }
}

