/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.assign;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAdjustDiffService;
import kd.fi.ap.business.invoice.articulate.IInvoiceArticulateService;
import kd.fi.ap.business.invoice.assign.AbstractAssignInvoiceService;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.business.pojo.InvoiceArticulateBillParam;
import kd.fi.ap.business.pojo.InvoiceArticulateContext;
import kd.fi.ap.enums.InvoiceAdjustEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.vo.InvoiceAdjustParam;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.ApFarmTaxAmtHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class FinApAssignInvoiceServiceImpl
extends AbstractAssignInvoiceService {
    @Override
    protected void autoAssign(AssignInvoiceParam assignInvoiceParam) {
        DynamicObject[] finApBills = this.getFinApBills(assignInvoiceParam.getBillIds());
        ArrayList<Long> allInvoiceIds = new ArrayList<Long>(32);
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                allInvoiceIds.add(invRow.getLong("invid"));
            }
        }
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(allInvoiceIds);
        this.processExceptionScene(finApBills, invoiceMap.values().toArray(new DynamicObject[0]));
        if (ObjectUtils.isEmpty(invoiceMap)) {
            return;
        }
        List<Object> matchRecordIds = this.invoiceMatchFin(assignInvoiceParam, finApBills, invoiceMap.values().toArray(new DynamicObject[0]));
        this.afterAssignWriteBack(assignInvoiceParam, matchRecordIds, false);
        if (assignInvoiceParam.isCreateBOTP()) {
            this.createBOTPRelation("ap_finapbill", assignInvoiceParam.getBillIds());
        }
    }

    @Override
    protected void handleAssign(AssignInvoiceParam assignInvoiceParam) {
        DynamicObject[] finApBills = this.getFinApBills(assignInvoiceParam.getBillIds());
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(assignInvoiceParam.getInvoiceIds());
        invoiceMap.entrySet().removeIf(inv -> "2".equals(((DynamicObject)inv.getValue()).getString("invoicestatus")));
        this.invoiceAdjust(finApBills, invoiceMap);
        List<Object> matchRecordIds = this.invoiceMatchFin(assignInvoiceParam, finApBills, invoiceMap.values().toArray(new DynamicObject[0]));
        this.afterAssignWriteBack(assignInvoiceParam, matchRecordIds, true);
        if (assignInvoiceParam.isCreateBOTP()) {
            this.createBOTPRelation("ap_finapbill", assignInvoiceParam.getBillIds());
        }
    }

    @Override
    protected void autoAntiAssign(AssignInvoiceParam assignInvoiceParam) {
        DynamicObject[] finApBills = this.getFinApBills(assignInvoiceParam.getBillIds());
        HashMap<Long, Set<Long>> bill4InvoiceMap = new HashMap<Long, Set<Long>>(8);
        Set invoiceSrcTypeEnums = InvoiceHelper.getCollectInvoiceSrcTypeEnums((boolean)true);
        invoiceSrcTypeEnums.add(InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue());
        invoiceSrcTypeEnums.add(InvoiceSrcTypeEnum.INVOICEMATCH.getValue());
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            Set invoiceIds = invEntry.stream().filter(invRow -> invoiceSrcTypeEnums.contains(invRow.getString("i_srctype"))).map(invRow -> invRow.getLong("invid")).collect(Collectors.toSet());
            bill4InvoiceMap.put(finApBill.getLong("id"), invoiceIds);
        }
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        deleteParam.setBill4InvoiceMap(bill4InvoiceMap).setOperateKey(assignInvoiceParam.getOperateKey()).setDeleteInvRow(false).setAppId(assignInvoiceParam.getAppId());
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
    }

    @Override
    protected void handleAntiAssign(AssignInvoiceParam assignInvoiceParam) {
        DynamicObject[] finApBills = this.getFinApBills(assignInvoiceParam.getBillIds());
        HashMap<Long, Set<Long>> bill4InvoiceMap = new HashMap<Long, Set<Long>>(8);
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            Set invoiceIds = invEntry.stream().filter(invRow -> InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(invRow.getString("i_srctype"))).map(invRow -> invRow.getLong("invid")).collect(Collectors.toSet());
            bill4InvoiceMap.put(finApBill.getLong("id"), invoiceIds);
        }
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        deleteParam.setBill4InvoiceMap(bill4InvoiceMap).setOperateKey(assignInvoiceParam.getOperateKey()).setDeleteInvRow(true).setAppId(assignInvoiceParam.getAppId());
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
    }

    @Override
    protected void addCtrlControl(AssignInvoiceParam assignInvoiceParam, String bizString) {
        super.addCtrlControl(assignInvoiceParam, bizString);
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_finapbill", (String)bizString, new HashSet<Long>(assignInvoiceParam.getBillIds()), (boolean)false);
    }

    protected List<Object> invoiceMatchFin(AssignInvoiceParam assignInvoiceParam, DynamicObject[] finApBills, DynamicObject[] invoices) {
        if (ObjectUtils.isEmpty((Object[])(invoices = (DynamicObject[])Arrays.stream(invoices).filter(inv -> !"2".equals(inv.getString("invoicestatus"))).toArray(DynamicObject[]::new)))) {
            return new ArrayList<Object>(2);
        }
        IInvoiceArticulateService articulateService = (IInvoiceArticulateService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOICEARTICULATEFINAP.getValue());
        InvoiceArticulateContext articulateContext = new InvoiceArticulateContext();
        Map invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
        if (assignInvoiceParam.isAutoAssign()) {
            Map<Long, Map<Long, BigDecimal>> finAp4InvoiceOccupyMap = assignInvoiceParam.getFinAp4InvoiceOccupyMap();
            Set<String> needReOccupySrcTypes = assignInvoiceParam.getNeedAutoOccupySrcTypes();
            long[] accurateIds = DB.genGlobalLongIds((int)finApBills.length);
            ArrayList<InvoiceArticulateBillParam> invoiceParams = new ArrayList<InvoiceArticulateBillParam>(32);
            ArrayList<InvoiceArticulateBillParam> finApParams = new ArrayList<InvoiceArticulateBillParam>(32);
            for (int i = 0; i < finApBills.length; ++i) {
                DynamicObject finApBill = finApBills[i];
                Map<Long, BigDecimal> invoiceOccupyAmtMap = finAp4InvoiceOccupyMap.get(finApBill.getLong("id"));
                long accurateId = accurateIds[i];
                DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    BigDecimal assignAmt;
                    String iSrcType = invRow.getString("i_srctype");
                    long invId = invRow.getLong("invid");
                    DynamicObject invoice = (DynamicObject)invoiceMap.get(invId);
                    if (invoice == null || !needReOccupySrcTypes.contains(iSrcType) || BigDecimal.ZERO.compareTo(invRow.getBigDecimal("i_usedamt")) != 0) continue;
                    InvoiceArticulateBillParam invoiceParam = new InvoiceArticulateBillParam();
                    invoiceParam.setBillId(invId).setAccurateArticulateId(accurateId).setBillOriginType(iSrcType);
                    if (InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(iSrcType)) {
                        invoiceParam.setCanArticulateAmt(invRow.getBigDecimal("i_canuseamt"));
                    }
                    if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) && !ObjectUtils.isEmpty(invoiceOccupyAmtMap) && (assignAmt = invoiceOccupyAmtMap.get(invId)) != null) {
                        invoiceParam.setCanArticulateAmt(assignAmt);
                    }
                    invoiceParams.add(invoiceParam);
                }
                InvoiceArticulateBillParam finApParam = new InvoiceArticulateBillParam();
                finApParam.setBillId(finApBill.getLong("id")).setAccurateArticulateId(accurateId);
                finApParams.add(finApParam);
            }
            articulateContext.setAccurateArticulate(true);
            return articulateService.articulate(articulateContext, invoiceParams, finApParams);
        }
        if (!ObjectUtils.isEmpty(assignInvoiceParam.getAsstBillParams()) && !ObjectUtils.isEmpty(assignInvoiceParam.getInvoiceBillParams())) {
            List<InvoiceArticulateBillParam> finApBillParams = assignInvoiceParam.getAsstBillParams();
            List<InvoiceArticulateBillParam> invoiceBillParams = assignInvoiceParam.getInvoiceBillParams();
            boolean isAccurateArticulate = finApBillParams.stream().anyMatch(param -> param.getAccurateArticulateId() != 0L) || invoiceBillParams.stream().anyMatch(param -> param.getAccurateArticulateId() != 0L);
            articulateContext.setAccurateArticulate(isAccurateArticulate);
            return articulateService.articulate(articulateContext, invoiceBillParams, finApBillParams);
        }
        Long[] invoiceIds = (Long[])Arrays.stream(invoices).map(inv -> inv.getLong("id")).toArray(Long[]::new);
        Long[] finApBillIds = (Long[])Arrays.stream(finApBills).map(finAp -> finAp.getLong("id")).toArray(Long[]::new);
        return articulateService.articulate(articulateContext, invoiceIds, finApBillIds);
    }

    private void invoiceAdjust(DynamicObject[] finApBills, Map<Long, DynamicObject> invoiceMap) {
        if (finApBills.length != 1 || !"B".equals(finApBills[0].getString("billstatus"))) {
            return;
        }
        DynamicObject finApBill = finApBills[0];
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
        for (DynamicObject invRow : invEntry) {
            invoiceIds.add(invRow.getLong("invid"));
        }
        ArrayList<DynamicObject> needAdjustInvoice = new ArrayList<DynamicObject>(8);
        needAdjustInvoice.addAll(invoiceMap.values());
        if (!invoiceIds.isEmpty()) {
            String selector = "pricetaxtotal,amount,tax";
            QFilter filter = new QFilter("id", "in", invoiceIds);
            filter.and("invoicestatus", "!=", (Object)"2");
            DynamicObject[] hasAssignInvoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selector, (QFilter[])new QFilter[]{filter});
            needAdjustInvoice.addAll(Arrays.asList(hasAssignInvoices));
        }
        InvoiceAdjustParam invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ADJUST);
        invoiceAdjustParam.setInvoices(needAdjustInvoice.toArray(new DynamicObject[0]));
        InvoiceAdjustDiffService adjustDiffService = (InvoiceAdjustDiffService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOCIEADJUST.getValue());
        adjustDiffService.executeAdjustDiff(new DynamicObject[]{finApBill}, invoiceAdjustParam);
        SaveServiceHelper.save((DynamicObject[])finApBills);
    }

    protected void afterAssignWriteBack(AssignInvoiceParam assignInvoiceParam, List<Object> matchRecordIds, boolean isHasAdjustDiff) {
        if (ObjectUtils.isEmpty(matchRecordIds)) {
            return;
        }
        Map<Long, List<DynamicObject>> groupByWriteOffIdRecordRowMap = this.matchRecordRowGroupByWriteOffId(matchRecordIds);
        ArrayList<Long> finApBillIds = new ArrayList<Long>(32);
        ArrayList<Long> invoiceIds = new ArrayList<Long>(32);
        for (Map.Entry<Long, List<DynamicObject>> entrySet : groupByWriteOffIdRecordRowMap.entrySet()) {
            Long writeOffId = entrySet.getKey();
            List<DynamicObject> matchRecordRows = entrySet.getValue();
            for (DynamicObject recordRow : matchRecordRows) {
                long billId = recordRow.getLong("billid");
                long assBillId = recordRow.getLong("assbillid");
                if (1893666802358029312L == writeOffId && billId != assBillId) {
                    invoiceIds.add(billId);
                    invoiceIds.add(assBillId);
                    continue;
                }
                if (1893667005572058112L != writeOffId) continue;
                invoiceIds.add(billId);
                finApBillIds.add(assBillId);
            }
        }
        String selectors = "haspaperticket,istaxdeduction,i_invoicetypef7,i_invoicetype,i_invoicecode,i_invoiceno,i_invoicedate,i_currency,i_pricetaxtotal,i_taxrate,i_tax,i_amount,i_asstactname,i_buyername,i_istaxdeduction,i_remark,i_canuseamt,i_usedamt,i_srctype,isprepayinv,i_issupplement,i_billno,i_invoicestatus,invid,i_serialno,inventry.seq,billstatus,iswrittenoff,ispremium,istanspay,e_amountbase,taxrate,basecurrency,org,invoicebiztype,deductiblerate,curdeductibleamt,intercostamt,e_farmproducts,e_pricetaxtotalbase,billtypeid";
        DynamicObject[] hasAssignFinApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(invoiceIds);
        DynamicObject[] hasAssignInvoices = invoiceMap.values().toArray(new DynamicObject[0]);
        Map<Long, List<Long>> hasOccupyAmtInvIdMap = this.addFinApInvEntry(assignInvoiceParam, hasAssignFinApBills, invoiceMap, groupByWriteOffIdRecordRowMap);
        logger.info("afterAssignWriteBack hasOccupyAmtInvIdMap is : " + hasOccupyAmtInvIdMap);
        if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(this.getISrcType())) {
            this.updateFinApTaxDeduction(assignInvoiceParam, hasAssignFinApBills, hasAssignInvoices);
        } else {
            this.updateInvoiceTaxDeduction(hasAssignFinApBills, hasAssignInvoices);
        }
        for (DynamicObject invoice : hasAssignInvoices) {
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            invoice.set("synstatus", (Object)"waitsynchro");
            invoice.set("changesynstatustime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])hasAssignInvoices);
        if (isHasAdjustDiff) {
            InvoiceHelper.saveFinAndWriteBack((DynamicObject[])hasAssignFinApBills);
        } else {
            SaveServiceHelper.save((DynamicObject[])hasAssignFinApBills);
        }
    }

    private void updateInvoiceTaxDeduction(DynamicObject[] finApBills, DynamicObject[] invoices) {
        String billTypes = StdConfig.get((String)"ignore.billTypes");
        String billTypeNum = finApBills[0].getString("billtypeid.number");
        boolean isIgnore = billTypes != null && billTypes.contains(billTypeNum);
        ArrayList<DynamicObject> taxDeductionChangedInvoices = new ArrayList<DynamicObject>(64);
        HashMap<Long, DynamicObject> invoiceMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject invoice : invoices) {
            String serialNo;
            boolean isTaxDeduction;
            boolean oldTaxDeduction = invoice.getBoolean("istaxdeduction");
            if (oldTaxDeduction != (isTaxDeduction = finApBills[0].getBoolean("istaxdeduction")) && !isIgnore) {
                invoiceMap.put(invoice.getLong("id"), invoice);
                invoice.set("istaxdeduction", (Object)isTaxDeduction);
                taxDeductionChangedInvoices.add(invoice);
            }
            if (!EmptyUtils.isNotEmpty((Object)(serialNo = invoice.getString("serialno")))) continue;
            invoice.set("synstatus", (Object)"waitsynchro");
            invoice.set("changesynstatustime", (Object)new Date());
        }
        for (DynamicObject finBill : finApBills) {
            DynamicObjectCollection invEntry = finBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"));
                if (invoice == null) continue;
                invRow.set("i_istaxdeduction", (Object)invoice.getBoolean("istaxdeduction"));
            }
        }
        if (!taxDeductionChangedInvoices.isEmpty()) {
            this.updateTaxDeduction(taxDeductionChangedInvoices);
        }
    }

    private Map<Long, List<DynamicObject>> matchRecordRowGroupByWriteOffId(List<Object> matchRecordIds) {
        String selectors = "writeofftypeid,billtype,billid,billentryid,matchamt,assbilltype,assbillid,assbillentryid,assmatchamt";
        QFilter filter = new QFilter("id", "in", matchRecordIds);
        filter.and(new QFilter("writeofftypeid", "!=", (Object)1893666267970144256L));
        DynamicObject[] matchRecords = BusinessDataServiceHelper.load((String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", matchRecordIds)});
        HashMap<Long, List<DynamicObject>> groupByWriteOffIdRecordMap = new HashMap<Long, List<DynamicObject>>(4);
        for (DynamicObject matchRecord : matchRecords) {
            long writeOffId = matchRecord.getLong("writeofftypeid.id");
            List records = groupByWriteOffIdRecordMap.getOrDefault(writeOffId, new ArrayList(16));
            DynamicObjectCollection entry = matchRecord.getDynamicObjectCollection("entry");
            records.addAll(entry);
            groupByWriteOffIdRecordMap.put(writeOffId, records);
        }
        return groupByWriteOffIdRecordMap;
    }

    private Map<Long, List<Long>> addFinApInvEntry(AssignInvoiceParam assignInvoiceParam, DynamicObject[] finApBills, final Map<Long, DynamicObject> invoiceMap, Map<Long, List<DynamicObject>> groupByWriteOffIdRecordRowMap) {
        HashMap<Long, List<Long>> hasOccupyAmtInvIdMap = new HashMap<Long, List<Long>>(8);
        if (ObjectUtils.isEmpty(groupByWriteOffIdRecordRowMap)) {
            return hasOccupyAmtInvIdMap;
        }
        Map<Long, Map<Long, BigDecimal>> finApOccupyInvMap = this.getFinApOccupyInvAmtMap(finApBills, groupByWriteOffIdRecordRowMap);
        for (DynamicObject finApBill : finApBills) {
            long finApBillId = finApBill.getLong("id");
            Map<Long, BigDecimal> invoiceOccupyAmtMap = finApOccupyInvMap.get(finApBillId);
            if (ObjectUtils.isEmpty(invoiceOccupyAmtMap)) continue;
            ArrayList<Long> assignInvoiceIds = new ArrayList<Long>(8);
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            Set hasOccupyInvIds = invEntry.stream().map(invRow -> invRow.getLong("invid")).collect(Collectors.toSet());
            HashMap<Long, BigDecimal> needAddUseAmtInvMap = new HashMap<Long, BigDecimal>(8);
            HashMap<Long, BigDecimal> needAddInvRowInvMap = new HashMap<Long, BigDecimal>(8);
            for (Map.Entry<Long, BigDecimal> entrySet : invoiceOccupyAmtMap.entrySet()) {
                if (hasOccupyInvIds.contains(entrySet.getKey())) {
                    needAddUseAmtInvMap.put(entrySet.getKey(), entrySet.getValue());
                    continue;
                }
                needAddInvRowInvMap.put(entrySet.getKey(), entrySet.getValue());
            }
            if (!needAddUseAmtInvMap.isEmpty()) {
                for (DynamicObject invRow2 : invEntry) {
                    long invId = invRow2.getLong("invid");
                    BigDecimal invOccupyAmt = (BigDecimal)needAddUseAmtInvMap.get(invId);
                    if (invOccupyAmt == null) continue;
                    invRow2.set("i_usedamt", (Object)invRow2.getBigDecimal("i_usedamt").add(invOccupyAmt));
                    assignInvoiceIds.add(invId);
                }
            }
            if (!needAddInvRowInvMap.isEmpty()) {
                ArrayList invoiceIds = new ArrayList(needAddInvRowInvMap.keySet());
                invoiceIds.sort(new Comparator<Long>(){

                    @Override
                    public int compare(Long o1, Long o2) {
                        String o1BillNo = ((DynamicObject)invoiceMap.get(o1)).getString("billno");
                        String o2BillNo = ((DynamicObject)invoiceMap.get(o2)).getString("billno");
                        return o1BillNo.compareTo(o2BillNo);
                    }
                });
                int seq = invEntry.size();
                for (Long invId : invoiceIds) {
                    BigDecimal iUseAmt = (BigDecimal)needAddInvRowInvMap.get(invId);
                    DynamicObject invoice = invoiceMap.get(invId);
                    if (invoice == null) continue;
                    assignInvoiceIds.add(invId);
                    DynamicObject invRow3 = invEntry.addNew();
                    invRow3.set("seq", (Object)(++seq));
                    invRow3.set("invid", invoice.getPkValue());
                    invRow3.set("i_usedamt", (Object)iUseAmt);
                    BigDecimal priceTaxTotal = invoice.getBigDecimal("pricetaxtotal");
                    BigDecimal tax = invoice.getBigDecimal("tax");
                    BigDecimal amount = priceTaxTotal.subtract(tax);
                    invRow3.set("i_invoicetype", (Object)invoice.getString("invoicetype"));
                    invRow3.set("i_invoicetypef7", invoice.get("invoicetypef7"));
                    invRow3.set("i_invoicecode", (Object)invoice.getString("invoicecode"));
                    invRow3.set("i_invoiceno", (Object)invoice.getString("invoiceno"));
                    invRow3.set("i_invoicedate", (Object)invoice.getDate("issuedate"));
                    invRow3.set("i_pricetaxtotal", (Object)priceTaxTotal);
                    invRow3.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)invoice));
                    invRow3.set("i_tax", (Object)tax);
                    invRow3.set("i_amount", (Object)amount);
                    invRow3.set("i_asstactname", (Object)invoice.getString("asstactname"));
                    invRow3.set("i_buyername", (Object)invoice.getString("buyername"));
                    invRow3.set("i_istaxdeduction", (Object)invoice.getBoolean("istaxdeduction"));
                    invRow3.set("i_remark", (Object)invoice.getString("remark"));
                    Map<Long, String> assignInvSrcTypeMap = assignInvoiceParam.getBillAssignInvSrcTypeMap().get(finApBillId);
                    if (!ObjectUtils.isEmpty(assignInvSrcTypeMap) && !ObjectUtils.isEmpty((Object)assignInvSrcTypeMap.get(invId))) {
                        invRow3.set("i_srctype", (Object)assignInvSrcTypeMap.get(invId));
                    } else {
                        invRow3.set("i_srctype", (Object)this.getISrcType());
                    }
                    invRow3.set("i_billno", (Object)invoice.getString("billno"));
                    invRow3.set("i_issupplement", (Object)("C".equals(invoice.getString("billstatus")) ? "1" : "0"));
                    invRow3.set("i_serialno", (Object)invoice.getString("serialno"));
                    invRow3.set("i_currency", (Object)invoice.getDynamicObject("currency"));
                    invRow3.set("isprepayinv", (Object)"ap_payapply".equals(invoice.getString("businesssource")));
                }
            }
            hasOccupyAmtInvIdMap.put(finApBillId, assignInvoiceIds);
        }
        this.deleteZeroInvoiceRow(finApBills);
        return hasOccupyAmtInvIdMap;
    }

    private void deleteZeroInvoiceRow(DynamicObject[] finApBills) {
        HashSet<Long> invoiceIds = new HashSet<Long>(16);
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                BigDecimal usedAmt = invRow.getBigDecimal("i_usedamt");
                if (BigDecimal.ZERO.compareTo(usedAmt) != 0) continue;
                invoiceIds.add(invRow.getLong("invid"));
            }
        }
        if (invoiceIds.isEmpty()) {
            return;
        }
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_inv_status", (String)"ap_invoice", (String)"id,invoicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)}, (String)"");
        HashMap<Long, String> invoiceStatusMap = new HashMap<Long, String>(8);
        for (Row row : invoiceDataSet) {
            invoiceStatusMap.put(row.getLong("id"), row.getString("invoicestatus"));
        }
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            Iterator iterator = invEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject invRow = (DynamicObject)iterator.next();
                String srcType = invRow.getString("i_srctype");
                String invoiceStatus = (String)invoiceStatusMap.get(invRow.getLong("invid"));
                if (BigDecimal.ZERO.compareTo(invRow.getBigDecimal("i_usedamt")) != 0 || !InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(srcType) && !InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue().equals(srcType) || !ObjectUtils.isEmpty((Object)invoiceStatus) && !"0".equals(invoiceStatus)) continue;
                iterator.remove();
            }
        }
    }

    private Map<Long, Map<Long, BigDecimal>> getFinApOccupyInvAmtMap(DynamicObject[] finApBills, Map<Long, List<DynamicObject>> groupByWriteOffIdRecordRowMap) {
        HashMap<Long, Map<Long, BigDecimal>> finApOccupyInvMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        List<DynamicObject> finApMatchInvRecordRows = groupByWriteOffIdRecordRowMap.get(1893667005572058112L);
        HashMap<Long, Set> inv4FinApMap = new HashMap<Long, Set>(8);
        if (!ObjectUtils.isEmpty(finApMatchInvRecordRows)) {
            for (DynamicObject recordRow : finApMatchInvRecordRows) {
                long invoiceId = recordRow.getLong("billid");
                BigDecimal matchAmt = recordRow.getBigDecimal("matchamt");
                long finApBillId = recordRow.getLong("assbillid");
                Map invoiceOccupyAmtMap = finApOccupyInvMap.getOrDefault(finApBillId, new HashMap(8));
                BigDecimal occupyAmt = invoiceOccupyAmtMap.getOrDefault(invoiceId, BigDecimal.ZERO);
                occupyAmt = occupyAmt.add(matchAmt);
                invoiceOccupyAmtMap.put(invoiceId, occupyAmt);
                finApOccupyInvMap.put(finApBillId, invoiceOccupyAmtMap);
                Set finApBillIds = inv4FinApMap.getOrDefault(invoiceId, new HashSet(4));
                finApBillIds.add(finApBillId);
                inv4FinApMap.put(invoiceId, finApBillIds);
            }
        }
        HashMap<Long, Set> invHasAssignFinApMap = new HashMap<Long, Set>(8);
        for (DynamicObject finApBill : finApBills) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                Set finApBillIds = invHasAssignFinApMap.getOrDefault(invId, new HashSet(8));
                finApBillIds.add(finApBill.getLong("id"));
                invHasAssignFinApMap.put(invId, finApBillIds);
            }
        }
        List<DynamicObject> redAndBlueInvRecordRows = groupByWriteOffIdRecordRowMap.get(1893666802358029312L);
        if (!ObjectUtils.isEmpty(redAndBlueInvRecordRows)) {
            Map.Entry next = finApOccupyInvMap.entrySet().iterator().next();
            for (DynamicObject recordRow : redAndBlueInvRecordRows) {
                long mainBillId = recordRow.getLong("billid");
                BigDecimal matchAmt = recordRow.getBigDecimal("matchamt");
                long assBillId = recordRow.getLong("assbillid");
                BigDecimal asstMatchAmt = recordRow.getBigDecimal("assmatchamt");
                if (mainBillId == assBillId) continue;
                Set main4FinApIds = (Set)inv4FinApMap.get(mainBillId);
                Set asst4FinApIds = (Set)inv4FinApMap.get(assBillId);
                if (ObjectUtils.isEmpty((Object)main4FinApIds) && ObjectUtils.isEmpty((Object)asst4FinApIds)) {
                    long needHangFinApId = 0L;
                    Set mainHangFinApIds = (Set)invHasAssignFinApMap.get(mainBillId);
                    Set asstHangFinApIds = (Set)invHasAssignFinApMap.get(assBillId);
                    if (!ObjectUtils.isEmpty((Object)mainHangFinApIds) && !ObjectUtils.isEmpty((Object)asstHangFinApIds)) {
                        for (Long mainHangFinApId : mainHangFinApIds) {
                            if (!asstHangFinApIds.contains(mainHangFinApId)) continue;
                            needHangFinApId = mainHangFinApId;
                            break;
                        }
                    }
                    Map invoiceOccupyAmtMap = needHangFinApId == 0L ? (Map)next.getValue() : (Map)finApOccupyInvMap.getOrDefault(needHangFinApId, new HashMap(8));
                    BigDecimal mainOccupyAmt = invoiceOccupyAmtMap.getOrDefault(mainBillId, BigDecimal.ZERO);
                    mainOccupyAmt = mainOccupyAmt.add(matchAmt);
                    invoiceOccupyAmtMap.put(mainBillId, mainOccupyAmt);
                    BigDecimal asstOccupyAmt = invoiceOccupyAmtMap.getOrDefault(assBillId, BigDecimal.ZERO);
                    asstOccupyAmt = asstOccupyAmt.add(asstMatchAmt);
                    invoiceOccupyAmtMap.put(assBillId, asstOccupyAmt);
                    finApOccupyInvMap.put(needHangFinApId == 0L ? (Long)next.getKey() : Long.valueOf(needHangFinApId), invoiceOccupyAmtMap);
                    continue;
                }
                long needWriteFinApId = ObjectUtils.isEmpty((Object)main4FinApIds) ? ((Long)new ArrayList(asst4FinApIds).get(0)).longValue() : ((Long)new ArrayList(main4FinApIds).get(0)).longValue();
                Map finApWriteAmtMap = (Map)finApOccupyInvMap.get(needWriteFinApId);
                BigDecimal mainOccupyAmt = finApWriteAmtMap.getOrDefault(mainBillId, BigDecimal.ZERO);
                mainOccupyAmt = mainOccupyAmt.add(matchAmt);
                finApWriteAmtMap.put(mainBillId, mainOccupyAmt);
                BigDecimal asstOccupyAmt = finApWriteAmtMap.getOrDefault(assBillId, BigDecimal.ZERO);
                asstOccupyAmt = asstOccupyAmt.add(asstMatchAmt);
                finApWriteAmtMap.put(assBillId, asstOccupyAmt);
                finApOccupyInvMap.put(needWriteFinApId, finApWriteAmtMap);
            }
        }
        return finApOccupyInvMap;
    }

    private void processExceptionScene(DynamicObject[] entities, DynamicObject[] invoices) {
        HashMap<Long, String> invoiceBillNoMap = new HashMap<Long, String>(64);
        for (DynamicObject finApBill : entities) {
            DynamicObjectCollection invEntries = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invEntry : invEntries) {
                if (invEntry.getBigDecimal("i_usedamt").signum() != 0) continue;
                invoiceBillNoMap.put(invEntry.getLong("invid"), invEntry.getString("i_billno"));
            }
        }
        String errorMessage = InvoiceHelper.validatorInvoiceExist(invoiceBillNoMap, (DynamicObject[])invoices);
        if (!ObjectUtils.isEmpty((Object)errorMessage)) {
            throw new KDBizException(errorMessage);
        }
    }

    private void updateFinApTaxDeduction(AssignInvoiceParam assignInvoiceParam, DynamicObject[] finBills, DynamicObject[] invoices) {
        if (ObjectUtils.isEmpty((Object[])finBills) || ObjectUtils.isEmpty((Object[])invoices)) {
            return;
        }
        Map<Long, DynamicObject> invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
        Object[] newInvoices = new DynamicObject[]{};
        HashSet<Long> invoiceIds = new HashSet<Long>(64);
        for (DynamicObject finBill : finBills) {
            DynamicObjectCollection invEntry = finBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                String isEle = invRow.getString("i_invoicetypef7.is_ele_invoice");
                if ("0".equals(isEle)) {
                    finBill.set("haspaperticket", (Object)Boolean.TRUE);
                }
                if (invoiceMap.get(invId) != null) continue;
                invoiceIds.add(invId);
            }
        }
        if (!invoiceIds.isEmpty()) {
            QFilter qfilter = new QFilter("id", "in", invoiceIds);
            String selector = "istaxdeduction,serialno,invoiceno,invoicecode";
            for (DynamicObject dynamicObject : newInvoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selector, (QFilter[])new QFilter[]{qfilter})) {
                invoiceMap.put(dynamicObject.getLong("id"), dynamicObject);
            }
        }
        if (assignInvoiceParam.isAutoAssign()) {
            String billTypes = StdConfig.get((String)"ignore.billTypes");
            for (DynamicObject finBill : finBills) {
                String string = finBill.getString("billtypeid.number");
                if (billTypes != null && billTypes.contains(string)) continue;
                boolean isTaxDeduction = finBill.getBoolean("istaxdeduction");
                DynamicObjectCollection invEntry = finBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    DynamicObject invoice = invoiceMap.get(invRow.getLong("invid"));
                    if (invoice == null) continue;
                    invoice.set("istaxdeduction", (Object)isTaxDeduction);
                }
            }
        } else {
            DynamicObject finBill = finBills[0];
            String billStatus = finBill.getString("billstatus");
            if ("B".equals(billStatus)) {
                finBill.set("istaxdeduction", (Object)invoices[0].getBoolean("istaxdeduction"));
                ApFarmTaxAmtHelper.setFinDecuAmt((DynamicObject[])finBills);
            } else if ("C".equals(billStatus)) {
                String billTypes = StdConfig.get((String)"ignore.billTypes");
                String billTypeNum = finBill.getString("billtypeid.number");
                if (billTypes == null || !billTypes.contains(billTypeNum)) {
                    DynamicObjectCollection invEntry = finBill.getDynamicObjectCollection("inventry");
                    for (DynamicObject invRow : invEntry) {
                        DynamicObject invoice = invoiceMap.get(invRow.getLong("invid"));
                        if (invoice == null) continue;
                        invoice.set("istaxdeduction", (Object)finBill.getBoolean("istaxdeduction"));
                    }
                }
            }
        }
        for (DynamicObject finBill : finBills) {
            DynamicObjectCollection invEntry = finBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = invoiceMap.get(invRow.getLong("invid"));
                if (invoice == null) continue;
                invRow.set("i_istaxdeduction", (Object)invoice.getBoolean("istaxdeduction"));
            }
        }
        this.updateInvoiceTaxDeduction(invoiceMap);
        if (!ObjectUtils.isEmpty((Object[])newInvoices)) {
            SaveServiceHelper.save((DynamicObject[])newInvoices);
        }
    }

    private void updateInvoiceTaxDeduction(Map<Long, DynamicObject> invoiceMap) {
        if (ObjectUtils.isEmpty(invoiceMap)) {
            return;
        }
        DynamicObjectCollection oldInvoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,istaxdeduction", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceMap.keySet())});
        Map<Long, Boolean> oldInvoiceDeductionMap = oldInvoices.stream().collect(Collectors.toMap(inv -> inv.getLong("id"), inv -> inv.getBoolean("istaxdeduction")));
        ArrayList<DynamicObject> taxDeductionChangedInvoices = new ArrayList<DynamicObject>(64);
        for (Map.Entry<Long, DynamicObject> entrySet : invoiceMap.entrySet()) {
            Long invId = entrySet.getKey();
            DynamicObject invoice = entrySet.getValue();
            if (invoice.getBoolean("istaxdeduction") == oldInvoiceDeductionMap.get(invId).booleanValue()) continue;
            taxDeductionChangedInvoices.add(invoice);
        }
        if (!taxDeductionChangedInvoices.isEmpty()) {
            this.updateTaxDeduction(taxDeductionChangedInvoices);
        }
    }

    private void updateTaxDeduction(List<DynamicObject> invoices) {
        if (ObjectUtils.isEmpty(invoices)) {
            return;
        }
        ConfigCache.put((String)"finBillUpdateTaxDeduction", (String)"finBillUpdateTaxDeduction", (Object)"true");
        ArrayList<Object> invoiceIds = new ArrayList<Object>(64);
        ArrayList<String> invNoAndCodes = new ArrayList<String>(64);
        for (DynamicObject invoice : invoices) {
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            invoiceIds.add(invoice.getPkValue());
            invNoAndCodes.add(invoice.getString("invoiceno") + "_" + invoice.getString("invoicecode"));
        }
        if (ObjectUtils.isEmpty(invoiceIds)) {
            return;
        }
        CommonParam param = new CommonParam();
        param.put((Object)"invoiceIds", invoiceIds);
        param.put((Object)"uniquekey", (Object)DB.genGlobalLongId());
        param.put((Object)"invNoAndCodes", invNoAndCodes);
        param.put((Object)"operate", (Object)this.getISrcType());
        ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_updatetaxdeduction", null, (String)"fi", (String)"ap", (String)"ApUpdateTaxDeductionECService", (Param)param, (String)"", invoiceIds);
    }

    protected DynamicObject[] getFinApBills(List<Long> finApBillIds) {
        HashSet<String> properties = new HashSet<String>(64);
        properties.add("billstatus");
        properties.addAll(PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false));
        properties.addAll(InvoiceHelper.getInvoiceAdjustSelectors());
        return BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", properties), (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
    }

    protected String getISrcType() {
        return InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue();
    }
}

