/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.collect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.vo.CloudInvoiceResultVO;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public abstract class AbstractCollectInvoiceService
implements ICollectInvoiceService {
    protected static final Log logger = LogFactory.getLog(AbstractCollectInvoiceService.class);
    protected InvoiceCollectParam collectParam;
    protected boolean isForm = false;

    @Override
    public CloudInvoiceResultVO collectInvoice(InvoiceCollectParam collectParam, DynamicObject[] entities) {
        logger.info("InvoiceCollectService collectInvoice_1 begin ");
        logger.info("InvoiceCollectService collectInvoice isForm : " + this.isForm);
        this.collectParam = collectParam;
        Map<String, DynamicObject> invoiceMap = this.analysisInvoiceData(entities);
        logger.info("InvoiceCollectService collectInvoice invoiceMap is : " + invoiceMap.keySet());
        this.beforeCollectInvoice(entities, invoiceMap);
        this.writeBackBills(entities, invoiceMap);
        this.afterCollectInvoice(entities, invoiceMap);
        return this.processResultVO(entities, invoiceMap);
    }

    @Override
    public CloudInvoiceResultVO collectInvoice(InvoiceCollectParam collectParam) {
        logger.info("InvoiceCollectService collectInvoice_2 begin ");
        this.isForm = true;
        return this.collectInvoice(collectParam, null);
    }

    protected abstract Map<String, DynamicObject> analysisInvoiceData(DynamicObject[] var1);

    protected void beforeCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
    }

    protected void writeBackBills(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
    }

    protected void afterCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
    }

    protected CloudInvoiceResultVO processResultVO(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        CloudInvoiceResultVO resultVO = new CloudInvoiceResultVO();
        if (!invoiceMap.isEmpty()) {
            resultVO.getHasRemoveSerialNos().addAll(invoiceMap.keySet());
        }
        return resultVO;
    }

    protected void executeAuditForInvoice(Map<Long, String> needAuditInvoiceMap, DynamicObject[] entities) {
        if (ObjectUtils.isEmpty(needAuditInvoiceMap)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", needAuditInvoiceMap.keySet());
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{filter});
        String errorMessage = InvoiceHelper.validatorInvoiceExist(needAuditInvoiceMap, (DynamicObject[])((DynamicObject[])invoices.toArray((Object[])new DynamicObject[0])));
        if (!ObjectUtils.isEmpty((Object)errorMessage)) {
            throw new KDBizException(errorMessage);
        }
        for (DynamicObject invoice : invoices) {
            if ("A".equals(invoice.getString("billstatus"))) continue;
            needAuditInvoiceMap.remove(invoice.getLong("id"));
        }
        if (!needAuditInvoiceMap.isEmpty()) {
            OperateOption operateOption0 = OperateOption.create();
            operateOption0.setVariableValue("currbizappid", this.collectParam.getAppId());
            operateOption0.setVariableValue("isreffin", "true");
            operateOption0.setVariableValue("WF", "false");
            operateOption0.setVariableValue("finBillno", entities[0].getString("billno"));
            operateOption0.setVariableValue("ishasright", "true");
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_invoice", (Object[])needAuditInvoiceMap.keySet().toArray(new Long[0]), (OperateOption)operateOption0);
            this.assertResult(submitResult, entities);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_invoice", (Object[])needAuditInvoiceMap.keySet().toArray(new Long[0]), (OperateOption)operateOption0);
            this.assertResult(auditResult, entities);
        }
    }

    private void assertResult(OperationResult result, DynamicObject[] entities) {
        if (result.isSuccess()) {
            return;
        }
        List validateInfos = result.getAllErrorOrValidateInfo();
        if (validateInfos == null || validateInfos.isEmpty()) {
            throw new KDBizException(result.getMessage());
        }
        String entityName = entities[0].getDataEntityType().getName();
        HashSet<String> invSrcTypes = new HashSet<String>(4);
        if ("ap_payapply".equals(entityName)) {
            invSrcTypes.add(ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue());
        } else if ("ap_finapbill".equals(entityName)) {
            invSrcTypes.add(InvoiceSrcTypeEnum.INVOICECOLLECT.getValue());
            invSrcTypes.add(InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue());
        } else {
            invSrcTypes.add(ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue());
        }
        StringBuilder sb = new StringBuilder();
        for (IOperateInfo err : validateInfos) {
            Long pkValue = (Long)err.getPkValue();
            String billNo = "";
            for (DynamicObject bill : entities) {
                List errorPks;
                DynamicObjectCollection inventries;
                if ("ap_replaceinvapply".equals(entityName)) {
                    inventries = bill.getDynamicObjectCollection("newinventry");
                    errorPks = inventries.stream().filter(inventry -> inventry.getLong("n_invid") == pkValue.longValue() && invSrcTypes.contains(inventry.getString("n_srctype"))).collect(Collectors.toList());
                } else {
                    inventries = bill.getDynamicObjectCollection("inventry");
                    errorPks = inventries.stream().filter(inventry -> inventry.getLong("invid") == pkValue.longValue() && invSrcTypes.contains(inventry.getString("i_srctype"))).collect(Collectors.toList());
                }
                if (errorPks.isEmpty()) continue;
                billNo = "ap_payapply".equals(entityName) ? ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7%s\u5bf9\u5e94\u7684\u6536\u7968\u5355", (String)"AbstractCollectInvoiceService_1", (String)"fi-ap-business", (Object[])new Object[0]) : ("ap_finapbill".equals(entityName) ? ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u7f16\u53f7%s\u5bf9\u5e94\u7684\u6536\u7968\u5355", (String)"AbstractCollectInvoiceService_0", (String)"fi-ap-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6362\u7968\u7533\u8bf7\u7f16\u53f7%s\u5bf9\u5e94\u7684\u6536\u7968\u5355", (String)"AbstractCollectInvoiceService_4", (String)"fi-ap-business", (Object[])new Object[0]));
                billNo = String.format(billNo, bill.getString("billno"));
                break;
            }
            sb.append(billNo).append(err.getMessage()).append('\n');
        }
        ErrorCode errorCode = new ErrorCode("ARAP_OPERATION_RESULT", sb.toString());
        throw new KDBizException(errorCode, new Object[0]);
    }

    protected List<String> getOriginalSerialNos(Map<String, String> returnData) {
        String serialNosStr = returnData.get("msg");
        if (StringUtils.isEmpty((String)serialNosStr)) {
            StringBuilder buf = new StringBuilder();
            JSONArray invoiceData = JSON.parseArray((String)JSON.toJSONString((Object)returnData.get("invoiceData")));
            if (invoiceData != null && invoiceData.size() > 0) {
                for (Object invoiceDatum : invoiceData) {
                    JSONObject invoice = (JSONObject)invoiceDatum;
                    if (invoice == null) continue;
                    String serialNo = invoice.get((Object)"serialNo").toString();
                    buf.append(serialNo);
                    buf.append(',');
                }
                serialNosStr = buf.toString();
            }
        }
        logger.info("AbstractCollectInvoiceService getOriginalSerialNos---\u8fd4\u56de\u7684\u53d1\u7968\u6d41\u6c34\u53f7\u662f" + serialNosStr);
        if (ObjectUtils.isEmpty((Object)serialNosStr)) {
            return new ArrayList<String>(2);
        }
        return Arrays.stream(serialNosStr.split(",")).collect(Collectors.toList());
    }

    protected void invoiceAsstactWarn(Map<String, DynamicObject> invoiceMap) {
        DynamicObject org;
        IDataModel model = this.collectParam.getFormView().getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String entityName = model.getDataEntityType().getName();
        boolean hasConfigWarn = false;
        String asstName = null;
        if ("ap_finapbill".equals(entityName)) {
            asstName = dataEntity.getString("asstact.name");
            org = (DynamicObject)model.getValue("org");
        } else {
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            if (!entry.isEmpty()) {
                asstName = ((DynamicObject)entry.get(0)).getString("e_asstact.name");
            }
            org = (DynamicObject)model.getValue("applyorg");
        }
        if (org != null) {
            HashSet<Long> orgIds = new HashSet<Long>(1);
            Long orgId = org.getLong("id");
            orgIds.add(orgId);
            Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
            DynamicObject config = (DynamicObject)configByOrg.get(orgId);
            boolean bl = hasConfigWarn = EmptyUtils.isEmpty((Object)config) || config != null && ("2".equals(config.getString("identicalpartyinvcom")) || "".equals(config.getString("identicalpartyinvcom")));
            if (!hasConfigWarn) {
                this.collectParam.getFormView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
            }
        }
        if (!hasConfigWarn || asstName == null) {
            return;
        }
        for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
            DynamicObject invoice = entrySet.getValue();
            if (asstName.trim().equals(invoice.getString("asstactname").trim())) continue;
            String showMessage = "ap_finapbill".equals(entityName) ? ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5f80\u6765\u6237\u4e0e\u53d1\u7968\u5f00\u7968\u516c\u53f8\u4e0d\u4e00\u81f4\u3002", (String)"AbstractCollectInvoiceService_2", (String)"fi-ap-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u6536\u6b3e\u4f9b\u5e94\u5546\u4e0e\u5f00\u7968\u516c\u53f8\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"AbstractCollectInvoiceService_3", (String)"fi-ap-business", (Object[])new Object[0]);
            Label label = (Label)this.collectParam.getFormView().getControl("invasstactinfo_labelap");
            label.setText(showMessage);
            this.collectParam.getFormView().setVisible(Boolean.TRUE, new String[]{"invasstactinfoflex"});
            break;
        }
    }
}

