/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.collect;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.Invoice4CloudResolveService;
import kd.fi.ap.business.invoice.InvoiceSynAttachmentService;
import kd.fi.ap.business.invoice.collect.AbstractCollectInvoiceService;
import kd.fi.ap.business.pojo.InvoiceResolveParam;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.vo.CloudInvoiceResultVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.StdConfig;

public class FinApCollectInvServiceImpl
extends AbstractCollectInvoiceService {
    private Map<String, DynamicObject> invoiceTypeMap = new HashMap<String, DynamicObject>(8);

    @Override
    protected Map<String, DynamicObject> analysisInvoiceData(DynamicObject[] entities) {
        logger.info("FinApCollectInvServiceImpl analysisInvoiceData begin.");
        List<DynamicObject> invoices = new ArrayList<DynamicObject>(64);
        String actionId = this.collectParam.getActionId();
        Map returnData = this.collectParam.getReturnData();
        if (this.isForm) {
            Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
            invoices = resolveService.importInvoice4Cloud(this.collectParam.getFormView(), returnData, actionId);
        } else {
            List<DynamicObject> savedInvoices = this.finApOperateToSaveInv(entities);
            invoices.addAll(savedInvoices);
        }
        return invoices.stream().collect(Collectors.toMap(inv -> inv.getString("serialno"), Function.identity()));
    }

    @Override
    protected void beforeCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("FinApCollectInvServiceImpl beforeCollectInvoice begin.");
        if (this.isForm) {
            this.checkInvoice(invoiceMap);
        }
    }

    @Override
    protected void writeBackBills(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("FinApCollectInvServiceImpl writeBackBills begin.");
        if (this.isForm && !invoiceMap.isEmpty()) {
            DynamicObject finApBill = this.collectParam.getFormView().getModel().getDataEntity(true);
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
                DynamicObject newInvRow = invEntry.addNew();
                DynamicObject downloadInv = entrySet.getValue();
                this.buildFinApInvEntry(newInvRow, downloadInv);
                newInvRow.set("i_srctype", (Object)InvoiceSrcTypeEnum.INVOICECOLLECT.getValue());
                newInvRow.set("invid", (Object)downloadInv.getLong("id"));
                String isEle = newInvRow.getString("i_invoicetypef7.is_ele_invoice");
                if (!"0".equals(isEle)) continue;
                finApBill.set("haspaperticket", (Object)Boolean.TRUE);
            }
        }
        if (!this.isForm) {
            for (DynamicObject finApBill : entities) {
                DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    if (!ObjectUtils.isEmpty((Object)invRow.getString("i_billno"))) continue;
                    String serialNo = invRow.getString("i_serialno");
                    DynamicObject savedInvoice = invoiceMap.get(serialNo);
                    if (savedInvoice == null) {
                        String opKey = "save".equals(this.collectParam.getOperateKey()) ? ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"FinApCollectInvServiceImpl_6", (String)"fi-ap-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"FinApCollectInvServiceImpl_7", (String)"fi-ap-business", (Object[])new Object[0]);
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u53d1\u7968\u53f7\u7801\u3001\u53d1\u7968\u4ee3\u7801\u7684\u6536\u7968\u5355\uff0c%s\u5931\u8d25\u3002", (String)"FinApCollectInvServiceImpl_0", (String)"fi-ap-business", (Object[])new Object[]{opKey}));
                    }
                    invRow.set("invid", (Object)savedInvoice.getLong("id"));
                    invRow.set("i_billno", (Object)savedInvoice.getString("billno"));
                    if (!ObjectUtils.isEmpty((Object)invRow.getString("i_invoicecode")) || !ObjectUtils.isEmpty((Object)invRow.getString("i_invoiceno"))) continue;
                    this.buildFinApInvEntry(invRow, savedInvoice);
                    String isEle = invRow.getString("i_invoicetypef7.is_ele_invoice");
                    if (!"0".equals(isEle)) continue;
                    finApBill.set("haspaperticket", (Object)Boolean.TRUE);
                }
            }
        }
    }

    @Override
    protected void afterCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("FinApCollectInvServiceImpl afterCollectInvoice begin.");
        if (this.isForm && !invoiceMap.isEmpty()) {
            IFormView formView = this.collectParam.getFormView();
            IDataModel model = formView.getModel();
            DynamicObject finApBill = formView.getModel().getDataEntity(true);
            boolean finDeduc = finApBill.getBoolean("istaxdeduction");
            String billStatus = finApBill.getString("billstatus");
            DynamicObject[] billTypes = StdConfig.get((String)"ignore.billTypes");
            String billTypeNum = finApBill.getString("billtypeid.number");
            boolean isIgnore = billTypes != null && billTypes.contains(billTypeNum);
            boolean isWrittenOff = finApBill.getBoolean("iswrittenoff");
            for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
                DynamicObject downloadInv = entrySet.getValue();
                boolean invDeduc = downloadInv.getBoolean("istaxdeduction");
                if (invDeduc == finDeduc || isIgnore) continue;
                if (!isWrittenOff && "A".equals(billStatus)) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u4e2d\u53d1\u7968\u7684\u201c\u53ef\u62b5\u6263\u201d\u6807\u8bc6\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u201c\u8fdb\u9879\u7a0e\u62b5\u6263\u201d\u6807\u8bc6\u5b58\u5728\u4e0d\u4e00\u81f4\uff0c\u63d0\u4ea4\u540e\uff0c\u4f1a\u6839\u636e\u201c\u8fdb\u9879\u7a0e\u62b5\u6263\u201d\u6807\u8bc6\u66f4\u65b0\u53d1\u7968\u7684\u201c\u53ef\u62b5\u6263\u201d\u6807\u8bc6\u3002", (String)"FinApCollectInvServiceImpl_8", (String)"fi-ap-business", (Object[])new Object[0]), Integer.valueOf(20000));
                    break;
                }
                if ("B".equals(billStatus)) {
                    formView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6839\u636e\u53d1\u7968\u7684\u201c\u53ef\u62b5\u6263\u201d\u6807\u8bc6\u66f4\u65b0\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u201c\u8fdb\u9879\u7a0e\u62b5\u6263\u201d\u6807\u8bc6\u3002", (String)"FinApCollectInvServiceImpl_9", (String)"fi-ap-business", (Object[])new Object[0]), Integer.valueOf(20000));
                    break;
                }
                if (!isWrittenOff || !"A".equals(billStatus)) break;
                formView.showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u4e2d\u53d1\u7968\u7684\u201c\u53ef\u62b5\u6263\u201d\u6807\u8bc6\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u201c\u8fdb\u9879\u7a0e\u62b5\u6263\u201d\u6807\u8bc6\u5b58\u5728\u4e0d\u4e00\u81f4\uff0c\u786e\u8ba4\u51b2\u9500\u540e\uff0c\u4f1a\u6839\u636e\u201c\u8fdb\u9879\u7a0e\u62b5\u6263\u201d\u6807\u8bc6\u66f4\u65b0\u53d1\u7968\u7684\u201c\u53ef\u62b5\u6263\u201d\u6807\u8bc6\u3002", (String)"FinApCollectInvServiceImpl_10", (String)"fi-ap-business", (Object[])new Object[0]), Integer.valueOf(20000));
                break;
            }
            InvoiceHelper.updateFinTaxDeductionLogic((DynamicObject[])new DynamicObject[]{finApBill}, (boolean)"B".equals(finApBill.getString("billstatus")));
            if (!BillStatusEnum.SUBMIT.getValue().equals(model.getValue("billstatus"))) {
                formView.updateView("inventry");
                formView.updateView("istaxdeduction");
                formView.updateView("haspaperticket");
                InvoiceSynAttachmentService attachmentService = (InvoiceSynAttachmentService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.SYNATTACHMENT.getValue());
                attachmentService.synAttachment(this.collectParam);
            }
            if (BillStatusEnum.SUBMIT.getValue().equals(model.getValue("billstatus")) && !model.getEntryEntity("inventry").isEmpty()) {
                formView.invokeOperation("assignsave");
            }
            BizExtendHelper.afterBizProcess((IFormView)formView, (String)"finap_collect_invoice");
            this.invoiceAsstactWarn(invoiceMap);
        }
        if (!this.isForm) {
            String operationKey = this.collectParam.getOperateKey();
            HashMap<Long, String> needAuditInvoiceMap = new HashMap<Long, String>(64);
            HashSet<Long> finApAssignIds = new HashSet<Long>(64);
            Set invoiceSrcTypeEnums = InvoiceHelper.getCollectInvoiceSrcTypeEnums((boolean)true);
            HashSet<Long> needUpdateInvStatusIds = new HashSet<Long>(8);
            for (DynamicObject finApBill : entities) {
                if (!"submit".equals(operationKey) && !"assignsave".equals(operationKey) && (!"save".equals(operationKey) || !finApBill.getBoolean("iswrittenoff"))) continue;
                DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    String iSrcType = invRow.getString("i_srctype");
                    if ("submit".equals(operationKey)) {
                        needUpdateInvStatusIds.add(invRow.getLong("invid"));
                    }
                    if (invRow.getBigDecimal("i_usedamt").signum() != 0) continue;
                    long invId = invRow.getLong("invid");
                    if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) || InvoiceSrcTypeEnum.INVOICEMATCH.getValue().equals(iSrcType)) {
                        finApAssignIds.add(finApBill.getLong("id"));
                        continue;
                    }
                    if (!invoiceSrcTypeEnums.contains(iSrcType)) continue;
                    needAuditInvoiceMap.put(invId, invRow.getString("i_billno"));
                    finApAssignIds.add(finApBill.getLong("id"));
                }
            }
            this.executeAuditForInvoice(needAuditInvoiceMap, entities);
            SaveServiceHelper.save((DynamicObject[])entities);
            if (!finApAssignIds.isEmpty()) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("invPks", "");
                operateOption.setVariableValue("currbizappid", this.collectParam.getAppId());
                OperationResult assignResult = OperationServiceHelper.executeOperate((String)"assign", (String)"ap_finapbill", (Object[])finApAssignIds.toArray(new Long[0]), (OperateOption)operateOption);
                logger.info("---assignResult.success---" + assignResult.isSuccess());
                logger.info("---assignResult.Message---" + assignResult.getMessage());
                OperationHelper.assertResult((OperationResult)assignResult);
            }
            InvoiceHelper.updateInvoiceStatus((Long[])needUpdateInvStatusIds.toArray(new Long[0]));
        }
    }

    @Override
    protected CloudInvoiceResultVO processResultVO(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("FinApCollectInvServiceImpl processResultVO begin.");
        CloudInvoiceResultVO resultVO = super.processResultVO(entities, invoiceMap);
        if (this.isForm) {
            List<String> serialNos = this.getOriginalSerialNos(this.collectParam.getReturnData());
            resultVO.getUnSaveSerialNos().addAll(serialNos);
        }
        return resultVO;
    }

    private List<DynamicObject> finApOperateToSaveInv(DynamicObject[] finApBills) {
        logger.info("FinApCollectInvServiceImpl finApOperateToSaveInv begin");
        ArrayList<DynamicObject> savedInvoices = new ArrayList<DynamicObject>(64);
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return savedInvoices;
        }
        Map orgForSerialMap = InvoiceHelper.getOrgForSerialMap((DynamicObject[])finApBills);
        logger.info("FinApCollectInvServiceImpl finApOperateToSaveInv orgForSerialMap : " + orgForSerialMap);
        List invoiceVOS = CallCloudHelper.queryCloudInvoice((Map)orgForSerialMap);
        if (ObjectUtils.isEmpty((Object)invoiceVOS)) {
            return savedInvoices;
        }
        Map invoiceVOMap = invoiceVOS.stream().collect(Collectors.toMap(InvoiceVO::getSerialNo, Function.identity()));
        Set invoiceSrcTypeEnums = InvoiceHelper.getCollectInvoiceSrcTypeEnums((boolean)true);
        for (DynamicObject finApBill : finApBills) {
            List<InvoiceVO> tempInvoiceVOs;
            HashMap<String, Long> serialNoToIdMap = new HashMap<String, Long>(8);
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                String iSrcType = invRow.getString("i_srctype");
                if (!invoiceSrcTypeEnums.contains(iSrcType) || !ObjectUtils.isEmpty((Object)invRow.getString("i_billno")) || ObjectUtils.isEmpty((Object)invRow.getString("i_serialno"))) continue;
                serialNoToIdMap.put(invRow.getString("i_serialno"), invRow.getLong("invid"));
            }
            if (serialNoToIdMap.isEmpty() || (tempInvoiceVOs = invoiceVOMap.entrySet().stream().filter(e -> serialNoToIdMap.containsKey(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList())).isEmpty()) continue;
            String asstactType = finApBill.getString("asstacttype");
            Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
            InvoiceResolveParam resolveParam = new InvoiceResolveParam();
            resolveParam.setAppId(this.collectParam.getAppId()).setOrgId(finApBill.getLong("org.id")).setBizType("bd_supplier".equals(asstactType) ? "PUR" : "FEE").setSerialNoMap(serialNoToIdMap).setAsstactType(asstactType).setAsstactId(finApBill.getLong("asstact.id")).setSrcCollect(true).setNeedSave(true).setInvoiceOrigin("ap_finapbill");
            savedInvoices.addAll(resolveService.genInvoice(resolveParam, tempInvoiceVOs));
        }
        logger.info("FinApCollectInvServiceImpl finApOperateToSaveInv savedInvoices size : " + savedInvoices.size());
        return savedInvoices;
    }

    private void checkInvoice(Map<String, DynamicObject> invoiceMap) {
        List<String> originalSerialNos = this.getOriginalSerialNos(this.collectParam.getReturnData());
        ArrayList<String> needRemoveSerialNos = new ArrayList<String>(2);
        IDataModel model = this.collectParam.getFormView().getModel();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObjectCollection inventry = model.getEntryEntity("inventry");
        Set serialNoSet = inventry.stream().map(invEntry -> invEntry.getString("i_serialno")).collect(Collectors.toSet());
        StringBuilder builder = new StringBuilder();
        BigDecimal priceTaxTotal = (BigDecimal)model.getValue("pricetaxtotal");
        for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
            String invoiceStatus;
            DynamicObject inv = entrySet.getValue();
            String invoiceNo = inv.getString("invoiceno");
            String invoiceCode = inv.getString("invoicecode");
            String invoiceMessage = ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s", (String)"FinApCollectInvServiceImp_8", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"FinApCollectInvServiceImp_9", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo, invoiceCode);
            String serialNo = inv.getString("serialno");
            originalSerialNos.remove(serialNo);
            if (!inventry.isEmpty() && serialNoSet.contains(serialNo)) {
                builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"FinApCollectInvServiceImpl_1", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
                builder.append('\n');
                needRemoveSerialNos.add(serialNo);
            }
            if ("2".equals(invoiceStatus = inv.getString("invoicestatus"))) {
                builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"FinApCollectInvServiceImpl_3", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
                builder.append('\n');
                needRemoveSerialNos.add(serialNo);
            }
            if (inv.getLong("currency.id") == currency.getLong("id")) continue;
            builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5e94\u4ed8\u7ed3\u7b97\u5e01[%2$s]\u4e0e\u53d1\u7968\u5e01\u79cd[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApCollectInvServiceImpl_4", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage, currency.getString("name"), inv.getString("currency.name")));
            builder.append('\n');
            needRemoveSerialNos.add(serialNo);
        }
        if (!originalSerialNos.isEmpty()) {
            originalSerialNos.removeIf(invoiceMap::containsKey);
            if (!originalSerialNos.isEmpty()) {
                DynamicObject org = (DynamicObject)model.getValue("org");
                HashMap orgForSerialMap = new HashMap(2);
                orgForSerialMap.put(org.getLong("id"), String.join((CharSequence)",", originalSerialNos));
                List invoiceVOS = CallCloudHelper.queryCloudInvoice((Map)orgForSerialMap);
                for (InvoiceVO invoiceVO : invoiceVOS) {
                    String invoiceNo = invoiceVO.getInvoiceNo();
                    String invoiceCode = invoiceVO.getInvoiceCode();
                    String invoiceMessage = ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s", (String)"FinApCollectInvServiceImp_8", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"FinApCollectInvServiceImp_9", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo, invoiceCode);
                    builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"FinApCollectInvServiceImpl_1", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
                    builder.append('\n');
                }
            }
        }
        BigDecimal unInvoicedAmt = (BigDecimal)model.getValue("uninvoicedamt");
        if ("B".equals(model.getValue("billstatus")) && unInvoicedAmt.compareTo(BigDecimal.ZERO) == 0) {
            builder.append(ResManager.loadKDString((String)"\u672a\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u7b49\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"FinApCollectInvServiceImpl_5", (String)"fi-ap-business", (Object[])new Object[0]));
            builder.append('\n');
            needRemoveSerialNos.addAll(invoiceMap.keySet());
        }
        for (String removeSerialNo : needRemoveSerialNos) {
            invoiceMap.remove(removeSerialNo);
        }
        needRemoveSerialNos.clear();
        BigDecimal invoiceSumAmt = BigDecimal.ZERO;
        for (DynamicObject invoice : invoiceMap.values()) {
            invoiceSumAmt = invoiceSumAmt.add(invoice.getBigDecimal("pricetaxtotal"));
        }
        if ("B".equals(model.getValue("billstatus")) && BigDecimal.ZERO.compareTo(priceTaxTotal.multiply(invoiceSumAmt)) > 0) {
            builder.append(ResManager.loadKDString((String)"\u53d1\u7968\u6c47\u603b\u91d1\u989d\u65b9\u5411\u4e0e\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"FinApCollectInvServiceImpl_2", (String)"fi-ap-business", (Object[])new Object[0]));
            builder.append('\n');
            needRemoveSerialNos.addAll(invoiceMap.keySet());
        }
        if (builder.length() > 0) {
            this.collectParam.getFormView().showErrorNotification(String.valueOf(builder));
        }
        for (String removeSerialNo : needRemoveSerialNos) {
            invoiceMap.remove(removeSerialNo);
        }
    }

    private void buildFinApInvEntry(DynamicObject finInvRow, DynamicObject invoice) {
        if (this.invoiceTypeMap.isEmpty()) {
            this.invoiceTypeMap = InvoiceTypeHelper.getInvoiceTypeMap();
        }
        finInvRow.set("i_usedamt", (Object)BigDecimal.ZERO);
        finInvRow.set("i_canuseamt", (Object)invoice.getBigDecimal("pricetaxtotal"));
        String invoicetype = invoice.getString("invoicetype");
        finInvRow.set("i_invoicetype", (Object)invoicetype);
        String typeNo = InvoiceType.getTypeNo((String)invoicetype);
        DynamicObject invTypeF7 = this.invoiceTypeMap.get(typeNo == null ? invoicetype : typeNo);
        finInvRow.set("i_invoicetypef7", (Object)invTypeF7);
        finInvRow.set("i_invoicecode", (Object)invoice.getString("invoicecode"));
        finInvRow.set("i_currency", (Object)invoice.getDynamicObject("currency"));
        finInvRow.set("i_invoiceno", (Object)invoice.getString("invoiceno"));
        finInvRow.set("i_invoicedate", (Object)invoice.getDate("issuedate"));
        finInvRow.set("i_pricetaxtotal", (Object)invoice.getBigDecimal("pricetaxtotal"));
        finInvRow.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)invoice));
        finInvRow.set("i_tax", (Object)invoice.getBigDecimal("tax"));
        finInvRow.set("i_amount", (Object)invoice.getBigDecimal("amount"));
        finInvRow.set("i_asstactname", (Object)invoice.getString("asstactname"));
        finInvRow.set("i_buyername", (Object)invoice.getString("buyername"));
        finInvRow.set("i_istaxdeduction", (Object)invoice.getBoolean("istaxdeduction"));
        finInvRow.set("i_remark", (Object)invoice.getString("remark"));
        finInvRow.set("i_issupplement", (Object)"0");
        finInvRow.set("i_serialno", (Object)invoice.getString("serialno"));
        finInvRow.set("i_invoicestatus", (Object)invoice.getString("invoicestatus"));
    }
}

