/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.collect;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.Invoice4CloudResolveService;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.invoice.collect.AbstractCollectInvoiceService;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.business.pojo.InvoiceResolveParam;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;

public class PayApplyCollectInvServiceImpl
extends AbstractCollectInvoiceService {
    @Override
    protected Map<String, DynamicObject> analysisInvoiceData(DynamicObject[] entities) {
        logger.info("PayApplyCollectInvServiceImpl analysisInvoiceData begin.");
        List<DynamicObject> invoices = new ArrayList<DynamicObject>(64);
        String actionId = this.collectParam.getActionId();
        Map returnData = this.collectParam.getReturnData();
        if (this.isForm) {
            Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
            invoices = resolveService.importInvoice4Cloud(this.collectParam.getFormView(), returnData, actionId);
        } else {
            List<DynamicObject> savedInvoices = this.payApplyOperateToSaveInv(entities);
            invoices.addAll(savedInvoices);
        }
        return invoices.stream().collect(Collectors.toMap(inv -> inv.getString("serialno"), Function.identity()));
    }

    @Override
    protected void beforeCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("PayApplyCollectInvServiceImpl beforeCollectInvoice begin.");
        if (this.isForm) {
            this.checkInvoice(invoiceMap);
        }
    }

    @Override
    protected void writeBackBills(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("PayApplyCollectInvServiceImpl writeBackBills begin.");
        if (this.isForm && !invoiceMap.isEmpty()) {
            DynamicObject finApBill = this.collectParam.getFormView().getModel().getDataEntity(true);
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            Map invoiceTypeMap = InvoiceTypeHelper.getInvoiceTypeMap();
            for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
                DynamicObject newInvRow = invEntry.addNew();
                Iterator downloadInv = entrySet.getValue();
                newInvRow.set("i_serialno", (Object)downloadInv.getString("serialno"));
                newInvRow.set("i_srctype", (Object)ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue());
                newInvRow.set("invid", (Object)downloadInv.getLong("id"));
                newInvRow.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)downloadInv));
                String invoicetype = downloadInv.getString("invoicetype");
                String typeNo = InvoiceType.getTypeNo((String)invoicetype);
                DynamicObject invTypeF7 = (DynamicObject)invoiceTypeMap.get(typeNo == null ? invoicetype : typeNo);
                newInvRow.set("i_invoicetypef7", (Object)invTypeF7);
                newInvRow.set("i_invoicecode", (Object)downloadInv.getString("invoicecode"));
                newInvRow.set("i_currency", (Object)downloadInv.getDynamicObject("currency"));
                newInvRow.set("i_invoiceno", (Object)downloadInv.getString("invoiceno"));
                newInvRow.set("i_invoicedate", (Object)downloadInv.getDate("issuedate"));
                newInvRow.set("i_pricetaxtotal", (Object)downloadInv.getBigDecimal("pricetaxtotal"));
                newInvRow.set("i_tax", (Object)downloadInv.getBigDecimal("tax"));
                newInvRow.set("i_amount", (Object)downloadInv.getBigDecimal("amount"));
                newInvRow.set("i_asstactname", (Object)downloadInv.getString("asstactname"));
                newInvRow.set("i_buyername", (Object)downloadInv.getString("buyername"));
                newInvRow.set("i_istaxdeduction", (Object)downloadInv.getBoolean("istaxdeduction"));
                newInvRow.set("i_remark", (Object)downloadInv.getString("remark"));
                newInvRow.set("i_invoicestatus", (Object)downloadInv.getString("invoicestatus"));
            }
        }
        if (!this.isForm) {
            HashSet<Long> invoiceIds = new HashSet<Long>(32);
            for (DynamicObjectCollection applyBill : entities) {
                DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    if (!ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype"))) continue;
                    invoiceIds.add(invRow.getLong("invid"));
                }
            }
            if (invoiceIds.isEmpty()) {
                return;
            }
            DynamicObjectCollection hasExistInvoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
            Set hasExistInvIds = hasExistInvoices.stream().map(inv -> inv.getLong("id")).collect(Collectors.toSet());
            for (DynamicObjectCollection applyBill : entities) {
                DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    String iSrcType = invRow.getString("i_srctype");
                    long invId = invRow.getLong("invid");
                    if (!ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType) || hasExistInvIds.contains(invId)) continue;
                    String serialNo = invRow.getString("i_serialno");
                    DynamicObject savedInvoice = invoiceMap.get(serialNo);
                    if (savedInvoice == null) {
                        String opKey = "save".equals(this.collectParam.getOperateKey()) ? ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"PayApplyCollectInvServiceImpl_4", (String)"fi-ap-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"PayApplyCollectInvServiceImpl_5", (String)"fi-ap-business", (Object[])new Object[0]);
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u53d1\u7968\u53f7\u7801\u3001\u53d1\u7968\u4ee3\u7801\u7684\u6536\u7968\u5355\uff0c%s\u5931\u8d25\u3002", (String)"PayApplyCollectInvServiceImpl_6", (String)"fi-ap-business", (Object[])new Object[]{opKey}));
                    }
                    invRow.set("invid", (Object)savedInvoice.getLong("id"));
                }
            }
        }
    }

    @Override
    protected void afterCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("PayApplyCollectInvServiceImpl afterCollectInvoice begin.");
        if (this.isForm && !invoiceMap.isEmpty()) {
            IFormView formView = this.collectParam.getFormView();
            IDataModel model = formView.getModel();
            formView.updateView("inventry");
            if (!BillStatusEnum.SAVE.getValue().equals(model.getValue("billstatus")) && !model.getEntryEntity("inventry").isEmpty()) {
                formView.invokeOperation("assignsave");
            }
            BizExtendHelper.afterBizProcess((IFormView)formView, (String)"apply_collect_invoice");
            this.invoiceAsstactWarn(invoiceMap);
        }
        if (!this.isForm) {
            HashMap<Long, Set<Long>> apply4InvoiceMap = new HashMap<Long, Set<Long>>(8);
            HashMap<Long, String> needAuditInvoiceMap = new HashMap<Long, String>(8);
            HashSet<Long> needAssignApplyIds = new HashSet<Long>(8);
            HashSet<Long> needUpdateInvStatusIds = new HashSet<Long>(8);
            for (DynamicObject applyBill : entities) {
                long applyId = applyBill.getLong("id");
                DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    if (applyBill.getBoolean("isprepayinvoice")) {
                        if (!"submit".equals(this.collectParam.getOperateKey()) && !"assignsave".equals(this.collectParam.getOperateKey()) || !ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype"))) continue;
                        if ("submit".equals(this.collectParam.getOperateKey())) {
                            needUpdateInvStatusIds.add(invRow.getLong("invid"));
                        }
                        needAuditInvoiceMap.put(invRow.getLong("invid"), String.valueOf(invRow.getLong("invid")));
                        needAssignApplyIds.add(applyId);
                        continue;
                    }
                    Set deleteInvoiceIds = apply4InvoiceMap.getOrDefault(applyId, new HashSet(8));
                    deleteInvoiceIds.add(invRow.getLong("invid"));
                    apply4InvoiceMap.put(applyId, deleteInvoiceIds);
                }
            }
            this.executeAuditForInvoice(needAuditInvoiceMap, entities);
            SaveServiceHelper.save((DynamicObject[])entities);
            if (!needAssignApplyIds.isEmpty()) {
                AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
                assignInvoiceParam.setAutoAssign(true).setBillIds(new ArrayList<Long>(needAssignApplyIds));
                IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYASSIGNINVOICE.getValue());
                assignInvoiceService.assign(assignInvoiceParam);
            }
            if (!apply4InvoiceMap.isEmpty()) {
                InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
                deleteParam.setBill4InvoiceMap(apply4InvoiceMap);
                IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYDELETEINVROW.getValue());
                deleteService.deleteInvoiceRow(deleteParam);
            }
            InvoiceHelper.updateInvoiceStatus((Long[])needUpdateInvStatusIds.toArray(new Long[0]));
        }
    }

    private List<DynamicObject> payApplyOperateToSaveInv(DynamicObject[] payApplyBills) {
        logger.info("PayApplyCollectInvServiceImpl payApplyOperateToSaveInv begin");
        ArrayList<DynamicObject> savedInvoices = new ArrayList<DynamicObject>(64);
        if (ObjectUtils.isEmpty((Object[])payApplyBills)) {
            return savedInvoices;
        }
        Map orgForSerialMap = InvoiceHelper.getOrgForSerialMap((DynamicObject[])payApplyBills);
        logger.info("PayApplyCollectInvServiceImpl payApplyOperateToSaveInv orgForSerialMap : " + orgForSerialMap);
        List invoiceVOS = CallCloudHelper.queryCloudInvoice((Map)orgForSerialMap);
        if (ObjectUtils.isEmpty((Object)invoiceVOS)) {
            return savedInvoices;
        }
        Map invoiceVOMap = invoiceVOS.stream().collect(Collectors.toMap(InvoiceVO::getSerialNo, Function.identity()));
        Set<String> hasInDbInvoiceSerialNos = this.getHasInDbInvoiceSerialNos(payApplyBills);
        for (DynamicObject payApplyBill : payApplyBills) {
            List<InvoiceVO> tempInvoiceVOs;
            boolean isPrePayInvoice = payApplyBill.getBoolean("isprepayinvoice");
            HashMap<String, Long> serialNoToIdMap = new HashMap<String, Long>(8);
            DynamicObjectCollection invEntry = payApplyBill.getDynamicObjectCollection("inventry");
            Iterator iterator = invEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject invRow = (DynamicObject)iterator.next();
                if (!ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype"))) continue;
                String serialNo = invRow.getString("i_serialno");
                if (!isPrePayInvoice && !hasInDbInvoiceSerialNos.contains(serialNo)) {
                    iterator.remove();
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)serialNo) || hasInDbInvoiceSerialNos.contains(serialNo)) continue;
                serialNoToIdMap.put(serialNo, invRow.getLong("invid"));
            }
            if (serialNoToIdMap.isEmpty() || (tempInvoiceVOs = invoiceVOMap.entrySet().stream().filter(e -> serialNoToIdMap.containsKey(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList())).isEmpty()) continue;
            DynamicObjectCollection entry = payApplyBill.getDynamicObjectCollection("entry");
            String asstactType = ((DynamicObject)entry.get(0)).getString("e_asstacttype");
            DynamicObject asstact = ((DynamicObject)entry.get(0)).getDynamicObject("e_asstact");
            Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
            InvoiceResolveParam resolveParam = new InvoiceResolveParam();
            resolveParam.setAppId(this.collectParam.getAppId()).setOrgId(payApplyBill.getLong("settleorg.id")).setBizType("bd_supplier".equals(asstactType) ? "PUR" : "FEE").setSerialNoMap(serialNoToIdMap).setAsstactType(asstactType).setAsstactId(asstact.getLong("id")).setSrcCollect(true).setNeedSave(true).setInvoiceOrigin("ap_payapply");
            savedInvoices.addAll(resolveService.genInvoice(resolveParam, tempInvoiceVOs));
        }
        logger.info("PayApplyCollectInvServiceImpl payApplyOperateToSaveInv savedInvoices size : " + savedInvoices.size());
        return savedInvoices;
    }

    private void checkInvoice(Map<String, DynamicObject> invoiceMap) {
        List<String> originalSerialNos = this.getOriginalSerialNos(this.collectParam.getReturnData());
        ArrayList<String> needRemoveSerialNos = new ArrayList<String>(2);
        IDataModel model = this.collectParam.getFormView().getModel();
        DynamicObject currency = (DynamicObject)model.getValue("settlecurrency");
        BigDecimal applyAmount = (BigDecimal)model.getValue("applyamount");
        DynamicObjectCollection inventry = model.getEntryEntity("inventry");
        Set serialNoSet = inventry.stream().map(invEntry -> invEntry.getString("i_serialno")).collect(Collectors.toSet());
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
            BigDecimal invPriceTaxtotal;
            DynamicObject invoice = entrySet.getValue();
            String invoiceNo = invoice.getString("invoiceno");
            String invoiceCode = invoice.getString("invoicecode");
            String invoiceMessage = ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s", (String)"PayApplyCollectInvServiceImpl_0", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"PayApplyCollectInvServiceImpl_1", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo, invoiceCode);
            String serialNo = invoice.getString("serialno");
            originalSerialNos.remove(serialNo);
            if (!inventry.isEmpty() && serialNoSet.contains(serialNo)) {
                builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"PayApplyCollectInvServiceImpl_2", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
                builder.append('\n');
                needRemoveSerialNos.add(serialNo);
            }
            if (invoice.getLong("currency.id") != currency.getLong("id")) {
                builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4ed8\u6b3e\u7533\u8bf7\u7ed3\u7b97\u5e01[%2$s]\u4e0e\u53d1\u7968\u5e01\u79cd[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyCollectInvServiceImpl_3", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage, currency.getString("name"), invoice.getString("currency.name")));
                builder.append('\n');
                needRemoveSerialNos.add(serialNo);
            }
            if (BigDecimal.ZERO.compareTo(applyAmount.multiply(invPriceTaxtotal = invoice.getBigDecimal("pricetaxtotal"))) <= 0) continue;
            builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d1\u7968\u91d1\u989d\u65b9\u5411\u4e0e\u7533\u8bf7\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PayApplyCollectInvServiceImpl_7", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
            builder.append('\n');
            needRemoveSerialNos.add(serialNo);
        }
        if (!originalSerialNos.isEmpty()) {
            originalSerialNos.removeIf(invoiceMap::containsKey);
            if (!originalSerialNos.isEmpty()) {
                DynamicObject settleOrg = (DynamicObject)model.getValue("settleorg");
                HashMap<Long, String> orgForSerialMap = new HashMap<Long, String>(2);
                orgForSerialMap.put(settleOrg.getLong("id"), String.join((CharSequence)",", originalSerialNos));
                List invoiceVOS = CallCloudHelper.queryCloudInvoice(orgForSerialMap);
                for (InvoiceVO invoiceVO : invoiceVOS) {
                    String invoiceNo = invoiceVO.getInvoiceNo();
                    String invoiceCode = invoiceVO.getInvoiceCode();
                    String invoiceMessage = ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s", (String)"PayApplyCollectInvServiceImpl_0", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"PayApplyCollectInvServiceImpl_1", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo, invoiceCode);
                    builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"PayApplyCollectInvServiceImpl_2", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
                    builder.append('\n');
                }
            }
        }
        if (builder.length() > 0) {
            this.collectParam.getFormView().showErrorNotification(String.valueOf(builder));
        }
        for (String removeSerialNo : needRemoveSerialNos) {
            invoiceMap.remove(removeSerialNo);
        }
    }

    private Set<String> getHasInDbInvoiceSerialNos(DynamicObject[] payApplyBills) {
        HashSet<String> serialNos = new HashSet<String>(8);
        for (DynamicObject payApplyBill : payApplyBills) {
            DynamicObjectCollection invEntry = payApplyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                if (ObjectUtils.isEmpty((Object)invRow.getString("i_serialno"))) continue;
                serialNos.add(invRow.getString("i_serialno"));
            }
        }
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"queryInvoice", (String)"ap_invoice", (String)"id,serialno", (QFilter[])new QFilter[]{new QFilter("serialno", "in", serialNos)}, (String)"");
        HashSet<String> hasInDbSerialNos = new HashSet<String>(8);
        for (Row invoice : invoiceDataSet) {
            hasInDbSerialNos.add(invoice.getString("serialno"));
        }
        return hasInDbSerialNos;
    }
}

