/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.delinv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.delinv.AbstractInvEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;

public class ApplyInvEntryDeleteServiceImpl
extends AbstractInvEntryDeleteService {
    @Override
    protected void executeDelete(InvEntryDeleteParam deleteParam, DynamicObject[] bills) {
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(deleteParam);
        HashSet<Long> deleteOpInvIds = new HashSet<Long>(8);
        ArrayList<Map<String, Long>> paramList = new ArrayList<Map<String, Long>>(8);
        for (DynamicObject applyBill : bills) {
            long applyId = applyBill.getLong("id");
            Set<Long> deleteInvEntryIds = deleteParam.getBill4InvoiceMap().get(applyId);
            if (ObjectUtils.isEmpty(deleteInvEntryIds)) continue;
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            Iterator iterator = invEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject invRow = (DynamicObject)iterator.next();
                long invId = invRow.getLong("invid");
                DynamicObject invoice = invoiceMap.get(invId);
                if (!deleteInvEntryIds.contains(invId) || invoice == null) continue;
                boolean isDeleteInvRow = false;
                if (deleteParam.isOnlyReleaseAmt()) {
                    isDeleteInvRow = true;
                } else {
                    boolean isNoBusiness = "ap_payapply".equals(invoice.getString("businesssource")) && invoice.getBigDecimal("unrelatedamt").compareTo(invoice.getBigDecimal("pricetaxtotal")) == 0 && !invoice.getBoolean("isvoucher") && !invoice.getBoolean("ismatched");
                    String iSrcType = invRow.getString("i_srctype");
                    if (ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType)) {
                        if (invoice.getBoolean("isreffin") && isNoBusiness) {
                            if (deleteParam.isBillClose()) {
                                invoice.set("isreffin", (Object)Boolean.FALSE);
                                invoice.set("businesssource", (Object)" ");
                            } else {
                                deleteOpInvIds.add(invId);
                            }
                            isDeleteInvRow = true;
                        }
                    } else if (ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) && !invoice.getBoolean("isreffin") && isNoBusiness) {
                        invoice.set("businesssource", (Object)" ");
                        isDeleteInvRow = true;
                    }
                }
                if (!isDeleteInvRow) continue;
                iterator.remove();
                if ("C".equals(invoice.getString("billstatus"))) {
                    HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
                    paramMap.put("srcBillId", invId);
                    paramMap.put("tarBillId", applyBill.getLong("id"));
                    paramList.add(paramMap);
                }
                if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
                invoice.set("synstatus", (Object)"waitsynchro");
                invoice.set("changesynstatustime", (Object)new Date());
            }
        }
        if (!deleteOpInvIds.isEmpty()) {
            this.invoiceExecuteDeleteOp(deleteOpInvIds.toArray(new Long[0]));
        }
        if (deleteParam.isSave()) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
        SaveServiceHelper.save((DynamicObject[])invoiceMap.values().toArray(new DynamicObject[0]));
        this.deleteBOTPRelation("ap_payapply", paramList);
    }

    private Map<Long, DynamicObject> getInvoiceMap(InvEntryDeleteParam deleteParam) {
        HashSet invoiceIds = new HashSet(8);
        for (Map.Entry<Long, Set<Long>> entrySet : deleteParam.getBill4InvoiceMap().entrySet()) {
            invoiceIds.addAll(entrySet.getValue());
        }
        String selectors = "isreffin,businesssource,unrelatedamt,isvoucher,ismatched,pricetaxtotal,billstatus,synstatus,changesynstatustime,serialno";
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        return Arrays.stream(invoices).collect(Collectors.toMap(i -> i.getLong("id"), Function.identity()));
    }

    @Override
    protected String getBillSelectors() {
        return "id,invid,i_srctype,i_billno,i_serialno";
    }

    @Override
    protected String getEntityName() {
        return "ap_payapply";
    }
}

