/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.delinv;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.delinv.AbstractInvEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;

public class ReplaceInvEntryDeleteServiceImpl
extends AbstractInvEntryDeleteService {
    @Override
    protected void executeDelete(InvEntryDeleteParam deleteParam, DynamicObject[] bills) {
        Map<Long, Set<Long>> bill4DeleteInvoiceMap = deleteParam.getBill4InvoiceMap();
        HashSet<Long> deleteOpInvIds = new HashSet<Long>(8);
        for (DynamicObject bill : bills) {
            long applyId = bill.getLong("id");
            Set<Long> deleteInvEntryIds = bill4DeleteInvoiceMap.get(applyId);
            if (ObjectUtils.isEmpty(deleteInvEntryIds)) continue;
            DynamicObjectCollection newInvEntry = bill.getDynamicObjectCollection("newinventry");
            Iterator iterator = newInvEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject newInvRow = (DynamicObject)iterator.next();
                long invId = newInvRow.getLong("n_invid");
                if (!deleteInvEntryIds.contains(invId)) continue;
                iterator.remove();
                if (!ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype"))) continue;
                deleteOpInvIds.add(invId);
            }
        }
        if (!deleteOpInvIds.isEmpty()) {
            this.invoiceExecuteDeleteOp(deleteOpInvIds.toArray(new Long[0]));
        }
        if (deleteParam.isSave()) {
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    @Override
    protected String getEntityName() {
        return "ap_replaceinvapply";
    }

    @Override
    protected String getBillSelectors() {
        return "n_srctype,n_invid";
    }
}

