/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoicematch.IMatchBillLoader;
import kd.fi.ap.business.invoicematch.botp.IRelationConverter;
import kd.fi.ap.business.invoicematch.helper.EnumRelType;
import kd.fi.ap.business.invoicematch.helper.MatchBillChainHelper;
import kd.fi.ap.business.invoicematch.helper.MatchBillLoaderParam;
import kd.fi.ap.business.invoicematch.helper.MatchChainBillShowHelper;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.ap.vo.Relation;
import kd.fi.arapcommon.report.SingleValAggFunction;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractMatchBillLoader
implements IMatchBillLoader {
    MatchBillLoaderParam loaderParam;
    protected MatchBillChain.MatchChain chain;
    protected MatchBillChain matchBillChain;

    public AbstractMatchBillLoader(MatchBillLoaderParam loaderParam) {
        this.loaderParam = loaderParam;
        this.matchBillChain = MatchBillChainHelper.getChainData(loaderParam.getView().getPageCache());
        this.chain = loaderParam.getMatchChain();
    }

    @Override
    public void loadDatas() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractMatchBillLoader.getRowDatas", (String)this.chain.getBillEntity(), (String)String.join((CharSequence)",", this.getBillSelectors()), (QFilter[])this.getFilters().toArray(new QFilter[0]), (String)this.getOrderBys());
        if (dataSet.copy().isEmpty() && this.chain.equals((Object)MatchBillChain.mainChain)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f85\u5339\u914d\u6570\u636e", (String)"AbstractMatchBillLoader_0", (String)"fi-ap-business", (Object[])new Object[0]));
        }
        dataSet = this.fillMatchData(dataSet);
        Set<Relation> relations = this.writeBotpRelationId(dataSet);
        if (this.loaderParam.getSiblingLoader() != null && relations != null && !this.loaderParam.getMatchParam().isViewMode()) {
            List<Long> siblingIds = relations.stream().map(Relation::getTargetEntryId).collect(Collectors.toList());
            AbstractMatchBillLoader siblingLoader = (AbstractMatchBillLoader)this.loaderParam.getSiblingLoader();
            siblingLoader.getLoaderParam().setSiblingIds(siblingIds);
        }
        TableValueSetter valueSetter = this.getTableValueGetter(dataSet);
        String entryIdentify = this.chain.getEntryIdentify();
        this.loaderParam.getModel().beginInit();
        this.loaderParam.getModel().batchCreateNewEntryRow(entryIdentify, valueSetter);
        this.afterLoadDatas();
        this.loaderParam.getModel().endInit();
        this.loaderParam.getView().updateView(entryIdentify);
        if (this.loaderParam.getSiblingLoader() != null) {
            this.loaderParam.getSiblingLoader().loadDatas();
        }
    }

    public void afterLoadDatas() {
        if (!this.chain.getBillEntity().equals(MatchBillChain.mainChain.getBillEntity()) && !this.loaderParam.getMatchParam().isViewMode()) {
            String entryKey = this.chain.getEntryIdentify();
            int entryRowCount = this.loaderParam.getModel().getEntryRowCount(entryKey);
            String matchType = (String)this.loaderParam.getModel().getValue("matchtype");
            for (int iRow = 0; iRow < entryRowCount; ++iRow) {
                this.loaderParam.getView().setEnable(Boolean.valueOf(matchType.equals("AMT")), iRow, new String[]{this.chain.getMatchAmtKey()});
                this.loaderParam.getView().setEnable(Boolean.valueOf(matchType.equals("QTY")), iRow, new String[]{this.chain.getMatchQtyKey()});
                if (!matchType.equals("AMT")) continue;
                this.loaderParam.getModel().setValue(this.chain.getMatchQtyKey(), (Object)BigDecimal.ONE, iRow);
            }
        } else if (this.loaderParam.getMatchParam().isViewMode() && !this.chain.getBillEntity().equals(MatchBillChain.mainChain.getBillEntity())) {
            this.viewModeValueSet();
        }
    }

    private void viewModeValueSet() {
        this.loaderParam.getModel().beginInit();
        DynamicObject[] matchRecords = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)this.loaderParam.getView().getPageCache().get("matchRecordCache"));
        Map<Long, Map<String, List<DynamicObject>>> matchRecordGroup = Stream.of(matchRecords).map(match -> match.getDynamicObjectCollection("matchentry")).flatMap(Collection::stream).collect(Collectors.groupingBy(entry -> entry.getLong("invpk"), Collectors.groupingBy(entry -> entry.getString("bill_type"))));
        int[] selectRows = ((EntryGrid)this.loaderParam.getView().getControl("entry")).getSelectRows();
        Long selInvPk = Long.parseLong(this.loaderParam.getModel().getValue("invpk", ArrayUtils.isEmpty((int[])selectRows) ? 0 : selectRows[0]).toString());
        Map recordEntityMap = matchRecordGroup.getOrDefault(selInvPk, new HashMap(0));
        List records = recordEntityMap.getOrDefault(this.chain.getBillEntity(), new ArrayList(0));
        Map<Long, List<DynamicObject>> recordEntryMap = records.stream().collect(Collectors.groupingBy(record -> record.getLong("billentryid")));
        DynamicObjectCollection entryEntity = this.loaderParam.getModel().getEntryEntity(this.chain.getEntryIdentify());
        entryEntity.forEach(entry -> {
            List recordList = (List)recordEntryMap.get(entry.getLong(this.chain.getIdIdentify()));
            if (recordList != null) {
                int iRow = entry.getInt("seq") - 1;
                BigDecimal qty = recordList.stream().map(e -> e.getBigDecimal("matchqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal amt = recordList.stream().map(e -> e.getBigDecimal("matchamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.loaderParam.getModel().setValue(this.chain.getMatchQtyKey(), (Object)qty, iRow);
                this.loaderParam.getModel().setValue(this.chain.getMatchAmtKey(), (Object)amt, iRow);
            }
        });
        IMatchBillLoader siblingLoader = this.loaderParam.getSiblingLoader();
        if (siblingLoader != null) {
            MatchBillChain.MatchChain siblingChain = this.matchBillChain.getSibling(this.chain.getBillEntity(), this.loaderParam.getDirection());
            List siblingRecords = recordEntityMap.getOrDefault(siblingChain.getBillEntity(), new ArrayList(0));
            Object[] entryPks = siblingRecords.stream().map(s -> s.getLong("billentryid")).toArray();
            ((AbstractMatchBillLoader)this.loaderParam.getSiblingLoader()).getLoaderParam().setEntryPks(entryPks);
        }
        this.loaderParam.getModel().endInit();
        this.loaderParam.getView().updateView(this.chain.getEntryIdentify());
    }

    private Set<Relation> writeBotpRelationId(DataSet dataSet) {
        String billEntity = this.chain.getBillEntity();
        EnumDirection direction = this.loaderParam.getDirection();
        MatchBillChain.MatchChain siblingChain = this.matchBillChain.getSibling(billEntity, direction);
        Set<Relation> relations = null;
        if (siblingChain != null && direction != null) {
            String relType;
            List<Long> entryIds = this.getDataSetAttrValues(dataSet, this.chain.getEntryEntity().concat(".id"));
            Long[] array = entryIds.toArray(new Long[0]);
            String string = relType = direction == EnumDirection.DOWN ? siblingChain.getPrevRelType() : siblingChain.getNextRelType();
            if (EmptyUtils.isNotEmpty((Object)relType)) {
                IRelationConverter converter = EnumRelType.valueOf(relType).getRelationConverter(this.chain.getBillEntity(), this.chain.getEntryEntity(), siblingChain.getBillEntity(), direction, array);
                relations = converter.getRelations();
                this.buildRelationEntryData(relations, direction);
            }
        }
        return relations;
    }

    private void buildRelationEntryData(Set<Relation> relations, EnumDirection direction) {
        if (EmptyUtils.isNotEmpty(relations) && !this.loaderParam.getMatchParam().isViewMode()) {
            DynamicObjectCollection collection = this.loaderParam.getModel().getEntryEntity("relentry");
            Set exists = collection.stream().map(e -> {
                Relation relation = new Relation(e.getString("relsrcentity"), Long.valueOf(e.getLong("relsrcentryid")), e.getString("reltgtentity"), Long.valueOf(e.getLong("reltgtentryid")), direction.name());
                relation.setInvPk(Long.valueOf(e.getLong("relinvpk")));
                return relation;
            }).collect(Collectors.toSet());
            relations.removeAll(exists);
            if (EmptyUtils.isNotEmpty(relations)) {
                EntryGrid grid = (EntryGrid)this.loaderParam.getView().getControl("entry");
                int checkRowIndex = grid.getSelectRows().length > 0 ? grid.getSelectRows()[0] : 0;
                Long invPk = Long.parseLong(this.loaderParam.getModel().getValue("invpk", checkRowIndex).toString());
                DynamicObjectCollection insertList = new DynamicObjectCollection(collection.getDynamicObjectType(), collection.getParent());
                for (Relation relation : relations) {
                    DynamicObject createInstance = (DynamicObject)insertList.getDynamicObjectType().createInstance();
                    createInstance.set("relsrcentity", (Object)relation.getEntityKey());
                    createInstance.set("relsrcentryid", (Object)relation.getEntryId());
                    createInstance.set("reltgtentity", (Object)relation.getTargetKey());
                    createInstance.set("reltgtentryid", (Object)relation.getTargetEntryId());
                    createInstance.set("reldirection", (Object)relation.getDirection());
                    createInstance.set("relinvpk", (Object)invPk);
                    insertList.add((Object)createInstance);
                }
                EntryProp entryProp = (EntryProp)this.loaderParam.getModel().getProperty("relentry");
                this.loaderParam.getModel().batchInsertEntryRow(entryProp, collection.size(), insertList);
            }
        }
    }

    private TableValueSetter getTableValueGetter(DataSet dataSet) {
        ArrayList<Object[]> rowDatas = new ArrayList<Object[]>(64);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        for (Row row : dataSet) {
            Object[] args = new Object[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                args[i] = row.get(fieldNames[i]);
            }
            rowDatas.add(args);
        }
        TableValueSetter valueSetter = this.getEntryValueSetter();
        for (Object[] args : rowDatas) {
            valueSetter.addRow(args);
        }
        return valueSetter;
    }

    private DataSet fillMatchData(DataSet dataSet) {
        String[] singleAggFieldNames;
        if (MatchBillChain.mainChain.getBillEntity().equals(this.chain.getBillEntity())) {
            return dataSet;
        }
        String billEntryPkIdentify = this.chain.getEntryEntity().concat(".").concat("id");
        List billEntryIds = this.getDataSetAttrValues(dataSet, billEntryPkIdentify);
        QFilter filter = new QFilter("matchentry.billentryid", "in", billEntryIds);
        String[] selectFields = dataSet.getRowMeta().getFieldNames();
        DataSet matchDataSet = QueryServiceHelper.queryDataSet((String)"AbstractMatchBill.fillMatchData", (String)"invoice_match_record", (String)"matchtype,matchentry.bill_type,matchentry.matchqty,matchentry.matchamt,matchentry.billentryid", (QFilter[])filter.toArray(), null);
        DataSet finish = dataSet.leftJoin(matchDataSet).on(billEntryPkIdentify, "matchentry.billentryid").select(selectFields, new String[]{"matchentry.matchqty", "matchentry.matchamt"}).finish();
        GroupbyDataSet sum = finish.groupBy(new String[]{billEntryPkIdentify}).sum("matchentry.matchqty", "matchedqty").sum("matchentry.matchamt", "matchedamt");
        Object[] fieldNames = finish.getRowMeta().getFieldNames();
        for (String singleAggFieldName : singleAggFieldNames = (String[])ArrayUtils.removeElements((Object[])fieldNames, (Object[])new String[]{"matchentry.matchqty", "matchentry.matchamt", "matchedqty", "matchedamt"})) {
            sum.agg((CustomAggFunction)new SingleValAggFunction(), singleAggFieldName, singleAggFieldName);
        }
        finish = sum.finish();
        finish = finish.removeFields(new String[]{"unmatchqty", "unmatchamt", "matchqty", "matchamt"});
        String unmatchQtyExpr = this.getQtyField() + " - (case when matchedqty is null then 0 else matchedqty end)";
        String unmatchAmtExpr = this.getAmtField() + " - (case when matchedamt is null then 0 else matchedamt end)";
        finish = finish.addField(unmatchQtyExpr, "unmatchqty").addField(unmatchAmtExpr, "unmatchamt").addNullField(new String[]{"matchqty", "matchamt"}).select(selectFields);
        return finish;
    }

    public String getAmtField() {
        return this.chain.getEntryEntity().concat(".").concat(this.chain.getAmtKey());
    }

    public String getQtyField() {
        return this.chain.getEntryEntity().concat(".").concat(this.chain.getQtyKey());
    }

    protected TableValueSetter getEntryValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String entryIdentify = this.chain.getEntryIdentify();
        EntryGrid grid = (EntryGrid)this.loaderParam.getView().getControl(entryIdentify);
        List mainGridFields = grid.getFieldEdits().stream().map(Control::getKey).collect(Collectors.toList());
        for (String fieldkey : mainGridFields) {
            vs.addField(fieldkey, new Object[0]);
        }
        return vs;
    }

    public List<QFilter> getFilters() {
        List<Long> siblingPks;
        String entryFilterKey = this.chain.getEntryEntity().concat(".").concat("id");
        DynamicObjectCollection existBillEntries = this.loaderParam.getModel().getEntryEntity(this.chain.getEntryIdentify());
        List existBillEntryIds = existBillEntries.stream().map(entry -> entry.getLong(this.chain.getIdIdentify())).collect(Collectors.toList());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(64);
        filters.add(new QFilter(entryFilterKey, "not in", existBillEntryIds));
        if (Objects.nonNull(this.loaderParam.getEntryPks())) {
            filters.add(new QFilter(entryFilterKey, "in", (Object)this.loaderParam.getEntryPks()));
        }
        if (this.loaderParam.getDirection() != null && (siblingPks = this.loaderParam.getSiblingIds()) != null) {
            filters.add(new QFilter(entryFilterKey, "in", siblingPks));
        }
        this.addFilters(filters);
        return filters;
    }

    private void addFilters(List<QFilter> filters) {
        Object orgPk = ((DynamicObject)this.loaderParam.getModel().getValue("org")).getPkValue();
        filters.add(new QFilter("org", "=", orgPk));
        filters.add(new QFilter("billstatus", "=", (Object)EnumBillStatus.C.name()));
        Object currency = ((DynamicObject)this.loaderParam.getModel().getValue("currency")).getPkValue();
        filters.add(new QFilter("currency", "=", currency));
        this.addCustomFilter(filters);
    }

    public void addCustomFilter(List<QFilter> filters) {
    }

    public abstract List<String> getBillSelectors();

    protected abstract String getOrderBys();

    @Override
    public void showBillSelectView(IFormPlugin formPlugin) {
        String billEntity = this.chain.getBillEntity();
        DynamicObjectCollection entryEntity = this.loaderParam.getModel().getEntryEntity(this.chain.getEntryIdentify());
        List<Object> displayedEntryPks = new ArrayList(64);
        String entryFilterKey = this.chain.getEntryEntity().concat(".").concat("id");
        if (EmptyUtils.isNotEmpty((Object)entryEntity)) {
            displayedEntryPks = entryEntity.stream().map(dyb -> dyb.getLong(this.chain.getIdIdentify())).collect(Collectors.toList());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(64);
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(new QFilter(entryFilterKey, "not in", displayedEntryPks));
        this.addFilters(filters);
        MatchChainBillShowHelper.showChainBill(billEntity, this.loaderParam.getView(), formPlugin.getPluginName(), this.chain.getF7Identify(), filters);
    }

    private <T> List<T> getDataSetAttrValues(DataSet dataSet, String attribute) {
        HashSet<Long> vals = new HashSet<Long>(64);
        if (StringUtils.isNotEmpty((CharSequence)attribute)) {
            for (Row row : dataSet.copy()) {
                vals.add(row.getLong(attribute));
            }
        }
        return vals.stream().map(val -> val).collect(Collectors.toList());
    }

    public MatchBillLoaderParam getLoaderParam() {
        return this.loaderParam;
    }
}

