/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.business.invoicematch.AbstractMatchBillLoader;
import kd.fi.ap.business.invoicematch.helper.MatchBillLoaderParam;
import kd.fi.ap.enums.InvMatchType;

public class ApInvoiceMatchBillLoader
extends AbstractMatchBillLoader {
    public ApInvoiceMatchBillLoader(MatchBillLoaderParam loaderParam) {
        super(loaderParam);
    }

    @Override
    public List<QFilter> getFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(64);
        Long invoicePk = this.loaderParam.getMatchParam().getInvoicePk();
        filters.add(new QFilter("id", "=", (Object)invoicePk));
        if (!this.loaderParam.getMatchParam().isViewMode()) {
            String invMatch = (String)this.loaderParam.getModel().getValue("invmatch");
            String matchType = (String)this.loaderParam.getModel().getValue("matchtype");
            if (invMatch.equals(InvMatchType.BILL.name())) {
                filters.add(new QFilter("unmatchamt", ">", (Object)0));
            } else {
                filters.add(new QFilter(matchType.equals("AMT") ? "entry.e_unmatchamt" : "entry.e_unmatchqty", ">", (Object)0));
            }
        }
        return filters;
    }

    @Override
    public List<String> getBillSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(64);
        String matchType = (String)this.loaderParam.getModel().getValue("invmatch");
        if (InvMatchType.BILL.name().equals(matchType)) {
            Collections.addAll(selectors, "asstacttype", "receivablessupp", "org", "invoicecode", "invoiceno", "invoicetype", "issuedate", "receivedate", "buyer", "asstact", "null as field1", "null as field2", "null as field3", "null as field4", "null as field5", "amount", "tax", "pricetaxtotal", "currency", "unmatchamt", "null as field6", "exchangerate", "matchrule", "id");
        } else {
            Collections.addAll(selectors, "asstacttype", "receivablessupp", "org", "invoicecode", "invoiceno", "invoicetype", "issuedate", "receivedate", "buyer", "asstact", "entry.e_invname", "entry.quantity", "entry.measureunit", "entry.price", "entry.taxrateid", "entry.e_amount", "entry.e_tax", "entry.e_pricetaxtotal", "currency", "entry.e_unmatchamt", "entry.e_unmatchqty", "exchangerate", "entry.e_matchrule", "entry.id");
        }
        return selectors;
    }

    @Override
    public void afterLoadDatas() {
        super.afterLoadDatas();
        String matchType = (String)this.loaderParam.getModel().getValue("invmatch");
        if (InvMatchType.BILL.name().equals(matchType)) {
            this.loaderParam.getView().setVisible(Boolean.FALSE, new String[]{"e_invname", "quantity", "price", "measureunit", "taxrateid", "unmatchqty"});
        }
    }

    @Override
    protected String getOrderBys() {
        return null;
    }
}

