/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.ap.business.invoicematch.botp.AbstractRelationConverter;
import kd.fi.ap.enums.EnumDirection;
import org.apache.commons.lang3.StringUtils;

public class BotpRelationConverter
extends AbstractRelationConverter {
    private final Map<Long, HashSet<Long>> map = new HashMap<Long, HashSet<Long>>(64);

    public BotpRelationConverter(String entityKey, String entryKey, String targetEntityKey, EnumDirection direction, Long[] entryIds) {
        super(entityKey, entryKey, targetEntityKey, direction, entryIds);
    }

    @Override
    public Map<Long, HashSet<Long>> getRelationMap() {
        List<BFRowLink> linkNodes = this.getBFTrackerResult();
        ConvertDataService reader = new ConvertDataService();
        for (BFRowLink linkNode : linkNodes) {
            BFRowId row = linkNode.getRowId();
            Long entryId = row.getEntryId();
            List<BFRowLink> relationNodes = linkNode.getAllRelationNodes();
            for (BFRowLink relationNode : relationNodes) {
                BFRowId srcRow = relationNode.getRowId();
                Long srcEntryId = srcRow.getEntryId();
                String entityName = reader.loadTableDefine(srcRow.getMainTableId()).getEntityKey();
                if (!StringUtils.equals((CharSequence)entityName, (CharSequence)this.targetEntityKey)) continue;
                HashSet<Long> hashSet = this.map.getOrDefault(entryId, new HashSet(64));
                hashSet.add(srcEntryId);
                this.map.put(entryId, hashSet);
            }
        }
        return this.map;
    }

    private List<BFRowLink> getBFTrackerResult() {
        ArrayList<BFRowLink> bfRowLinks = new ArrayList(64);
        if (EnumDirection.UP == this.direction) {
            List nodes = BFTrackerServiceHelper.loadLinkUpNodes((String)this.entityKey, (String)this.entryKey, (Long[])this.entryIds);
            bfRowLinks = nodes.stream().map(BFRowLink::new).collect(Collectors.toList());
        } else {
            List nodes = BFTrackerServiceHelper.loadLinkDownNodes((String)this.entityKey, (String)this.entryKey, (Long[])this.entryIds);
            bfRowLinks = nodes.stream().map(BFRowLink::new).collect(Collectors.toList());
        }
        return bfRowLinks;
    }

    static class BFRowLink {
        private BFRowLinkUpNode upNode;
        private BFRowLinkDownNode downNode;

        public BFRowLink(BFRowLinkUpNode upNode) {
            this.upNode = upNode;
        }

        public BFRowLink(BFRowLinkDownNode downNode) {
            this.downNode = downNode;
        }

        public BFRowId getRowId() {
            if (this.upNode != null) {
                return this.upNode.getRowId();
            }
            if (this.downNode != null) {
                return this.downNode.getRowId();
            }
            throw new KDException(new ErrorCode("DataSetBotpConverter", "upNode and downNode can't be both null..."), new Object[0]);
        }

        public List<BFRowLink> getAllRelationNodes() {
            if (this.upNode != null) {
                return this.upNode.findAllSourceNodes().stream().map(BFRowLink::new).collect(Collectors.toList());
            }
            if (this.downNode != null) {
                return this.downNode.findAllChildNodes().stream().map(BFRowLink::new).collect(Collectors.toList());
            }
            throw new KDException(new ErrorCode("DataSetBotpConverter", "upNode and downNode can't be both null..."), new Object[0]);
        }
    }
}

