/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.vo.MatchResult;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.ap.vo.MatchSchemeEntryVO;
import kd.fi.ap.vo.MatchSchemeVO;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.BillFieldMappingVO;

public abstract class AbstractInvMatchService {
    private static final Log logger = LogFactory.getLog(AbstractInvMatchService.class);
    Map<Long, DynamicObject> unitMap = new HashMap<Long, DynamicObject>(2);
    Map<String, BigDecimal> coefficientMap = new HashMap<String, BigDecimal>(2);
    Map<Long, BigDecimal> matchBaseQtyMap = new HashMap<Long, BigDecimal>(2);
    private MatchSchemeVO matchSchemeVO;

    public List<MatchResult> mainDataInit(List<Object> invoiceIds, MatchSchemeVO matchSchemeVO) {
        Set fieldMapping = AdjustExchHelper.getBillFieldMapping((String)"ap_invoice", (String)"ap_matchinvoice");
        QFilter filter = new QFilter("id", "in", invoiceIds);
        filter.and(new QFilter("unrelatedamt", "!=", (Object)0));
        Set<String> invSelector = this.getInvSelectorStr(fieldMapping);
        if (matchSchemeVO != null) {
            this.matchSchemeVO = matchSchemeVO;
            this.addSchemeSelector(invSelector);
        }
        DynamicObjectCollection invoiceColl = QueryServiceHelper.query((String)"ap_invoice", (String)String.join((CharSequence)",", invSelector), (QFilter[])filter.toArray());
        ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>(invoiceColl.size());
        for (DynamicObject invoice : invoiceColl) {
            MatchResult result = this.invDyn2VO(invoice, fieldMapping);
            if (ObjectUtils.isEmpty((Object)result)) continue;
            matchResults.add(result);
        }
        return matchResults;
    }

    private void addSchemeSelector(Set<String> invSelector) {
        for (MatchSchemeEntryVO matchSchemeEntry : this.matchSchemeVO.getMatchSchemeEntrys()) {
            invSelector.add(matchSchemeEntry.getMatchfield());
        }
    }

    private Set<String> getInvSelectorStr(Set<BillFieldMappingVO> fieldMapping) {
        HashSet<String> selectors = new HashSet<String>(32);
        selectors.add("id");
        selectors.add("entry.id");
        selectors.add("entry.material");
        selectors.add("entry.e_materialversion");
        selectors.add("entry.spectype");
        selectors.add("entry.e_invname");
        selectors.add("entry.e_invunit");
        selectors.add("entry.measureunit");
        selectors.add("entry.quantity");
        selectors.add("entry.price");
        selectors.add("entry.taxrate");
        selectors.add("entry.e_taxclass");
        selectors.add("entry.discountmode");
        selectors.add("entry.discountrate");
        selectors.add("entry.discountamt");
        selectors.add("entry.e_amount");
        selectors.add("entry.e_tax");
        selectors.add("entry.e_pricetaxtotal");
        selectors.add("billno");
        selectors.add("buyername");
        selectors.add("asstactname");
        selectors.add("asstacttype");
        selectors.add("receivablessupp.masterid as receivablessupp");
        selectors.add("org");
        selectors.add("currency");
        selectors.add("biztype");
        selectors.add("invoicetype");
        selectors.add("invoicetypef7");
        selectors.add("invoiceno");
        selectors.add("invoicecode");
        selectors.add("entry.e_unrelatedamt");
        selectors.add("entry.e_unmatchamt");
        this.handleExtField(fieldMapping, selectors, false);
        return selectors;
    }

    private MatchResult invDyn2VO(DynamicObject invoice, Set<BillFieldMappingVO> fieldMapping) {
        Long materialId;
        DynamicObject material;
        MatchResult result = MatchResult.New();
        result.setInvPk(Long.valueOf(invoice.getLong("id")));
        result.setInvEntryPk(Long.valueOf(invoice.getLong("entry.id")));
        result.setBillno(invoice.getString("billno"));
        result.setAsstactname(invoice.getString("asstactname"));
        result.setBuyername(invoice.getString("buyername"));
        result.setAsstacttype(invoice.getString("asstacttype"));
        result.setAsstactId(Long.valueOf(invoice.getLong("receivablessupp")));
        result.setOrgId(Long.valueOf(invoice.getLong("org")));
        result.setCurrencyId(Long.valueOf(invoice.getLong("currency")));
        result.setBiztype(invoice.getString("biztype"));
        result.setBilltype(this.getMatchBillEntity());
        result.setInvoicetype(invoice.getString("invoicetype"));
        result.setInvoicetypeId(Long.valueOf(invoice.getLong("invoicetypef7")));
        result.setInvoiceno(invoice.getString("invoiceno"));
        result.setInvoicecode(invoice.getString("invoicecode"));
        result.setMaterialId(Long.valueOf(invoice.getLong("entry.material")));
        result.setMaterialversion(invoice.getString("entry.e_materialversion"));
        result.setSpectype(invoice.getString("entry.spectype"));
        result.setInvname(invoice.getString("entry.e_invname"));
        result.setInvunit(invoice.getString("entry.e_invunit"));
        result.setMeasureunit(Long.valueOf(invoice.getLong("entry.measureunit")));
        result.setQuantity(invoice.getBigDecimal("entry.quantity"));
        result.setPrice(invoice.getBigDecimal("entry.price"));
        result.setTaxrate(invoice.getBigDecimal("entry.taxrate"));
        result.setTaxclass(Long.valueOf(invoice.getLong("entry.e_taxclass")));
        result.setDiscountmode(invoice.getString("entry.discountmode"));
        result.setDiscountrate(invoice.getBigDecimal("entry.discountrate"));
        result.setDiscountamt(invoice.getBigDecimal("entry.discountamt"));
        result.setAmount(invoice.getBigDecimal("entry.e_amount"));
        result.setTax(invoice.getBigDecimal("entry.e_tax"));
        result.setPricetaxtotal(invoice.getBigDecimal("entry.e_pricetaxtotal"));
        if (this.matchSchemeVO != null) {
            Map schemeMap = result.getSchemeMap();
            List matchSchemeEntrys = this.matchSchemeVO.getMatchSchemeEntrys();
            for (MatchSchemeEntryVO matchSchemeEntry : matchSchemeEntrys) {
                schemeMap.put(matchSchemeEntry.getMatchfield(), invoice.get(matchSchemeEntry.getMatchfield()));
            }
        }
        if (!fieldMapping.isEmpty()) {
            for (BillFieldMappingVO mappingVO : fieldMapping) {
                String srcField = mappingVO.getSrcField();
                String srcFieldSite = mappingVO.getSrcFieldSite();
                if (!"ap_invoice".equals(srcFieldSite)) {
                    srcField = srcFieldSite + '.' + srcField;
                }
                result.getExtMap().put(mappingVO.getTargetField(), invoice.get(srcField));
            }
        }
        if (ObjectUtils.isEmpty((Object)(material = BusinessDataServiceHelper.loadSingleFromCache((Object)(materialId = result.getMaterialId()), (String)"bd_material", (String)"baseunit")))) {
            return null;
        }
        DynamicObject baseunit = material.getDynamicObject("baseunit");
        result.setBaseunit(Long.valueOf(baseunit.getLong("id")));
        this.unitMap.put(result.getBaseunit(), baseunit);
        String key = this.getCoefficientKey(materialId, result.getMeasureunit(), result.getBaseunit());
        BigDecimal coefficient = this.coefficientMap.get(key);
        if (coefficient == null) {
            coefficient = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)result.getMeasureunit(), (Long)result.getBaseunit());
            this.coefficientMap.put(key, coefficient);
        }
        BigDecimal baseunitqty = UnitConvertHelper.getBaseunitqty((BigDecimal)result.getQuantity(), (BigDecimal)coefficient, (DynamicObject)baseunit);
        result.setBaseqty(baseunitqty);
        return result;
    }

    public List<MatchResult> loadMatchBill(List<MatchResult> matchResults, MatchSchemeVO matchSchemeVO) {
        Set fieldMapping = AdjustExchHelper.getBillFieldMapping((String)this.getMatchBillEntity(), (String)"ap_matchinvoice");
        for (MatchResult matchResult : matchResults) {
            matchResult.setMatchschemeId(matchSchemeVO.getSchemePK());
            List items = matchResult.getItems();
            QFilter schemeFilter = this.getMatchSchemeFilter(matchResult, matchSchemeVO);
            String orderBys = "biztime " + matchSchemeVO.getTimeorder();
            StringBuilder builder = new StringBuilder("MatchFilter:");
            builder.append(schemeFilter);
            logger.info(builder.toString());
            DynamicObjectCollection billColl = QueryServiceHelper.query((String)this.getMatchBillEntity(), (String)this.getMatchSelectorStr(fieldMapping), (QFilter[])new QFilter[]{schemeFilter}, (String)orderBys);
            this.handleMatchItems(billColl, items, fieldMapping);
        }
        return this.match(matchResults);
    }

    public List<MatchResult> match(List<MatchResult> matchResults) {
        HashMap orderIdMap = new HashMap(2);
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)matchResults.get(0).getCurrencyId(), (String)"bd_currency", (String)"amtprecision");
        int precision = currency.getInt("amtprecision");
        for (MatchResult matchResult : matchResults) {
            BigDecimal invPrice = matchResult.getPrice();
            Long unitId = matchResult.getMeasureunit();
            DynamicObject unit = this.unitMap.get(unitId);
            if (unit == null) {
                unit = BusinessDataServiceHelper.loadSingleFromCache((Object)unitId, (String)"bd_measureunits", (String)"precisionaccount,precision");
                this.unitMap.put(unitId, unit);
            }
            BigDecimal baseqty = matchResult.getBaseqty();
            List items = matchResult.getItems();
            BigDecimal matchAmt = BigDecimal.ZERO;
            BigDecimal matchTax = BigDecimal.ZERO;
            BigDecimal matchBaseQty = BigDecimal.ZERO;
            Iterator iterator = items.iterator();
            ArrayList<MatchResultItem> matchItems = new ArrayList<MatchResultItem>(1);
            while (iterator.hasNext()) {
                MatchResultItem item = (MatchResultItem)iterator.next();
                Long entryId = (Long)item.getEntryId();
                if (baseqty.signum() == 0) break;
                if (baseqty.signum() != item.getBaseqty().signum()) {
                    logger.info("Match SignumDiff:" + item.getBillno() + item.getBaseqty());
                    continue;
                }
                BigDecimal remainjoinpricebaseqty = item.getUninvoicedbaseqty();
                BigDecimal matchedMapBaseQty = this.initMatchBaseQtyMap(matchResult).get(entryId);
                boolean isRecalculate = false;
                if (matchedMapBaseQty != null) {
                    if (remainjoinpricebaseqty.abs().compareTo(matchedMapBaseQty.abs()) > 0) {
                        remainjoinpricebaseqty = remainjoinpricebaseqty.subtract(matchedMapBaseQty);
                        isRecalculate = true;
                        logger.info("Match ResultRecordUsed:" + item.getBillno() + remainjoinpricebaseqty);
                    } else {
                        logger.info("Match ResultRecordUsed:" + item.getBillno());
                        continue;
                    }
                }
                logger.info("Match KeyInfo:" + item.getBillno() + "\u6536\u7968\u5355\u5269\u4f59\u57fa\u672c\u6570\u91cf\uff1a" + matchResult.getBillno() + baseqty + "\u672a\u5f00\u7968\u57fa\u672c\u6570\u91cf\uff1a" + remainjoinpricebaseqty);
                boolean isAllMatch = baseqty.abs().compareTo(remainjoinpricebaseqty.abs()) > 0;
                BigDecimal curMatchBaseQty = isAllMatch ? remainjoinpricebaseqty : baseqty;
                baseqty = baseqty.subtract(curMatchBaseQty);
                matchBaseQty = matchBaseQty.add(curMatchBaseQty);
                item.setCurbaseqty(curMatchBaseQty);
                String key = this.getCoefficientKey(item.getMaterialId(), item.getUnitId(), item.getBaseunitId());
                BigDecimal coefficient = this.coefficientMap.get(key);
                if (coefficient == null) {
                    coefficient = UnitConvertHelper.getUnitRateConv((Long)item.getMaterialId(), (Long)item.getUnitId(), (Long)item.getBaseunitId());
                    this.coefficientMap.put(key, coefficient);
                }
                BigDecimal curqty = isAllMatch && !isRecalculate ? item.getUninvoicedqty() : UnitConvertHelper.getUnitQty((BigDecimal)curMatchBaseQty, (BigDecimal)coefficient, (DynamicObject)unit);
                item.setCurqty(curqty);
                BigDecimal curMatchAmt = curqty.multiply(item.getPrice()).setScale(precision, 4);
                matchAmt = matchAmt.add(curMatchAmt);
                BigDecimal curMatchTax = curMatchAmt.multiply(item.getTaxrate()).divide(new BigDecimal(100), precision, 4);
                matchTax = matchTax.add(curMatchTax);
                item.setCuramt(curMatchAmt);
                item.setCurtax(curMatchTax);
                item.setCuramtandtax(curMatchAmt.add(curMatchTax));
                item.setPricediff(item.getPrice().subtract(invPrice));
                if (matchedMapBaseQty != null) {
                    curMatchBaseQty = matchedMapBaseQty.add(curMatchBaseQty);
                }
                this.matchBaseQtyMap.put(entryId, curMatchBaseQty);
                matchItems.add(item);
            }
            matchResult.setItems(matchItems);
            matchResult.setAmountdiff(matchResult.getAmount().subtract(matchAmt));
            matchResult.setTaxdiff(matchResult.getTax().subtract(matchTax));
            matchResult.setPricetaxtotaldiff(matchResult.getAmountdiff().add(matchResult.getTaxdiff()));
            if (baseqty.signum() != 0) {
                matchResult.setLogmsg(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5339\u914d\u7684\u6570\u636e\u3002", (String)"AbstractInvMatchService_0", (String)"fi-ap-business", (Object[])new Object[0]));
            }
            if (matchBaseQty.signum() == 0) {
                matchResult.setLogmsg(ResManager.loadKDString((String)"\u53d1\u7968\u672a\u5339\u914d\u5b8c\u6210\u3002", (String)"AbstractInvMatchService_1", (String)"fi-ap-business", (Object[])new Object[0]));
            }
            Set matchBillIdSet = items.stream().map(MatchResultItem::getBillId).collect(Collectors.toSet());
            for (Object matchBillId : matchBillIdSet) {
                Set souBillIds;
                if (orderIdMap.get(matchBillId) != null || (souBillIds = BOTPHelper.findSouBillIds((String)this.getMatchBillEntity(), (Long)((Long)matchBillId), (String)"pm_purorderbill")).isEmpty()) continue;
                Long orderId = (Long)souBillIds.iterator().next();
                orderIdMap.put(matchBillId, orderId);
            }
        }
        DynamicObjectCollection orderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIdMap.values())});
        Map<Long, String> orderBillMap = orderBills.stream().collect(Collectors.toMap(orderBill -> orderBill.getLong("id"), orderBill -> orderBill.getString("billno")));
        for (MatchResult matchResult : matchResults) {
            List items = matchResult.getItems();
            for (MatchResultItem item : items) {
                Object billId = item.getBillId();
                Long orderId = (Long)orderIdMap.get(billId);
                if (!EmptyUtils.isNotEmpty((Object)orderId)) continue;
                item.setOrderId(orderId);
                item.setOrderbillno(orderBillMap.get(orderId));
            }
        }
        return matchResults;
    }

    public Map<Long, BigDecimal> initMatchBaseQtyMap(MatchResult matchResult) {
        if (!this.matchBaseQtyMap.isEmpty()) {
            return this.matchBaseQtyMap;
        }
        logger.info("initMatchBaseQtyMap:" + matchResult.getMatchResultPk());
        DynamicObjectCollection matchColl = QueryServiceHelper.query((String)"ap_matchinvoice", (String)"id,entry.subentry.stockentryid stockentryid,entry.subentry.curbaseqty curbaseqty", (QFilter[])new QFilter[]{new QFilter("ismatched", "=", (Object)Boolean.FALSE), new QFilter("id", "!=", (Object)matchResult.getMatchResultPk())});
        for (DynamicObject matchRecord : matchColl) {
            long stockentryid = matchRecord.getLong("stockentryid");
            BigDecimal curbaseqty = matchRecord.getBigDecimal("curbaseqty");
            BigDecimal v = this.matchBaseQtyMap.get(stockentryid);
            if (v != null) {
                curbaseqty = curbaseqty.add(v);
            }
            this.matchBaseQtyMap.put(stockentryid, curbaseqty);
        }
        return this.matchBaseQtyMap;
    }

    protected String getCoefficientKey(Long materialId, Long unitId, Long baseunitId) {
        return materialId + "_" + unitId + "_" + baseunitId;
    }

    private String getMatchSelectorStr(Set<BillFieldMappingVO> fieldMapping) {
        HashSet<String> selectors = new HashSet<String>(32);
        selectors.add("id");
        selectors.add("org");
        selectors.add("billno");
        this.getMatchSelector(selectors);
        this.handleExtField(fieldMapping, selectors, true);
        return String.join((CharSequence)",", selectors);
    }

    protected abstract void getMatchSelector(Set<String> var1);

    protected void handleExtField(Set<BillFieldMappingVO> fieldMapping, Set<String> selectors, boolean isSub) {
        if (fieldMapping.isEmpty()) {
            return;
        }
        Iterator<BillFieldMappingVO> iterator = fieldMapping.iterator();
        while (iterator.hasNext()) {
            String ENTITY_INVOICEMATCH;
            BillFieldMappingVO mappingVO = iterator.next();
            String srcField = mappingVO.getSrcField();
            String srcFieldSite = mappingVO.getSrcFieldSite();
            if (selectors.contains(srcField)) {
                iterator.remove();
                continue;
            }
            String string = ENTITY_INVOICEMATCH = isSub ? this.getMatchBillEntity() : "ap_invoice";
            if (!ENTITY_INVOICEMATCH.equals(srcFieldSite)) {
                srcField = srcFieldSite + '.' + srcField;
            }
            selectors.add(srcField);
        }
    }

    private void handleMatchItems(DynamicObjectCollection billColl, List<MatchResultItem> items, Set<BillFieldMappingVO> fieldMapping) {
        for (DynamicObject bill : billColl) {
            MatchResultItem item = this.matchBill2Vo(bill, fieldMapping);
            items.add(item);
        }
    }

    protected MatchResultItem matchBill2Vo(DynamicObject bill, Set<BillFieldMappingVO> fieldMapping) {
        MatchResultItem item = new MatchResultItem();
        item.setBillEntity(this.getMatchBillEntity());
        item.setBillId((Object)bill.getLong("id"));
        item.setBillno(bill.getString("billno"));
        if (!fieldMapping.isEmpty()) {
            for (BillFieldMappingVO mappingVO : fieldMapping) {
                String srcField = mappingVO.getSrcField();
                String srcFieldSite = mappingVO.getSrcFieldSite();
                if (!this.getMatchBillEntity().equals(srcFieldSite)) {
                    srcField = srcFieldSite + '.' + srcField;
                }
                item.getExtSubMap().put(mappingVO.getTargetField(), bill.get(srcField));
            }
        }
        return item;
    }

    protected QFilter getMatchSchemeFilter(MatchResult item, MatchSchemeVO matchSchemeVO) {
        QFilter filter = this.getDefaultFilter(item);
        BigDecimal price = item.getPrice();
        BigDecimal pricetolerance = matchSchemeVO.getPricetolerance();
        if (pricetolerance.signum() == 0) {
            filter.and(new QFilter("billentry.price", "=", (Object)price));
        } else if (pricetolerance.signum() > 0) {
            filter.and(new QFilter("billentry.price", "<=", (Object)price.add(pricetolerance)));
            filter.and(new QFilter("billentry.price", ">=", (Object)price.subtract(pricetolerance)));
        }
        List matchSchemeEntrys = matchSchemeVO.getMatchSchemeEntrys();
        Map schemeMap = item.getSchemeMap();
        for (MatchSchemeEntryVO matchSchemeEntryVO : matchSchemeEntrys) {
            filter.and(new QFilter(matchSchemeEntryVO.getMappingfield(), "=", schemeMap.get(matchSchemeEntryVO.getMatchfield())));
        }
        return filter;
    }

    protected QFilter getDefaultFilter(MatchResult matchResult) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        return filter.and(this.getMatchBillFilter(matchResult));
    }

    protected abstract QFilter getMatchBillFilter(MatchResult var1);

    public MatchResult loadMatchBill(MatchResult result, Set<Object> selectIds, Set<Object> selectEntryIds) {
        Set fieldMapping = AdjustExchHelper.getBillFieldMapping((String)this.getMatchBillEntity(), (String)"ap_matchinvoice");
        QFilter filter = new QFilter("id", "in", selectIds);
        filter.and(new QFilter("billentry.id", "in", selectEntryIds));
        List items = result.getItems();
        DynamicObjectCollection billColl = QueryServiceHelper.query((String)this.getMatchBillEntity(), (String)this.getMatchSelectorStr(fieldMapping), (QFilter[])filter.toArray(), (String)"biztime desc");
        this.handleMatchItems(billColl, items, fieldMapping);
        items.removeIf(item -> !result.getMaterialId().equals(item.getMaterialId()));
        ArrayList<MatchResult> list = new ArrayList<MatchResult>(1);
        list.add(result);
        List<MatchResult> matchResults = this.match(list);
        return matchResults.get(0);
    }

    protected abstract String getMatchBillEntity();
}

