/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.match;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.ap.business.invoicematch.helper.EnumMatchAction;
import kd.fi.ap.business.invoicematch.match.AbstractMatchAction;
import kd.fi.ap.vo.MatchActionParam;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class InvSelectChangeAction
extends AbstractMatchAction {
    public InvSelectChangeAction(MatchActionParam matchParam) {
        super(matchParam);
    }

    @Override
    public void matchEntry() {
        Integer newRow;
        this.freshMatchTabView();
        this.setTargetValue();
        if (this.matchParam.isViewMode()) {
            EnumMatchAction.VIEW_MODE.action(this.matchParam);
            return;
        }
        SelectRowsEvent evt = (SelectRowsEvent)this.matchParam.getEventParam();
        Integer oldRow = EmptyUtils.isNotEmpty((Object)evt.getOldRows()) ? (Integer)evt.getOldRows().get(0) : null;
        Integer n = newRow = EmptyUtils.isNotEmpty((Object)evt.getNewRows()) ? (Integer)evt.getNewRows().get(0) : null;
        if (oldRow != null) {
            Object oldInvPk = this.matchParam.getModel().getValue("invpk", oldRow.intValue());
            for (MatchBillChain.MatchChain chain : this.matchBillChain.getChains()) {
                DynamicObjectCollection entryEntity = this.matchParam.getModel().getEntryEntity(chain.getEntryIdentify());
                if (!EmptyUtils.isNotEmpty((Object)entryEntity)) continue;
                String redisKey = "entrymatchcache_".concat(oldInvPk.toString()).concat(chain.getEntryIdentify());
                String serialize = DynamicObjectSerializeUtil.serialize((Object[])entryEntity.toArray(), (DynamicObjectType)entryEntity.getDynamicObjectType());
                this.matchParam.getView().getPageCache().put(redisKey, serialize);
            }
            this.clearEntryData();
        }
        if (newRow != null) {
            Object newInvPk = this.matchParam.getModel().getValue("invpk", newRow.intValue());
            for (MatchBillChain.MatchChain chain : this.matchBillChain.getChains()) {
                String redisKey = "entrymatchcache_".concat(newInvPk.toString()).concat(chain.getEntryIdentify());
                String jsonString = this.matchParam.getView().getPageCache().get(redisKey);
                if (!StringUtils.isNotEmpty((CharSequence)jsonString)) continue;
                this.matchParam.getModel().beginInit();
                DynamicObjectCollection entryCollection = this.matchParam.getModel().getEntryEntity(chain.getEntryIdentify());
                Object[] entryObjEntity = DynamicObjectSerializeUtil.deserialize((String)jsonString, (DynamicObjectType)entryCollection.getDynamicObjectType());
                DynamicObject[] entryEntity = (DynamicObject[])Stream.of(entryObjEntity).map(obj -> (DynamicObject)obj).toArray(DynamicObject[]::new);
                TableValueSetter tableValueGetter = this.getTableValueGetter(entryEntity, chain);
                this.matchParam.getModel().batchCreateNewEntryRow(chain.getEntryIdentify(), tableValueGetter);
                this.matchParam.getModel().endInit();
                this.matchParam.getView().updateView(chain.getEntryIdentify());
            }
        }
        this.refreshMatchKeyEnable();
    }

    private TableValueSetter getTableValueGetter(DynamicObject[] array, MatchBillChain.MatchChain chain) {
        TableValueSetter valueSetter = this.getEntryValueSetter(chain);
        List fields = valueSetter.getFields();
        ArrayList<Object[]> rowDatas = new ArrayList<Object[]>(64);
        for (DynamicObject row : array) {
            Object[] args = fields.stream().map(field -> {
                Object fieldValue = row.get(field);
                return fieldValue instanceof DynamicObject ? ((DynamicObject)fieldValue).getPkValue() : fieldValue;
            }).toArray();
            rowDatas.add(args);
        }
        for (Object[] args : rowDatas) {
            valueSetter.addRow(args);
        }
        return valueSetter;
    }

    protected TableValueSetter getEntryValueSetter(MatchBillChain.MatchChain chain) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        EntryGrid grid = (EntryGrid)this.matchParam.getView().getControl(chain.getEntryIdentify());
        List mainGridFields = grid.getFieldEdits().stream().map(Control::getKey).collect(Collectors.toList());
        for (String fieldKey : mainGridFields) {
            vs.addField(fieldKey, new Object[0]);
        }
        return vs;
    }
}

