/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.journal.BizDescriptionEnum;
import kd.fi.arapcommon.journal.convert.BasedataBatchReader;
import kd.fi.arapcommon.journal.convert.JournalAutoConverter;
import kd.fi.arapcommon.util.EmptyUtils;

public class PayBillPushJournalConverter
extends JournalAutoConverter {
    private BasedataBatchReader basedataReader = new BasedataBatchReader();

    protected String getJournalType(String sourceEntityKey) {
        return "ap_journal";
    }

    public List<DynamicObject> convert(DynamicObject[] sourceBills) {
        for (DynamicObject sourceBill : sourceBills) {
            if (!this.isPrepaid(sourceBill)) continue;
            String payeeType = sourceBill.getString("payeetype");
            this.basedataReader.addParam(payeeType, sourceBill.get("payee"));
        }
        return super.convert(sourceBills);
    }

    protected List<DynamicObject> convert(DynamicObject payBill) {
        if (this.isPrepaid(payBill)) {
            this.entryKey = "entry";
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection(this.entryKey);
            entry.removeIf(row -> !row.getBoolean("e_paymenttype.ispartpayment"));
            return super.convert(payBill);
        }
        return new ArrayList<DynamicObject>();
    }

    protected boolean isPrepaid(DynamicObject payBill) {
        return payBill.getBoolean("paymenttype.ispartpayment");
    }

    protected Object getValue(String journalField, DynamicObject sourceBill, DynamicObject row) {
        if ("biztype".equals(journalField)) {
            return sourceBill.getString("billtype.number");
        }
        DynamicObjectCollection entrys = sourceBill.getDynamicObjectCollection("entry");
        BigDecimal payableAmt = BigDecimal.ZERO;
        BigDecimal payableLocAmt = BigDecimal.ZERO;
        long settleOrgId = 0L;
        if (EmptyUtils.isNotEmpty((Object)entrys)) {
            settleOrgId = ((DynamicObject)entrys.get(0)).getLong("settleorg.id");
            for (DynamicObject entry : entrys) {
                payableAmt = payableAmt.add(entry.getBigDecimal("e_payableamt"));
                payableLocAmt = payableLocAmt.add(entry.getBigDecimal("e_payablelocamt"));
            }
        }
        if ("org".equals(journalField)) {
            if (row != null) {
                return row.getLong("settleorg.id");
            }
            return settleOrgId;
        }
        if ("prepaidamt".equals(journalField)) {
            if (row != null) {
                return row.getBigDecimal("e_payableamt");
            }
            return payableAmt;
        }
        if ("localprepaidamt".equals(journalField)) {
            if (row != null) {
                return row.getBigDecimal("e_payablelocamt");
            }
            return payableLocAmt;
        }
        if ("asstacttype".equals(journalField)) {
            return sourceBill.get("payeetype");
        }
        if ("asstact".equals(journalField)) {
            Object payeeId;
            String payeeType = sourceBill.getString("payeetype");
            DynamicObject payee = this.basedataReader.read(payeeType, payeeId = sourceBill.get("payee"));
            if (payee != null) {
                return payee;
            }
            return payeeId;
        }
        if ("bizdate".equals(journalField)) {
            Long orgId = row != null ? Long.valueOf(row.getLong("settleorg.id")) : Long.valueOf(sourceBill.getLong("org.id"));
            Date journalDate = this.getJournalDate(sourceBill, row);
            InitHelper initHelper = new InitHelper(orgId.longValue(), "ap_init");
            Date currentDate = initHelper.getCurrentDate();
            if (currentDate != null && journalDate != null) {
                return journalDate.compareTo(currentDate) > 0 ? journalDate : currentDate;
            }
            return journalDate;
        }
        if ("bizdescription".equals(journalField)) {
            if (row != null) {
                return "202".equals(row.getString("e_paymenttype.biztype")) ? BizDescriptionEnum.paid.name() : BizDescriptionEnum.pay.name();
            }
            return "202".equals(sourceBill.getString("paymenttype.biztype")) ? BizDescriptionEnum.paid.name() : BizDescriptionEnum.pay.name();
        }
        return super.getValue(journalField, sourceBill, row);
    }

    private Date getJournalDate(DynamicObject sourceBill, DynamicObject row) {
        long orgId = row != null ? row.getLong("settleorg.id") : sourceBill.getLong("org.id");
        Object casParam = SystemParameterHelper.getCasParam((Long)orgId, (String)"cs104");
        Date bizDate = null;
        bizDate = Objects.equals(casParam, "2") ? sourceBill.getDate("paydate") : sourceBill.getDate("bizdate");
        return bizDate;
    }

    protected Set<String> getSourceBillSelectors() {
        HashSet<String> selectors = new HashSet<String>();
        if (this.entryKey != null) {
            selectors.add("e_actamt");
            selectors.add("e_localamt");
        } else {
            selectors.add("actpayamt");
            selectors.add("localamt");
        }
        selectors.add("e_payableamt");
        selectors.add("e_payablelocamt");
        selectors.add("settleorg");
        selectors.add("billtype");
        selectors.add("payeetype");
        selectors.add("payee");
        selectors.add("bizdate");
        selectors.add("paydate");
        selectors.add("paymenttype");
        selectors.add("e_paymenttype");
        selectors.addAll(this.getSourceBillDefaultSelectors());
        return selectors;
    }
}

