/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.init.InitServiceHelper;
import kd.fi.arapcommon.service.AbstractOpService;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class InitCloseImpl
extends AbstractOpService {
    private int BATCHCOUNT = 0;

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("org");
        lst.add("isfinishinit");
        lst.add("periodtype");
        lst.add("startperiod");
        lst.add("curperiod");
        lst.add("startdate");
        lst.add("currentdate");
        lst.add("standardcurrency");
        lst.add("exratetable");
        lst.add("entryentity.asstacttype");
        lst.add("entryentity.asstact");
        lst.add("entryentity.currency");
        lst.add("entryentity.invoiceamount");
        lst.add("entryentity.businessamount");
        lst.add("entryentity.paymentamount");
        lst.add("entryentity.totalamount");
        return lst;
    }

    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
    }

    public void process(DynamicObject info) {
        super.process(info);
        Object orgPk = info.getDynamicObject("org").getPkValue();
        this.updateBill(orgPk, "ap_finapbill", true);
        this.updateBill(orgPk, "ap_busbill", true);
        this.updateBill(orgPk, "ap_paidbill", false);
        info.set("curperiod", (Object)info.getDynamicObject("startperiod"));
        info.set("currentdate", (Object)info.getDate("startdate"));
        info.set("isfinishinit", (Object)Boolean.TRUE);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{info});
    }

    private void updateBill(Object orgPk, String entityKey, boolean isPeriod) {
        QFilter qFilter = new QFilter("org", "=", orgPk);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
        if (isPeriod) {
            qFilter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        LinkedList<Long> ids = new LinkedList<Long>();
        if (this.BATCHCOUNT == 0) {
            this.BATCHCOUNT = InitServiceHelper.getInitBatchHandleCount();
        }
        try (DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"fi.ap.InitCloseImpl", (String)entityKey, (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row bill : billDataSet) {
                ids.add(bill.getLong("id"));
                if (ids.size() != this.BATCHCOUNT) continue;
                this.doUpdateStatus(ids, entityKey);
                ids.clear();
            }
        }
        if (!ids.isEmpty()) {
            this.doUpdateStatus(ids, entityKey);
        }
    }

    private void doUpdateStatus(List<Long> ids, String entityKey) {
        DynamicObject[] bills;
        DynamicObjectType subEntityType = EntityMetadataUtils.getSubEntityType((String)entityKey, (String)"billstatus, auditdate,auditor,bizdate,bookdate");
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)subEntityType)) {
            bill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            bill.set("auditdate", (Object)new Date());
            bill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            if ("ap_paidbill".equals(entityKey) || bill.getDate("bookdate") != null) continue;
            Date bizDate = bill.getDate("bizdate");
            bill.set("bookdate", (Object)bizDate);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"periodaudit", (String)entityKey, (Object[])ids.toArray(new Long[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)opResult);
    }
}

