/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.task;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.DateUtils;

public class FinBillAssignUpgradeTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-90);
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)beginDate);
        QFilter uninvoicedAmtFilter = new QFilter("uninvoicedamt", ">", (Object)BigDecimal.ZERO);
        QFilter priceTaxTotalFilter = new QFilter("pricetaxtotal", ">", (Object)BigDecimal.ZERO);
        QFilter negEntryPriceTaxTotalFilter = new QFilter("detailentry.e_pricetaxtotal", "<", (Object)BigDecimal.ZERO);
        DynamicObjectCollection negativeFinBillCollection1 = QueryServiceHelper.query((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{dateFilter, uninvoicedAmtFilter, priceTaxTotalFilter, negEntryPriceTaxTotalFilter});
        QFilter negUninvoicedAmtFilter = new QFilter("uninvoicedamt", "<", (Object)BigDecimal.ZERO);
        QFilter negPriceTaxTotalFilter = new QFilter("pricetaxtotal", "<", (Object)BigDecimal.ZERO);
        QFilter entryPriceTaxTotalFilter = new QFilter("detailentry.e_pricetaxtotal", ">", (Object)BigDecimal.ZERO);
        DynamicObjectCollection negativeFinBillCollection2 = QueryServiceHelper.query((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{dateFilter, negUninvoicedAmtFilter, negPriceTaxTotalFilter, entryPriceTaxTotalFilter});
        negativeFinBillCollection1.addAll((Collection)negativeFinBillCollection2);
        HashSet<Long> batchIds = new HashSet<Long>(100);
        for (DynamicObject finBill : negativeFinBillCollection1) {
            batchIds.add(finBill.getLong("id"));
            if (batchIds.size() != 100) continue;
            this.repair(batchIds);
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.repair(batchIds);
        }
        this.deleteTask();
    }

    private void repair(Set<Long> ids) {
        try (TXHandle tx = TX.requiresNew();){
            Object[] negativeFinBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,pricetaxtotal,uninvoicedamt,e_pricetaxtotal,e_invoicedamt,e_uninvoicedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (ObjectUtils.isEmpty((Object[])negativeFinBills)) {
                return;
            }
            try {
                for (Object finBill : negativeFinBills) {
                    BigDecimal uninvoicedAmt = finBill.getBigDecimal("uninvoicedamt");
                    BigDecimal priceTaxTotal = finBill.getBigDecimal("pricetaxtotal");
                    BigDecimal invoicedAmt = priceTaxTotal.subtract(uninvoicedAmt);
                    DynamicObjectCollection entry = finBill.getDynamicObjectCollection("detailentry");
                    for (DynamicObject row : entry) {
                        row.set("e_invoicedamt", (Object)BigDecimal.ZERO);
                        row.set("e_uninvoicedamt", (Object)row.getBigDecimal("e_pricetaxtotal"));
                    }
                    this.repairFinBill(invoicedAmt, (DynamicObject)finBill);
                }
                SaveServiceHelper.save((DynamicObject[])negativeFinBills);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void repairFinBill(BigDecimal invoicedAmt, DynamicObject finbill) {
        DynamicObjectCollection entry = finbill.getDynamicObjectCollection("detailentry");
        for (DynamicObject row : entry) {
            BigDecimal priceTaxTotal = row.getBigDecimal("e_pricetaxtotal");
            BigDecimal uninvoicedAmt = row.getBigDecimal("e_uninvoicedamt");
            if (uninvoicedAmt.compareTo(BigDecimal.ZERO) == 0 || !this.isNegativeRow(invoicedAmt, priceTaxTotal)) continue;
            row.set("e_uninvoicedamt", (Object)BigDecimal.ZERO);
            row.set("e_invoicedamt", (Object)priceTaxTotal);
            invoicedAmt = invoicedAmt.add(uninvoicedAmt.negate());
        }
        for (DynamicObject detail : entry) {
            BigDecimal applyAmt = detail.getBigDecimal("e_uninvoicedamt");
            BigDecimal rowPriceTaxTotal = detail.getBigDecimal("e_pricetaxtotal");
            if (this.isNegativeRow(invoicedAmt, rowPriceTaxTotal)) continue;
            if (applyAmt.abs().compareTo(invoicedAmt.abs()) >= 0) {
                detail.set("e_uninvoicedamt", (Object)applyAmt.subtract(invoicedAmt));
                detail.set("e_invoicedamt", (Object)rowPriceTaxTotal.subtract(detail.getBigDecimal("e_uninvoicedamt")));
                break;
            }
            if (applyAmt.abs().compareTo(invoicedAmt.abs()) >= 0) continue;
            detail.set("e_uninvoicedamt", (Object)applyAmt.subtract(applyAmt));
            detail.set("e_invoicedamt", (Object)rowPriceTaxTotal.subtract(detail.getBigDecimal("e_uninvoicedamt")));
            invoicedAmt = invoicedAmt.subtract(applyAmt);
        }
    }

    private boolean isNegativeRow(BigDecimal invoicedAmt, BigDecimal entryPriceTaxTotal) {
        return invoicedAmt.compareTo(BigDecimal.ZERO) > 0 && entryPriceTaxTotal.compareTo(BigDecimal.ZERO) < 0 || invoicedAmt.compareTo(BigDecimal.ZERO) < 0 && entryPriceTaxTotal.compareTo(BigDecimal.ZERO) > 0;
    }

    private void deleteTask() {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String delTaskDefineSql = "delete from t_sch_taskdefine where fid = '2QDHNZ+58SVA'";
                DB.execute((DBRoute)DBRoute.basedata, (String)delTaskDefineSql);
                String delTaskDefineLSql = "delete from t_sch_taskdefine_l where fid = '2QDHNZ+58SVA'";
                DB.execute((DBRoute)DBRoute.basedata, (String)delTaskDefineLSql);
                String delJobSql = "delete from T_SCH_JOB where fid = '2QDHPA4AGW9Z'";
                DB.execute((DBRoute)DBRoute.basedata, (String)delJobSql);
                String delJobLSql = "delete from T_SCH_JOB_l where fid = '2QDHNZ+58SVA'";
                DB.execute((DBRoute)DBRoute.basedata, (String)delJobLSql);
                String delScheduleSql = "DELETE FROM T_SCH_SCHEDULE WHERE FID = '2QDILCZJKSZU'";
                DB.execute((DBRoute)DBRoute.basedata, (String)delScheduleSql);
                String delScheduleLSql = "DELETE FROM T_SCH_SCHEDULE_L WHERE FID = '2QDILCZJKSZU'";
                DB.execute((DBRoute)DBRoute.basedata, (String)delScheduleLSql);
                String delScheduleEntrySql = "DELETE FROM T_SCH_SCHEDULE_ENTRY WHERE FID = '2QDILCZJKSZU'";
                DB.execute((DBRoute)DBRoute.basedata, (String)delScheduleEntrySql);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }
}

