/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.task.UpdateInvCloudTask;
import kd.fi.arapcommon.util.StdConfig;

public class UpdateInvStatusTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(UpdateInvCloudTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String isSynchInvoiceCloud = StdConfig.get((String)"isSynchInvoiceCloud");
        if ("false".equalsIgnoreCase(isSynchInvoiceCloud)) {
            return;
        }
        try {
            Date beforeDate = this.getTwoMonthBefore(map);
            QFilter qf = new QFilter("issuedate", ">=", (Object)beforeDate).and("issuedate", "<=", (Object)new Date());
            qf = qf.and("invoicestatus", "=", (Object)"0");
            DynamicObjectCollection invos = QueryServiceHelper.query((String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{qf});
            List ids = invos.stream().map(inv -> inv.getLong("id")).collect(Collectors.toList());
            List splitList = this.split(ids, 100);
            for (int i = 0; i < splitList.size(); ++i) {
                this.updateInvStatus(splitList.get(i));
            }
        }
        catch (Exception e) {
            logger.info("UpdateInvStatusTask failed  " + e.getMessage());
        }
    }

    public <T> List<List<T>> split(List<T> resList, int count) {
        if (resList == null || count < 1) {
            return null;
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            for (int i = 0; i < pre; ++i) {
                ArrayList<T> itemList = new ArrayList<T>(10);
                for (int j = 0; j < count; ++j) {
                    itemList.add(resList.get(i * count + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList<T> itemList = new ArrayList<T>(10);
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * count + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }

    public void updateInvStatus(List ids) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"updateinvstatus", (String)"ap_invoice", (Object[])ids.toArray(new Object[0]), (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            logger.info("UpdateInvStatusTask failed : " + result.getMessage());
        }
    }

    public Date getTwoMonthBefore(Map<String, Object> map) {
        Object beforeMonth = map.get("beforemonth");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (beforeMonth == null) {
            cal.add(2, -2);
        } else {
            Integer before = Integer.parseInt(beforeMonth.toString());
            cal.add(2, -before.intValue());
        }
        return cal.getTime();
    }
}

