/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.tolerance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.formula.FormulaEngine;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class FormulaUtil {
    public static BigDecimal execFormula(String formula, DynamicObject obj) {
        String expression = FormulaUtil.getExpression(formula);
        return FormulaUtil.execExpression(expression, obj);
    }

    public static BigDecimal execExpression(String expression, DynamicObject obj) {
        List<String> fields = FormulaUtil.getFields(expression);
        HashMap<String, BigDecimal> variableMap = new HashMap<String, BigDecimal>(10);
        for (String field : fields) {
            variableMap.put(field, obj.getBigDecimal(field));
        }
        BigDecimal result = (BigDecimal)FormulaEngine.execExcelFormula((String)expression, variableMap);
        return result;
    }

    public static BigDecimal execFormula(String formula, Map<String, Object> variableMap) {
        String expression = FormulaUtil.getExpression(formula);
        List<String> fields = FormulaUtil.getFields(expression);
        for (String field : fields) {
            variableMap.put(field, variableMap.get(field));
        }
        BigDecimal result = (BigDecimal)FormulaEngine.execExcelFormula((String)expression, variableMap);
        return result;
    }

    public static BigDecimal execFormulaSaved(String formula, Map<String, Object> variableMap, DynamicObject detail, String controlParty, String oppositeParty, DynamicObject bill) {
        String expression = FormulaUtil.getExpression(formula);
        List<String> fields = FormulaUtil.getFields(expression);
        WriteBackRuleReader wbrReader = new WriteBackRuleReader();
        List loadRules = wbrReader.loadRules(controlParty);
        loadRules = loadRules.stream().filter(wbrEle -> oppositeParty.equals(wbrEle.getSourceEntityNumber()) && "save".equalsIgnoreCase(wbrEle.getOp())).collect(Collectors.toList());
        HashMap<String, String> sfKeyToTFormula = new HashMap<String, String>();
        for (WriteBackRuleElement wbrEle2 : loadRules) {
            List wbFormulas = wbrEle2.getFormulas();
            for (Object wbFormula : wbFormulas) {
                sfKeyToTFormula.put(wbFormula.getSourceCommitFieldKey(), wbFormula.getFormula().getExpression());
            }
        }
        for (String field : fields) {
            if (sfKeyToTFormula.isEmpty() || sfKeyToTFormula.get(field) == null) continue;
            BigDecimal value = (BigDecimal)variableMap.get(field);
            DynamicObjectCollection entryDetails = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)controlParty).getDynamicObjectCollection(detail.getDataEntityType().getName());
            for (DynamicObject entryDetail : entryDetails) {
                if (!detail.getPkValue().equals(entryDetail.getPkValue())) continue;
                detail = entryDetail;
                break;
            }
            BigDecimal opValue = FormulaUtil.execExpression((String)sfKeyToTFormula.get(field), detail);
            variableMap.put(field, value.subtract(opValue));
        }
        BigDecimal result = (BigDecimal)FormulaEngine.execExcelFormula((String)expression, variableMap);
        return result;
    }

    public static Boolean isHead(String entityType, String formula) {
        String entryTypeName = FormulaUtil.getEntryTypeName(entityType, formula);
        return entryTypeName.equals(entityType);
    }

    public static String getEntryTypeName(String entityType, String formula) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        Map allFields = dataEntityType.getAllFields();
        String expression = FormulaUtil.getExpression(formula);
        List<String> fields = FormulaUtil.getFields(expression);
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(fields.get(0));
        String entryTypeName = iDataEntityProperty.getParent().getName();
        return entryTypeName;
    }

    public static String getExpression(String formula) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
        String expression = condition.getExpression();
        return expression.replace(" ", "");
    }

    public static String getExprTran(String formula) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
        String exprTran = condition.getExprTran();
        return exprTran.replace(" ", "");
    }

    public static List<String> getFields(String expression) {
        ArrayList<String> fields = new ArrayList();
        String[] variables = FormulaEngine.extractVariables((String)expression);
        fields = new ArrayList<String>(Arrays.asList(variables));
        return fields;
    }

    public static Boolean isSame(String entityType1, String formula1, String entityType2, String formula2) {
        if (FormulaUtil.isHead(entityType1, formula1).booleanValue() && FormulaUtil.isHead(entityType2, formula2).booleanValue() || !FormulaUtil.isHead(entityType1, formula1).booleanValue() && !FormulaUtil.isHead(entityType2, formula2).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Deprecated
    private static Boolean isOperator(char c) {
        return '+' == c || '-' == c || '*' == c || '/' == c || '(' == c || ')' == c;
    }
}

