/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.tolerance;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.tolerance.IToleranceCheckService;
import kd.fi.ap.business.tolerance.VoTest;

public class ToleranceCheckFactory {
    private static final Log logger = LogFactory.getLog(ToleranceCheckFactory.class);
    private static Map<String, String> checkServiceMap = new HashMap<String, String>();

    public static IToleranceCheckService createCheckService(String serviceMark, VoTest votest) {
        String classPath = checkServiceMap.get(serviceMark);
        IToleranceCheckService checkService = null;
        try {
            Class<?> clazz = Class.forName(classPath);
            Constructor<?> constructor = clazz.getConstructor(VoTest.class);
            checkService = (IToleranceCheckService)constructor.newInstance(votest);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return checkService;
    }

    static {
        checkServiceMap.put("BOTP", "kd.fi.ap.business.tolerance.ToleranceCheckBOTP");
        checkServiceMap.put("CORE", "kd.fi.ap.business.tolerance.ToleranceCheckCORE");
        checkServiceMap.put("SELF", "kd.fi.ap.business.tolerance.ToleranceCheckSELF");
    }
}

