/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.tolerance;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.tolerance.FormulaUtil;

public class ToleranceLog {
    private static ToleranceLog log = new ToleranceLog();

    public static ToleranceLog getToleranceLog() {
        return log;
    }

    private ToleranceLog() {
    }

    public void insertToleranceLog(DynamicObject bill, DynamicObject strategyDetail, DynamicObject schemeDetail) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"ap_tolerance_log");
        log.set("operationtime", (Object)new Date());
        log.set("org", (Object)bill.getDynamicObject("org"));
        String source = strategyDetail.getString("e_source");
        source = source.substring(1, source.length() - 1).replace("COREBILL", ResManager.loadResFormat((String)"\u6838\u5fc3\u5355\u636e\u53f7", (String)"ToleranceLog_0", (String)"fi-ap-business", (Object[])new Object[0]));
        log.set("source", (Object)source);
        log.set("strategyname", schemeDetail.getDynamicObject("e_tolerancestrategy").get("name"));
        String controlParty = strategyDetail.getDynamicObject("e_controlparty").getString("name");
        String oppositeParty = strategyDetail.getDynamicObject("e_oppositeparty").getString("name");
        log.set("controlparty", (Object)controlParty);
        log.set("controlobject", (Object)FormulaUtil.getExprTran(strategyDetail.getString("e_controlobjectdesc")));
        log.set("oppositeparty", (Object)oppositeParty);
        log.set("oppositeobject", (Object)FormulaUtil.getExprTran(strategyDetail.getString("e_oppositeobjectdesc")));
        String tolerancelimit = schemeDetail.getString("e_tolerancelimit");
        tolerancelimit = tolerancelimit.replace("NUM", ResManager.loadResFormat((String)"\u6570\u503c", (String)"ToleranceLog_1", (String)"fi-ap-business", (Object[])new Object[0])).replace("PER", ResManager.loadResFormat((String)"\u767e\u5206\u6bd4", (String)"ToleranceLog_2", (String)"fi-ap-business", (Object[])new Object[0]));
        log.set("tolerancelimit", (Object)tolerancelimit);
        log.set("upperlimit", (Object)schemeDetail.getString("e_upperlimit"));
        log.set("lowerLimit", (Object)schemeDetail.getString("e_lowerlimit"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

