/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.tolerance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.tolerance.FormulaUtil;
import kd.fi.ap.business.tolerance.SourcebillInfoEnum;
import kd.fi.ap.business.tolerance.ToleranceAssignMatch;
import kd.fi.ap.business.tolerance.ToleranceLog;
import kd.fi.ap.business.tolerance.ToleranceQueryUtil;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ToleranceSchemeCatValidator {
    public Map<Object, List<Map<String, String>>> validate(ExtendedDataEntity[] datas, String operateKey) {
        DynamicObject[] toleranceSchemes = ToleranceQueryUtil.queryToleranceSchemes();
        if (EmptyUtils.isEmpty((Object)toleranceSchemes)) {
            return new HashMap<Object, List<Map<String, String>>>();
        }
        Map<String, BigDecimal> querySourceBills = ToleranceQueryUtil.querySourceBills(datas, toleranceSchemes);
        HashMap<Object, List<Map<String, String>>> result = new HashMap<Object, List<Map<String, String>>>();
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            List<Map<String, String>> schemeList = this.catSchemes(bill, toleranceSchemes, querySourceBills, operateKey);
            if (schemeList == null || schemeList.isEmpty()) continue;
            result.put(bill.getPkValue(), schemeList);
        }
        return result;
    }

    private List<Map<String, String>> catSchemes(DynamicObject bill, DynamicObject[] toleranceSchemes, Map<String, BigDecimal> querySourceBills, String operateKey) {
        ArrayList<Map<String, String>> schemeList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < toleranceSchemes.length; ++i) {
            if (!ToleranceAssignMatch.isMatchenScheme(bill, toleranceSchemes[i])) continue;
            DynamicObject toleranceScheme = toleranceSchemes[i];
            String controlMode = toleranceScheme.getString("controlmode");
            String schemeName = toleranceScheme.getString("name");
            if (!this.checkControlPoint(toleranceScheme, operateKey).booleanValue()) continue;
            DynamicObjectCollection schemeDetails = toleranceScheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject schemeDetail : schemeDetails) {
                if (!this.checkControlParty(schemeDetail, bill).booleanValue() || !this.checkCondition(schemeDetail, bill)) continue;
                List<Map<String, String>> stragtyList = this.catSchemedetail(schemeDetail, bill, querySourceBills);
                if (stragtyList != null && stragtyList.size() > 0) {
                    for (Map<String, String> message : stragtyList) {
                        message.put("controlmode", controlMode);
                        message.put("schemeName", schemeName);
                    }
                    if ("FORBID".equals(controlMode)) {
                        return stragtyList;
                    }
                }
                schemeList.addAll(stragtyList);
            }
        }
        return schemeList;
    }

    private Boolean checkControlPoint(DynamicObject toleranceScheme, String operateKey) {
        String controlpoint = (String)toleranceScheme.get("controlpoint");
        return controlpoint.contains(operateKey);
    }

    private boolean checkCondition(DynamicObject schemeDetail, DynamicObject bill) {
        QFilter billQFilter;
        String controlParty = this.queryControlParty(schemeDetail);
        String condition = schemeDetail.getString("e_conditiondesc");
        if (EmptyUtils.isEmpty((Object)condition)) {
            return true;
        }
        if (bill.getLong("id") == 0L) {
            return true;
        }
        QFilter conditionQFilter = this.buildQFilter(controlParty, condition);
        Map map = BusinessDataServiceHelper.loadFromCache((String)controlParty, (QFilter[])new QFilter[]{conditionQFilter, billQFilter = new QFilter("id", "=", bill.getPkValue())});
        return map != null && map.size() > 0;
    }

    private String queryControlParty(DynamicObject schemeDetail) {
        DynamicObject toleranceStrategy = schemeDetail.getDynamicObject("e_tolerancestrategy");
        String controlParty = toleranceStrategy.getDynamicObject("controlparty").getString("id");
        return controlParty;
    }

    private String queryControlPartyFromDetail(DynamicObject strategyDetail) {
        String controlParty = strategyDetail.getDynamicObject("e_controlparty").getString("id");
        return controlParty;
    }

    private String queryOppositeParty(DynamicObject strategyDetail) {
        String oppositeParty = strategyDetail.getDynamicObject("e_oppositeparty").getString("id");
        return oppositeParty;
    }

    private Boolean checkControlParty(DynamicObject schemeDetail, DynamicObject bill) {
        return this.queryControlParty(schemeDetail).equals(bill.getDataEntityType().getName());
    }

    private Boolean checkOppositeParty(DynamicObject strategyDetail, DynamicObject bill) {
        String oppositeParty = strategyDetail.getDynamicObject("e_oppositeparty").getString("id");
        Map findSourceBills = BOTPHelper.findSourceBills((String)bill.getDataEntityType().getName(), (Long)bill.getLong("id"));
        String source = this.queryStrategySource(strategyDetail);
        if (findSourceBills != null && findSourceBills.size() > 0 && (source.contains("BOTP") || source.contains("CORE"))) {
            return findSourceBills.containsKey(oppositeParty);
        }
        if ((findSourceBills == null || findSourceBills.size() == 0) && source.contains("CORE")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String queryStrategySource(DynamicObject strategyDetail) {
        String source = strategyDetail.getString("e_source");
        return source;
    }

    private List<Map<String, String>> catSchemedetail(DynamicObject schemeDetail, DynamicObject bill, Map<String, BigDecimal> querySourceBills) {
        DynamicObject toleranceStrategy = schemeDetail.getDynamicObject("e_tolerancestrategy");
        DynamicObjectCollection strategyDetails = toleranceStrategy.getDynamicObjectCollection("strategyentry");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (DynamicObject strategyDetail : strategyDetails) {
            HashMap<String, String> message = new HashMap<String, String>();
            boolean isSameParty = this.queryControlPartyFromDetail(strategyDetail).equals(this.queryOppositeParty(strategyDetail));
            if (!isSameParty && !this.checkOppositeParty(strategyDetail, bill).booleanValue()) continue;
            String strategyName = toleranceStrategy.getString("name");
            if ((querySourceBills.isEmpty() || isSameParty || !this.checkStrategydetail(schemeDetail, strategyDetail, bill, querySourceBills).booleanValue()) && (!isSameParty || !this.checkStrategydetailOfSelf(schemeDetail, strategyDetail, bill).booleanValue())) continue;
            message.put("strategyName", strategyName);
            list.add(message);
            ToleranceLog.getToleranceLog().insertToleranceLog(bill, strategyDetail, schemeDetail);
        }
        return list;
    }

    private Boolean checkStrategydetail(DynamicObject schemeDetail, DynamicObject strategyDetail, DynamicObject bill, Map<String, BigDecimal> sourceBillsMap) {
        String toleranceLimit = schemeDetail.getString("e_tolerancelimit");
        BigDecimal upperLimit = schemeDetail.getBigDecimal("e_upperlimit");
        BigDecimal lowerLimit = schemeDetail.getBigDecimal("e_lowerlimit");
        String controlParty = this.queryControlParty(schemeDetail);
        String oppositeParty = this.queryOppositeParty(strategyDetail);
        String controlObjectDesc = strategyDetail.getString("e_controlobjectdesc");
        String oppositeObjectDesc = strategyDetail.getString("e_oppositeobjectdesc");
        if (FormulaUtil.isHead(controlParty, controlObjectDesc).booleanValue()) {
            BigDecimal controlResult = FormulaUtil.execFormula(controlObjectDesc, bill);
            List<String> fields = FormulaUtil.getFields(FormulaUtil.getExpression(oppositeObjectDesc));
            Map findSourceBills = BOTPHelper.findSourceBills((String)controlParty, (Long)bill.getLong("id"));
            ArrayList sourcebillids = new ArrayList(10);
            if (findSourceBills != null && findSourceBills.size() == 0) {
                return Boolean.FALSE;
            }
            if (findSourceBills != null) {
                Collection sourceBillIds = findSourceBills.values();
                for (HashSet hashSet : sourceBillIds) {
                    sourcebillids.addAll(hashSet);
                }
            }
            BigDecimal oppositeResult = BigDecimal.ZERO;
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            for (Long sourcebillid : sourcebillids) {
                for (String field : fields) {
                    if (sourceBillsMap.get(sourcebillid + field) == null) continue;
                    varMap.put(field, sourceBillsMap.get(sourcebillid + field));
                }
                if (varMap.isEmpty()) continue;
                oppositeResult = oppositeResult.add(FormulaUtil.execFormula(oppositeObjectDesc, varMap));
            }
            return this.isOver(toleranceLimit, upperLimit, lowerLimit, controlResult, oppositeResult);
        }
        String entryTypeName = FormulaUtil.getEntryTypeName(controlParty, controlObjectDesc);
        DynamicObjectCollection controlDetails = bill.getDynamicObjectCollection(entryTypeName);
        Long[] entryIds = (Long[])controlDetails.stream().map(detail -> detail.getLong("id")).toArray(Long[]::new);
        Map<Object, Object> idToSidMap = new HashMap();
        Long billPk = bill.getLong("id");
        if (billPk != 0L) {
            idToSidMap = ToleranceQueryUtil.loadSourceRowId(controlParty, entryTypeName, entryIds);
        }
        boolean isCore = false;
        if (idToSidMap == null || idToSidMap.size() == 0) {
            for (DynamicObject controlDetail : controlDetails) {
                List<String> fields = FormulaUtil.getFields(FormulaUtil.getExpression(oppositeObjectDesc));
                List<String> matchFields = ToleranceQueryUtil.matchEntryFileds(oppositeParty, fields);
                Long corebillid = controlDetail.getLong(SourcebillInfoEnum.valueOf(controlParty).getCorebillid());
                String corebilltype = controlDetail.getString(SourcebillInfoEnum.valueOf(controlParty).getCorebilltype());
                int corebillentryseq = controlDetail.getInt(SourcebillInfoEnum.valueOf(controlParty).getCorebillentryseq());
                if (corebillentryseq < 1 || corebillid == 0L) {
                    return Boolean.FALSE;
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)corebillid)};
                Long sourcebillentryid = (Long)((DynamicObject)QueryServiceHelper.query((String)corebilltype, (String)matchFields.get(0), (QFilter[])filters).get(corebillentryseq - 1)).get(0);
                HashSet<Long> sidSet = new HashSet<Long>();
                sidSet.add(sourcebillentryid);
                idToSidMap.put(controlDetail.getLong("id"), sidSet);
                isCore = true;
            }
        }
        for (DynamicObject controlDetail : controlDetails) {
            BigDecimal controlResult = FormulaUtil.execFormula(controlObjectDesc, controlDetail);
            List<String> fields = FormulaUtil.getFields(FormulaUtil.getExpression(oppositeObjectDesc));
            List<String> matchFields = ToleranceQueryUtil.matchEntryFileds(oppositeParty, fields);
            matchFields.remove(0);
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            HashSet hashSet = (HashSet)idToSidMap.get(controlDetail.getLong("id"));
            for (Long next : hashSet) {
                for (int i = 0; i < matchFields.size(); ++i) {
                    String sourceBillskey = next + matchFields.get(i);
                    if (sourceBillsMap.get(sourceBillskey) == null) continue;
                    varMap.put(fields.get(i), sourceBillsMap.get(sourceBillskey));
                }
            }
            BigDecimal oppositeResult = BigDecimal.ZERO;
            oppositeResult = !isCore && controlDetail.getLong("id") != 0L ? FormulaUtil.execFormulaSaved(oppositeObjectDesc, varMap, controlDetail, controlParty, oppositeParty, bill) : FormulaUtil.execFormula(oppositeObjectDesc, varMap);
            Boolean over = this.isOver(toleranceLimit, upperLimit, lowerLimit, controlResult, oppositeResult);
            if (!over.booleanValue()) continue;
            return over;
        }
        return Boolean.FALSE;
    }

    private Boolean checkStrategydetailOfSelf(DynamicObject schemeDetail, DynamicObject strategyDetail, DynamicObject bill) {
        String toleranceLimit = schemeDetail.getString("e_tolerancelimit");
        BigDecimal upperLimit = schemeDetail.getBigDecimal("e_upperlimit");
        BigDecimal lowerLimit = schemeDetail.getBigDecimal("e_lowerlimit");
        String controlParty = this.queryControlParty(schemeDetail);
        String controlObjectDesc = strategyDetail.getString("e_controlobjectdesc");
        String oppositeObjectDesc = strategyDetail.getString("e_oppositeobjectdesc");
        if (FormulaUtil.isHead(controlParty, controlObjectDesc).booleanValue()) {
            BigDecimal controlResult = FormulaUtil.execFormula(controlObjectDesc, bill);
            BigDecimal oppositeResult = FormulaUtil.execFormula(oppositeObjectDesc, bill);
            return this.isOver(toleranceLimit, upperLimit, lowerLimit, controlResult, oppositeResult);
        }
        String entryTypeName = FormulaUtil.getEntryTypeName(controlParty, controlObjectDesc);
        DynamicObjectCollection controlDetails = bill.getDynamicObjectCollection(entryTypeName);
        for (DynamicObject controlDetail : controlDetails) {
            BigDecimal oppositeResult;
            BigDecimal controlResult = FormulaUtil.execFormula(controlObjectDesc, controlDetail);
            Boolean over = this.isOver(toleranceLimit, upperLimit, lowerLimit, controlResult, oppositeResult = FormulaUtil.execFormula(oppositeObjectDesc, controlDetail));
            if (!over.booleanValue()) continue;
            return over;
        }
        return Boolean.TRUE;
    }

    private Boolean isOver(String toleranceLimit, BigDecimal upperLimit, BigDecimal lowerLimit, BigDecimal controlResult, BigDecimal oppositeResult) {
        if (upperLimit.compareTo(BigDecimal.ZERO) == 0 && lowerLimit.compareTo(BigDecimal.ZERO) == 0) {
            return Boolean.FALSE;
        }
        switch (toleranceLimit) {
            case "PER": {
                if (upperLimit.compareTo(BigDecimal.ZERO) == 0) {
                    return oppositeResult.multiply(BigDecimal.ONE.subtract(lowerLimit.divide(new BigDecimal(100)))).compareTo(controlResult) > 0;
                }
                if (lowerLimit.compareTo(BigDecimal.ZERO) == 0) {
                    return oppositeResult.multiply(upperLimit.divide(new BigDecimal(100)).add(BigDecimal.ONE)).compareTo(controlResult) < 0;
                }
                return oppositeResult.multiply(upperLimit.divide(new BigDecimal(100)).add(BigDecimal.ONE)).compareTo(controlResult) < 0 || oppositeResult.multiply(BigDecimal.ONE.subtract(lowerLimit.divide(new BigDecimal(100)))).compareTo(controlResult) > 0;
            }
            case "NUM": {
                if (upperLimit.compareTo(BigDecimal.ZERO) == 0) {
                    return oppositeResult.subtract(lowerLimit).compareTo(controlResult) > 0;
                }
                if (lowerLimit.compareTo(BigDecimal.ZERO) == 0) {
                    return oppositeResult.add(upperLimit).compareTo(controlResult) < 0;
                }
                return oppositeResult.add(upperLimit).compareTo(controlResult) < 0 || oppositeResult.subtract(lowerLimit).compareTo(controlResult) > 0;
            }
        }
        return Boolean.FALSE;
    }

    private QFilter buildQFilter(String entityKey, String filter) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filter, CRCondition.class);
        FilterCondition filterCondition = crCondition.getFilterCondition();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityKey);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.buildFilter();
        QFilter qFilter = filterBuilder.getQFilter();
        return qFilter;
    }
}

