/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.webapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.openapi.BillSaveApi;
import kd.fi.arapcommon.util.QueryUtil;

public class ApImportSettleSaveApi
extends BillSaveApi {
    private final Map<String, Object> dataCache = new HashMap<String, Object>(2);
    private final QueryUtil queryUtil = new QueryUtil();

    public ApImportSettleSaveApi() {
        super(false);
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        ArrayList datas = (ArrayList)params.get("datas");
        this.checkBatchNo(datas);
        return super.doCustomService(params);
    }

    protected String bizCheck(LinkedHashMap<String, Object> data) {
        return this.check(data, this.getSettleRelation());
    }

    private void checkBatchNo(List<Map<String, Object>> datas) {
        HashSet<String> batchNos = new HashSet<String>(2);
        for (Map<String, Object> data : datas) {
            String batchNumber = (String)data.get("batchnumber");
            batchNos.add(batchNumber);
            if (batchNos.size() <= 1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6279\u6b21\u53f7\u5fc5\u987b\u4e00\u81f4", (String)"ApImportSettleSaveApi_0", (String)"fi-ap-webapi", (Object[])new Object[0]));
        }
        boolean existsBatchNo = QueryServiceHelper.exists((String)"ap_settleimport", (QFilter[])new QFilter[]{new QFilter("batchnumber", "=", batchNos.iterator().next())});
        if (existsBatchNo) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u6279\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"ApImportSettleSaveApi_1", (String)"fi-ap-webapi", (Object[])new Object[0]));
        }
    }

    private String check(LinkedHashMap<String, Object> data, List<String> rightRelation) {
        String message = null;
        String orgNumber = (String)data.get("org");
        String settleRelation = (String)data.get("settlerelation");
        message = this.checkOrg(orgNumber);
        if (message != null) {
            return message;
        }
        if (!rightRelation.contains(settleRelation)) {
            return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ApImportSettleSaveApi_2", (String)"fi-ap-webapi", (Object[])new Object[0]), orgNumber);
        }
        return message;
    }

    public String checkOrg(String orgNumber) {
        DynamicObject init;
        String message = null;
        String orgKey = "bos_org_" + orgNumber;
        DynamicObject org = (DynamicObject)this.dataCache.get(orgKey);
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"isfinishinit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
            this.dataCache.put(orgKey, org);
        }
        if ((init = this.queryUtil.getInitObj(org.getLong("id"), "ap_init")) == null || !init.getBoolean("isfinishinit")) {
            message = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%s\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ApImportSettleSaveApi_3", (String)"fi-ap-webapi", (Object[])new Object[0]), orgNumber);
        }
        return message;
    }

    public List<String> getSettleRelation() {
        ArrayList<String> settleRelation = new ArrayList<String>();
        settleRelation.add("appaysettle");
        settleRelation.add("payself");
        settleRelation.add("apself");
        settleRelation.add("aparsettle");
        settleRelation.add("payrecsettle");
        settleRelation.add("aprecsettle");
        return settleRelation;
    }
}

