/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ApPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionServiceHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.convert.InitConvertHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;

public class InvoiceToFinApConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(InvoiceToFinApConvertPlugin.class);
    private Map<Long, DynamicObject> orgInitMap;
    private Map<Long, Object> orgIsEnableLineTypeMap;
    private DynamicObject[] needMatchSplitSchemes;
    private Map<Object, DynamicObject> supplierMap;
    private final Map<Long, DynamicObject> purOrderBillIdToSupplierMap = new HashMap<Long, DynamicObject>(1);
    private final Map<Long, Map<DynamicObject, DynamicObject>> billTypeToBizTypeMap = new HashMap<Long, Map<DynamicObject, DynamicObject>>(1);
    private Map<Long, List<Long>> invoiceIdToBusIdsMap;
    private Map<Long, DynamicObject> invoiceBillMap;
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);

    public void initVariable(InitVariableEventArgs e) {
        if ("Draw".equals(this.getOpType().name())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0a\u62c9\u6536\u7968\u5355\u3002\u82e5\u9700\u6839\u636e\u6536\u7968\u5355\u4e0b\u63a8\u5e94\u4ed8\uff0c\u8bf7\u4ece\u6536\u7968\u5355\u786e\u8ba4\u5e94\u4ed8\u3002", (String)"InvoiceToFinApConvertPlugin_0", (String)"fi-ap-common", (Object[])new Object[0]));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("InvoiceToFinApConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        ArrayList<Long> invoiceIds = new ArrayList<Long>(32);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            DynamicObject dataEntity = extendEntity.getDataEntity();
            entities.add(dataEntity);
            invoiceIds.add(dataEntity.getLong("sourcebillid"));
            orgIds.add(dataEntity.getLong("org.id"));
        }
        Map<Long, Set<Long>> onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds("ap_invoice", orgIds, invoiceIds);
        if (!onTheWayInvoiceIdsMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u7968\u5355\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\u65f6\u624d\u5141\u8bb8\u786e\u8ba4\u5e94\u4ed8\uff1a1.\u5355\u636e\u72b6\u6001\u4e3a\"\u5df2\u5ba1\u6838\"\uff1b2.\u672a\u5173\u8054\u91d1\u989d\u4e0d\u4e3a0\uff1b3.\u4e0d\u662f\u4ece\u5e94\u4ed8\u3001\u4ed8\u6b3e\u7533\u8bf7\u5355\u91c7\u96c6\u800c\u6765\uff1b4.\u4e1a\u52a1\u6765\u6e90\u4e3a\u7a7a\uff1b5.\u672a\u5173\u8054\u975e\u5ba1\u6838\u6001\u7684\u6362\u7968\u7533\u8bf7\uff1b6.\u53d1\u7968\u72b6\u6001\u53ea\u6709\u4e3a\u7a7a\u548c\u6b63\u5e38\u7684\u624d\u80fd\u4e0b\u63a8\u3002", (String)"InvoiceToFinApConvertPlugin_1", (String)"fi-ap-common", (Object[])new Object[0]));
        }
        this.prepareData(entities);
        for (DynamicObject finApBill : entities) {
            DynamicObject org = finApBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit((DynamicObject)org, this.orgInitMap, (boolean)false);
            this.setHeadValue(finApBill);
            this.setDetailEntryValue(finApBill);
            this.setInvoiceEntryValue(finApBill);
        }
        for (DynamicObject finApBill : entities) {
            this.setHeadAmtValue(finApBill);
            this.setPlanEntryValue(finApBill);
        }
        BookDateHelper.setBookDate((DynamicObject[])entities.toArray(new DynamicObject[0]), (boolean)false);
        InvoiceHelper.updateFinTaxDeductionLogic(entities.toArray(new DynamicObject[0]), false);
        logger.info("InvoiceToFinApConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("InvoiceToFinApConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> asstactIdSet = new HashSet<Long>(entities.size());
        HashSet<Long> srcPurOrderBillIds = new HashSet<Long>(1);
        HashSet<Long> invoiceIds = new HashSet<Long>(entities.size());
        HashSet<Long> srcInvSet = new HashSet<Long>(1);
        HashSet<Long> billTypeIds = new HashSet<Long>(1);
        for (DynamicObject entity : entities) {
            long orgId = entity.getLong("org.id");
            if (orgId != 0L) {
                orgIds.add(orgId);
            }
            DynamicObject asstact = entity.getDynamicObject("asstact");
            String srcBillType = entity.getString("sourcebilltype");
            if (asstact == null) {
                if ("pm_purorderbill".equals(srcBillType)) {
                    srcPurOrderBillIds.add(entity.getLong("sourcebillid"));
                }
            } else {
                asstactIdSet.add(asstact.getLong("id"));
            }
            for (DynamicObject invRow : entity.getDynamicObjectCollection("inventry")) {
                invoiceIds.add(invRow.getLong("invid"));
            }
            if ("ap_invoice".equals(srcBillType)) {
                srcInvSet.add(entity.getLong("sourcebillid"));
            }
            billTypeIds.add(entity.getLong("billtypeid.id"));
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, (boolean)false);
        this.orgIsEnableLineTypeMap = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.FALSE, new ArrayList(orgIds), (String)"ap_025");
        if (!srcPurOrderBillIds.isEmpty()) {
            Map purOrderBillMap = BusinessDataServiceHelper.loadFromCache((String)"pm_purorderbill", (String)"id,supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", srcPurOrderBillIds)});
            for (DynamicObject purOrderBill : purOrderBillMap.values()) {
                asstactIdSet.add(purOrderBill.getLong("supplier.id"));
                this.purOrderBillIdToSupplierMap.put(purOrderBill.getLong("id"), purOrderBill.getDynamicObject("supplier"));
            }
        }
        this.supplierMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"deliversupplierid,invoicesupplierid,receivingsupplierid,paymentcurrency, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet)});
        DynamicObject[] apInvoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"pricetaxtotal,entry.taxrate,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        this.invoiceBillMap = Arrays.stream(apInvoices).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill));
        this.invoiceIdToBusIdsMap = BOTPHelper.loadNearUpBillIds((String)"ap_invoice", (String)"ap_busbill", (Long[])srcInvSet.toArray(new Long[0]));
        for (Long billTypeId : billTypeIds) {
            HashMap<DynamicObject, DynamicObject> paramMap = new HashMap<DynamicObject, DynamicObject>(1);
            DynamicObject bizType = LineTypeHelper.getDefaultBizType((long)billTypeId);
            long bizTypeId = bizType == null ? 0L : bizType.getLong("id");
            DynamicObject lineType = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
            paramMap.put(bizType, lineType);
            this.billTypeToBizTypeMap.put(billTypeId, paramMap);
        }
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes((String)"ap_finapbill");
        logger.info("InvoiceToFinApConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finApBill) {
        long billTypeId;
        Map<DynamicObject, DynamicObject> bizTypeToLineType;
        DynamicObject asstact;
        boolean isOnlyFromInv;
        Date termsDate;
        logger.info("InvoiceToFinApConvertPlugin.setHeadValue start");
        DynamicObject org = finApBill.getDynamicObject("org");
        InitServiceHelper.setBizDate((DynamicObject)finApBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (ConvertRuleElement)this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting((ConvertRuleElement)this.getRule(), (boolean)true, (String)"exchangerate");
        InitServiceHelper.setInitValue((DynamicObject)finApBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (boolean)isSettingForExchange);
        DynamicObject payorg = finApBill.getDynamicObject("payorg");
        if (!ObjectUtils.isEmpty((Object)payorg) && !payorg.getBoolean("fisbankroll")) {
            finApBill.set("payorg", null);
        }
        if ((termsDate = finApBill.getDate("termsdate")) == null) {
            Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)finApBill);
            finApBill.set("termsdate", (Object)basicDate);
        }
        Long asstactId = finApBill.getLong("asstact.id");
        DynamicObject supplier = this.supplierMap.get(asstactId);
        Long invId = finApBill.getLong("sourcebillid");
        List<Long> busIds = this.invoiceIdToBusIdsMap.get(invId);
        boolean bl = isOnlyFromInv = busIds == null && "ap_invoice".equals(finApBill.getString("sourcebilltype"));
        if (supplier != null && isOnlyFromInv) {
            DynamicObject recSupplierId = supplier.getDynamicObject("receivingsupplierid");
            finApBill.set("receivingsupplierid", (Object)recSupplierId);
        }
        if ((asstact = finApBill.getDynamicObject("asstact")) == null && "pm_purorderbill".equals(finApBill.getString("sourcebilltype"))) {
            asstact = this.purOrderBillIdToSupplierMap.get(finApBill.getLong("sourcebillid"));
            finApBill.set("asstact", (Object)asstact);
        }
        String asstactType = finApBill.getString("asstacttype");
        if (ObjectUtils.isEmpty((Object)finApBill.get("paymentcurrency")) && !"bd_supplier".equals(asstactType)) {
            finApBill.set("paymentcurrency", (Object)finApBill.getDynamicObject("currency"));
        } else if (asstact != null) {
            supplier = this.supplierMap.get(asstact.getLong("id"));
            if (ObjectUtils.isEmpty((Object)finApBill.get("paymentcurrency"))) {
                DynamicObject paymentCurrency = supplier.getDynamicObject("paymentcurrency");
                if (ObjectUtils.isEmpty((Object)paymentCurrency)) {
                    finApBill.set("paymentcurrency", (Object)finApBill.getDynamicObject("currency"));
                } else {
                    finApBill.set("paymentcurrency", (Object)paymentCurrency);
                }
            }
            if (ObjectUtils.isEmpty((Object)finApBill.get("payeebanknum"))) {
                HashMap<String, String> accountBankInfo = new HashMap<String, String>(2);
                DynamicObjectCollection bankColls = supplier.getDynamicObjectCollection("entry_bank");
                for (DynamicObject bankInfo : bankColls) {
                    if (!accountBankInfo.isEmpty() && !bankInfo.getBoolean("isdefault_bank")) continue;
                    accountBankInfo.put("accountStr", bankInfo.getString("bankaccount"));
                    accountBankInfo.put("bebank", (String)bankInfo.getDynamicObject("bank"));
                }
                if (!accountBankInfo.isEmpty()) {
                    finApBill.set("payeebanknum", accountBankInfo.get("accountStr"));
                    finApBill.set("bebank", accountBankInfo.get("bebank"));
                }
            }
        }
        Boolean isEnableLineType = (Boolean)this.orgIsEnableLineTypeMap.get(org.getLong("id"));
        if (isEnableLineType.booleanValue() && (bizTypeToLineType = this.billTypeToBizTypeMap.get(billTypeId = finApBill.getLong("billtypeid.id"))) != null) {
            for (Map.Entry<DynamicObject, DynamicObject> entry : bizTypeToLineType.entrySet()) {
                finApBill.set("biztype", (Object)entry.getKey());
            }
        }
        logger.info("InvoiceToFinApConvertPlugin.setHeadValue end");
    }

    private void setDetailEntryValue(DynamicObject finApBill) {
        logger.info("InvoiceToFinApConvertPlugin.setDetailEntryValue start");
        this.calculateDetailEntry(finApBill);
        this.setDetailEntryOtherValue(finApBill);
        if (this.isPushAndSave(finApBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finApBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finArDetailEntries = new ArrayList(8);
                finArDetailEntries.addAll(finApBill.getDynamicObjectCollection("detailentry"));
                this.detailEntriesCache.put(finApBill.getLong("id"), finArDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finApBill.getDynamicObjectCollection("detailentry"));
            }
        }
        logger.info("InvoiceToFinApConvertPlugin.setDetailEntryValue end");
    }

    private void setInvoiceEntryValue(DynamicObject finApBill) {
        logger.info("InvoiceToFinApConvertPlugin.setInvoiceEntryValue start");
        for (DynamicObject invRow : finApBill.getDynamicObjectCollection("inventry")) {
            DynamicObject invoice = this.invoiceBillMap.get(invRow.getLong("invid"));
            invRow.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate(invoice));
        }
        logger.info("InvoiceToFinApConvertPlugin.setInvoiceEntryValue end");
    }

    private void setHeadAmtValue(DynamicObject finApBill) {
        logger.info("InvoiceToFinApConvertPlugin.setHeadAmtValue start");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        BigDecimal unInvoiceAmt = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finApBill) ? this.detailEntriesCache.get(finApBill.getLong("id")) : finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_pricetaxtotal"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_pricetaxtotalbase"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_amountbase"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
            unInvoiceAmt = unInvoiceAmt.add(detailEntry.getBigDecimal("e_uninvoicedamt"));
        }
        finApBill.set("pricetaxtotal", (Object)priceTaxTotal);
        finApBill.set("pricetaxtotalbase", (Object)priceTaxTotalBase);
        finApBill.set("amount", (Object)amount);
        finApBill.set("amountbase", (Object)amountBase);
        finApBill.set("tax", (Object)tax);
        finApBill.set("taxlocamt", (Object)taxLocAmt);
        finApBill.set("uninvoicedamt", (Object)unInvoiceAmt);
        finApBill.set("unverifyamount", (Object)amount);
        finApBill.set("unsettleamount", (Object)priceTaxTotal);
        finApBill.set("unsettleamountbase", (Object)priceTaxTotalBase);
        finApBill.set("adjustamount", (Object)adjustamt);
        finApBill.set("adjustlocalamt", (Object)adjustamtlocal);
        logger.info("InvoiceToFinApConvertPlugin.setHeadAmtValue end");
    }

    private void setPlanEntryValue(DynamicObject finApBill) {
        logger.info("InvoiceToFinApConvertPlugin.setPlanEntryValue start");
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finApBill, (DynamicObject[])this.needMatchSplitSchemes);
        finApBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finApBill)) {
            this.calculatePlanEntryByPushAndSave(finApBill, matchSplitScheme);
        } else {
            ApPlanSplitAndBuilder.splitAndBuild((DynamicObject)finApBill, (DynamicObject)matchSplitScheme);
        }
        this.setHeadDueDate(finApBill);
        logger.info("InvoiceToFinApConvertPlugin.setPlanEntryValue end");
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finApBill, DynamicObject matchSplitScheme) {
        DynamicObject[] dbFinApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBill.getLong("id"))});
        if (dbFinApBills == null || dbFinApBills.length == 0) {
            ApPlanSplitAndBuilder.splitAndBuild((DynamicObject)finApBill, (DynamicObject)matchSplitScheme);
        } else {
            DynamicObject dbFinApBill = dbFinApBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finApBill.getLong("id"));
            Map detailEntryIndexToSplitDimensionId = ApPlanSplitAndBuilder.splitAndBuildByPushAndSave((DynamicObject)finApBill, detailEntries, (DynamicObject)matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFinApBill.getDynamicObjectCollection("detailentry");
            DynamicObjectCollection curDetailEntries = finApBill.getDynamicObjectCollection("detailentry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFinApBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFinApBill});
        }
    }

    private void setHeadDueDate(DynamicObject finApBill) {
        Date planMaxDuedate = finApBill.getDate("duedate");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finApBill.set("duedate", (Object)planMaxDuedate);
    }

    private void setDetailEntryOtherValue(DynamicObject finApBill) {
        long billTypeId = finApBill.getLong("billtypeid.id");
        Map<DynamicObject, DynamicObject> bizTypeToLineType = this.billTypeToBizTypeMap.get(billTypeId);
        Long asstactId = finApBill.getLong("asstact.id");
        DynamicObject supplier = this.supplierMap.get(asstactId);
        Long invId = finApBill.getLong("sourcebillid");
        List<Long> busIds = this.invoiceIdToBusIdsMap.get(invId);
        boolean isOnlyFromInv = busIds == null && "ap_invoice".equals(finApBill.getString("sourcebilltype"));
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            if (supplier != null && isOnlyFromInv) {
                DynamicObject invSupplierid = supplier.getDynamicObject("invoicesupplierid");
                DynamicObject delSupplierid = supplier.getDynamicObject("deliversupplierid");
                detailEntry.set("e_invoicesupplierid", (Object)invSupplierid);
                detailEntry.set("e_deliversupplierid", (Object)delSupplierid);
            }
            if (bizTypeToLineType == null) continue;
            for (Map.Entry<DynamicObject, DynamicObject> bizTypeToLineTypeEntrySet : bizTypeToLineType.entrySet()) {
                DynamicObject lineType = detailEntry.getDynamicObject("linetype");
                if (!ObjectUtils.isEmpty((Object)lineType)) continue;
                detailEntry.set("linetype", (Object)bizTypeToLineTypeEntrySet.getValue());
            }
        }
    }

    private void calculateDetailEntry(DynamicObject finApBill) {
        String quotation = finApBill.getString("quotation");
        boolean includeTax = finApBill.getBoolean("isincludetax");
        int baseprecision = finApBill.getInt("basecurrency.amtprecision");
        int precision = finApBill.getInt("currency.amtprecision");
        BigDecimal exchangeRate = finApBill.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0 && "1".equals(quotation)) {
            quotation = "0";
        }
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal e_baseunitqty;
            BigDecimal covertRate;
            PriceTaxTotalCalculator calculator;
            BigDecimal discountAmt;
            boolean isPresent = detailEntry.getBoolean("ispresent");
            BigDecimal price = detailEntry.getBigDecimal("price");
            BigDecimal priceTax = detailEntry.getBigDecimal("pricetax");
            boolean isPriceTotal = finApBill.getBoolean("ispricetotal");
            if (isPriceTotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                BigDecimal e_baseunitqty2;
                BigDecimal covertRate2;
                BigDecimal quantity = detailEntry.getBigDecimal("quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                boolean covertRateIsEmpty = (covertRate2 = detailEntry.getBigDecimal("e_unitconvertrate")) == null || covertRate2.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = detailEntry.getDynamicObject("material");
                DynamicObject measureUnit = detailEntry.getDynamicObject("measureunit");
                DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        detailEntry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate2 = this.queryUtil.getConvertRate(Long.valueOf(material.getLong("id")), Long.valueOf(measureUnit.getLong("id")), Long.valueOf(baseUnit.getLong("id")));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate2 = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    detailEntry.set("e_unitconvertrate", (Object)covertRate2);
                }
                if ((e_baseunitqty2 = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty2.compareTo(BigDecimal.ZERO) == 0) {
                    e_baseunitqty2 = InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate2, (DynamicObject)baseUnit);
                    detailEntry.set("e_baseunitqty", (Object)e_baseunitqty2);
                }
                detailEntry.set("unverifyquantity", (Object)quantity);
                detailEntry.set("e_unverifybaseqty", (Object)e_baseunitqty2);
                continue;
            }
            BigDecimal qty = (BigDecimal)detailEntry.get("quantity");
            BigDecimal taxRate = (BigDecimal)detailEntry.get("taxrate");
            String discountMode = (String)detailEntry.get("discountmode");
            BigDecimal discountRate = (BigDecimal)detailEntry.get("discountrate");
            BigDecimal e_adjustamount = detailEntry.getBigDecimal("e_adjustamount");
            BigDecimal e_pricetaxtotal = (BigDecimal)detailEntry.get("e_pricetaxtotal");
            BigDecimal e_amount = (BigDecimal)detailEntry.get("e_amount");
            BigDecimal e_tax = (BigDecimal)detailEntry.get("e_tax");
            if (includeTax) {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    detailEntry.set("discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                }
                discountAmt = detailEntry.getBigDecimal("discountamount");
                calculator = new PriceTaxTotalCalculator(qty, e_pricetaxtotal, taxRate, discountMode, discountRate, precision, e_adjustamount, discountAmt);
            } else {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    detailEntry.set("discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                }
                discountAmt = detailEntry.getBigDecimal("discountamount");
                BigDecimal unitPrice = (BigDecimal)detailEntry.get("price");
                calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, e_adjustamount, discountAmt);
            }
            calculator.setPricetaxtotal(e_pricetaxtotal);
            calculator.setAmount(e_amount);
            calculator.setTax(e_tax);
            if (detailEntry.getBigDecimal("price").compareTo(BigDecimal.ZERO) == 0 || detailEntry.getBigDecimal("e_pricetaxtotal").compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("ispresent", (Object)Boolean.TRUE);
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, baseprecision, false, quotation);
            localCalculator.calculate();
            BigDecimal e_taxlocamt = localCalculator.getTaxlocal();
            BigDecimal e_amountbase = localCalculator.getAmountlocal();
            BigDecimal e_pricetaxtotalbase = localCalculator.getPricetaxtotallocal();
            detailEntry.set("e_amountbase", (Object)e_amountbase);
            detailEntry.set("e_taxlocalamt", (Object)e_taxlocamt);
            detailEntry.set("unlockamt", (Object)e_pricetaxtotal);
            detailEntry.set("unsettleamt", (Object)e_pricetaxtotal);
            detailEntry.set("e_invoicedamt", (Object)e_pricetaxtotal);
            detailEntry.set("e_unverifyamount", (Object)e_amount);
            detailEntry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
            detailEntry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_adjustamount", (Object)localCalculator.getAdjustamt());
            detailEntry.set("e_adjustlocalamt", (Object)localCalculator.getAdjustamt());
            detailEntry.set("e_expensebillids_tag", (Object)detailEntry.getString("e_expensebillids"));
            detailEntry.set("e_expensebillids", (Object)"");
            BigDecimal quantity = detailEntry.getBigDecimal("quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            boolean covertRateIsEmpty = (covertRate = detailEntry.getBigDecimal("e_unitconvertrate")) == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
            DynamicObject material = detailEntry.getDynamicObject("material");
            DynamicObject measureUnit = detailEntry.getDynamicObject("measureunit");
            DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    detailEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRateIsEmpty) {
                    covertRate = this.queryUtil.getConvertRate(Long.valueOf(material.getLong("id")), Long.valueOf(measureUnit.getLong("id")), Long.valueOf(baseUnit.getLong("id")));
                }
            } else if (covertRateIsEmpty) {
                covertRate = BigDecimal.ONE;
            }
            if (covertRateIsEmpty) {
                detailEntry.set("e_unitconvertrate", (Object)covertRate);
            }
            if ((e_baseunitqty = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                e_baseunitqty = InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit);
                detailEntry.set("e_baseunitqty", (Object)e_baseunitqty);
            }
            detailEntry.set("unverifyquantity", (Object)quantity);
            detailEntry.set("e_unverifybaseqty", (Object)e_baseunitqty);
        }
    }

    private boolean isPushAndSave(DynamicObject finApBill) {
        return BOTPHelper.isPushAndSave((ConvertRuleElement)this.getRule(), (DynamicObject)finApBill);
    }
}

