/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class ApHelper {
    public static boolean isEmpty(Object o) {
        if (o instanceof String) {
            return o == null || o.toString().trim().length() == 0;
        }
        if (o instanceof Long) {
            return o == null || (Long)o == 0L;
        }
        if (o instanceof BigDecimal) {
            return o == null || ((BigDecimal)o).compareTo(BigDecimal.ZERO) == 0;
        }
        return o == null;
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(ApHelper.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    public static String idListToInClause(List<Long> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append(idList.get(0));
        } else {
            Iterator<Long> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append(it.next()).append(", ");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static List<String> getIdList(DynamicObject[] infos) {
        ArrayList<String> idList = new ArrayList<String>(infos.length);
        for (DynamicObject info : infos) {
            idList.add(info.getPkValue().toString());
        }
        return idList;
    }

    public static List<Object> getIdList(DynamicObjectCollection objs) {
        ArrayList<Object> pks = new ArrayList<Object>();
        if (objs != null && objs.size() > 0) {
            for (DynamicObject obj : objs) {
                pks.add(obj.getPkValue());
            }
        }
        return pks;
    }

    public static List<Object> getIdList4MultiBase(DynamicObjectCollection objs) {
        ArrayList<Object> pks = new ArrayList<Object>();
        if (objs != null && objs.size() > 0) {
            for (DynamicObject obj : objs) {
                pks.add(obj.getDynamicObject("fbasedataid").getPkValue());
            }
        }
        return pks;
    }
}

