/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class DisPurBillHelper {
    private static final Log logger = LogFactory.getLog(DisPurBillHelper.class);

    public static void disposepmByBotp(DynamicObject appBill, boolean isclose) {
        DynamicObjectCollection collection = appBill.getDynamicObjectCollection("entry");
        ArrayList disposeData = new ArrayList();
        for (DynamicObject entry : collection) {
            BigDecimal paysettamt = entry.getBigDecimal("e_paidamt").multiply(appBill.getBigDecimal("exchangerate"));
            BigDecimal joinamount = paysettamt.subtract(entry.getBigDecimal("e_approvedseleamt"));
            if (joinamount.compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, Number> disposeRowInfo = new HashMap<String, Number>();
            disposeRowInfo.put("mainbillid", entry.getLong("e_corebillid"));
            disposeRowInfo.put("mainbillentryid", entry.getLong("e_corebillentryid"));
            if (!isclose) {
                joinamount = joinamount.negate();
            }
            disposeRowInfo.put("joinamount", joinamount);
            disposeData.add(disposeRowInfo);
        }
        if (!ObjectUtils.isEmpty(disposeData)) {
            DisPurBillHelper.invoke("scmc", "pm", "PurService", "WbJoinAmount", disposeData);
        }
    }

    protected static <T> T invoke(String cloud, String app, String service, String method, Object ... params) {
        if (!"fi".equals(cloud)) {
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"payinvokeScmc");){
                Object object = DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)service, (String)method, (Object[])params);
                return (T)object;
            }
            catch (Exception e) {
                try {
                    tx.markRollback();
                    logger.error("context", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return (T)DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)service, (String)method, (Object[])params);
    }
}

