/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.ap.vo.CheckResult;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class WriteoffVerify {
    private static final String WRITE_OFF_PROS = "billstatus, billno,ispremium, settlestatus, iswrittenoff, verifystatus, detailentry, lockedamt, settledamt, org, planentity, planlockedamt, plansettledamt, inventry.i_srctype,billsrctype";

    public static CheckResult check(Object[] pks) {
        CheckResult result = new CheckResult();
        if (ObjectUtils.isEmpty((Object[])pks)) {
            result.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteoffVerify_10", (String)"fi-ap-common", (Object[])new Object[0]));
            result.setIspass(false);
            return result;
        }
        ArrayList<String> billIds4Msmod = new ArrayList<String>(pks.length);
        ArrayList<String> billIds = new ArrayList<String>(pks.length);
        for (Object pk2 : pks) {
            billIds.add(pk2.toString());
            billIds4Msmod.add("ap_finapbill#" + pk2.toString());
        }
        List unFinishedIds = TxCheckUtil.loadUnfinishedTx((String)"ap_verify", billIds);
        List unFinishedIds4Msmod = TxCheckUtil.getLocked(billIds4Msmod);
        HashMap<Long, Integer> settleModelParam = new HashMap<Long, Integer>(2);
        Set<Long> pkSet = Stream.of(pks).map(pk -> (Long)pk).collect(Collectors.toSet());
        Map dirtTargetBillMap = BOTPHelper.findDirtTargetBillMap((String)"ap_finapbill", (Long[])pkSet.toArray(new Long[0]));
        QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        qFilter.and("sourcebillid", "in", (Object)pks);
        QFilter tanspayFilter = new QFilter("istanspay", "=", (Object)Boolean.TRUE);
        DynamicObject[] tanspayBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"sourcebillid", (QFilter[])new QFilter[]{qFilter, tanspayFilter});
        Set isTanspayPks = Stream.of(tanspayBills).map(tanspayBill -> tanspayBill.getLong("sourcebillid")).collect(Collectors.toSet());
        QFilter premiumFilter = new QFilter("ispremium", "=", (Object)Boolean.TRUE);
        DynamicObject[] premiumBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"sourcebillid,detailentry.lockedamt,detailentry.settledamt", (QFilter[])new QFilter[]{qFilter, premiumFilter});
        Map<Long, List<DynamicObject>> premiumBillsMap = Stream.of(premiumBills).collect(Collectors.groupingBy(premiumBill -> premiumBill.getLong("sourcebillid")));
        List<Long> hadRevalSrcBusIds = WriteoffVerify.getHadRevalPurBill(pks);
        QFilter qf = new QFilter("id", "in", (Object)pks);
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)WRITE_OFF_PROS, (QFilter[])new QFilter[]{qf});
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> finApBillIds = new ArrayList<Long>(32);
        for (DynamicObject finApBill : finApBills) {
            orgIds.add(finApBill.getLong("org.id"));
            finApBillIds.add(finApBill.getLong("id"));
        }
        Map<Long, Set<Long>> onTheWayBillIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds("ap_finapbill", orgIds, finApBillIds);
        for (DynamicObject finApBill : finApBills) {
            long finPK;
            Map targetBills;
            BigDecimal settledAmt;
            BigDecimal lockedAmt;
            String billno = finApBill.getString("billno");
            billno = billno + ":";
            Long billId = finApBill.getLong("id");
            if (BillSrcTypeEnum.FROMEAS.getValue().equals(finApBill.getString("billsrctype"))) {
                result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%1$s\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u4e3aEAS\u96c6\u6210\u65b9\u6848\u540c\u6b65\u7684\u5355\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_12", (String)"fi-ap-common", (Object[])new Object[0]), finApBill.getString("billno")));
                result.setIspass(false);
                return result;
            }
            String writeOffCheckMessage = FinApBillHelper.getWriteOffCheckMessage(finApBill);
            if (EmptyUtils.isNotEmpty((Object)writeOffCheckMessage)) {
                result.setMessage(writeOffCheckMessage);
                result.setIspass(false);
                return result;
            }
            if (unFinishedIds.contains(String.valueOf(billId)) || unFinishedIds4Msmod.contains("ap_finapbill#" + billId)) {
                result.setMessage(ResManager.loadKDStringExt((String)"%s\u5b58\u5728\u672a\u5b8c\u6210\u7684\u6838\u9500\u5206\u5e03\u5f0f\u4e8b\u52a1\uff0c\u4e0d\u80fd\u51b2\u9500\uff0c\u8bf7\u901a\u8fc7\u201c\u8054\u67e5>\u8054\u67e5\u4e8b\u52a1\u65e5\u5fd7\u201d\u529f\u80fd\u67e5\u770b\u5bf9\u5e94\u7684\u4fe1\u606f\u6216\u5728\u201c\u914d\u7f6e\u5de5\u5177>\u5206\u5e03\u5f0f\u4e8b\u52a1>\u4e8b\u52a1\u67e5\u8be2\u201d\u83dc\u5355\u67e5\u770b\u76f8\u5173\u4fe1\u606f\u3002", (String)"WriteoffVerify_9", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (hadRevalSrcBusIds.contains(billId)) {
                result.setMessage(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s \u5bf9\u5e94\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u5df2\u91cd\u4f30\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_8", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(finApBill.getString("billstatus"))) {
                result.setMessage(ResManager.loadKDString((String)"%s\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u5ba1\u6838\u540e\u91cd\u8bd5\u3002", (String)"WriteoffVerify_0", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (finApBill.getBoolean("ispremium")) {
                result.setMessage(ResManager.loadKDString((String)"%s\u8d28\u4fdd\u91d1\u5355\u636e\u65e0\u6cd5\u51b2\u9500\u3002", (String)"WriteoffVerify_1", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (finApBill.getBoolean("iswrittenoff")) {
                result.setMessage(ResManager.loadKDString((String)"%s\u51b2\u9500\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u51b2\u9500\u3002", (String)"WriteoffVerify_2", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (onTheWayBillIdsMap.containsKey(billId)) {
                result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u64cd\u4f5c\u5931\u8d25\u3002\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6362\u7968\u8bb0\u5f55\uff0c\u8bf7\u901a\u8fc7\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u8bb0\u5f55\u540e\u91cd\u8bd5\u3002", (String)"WriteoffVerify_11", (String)"fi-ap-common", (Object[])new Object[0]), billno));
                result.setIspass(false);
                return result;
            }
            long orgId = finApBill.getDynamicObject("org").getLong("id");
            Integer ap003 = (Integer)settleModelParam.get(orgId);
            if (ap003 == null) {
                ap003 = SystemParameterHelper.getParameterInteger(orgId, "ap_003");
                settleModelParam.put(orgId, ap003);
            }
            if (1 == ap003) {
                DynamicObjectCollection entries = finApBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entries) {
                    lockedAmt = entry.getBigDecimal("lockedamt");
                    settledAmt = entry.getBigDecimal("settledamt");
                    if (lockedAmt == null || settledAmt == null || lockedAmt.compareTo(settledAmt) == 0) continue;
                    result.setMessage(ResManager.loadKDString((String)"%s\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"WriteoffVerify_4", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
            } else if (2 == ap003) {
                DynamicObjectCollection entries = finApBill.getDynamicObjectCollection("planentity");
                for (DynamicObject entry : entries) {
                    lockedAmt = entry.getBigDecimal("planlockedamt");
                    settledAmt = entry.getBigDecimal("plansettledamt");
                    if (lockedAmt == null || settledAmt == null || lockedAmt.compareTo(settledAmt) == 0) continue;
                    result.setMessage(ResManager.loadKDString((String)"%s\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"WriteoffVerify_4", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
            }
            if ((targetBills = (Map)dirtTargetBillMap.get(finPK = finApBill.getLong("id"))) == null) continue;
            Set keySet = targetBills.keySet();
            if (keySet.contains("ap_liquidation")) {
                result.setMessage(ResManager.loadKDString((String)"%s\u5355\u636e\u5df2\u8fdb\u884c\u8fc7\u6e05\u7406\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"WriteoffVerify_5", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (isTanspayPks.contains(finPK)) {
                result.setMessage(ResManager.loadKDString((String)"%s\u5355\u636e\u5df2\u8fdb\u884c\u8fc7\u8f6c\u4ed8\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"WriteoffVerify_6", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            List<DynamicObject> finprems = premiumBillsMap.get(finPK);
            if (EmptyUtils.isEmpty(finprems)) continue;
            for (DynamicObject finprem : finprems) {
                DynamicObjectCollection prmentries = finprem.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : prmentries) {
                    BigDecimal lockedAmt2 = entry.getBigDecimal("lockedamt");
                    BigDecimal settledAmt2 = entry.getBigDecimal("settledamt");
                    if (lockedAmt2 == null || settledAmt2 == null || lockedAmt2.compareTo(settledAmt2) == 0) continue;
                    result.setMessage(ResManager.loadKDString((String)"%s\u4e0b\u6e38\u8d28\u4fdd\u91d1\u5355\u636e\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"WriteoffVerify_7", (String)"fi-ap-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
            }
        }
        return result;
    }

    private static List<Long> getHadRevalPurBill(Object[] pks) {
        ArrayList<Long> hadSrcRevalBusIds = new ArrayList<Long>(pks.length);
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno,sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        ArrayList<Long> directSrcBusIds = new ArrayList<Long>(2);
        ArrayList<Long> sameSrcFinIds = new ArrayList<Long>(2);
        for (DynamicObject bill : finApBills) {
            String srcType = bill.getString("sourcebilltype");
            if ("ap_busbill".equals(srcType)) {
                directSrcBusIds.add(bill.getLong("sourcebillid"));
                continue;
            }
            sameSrcFinIds.add(bill.getLong("id"));
        }
        if (directSrcBusIds.size() > 0) {
            DynamicObjectCollection hadRevalBusBill = QueryServiceHelper.query((String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", directSrcBusIds), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)});
            List hadRevalBusIds = hadRevalBusBill.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            for (Iterator bill : finApBills) {
                String billNo = bill.getString("billno");
                Long sourcebillId = bill.getLong("sourcebillid");
                if (!hadRevalBusIds.contains(sourcebillId)) continue;
                hadSrcRevalBusIds.add(bill.getLong("id"));
            }
        }
        if (sameSrcFinIds.size() > 0) {
            DynamicObjectCollection sameWoffBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,srcfinbillid,sourcebillid", (QFilter[])new QFilter[]{new QFilter("srcfinbillid", "in", sameSrcFinIds)});
            HashMap<Long, Long> sameSrcFinToBusIdMap = new HashMap<Long, Long>(2);
            ArrayList<Long> srcBusIds = new ArrayList<Long>(sameSrcFinIds.size());
            for (DynamicObject woffBill : sameWoffBills) {
                Long srcBusId = Long.valueOf(woffBill.getString("sourcebillid"));
                sameSrcFinToBusIdMap.put(woffBill.getLong("srcfinbillid"), srcBusId);
                srcBusIds.add(srcBusId);
            }
            if (srcBusIds.size() > 0) {
                DynamicObjectCollection hadRevalSameSrcBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIds), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)});
                if (hadRevalSameSrcBills == null || hadRevalSameSrcBills.size() == 0) {
                    return hadSrcRevalBusIds;
                }
                List hadRevalBillIds = hadRevalSameSrcBills.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                for (Map.Entry entrySet : sameSrcFinToBusIdMap.entrySet()) {
                    if (!hadRevalBillIds.contains(entrySet.getValue())) continue;
                    hadSrcRevalBusIds.add((Long)entrySet.getKey());
                }
            }
        }
        return hadSrcRevalBusIds;
    }
}

