/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.piaozone;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.enums.PZInvTypeEnum;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceItemVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.enums.BillOperationEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.DiscountModeEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.vo.InvoiceMatchVo;

@Deprecated
public class InvoiceCloudHelper {
    private static final Log logger = LogFactory.getLog(InvoiceCloudHelper.class);
    private MainEntityType dt;
    private Date currentDate = new Date();
    private long userID;
    private long orgPk;
    private String bizType;
    private Long pk;
    private Map<String, Long> serialnoMap;
    private boolean isSrcCollect = false;
    private boolean isSaveEntry = false;
    private String asstActType;
    private DynamicObject asstAct;
    private String appId = "ap";
    public static String selectors = "id,billstatus,sourcebillid,asstact,inventry.invid,inventry.i_usedamt,inventry.i_billno,inventry.i_invoicetype,inventry.i_invoicetypef7,inventry.i_invoicecode,inventry.i_invoiceno,inventry.i_invoicedate,inventry.i_pricetaxtotal,inventry.i_taxrate,inventry.i_tax,inventry.i_amount,inventry.i_asstactname,inventry.i_buyername,inventry.i_istaxdeduction,inventry.i_remark,inventry.i_srctype,inventry.i_issupplement,inventry.i_serialno,inventry.i_canuseamt,inventry.i_currency,inventry.i_invoicestatus,org,invoicebiztype,istaxdeduction,iswrittenoff,ispremium,istanspay,e_amountbase,taxrate,e_farmproducts,e_pricetaxtotalbase,deductiblerate,basecurrency,curdeductibleamt,intercostamt";

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public InvoiceCloudHelper(long orgPk, String bizType) {
        this.orgPk = orgPk;
        this.bizType = bizType;
        logger.info("------param------ orgPk=" + orgPk + " ,bizType=" + bizType);
        this.dt = EntityMetadataCache.getDataEntityType((String)"ap_invoice");
        this.userID = RequestContext.get().getCurrUserId();
    }

    public InvoiceCloudHelper(long orgPk, String bizType, Long pk) {
        this.orgPk = orgPk;
        this.bizType = bizType;
        this.pk = pk;
        logger.info("------param------ orgPk=" + orgPk + " ,bizType=" + bizType + " ,pk=" + pk);
        this.dt = EntityMetadataCache.getDataEntityType((String)"ap_invoice");
        this.userID = RequestContext.get().getCurrUserId();
    }

    public InvoiceCloudHelper(long orgPk, String bizType, boolean isSaveEntry, Map<String, Long> serialnoMap, String asstActType, DynamicObject asstAct, boolean isSrcCollect) {
        this.orgPk = orgPk;
        this.bizType = bizType;
        this.serialnoMap = serialnoMap;
        this.isSaveEntry = isSaveEntry;
        this.asstActType = asstActType;
        this.asstAct = asstAct;
        this.isSrcCollect = isSrcCollect;
        logger.info("------param------ orgPk=" + orgPk + " ,bizType=" + bizType + " ,serialnoMap=" + serialnoMap);
        this.dt = EntityMetadataCache.getDataEntityType((String)"ap_invoice");
        this.userID = RequestContext.get().getCurrUserId();
    }

    @Deprecated
    public List<DynamicObject> genInvoice(List<InvoiceVO> vos) {
        return this.genInvoice(vos, null);
    }

    @Deprecated
    public List<DynamicObject> genInvoice(List<InvoiceVO> vos, String source) {
        List serialList = vos.stream().map(InvoiceVO::getSerialNo).collect(Collectors.toList());
        QFilter qf = new QFilter("serialno", "in", serialList);
        DynamicObjectCollection existsInvs = QueryServiceHelper.query((String)"ap_invoice", (String)"invoicecode, invoiceno, serialno", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)existsInvs)) {
            List existsList = existsInvs.stream().map(inv -> inv.getString("serialno")).collect(Collectors.toList());
            vos.removeIf(inv -> existsList.contains(inv.getSerialNo()));
        }
        ArrayList<DynamicObject> invoices = new ArrayList<DynamicObject>();
        if (!vos.isEmpty()) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgPk, (String)"bos_org", (String)"id, number, name");
            DynamicObject newBill = BusinessDataServiceHelper.newDynamicObject((String)"ap_invoice");
            if (!CodeRuleServiceHelper.isExist((String)"ap_invoice", (DynamicObject)newBill, (String)org.getPkValue().toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u6536\u7968\u5355\u7f16\u7801\u89c4\u5219\u518d\u8fdb\u884c\u91c7\u96c6\u53d1\u7968\u3002", (String)"InvoiceCloudHelper_0", (String)"fi-ap-common", (Object[])new Object[0]));
            }
            for (InvoiceVO vo : vos) {
                invoices.add(this.buildInvoice(org, vo));
            }
            CodeRuleServiceHelper.injectNumbers((String)"ap_invoice", invoices);
            if (this.pk != null) {
                ((DynamicObject)invoices.get(0)).set("id", (Object)this.pk);
            }
            if (this.serialnoMap != null) {
                for (DynamicObject invoice : invoices) {
                    String serialno = invoice.getString("serialno");
                    Long pk = this.serialnoMap.get(serialno);
                    if (pk == null) continue;
                    invoice.set("id", (Object)pk);
                }
            }
            if (!this.isSaveEntry) {
                boolean operationPermission = OperationUtils.hasOperationPermission((String)this.appId, (String)"ap_invoice", (BillOperationEnum)BillOperationEnum.SAVE);
                if (operationPermission) {
                    OperateOption option = OperateOption.create();
                    if (source != null) {
                        option.setVariableValue("source", source);
                    }
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_invoice", (DynamicObject[])invoices.toArray(new DynamicObject[0]), (OperateOption)option);
                    logger.info("---result.success---" + result.isSuccess());
                    OperationHelper.assertResult((OperationResult)result);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6536\u7968\u5355\u7684\u4fdd\u5b58\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceCloudHelper_1", (String)"fi-ap-common", (Object[])new Object[0]));
                }
            }
        }
        return invoices;
    }

    public DynamicObject buildInvoice(DynamicObject org, InvoiceVO vo) {
        DynamicObject inv = new DynamicObject((DynamicObjectType)this.dt);
        inv.set("creator", (Object)this.userID);
        inv.set("createtime", (Object)this.currentDate);
        inv.set("modifier", (Object)this.userID);
        inv.set("modifytime", (Object)this.currentDate);
        inv.set("org", (Object)org);
        Long currencyId = vo.getCurrencyId();
        DynamicObject currency = !ObjectUtils.isEmpty((Object)currencyId) && currencyId != 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency") : BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bd_currency");
        inv.set("currency", (Object)currency);
        Date invoiceDate = vo.getInvoiceDate();
        InitHelper init = new InitHelper(this.orgPk, "ap_init");
        DynamicObject basecurrency = init.getStandardCurrency();
        long srcCurrencyId = currency.getLong("id");
        long destCurrencyId = basecurrency.getLong("id");
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)invoiceDate);
        String quotation = isIndirect ? "1" : "0";
        int amtprecision = basecurrency.getInt("amtprecision");
        this.buildHeader(vo, inv, org);
        BigDecimal exchangerate = BigDecimal.ONE;
        if (!currency.getPkValue().equals(basecurrency.getPkValue()) && ObjectUtils.isEmpty((Object)(exchangerate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)invoiceDate)))) {
            isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)invoiceDate);
            quotation = isIndirect ? "1" : "0";
            exchangerate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)new Date());
        }
        Map<String, DynamicObject> entryMap = this.getMapperMap(vo.getSalerTaxNo());
        DynamicObjectCollection entries = inv.getDynamicObjectCollection("entry");
        EntryProp prop = (EntryProp)this.dt.findProperty("entry");
        DynamicObjectType entryDT = prop.getDynamicCollectionItemPropertyType();
        List<InvoiceItemVO> mergeItems = this.getMergeItems(vo.getItems());
        if (mergeItems != null && !mergeItems.isEmpty()) {
            for (int i = 0; i < mergeItems.size(); ++i) {
                InvoiceItemVO item = mergeItems.get(i);
                DynamicObject entry = this.buildEntry(entryDT, item, entryMap, exchangerate, amtprecision, quotation, i + 1);
                entries.add((Object)entry);
            }
        } else {
            entries.add((Object)this.buildEntry4Quota(entryDT, exchangerate, amtprecision, vo, quotation));
        }
        this.calculatorEntryAmt(inv, entries);
        return inv;
    }

    private void calculatorEntryAmt(DynamicObject inv, DynamicObjectCollection entries) {
        DynamicObject currency = inv.getDynamicObject("currency");
        int precision = currency.getInt("amtprecision");
        DynamicObject basecurrency = inv.getDynamicObject("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal rate = inv.getBigDecimal("exchangerate");
        PriceLocalCalculator localCalculator = null;
        PriceTaxTotalCalculator calculator = null;
        for (DynamicObject entry : entries) {
            BigDecimal qty = entry.getBigDecimal("quantity");
            BigDecimal taxRate = entry.getBigDecimal("taxrate");
            String discountMode = entry.getString("discountmode");
            BigDecimal discountRate = entry.getBigDecimal("discountrate");
            BigDecimal pricetaxtotal = entry.getBigDecimal("e_pricetaxtotal");
            calculator = new PriceTaxTotalCalculator(qty, pricetaxtotal, taxRate, discountMode, discountRate, precision);
            localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision);
            localCalculator.calculate();
            entry.set("actprice", (Object)localCalculator.getActunitprice());
            entry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
        }
    }

    private DynamicObject buildEntry4Quota(DynamicObjectType entryDT, BigDecimal exchangerate, int amtprecision, InvoiceVO vo, String quotation) {
        DynamicObject taxrateObj;
        BigDecimal taxRate;
        DynamicObject entry = new DynamicObject(entryDT);
        entry.set("seq", (Object)1);
        entry.set("e_invname", (Object)PZInvTypeEnum.getName(vo.getInvoiceType()));
        BigDecimal amount = vo.getInvoiceAmount() != null ? vo.getInvoiceAmount() : (vo.getInvoiceMoney() != null ? vo.getInvoiceMoney() : vo.getAmount());
        BigDecimal totalAmount = vo.getTotalAmount();
        BigDecimal taxAmount = vo.getTaxAmount() != null ? vo.getTaxAmount() : vo.getTotalTaxAmount();
        String invoiceType = (String)StringUtils.defaultIfEmpty((CharSequence)InvoiceType.getValue((String)vo.getInvoiceType()), (CharSequence)vo.getInvoiceType());
        if ("PLANE".equals(invoiceType) || "PAYLETTER".equals(invoiceType)) {
            amount = totalAmount.subtract(taxAmount);
        }
        if (amount == null && taxAmount == null) {
            amount = totalAmount;
            taxAmount = BigDecimal.ZERO;
        } else if (amount == null && taxAmount != null) {
            amount = totalAmount.subtract(taxAmount);
        } else {
            taxAmount = totalAmount.subtract(amount);
        }
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            entry.set("price", (Object)amount);
        } else {
            entry.set("price", (Object)amount.negate());
        }
        entry.set("e_amount", (Object)amount);
        entry.set("quantity", (Object)(amount.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ONE : BigDecimal.ONE.negate()));
        BigDecimal bigDecimal = taxRate = EmptyUtils.isNotEmpty((Object)vo.getTaxRate()) ? vo.getTaxRate().multiply(new BigDecimal(100)) : BigDecimal.ZERO;
        if (EmptyUtils.isNotEmpty((Object)amount) && amount.compareTo(BigDecimal.ZERO) > 0 && taxRate.compareTo(BigDecimal.ZERO) == 0) {
            taxRate = taxAmount.divide(amount, amtprecision, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        if (taxRate.compareTo(BigDecimal.ZERO) != 0 && !ObjectUtils.isEmpty((Object)(taxrateObj = BusinessDataServiceHelper.loadSingle((String)"bd_taxrate", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("taxrate", "=", (Object)taxRate)})))) {
            entry.set("taxrateid", (Object)taxrateObj);
        }
        entry.set("taxrate", (Object)taxRate);
        entry.set("e_tax", (Object)taxAmount);
        entry.set("e_pricetaxtotal", (Object)totalAmount);
        entry.set("e_unrelatedamt", (Object)totalAmount);
        entry.set("discountmode", (Object)DiscountModeEnum.NULL.getValue());
        if (exchangerate != null) {
            if ("0".equals(quotation)) {
                entry.set("e_pricetaxtotalbase", (Object)totalAmount.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
            } else {
                entry.set("e_pricetaxtotalbase", (Object)totalAmount.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
            }
        }
        return entry;
    }

    private Map<String, DynamicObject> getMapperMap(String taxNo) {
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
        String select = "entry.e_invname, entry.e_invspectype, entry.e_invunit, entry.e_material, entry.e_spectype, entry.e_measureunit, entry.e_expenseitem";
        QFilter qFilter = new QFilter("org", "=", (Object)this.orgPk);
        qFilter.and(new QFilter("number", "=", (Object)taxNo));
        DynamicObject mapper = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_invoicemapper", (String)select, (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object)mapper)) {
            DynamicObjectCollection entries = mapper.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                String key = entry.getString("e_invname") + entry.getString("e_invspectype") + entry.getString("e_invunit");
                entryMap.put(key.replaceAll(" ", ""), entry);
            }
        }
        return entryMap;
    }

    private DynamicObject buildEntry(DynamicObjectType entryDT, InvoiceItemVO item, Map<String, DynamicObject> entryMap, BigDecimal exchangerate, int amtprecision, String quotation, int seq) {
        DynamicObject taxclass;
        DynamicObject entry = new DynamicObject(entryDT);
        entry.set("seq", (Object)seq);
        entry.set("e_inventryseq", (Object)item.getSeq());
        entry.set("e_invname", (Object)item.getGoodsName());
        entry.set("e_invspectype", (Object)item.getSpecModel());
        entry.set("e_invunit", (Object)item.getUnit());
        String key = item.getGoodsName() + item.getSpecModel() + item.getUnit();
        if (entryMap.containsKey(key.replaceAll(" ", ""))) {
            DynamicObject mapperEntry = entryMap.get(key.replaceAll(" ", ""));
            if ("PUR".equals(this.bizType)) {
                entry.set("material", (Object)mapperEntry.getDynamicObject("e_material"));
                entry.set("spectype", mapperEntry.get("e_spectype"));
            } else {
                entry.set("expenseitem", (Object)mapperEntry.getDynamicObject("e_expenseitem"));
            }
            entry.set("measureunit", (Object)mapperEntry.getDynamicObject("e_measureunit"));
        }
        BigDecimal quantity = item.getNum();
        BigDecimal amount = item.getDetailAmount();
        if (EmptyUtils.isEmpty((Object)quantity) && EmptyUtils.isEmpty((Object)item.getUnitPrice())) {
            if (amount.compareTo(BigDecimal.ZERO) > 0) {
                entry.set("quantity", (Object)BigDecimal.ONE);
                entry.set("price", (Object)amount);
            } else {
                entry.set("quantity", (Object)BigDecimal.ONE.negate());
                entry.set("price", (Object)amount.negate());
            }
        } else {
            entry.set("quantity", (Object)(EmptyUtils.isEmpty((Object)quantity) ? (amount.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ONE : BigDecimal.ONE.negate()) : quantity));
            entry.set("price", (Object)(EmptyUtils.isEmpty((Object)item.getUnitPrice()) ? amount : item.getUnitPrice()));
        }
        entry.set("e_amount", (Object)amount);
        BigDecimal taxRate = item.getTaxRate().multiply(new BigDecimal(100));
        DynamicObject taxrateObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("taxrate", "=", (Object)taxRate)});
        if (!ObjectUtils.isEmpty((Object)taxrateObj)) {
            entry.set("taxrateid", (Object)taxrateObj);
        }
        entry.set("taxrate", (Object)taxRate);
        BigDecimal tax = item.getTaxAmount();
        entry.set("e_tax", (Object)tax);
        BigDecimal discountAmt = item.getDiscountAmt();
        if (!ObjectUtils.isEmpty((Object)discountAmt) && discountAmt.compareTo(BigDecimal.ZERO) != 0) {
            entry.set("discountamt", (Object)discountAmt);
            if (exchangerate != null) {
                if ("0".equals(quotation)) {
                    entry.set("discountlocalamt", (Object)discountAmt.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
                } else {
                    entry.set("discountlocalamt", (Object)discountAmt.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
                }
            }
            entry.set("discountmode", (Object)DiscountModeEnum.PERUNIT.getValue());
            BigDecimal discountrate = discountAmt.divide(entry.getBigDecimal("quantity").multiply(BigDecimal.ONE.add(item.getTaxRate())), 10, RoundingMode.HALF_UP);
            entry.set("discountrate", (Object)discountrate);
        } else {
            entry.set("discountmode", (Object)DiscountModeEnum.NULL.getValue());
        }
        BigDecimal pricetaxtotal = amount.add(tax);
        entry.set("e_pricetaxtotal", (Object)pricetaxtotal);
        entry.set("e_unrelatedamt", (Object)pricetaxtotal);
        if (exchangerate != null) {
            if ("0".equals(quotation)) {
                entry.set("e_pricetaxtotalbase", (Object)pricetaxtotal.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.multiply(exchangerate).setScale(amtprecision, RoundingMode.HALF_UP));
            } else {
                entry.set("e_pricetaxtotalbase", (Object)pricetaxtotal.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
                entry.set("e_amountbase", (Object)amount.divide(exchangerate, amtprecision, RoundingMode.HALF_UP));
            }
        }
        if (!ObjectUtils.isEmpty((Object)(taxclass = BusinessDataServiceHelper.loadSingleFromCache((String)"er_taxclasscode", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("mergecode", "=", (Object)item.getGoodsCode())})))) {
            entry.set("e_taxclass", (Object)taxclass);
        }
        return entry;
    }

    private List<InvoiceItemVO> getMergeItems(List<InvoiceItemVO> items) {
        ArrayList<InvoiceItemVO> mergeItems = new ArrayList();
        if (items != null && items.size() > 1) {
            int count = items.size();
            for (int i = 0; i < count; ++i) {
                InvoiceItemVO current = items.get(i);
                String discountType = current.getDiscountType();
                if ("2".equals(discountType)) {
                    int j = i + 1;
                    if (j >= count) continue;
                    InvoiceItemVO next = items.get(j);
                    InvoiceItemVO merge = this.buildMergeItem(current, next);
                    if (merge != null) {
                        mergeItems.add(merge);
                        ++i;
                        continue;
                    }
                    mergeItems.add(current);
                    continue;
                }
                if (discountType != null && !"0".equals(discountType)) continue;
                mergeItems.add(current);
            }
        } else {
            mergeItems = items;
        }
        return mergeItems;
    }

    private InvoiceItemVO buildMergeItem(InvoiceItemVO current, InvoiceItemVO next) {
        InvoiceItemVO merge = null;
        if ("1".equals(next.getDiscountType()) && current.getGoodsCode().equals(next.getGoodsCode())) {
            merge = current;
            merge.setDetailAmount(merge.getDetailAmount().add(next.getDetailAmount()));
            merge.setTaxAmount(merge.getTaxAmount().add(next.getTaxAmount()));
            merge.setDiscountAmt(next.getDetailAmount().add(next.getTaxAmount()).abs());
        }
        return merge;
    }

    private void buildHeader(InvoiceVO vo, DynamicObject inv, DynamicObject org) {
        String quotation;
        String buyerName;
        QFilter qfilter;
        Map buyerMap;
        inv.set("serialno", (Object)vo.getSerialNo());
        inv.set("invoicestatus", (Object)vo.getInvoiceStatus());
        inv.set("checkstatus", (Object)vo.getCheckStatus());
        inv.set("invoicecode", (Object)vo.getInvoiceCode());
        inv.set("invoiceno", (Object)vo.getInvoiceNo());
        Date invoiceDate = vo.getInvoiceDate();
        inv.set("issuedate", (Object)invoiceDate);
        inv.set("receivedate", (Object)new Date());
        inv.set("biztype", (Object)this.bizType);
        String invoiceType = (String)StringUtils.defaultIfEmpty((CharSequence)InvoiceType.getValue((String)vo.getInvoiceType()), (CharSequence)vo.getInvoiceType());
        inv.set("invoicetype", (Object)invoiceType);
        inv.set("invoicetypef7", (Object)InvoiceTypeHelper.getInvoiceTypePK((String)vo.getInvoiceType()));
        inv.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        inv.set("remark", (Object)StringUtils.trim((String)vo.getRemark()));
        if (InvoiceType.OVERSEAS.getValue().equals(invoiceType)) {
            inv.set("isincludetax", (Object)Boolean.FALSE);
        }
        if (!ObjectUtils.isEmpty((Object)(buyerMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{qfilter = new QFilter("name", "=", (Object)(buyerName = vo.getBuyerName()))})))) {
            inv.set("buyer", (Object)buyerMap.values().toArray(new DynamicObject[0])[0]);
        }
        inv.set("buyername", (Object)vo.getBuyerName());
        inv.set("buyertin", (Object)vo.getBuyerTaxNo());
        String buyerAddressPhone = vo.getBuyerAddressPhone();
        int max = InvoiceCloudHelper.getNumberMaxPosition(buyerAddressPhone, "-");
        if (max == -1) {
            inv.set("buyertel", (Object)buyerAddressPhone);
        } else {
            inv.set("buyeraddr", (Object)StringUtils.substring((String)buyerAddressPhone, (int)0, (int)(max + 1)));
            inv.set("buyertel", (Object)StringUtils.substring((String)buyerAddressPhone, (int)(max + 1)));
        }
        String buyerAccount = vo.getBuyerAccount();
        int max2 = InvoiceCloudHelper.getNumberMaxPosition(buyerAccount, null);
        if (max2 == -1) {
            inv.set("buyeracct", (Object)buyerAccount);
        } else {
            inv.set("buyerbank", (Object)StringUtils.substring((String)buyerAccount, (int)0, (int)(max2 + 1)));
            inv.set("buyeracct", (Object)StringUtils.substring((String)buyerAccount, (int)(max2 + 1)));
        }
        String salerTaxNo = vo.getSalerTaxNo();
        String salerName = vo.getSalerName();
        Map<String, Object> asstMap = this.getAsstact(salerTaxNo, salerName, invoiceType);
        if (asstMap != null) {
            inv.set("asstacttype", asstMap.get("asstActType"));
            inv.set("asstact", asstMap.get("asstAct"));
            inv.set("receivablessupp", asstMap.get("asstAct"));
            inv.set("receivablesacct", asstMap.get("acctBank"));
        } else {
            inv.set("asstacttype", (Object)"bd_supplier");
        }
        inv.set("asstactname", (Object)salerName);
        inv.set("sellertin", (Object)salerTaxNo);
        String salerAddressPhone = vo.getSalerAddressPhone();
        int s_max = InvoiceCloudHelper.getNumberMaxPosition(salerAddressPhone, "-");
        if (s_max == -1) {
            inv.set("sellertel", (Object)salerAddressPhone);
        } else {
            inv.set("selleraddr", (Object)StringUtils.substring((String)salerAddressPhone, (int)0, (int)(s_max + 1)));
            inv.set("sellertel", (Object)StringUtils.substring((String)salerAddressPhone, (int)(s_max + 1)));
        }
        String salerAccount = vo.getSalerAccount();
        int s_max2 = InvoiceCloudHelper.getNumberMaxPosition(salerAccount, null);
        if (s_max2 == -1) {
            inv.set("selleracct", (Object)salerAccount);
        } else {
            inv.set("sellerbank", (Object)StringUtils.substring((String)salerAccount, (int)0, (int)(s_max2 + 1)));
            inv.set("selleracct", (Object)StringUtils.substring((String)salerAccount, (int)(s_max2 + 1)));
        }
        InitHelper init = new InitHelper(this.orgPk, "ap_init");
        DynamicObject basecurrency = init.getStandardCurrency();
        inv.set("basecurrency", (Object)basecurrency);
        DynamicObject exratetable = init.getExrateTable();
        inv.set("exratetable", (Object)exratetable);
        inv.set("exratedate", (Object)invoiceDate);
        DynamicObject currency = inv.getDynamicObject("currency");
        long srcCurrencyId = (Long)currency.getPkValue();
        long destCurrencyId = (Long)basecurrency.getPkValue();
        BigDecimal exchangeRate = BigDecimal.ONE;
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)invoiceDate);
        String string = quotation = isIndirect ? "1" : "0";
        if (!currency.getPkValue().equals(basecurrency.getPkValue()) && ObjectUtils.isEmpty((Object)(exchangeRate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)invoiceDate)))) {
            isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)new Date());
            quotation = isIndirect ? "1" : "0";
            exchangeRate = BaseDataHelper.getExchangeRate((Long)Long.valueOf(init.getExrateTable().getPkValue().toString()), (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)new Date());
        }
        inv.set("exchangerate", (Object)exchangeRate);
        inv.set("quotation", (Object)quotation);
        BigDecimal amount = vo.getInvoiceAmount() != null ? vo.getInvoiceAmount() : ((vo.getInvoiceMoney() != null ? vo.getInvoiceMoney() : vo.getAmount()) != null ? vo.getAmount() : vo.getTotalAmount());
        int amtPrecision = basecurrency.getInt("amtprecision");
        inv.set("amount", (Object)amount);
        inv.set("tax", (Object)(vo.getTaxAmount() != null ? vo.getTaxAmount() : vo.getTotalTaxAmount()));
        inv.set("pricetaxtotal", (Object)vo.getTotalAmount());
        inv.set("unrelatedamt", (Object)vo.getTotalAmount());
        if (exchangeRate != null) {
            if ("0".equals(quotation)) {
                inv.set("amountbase", (Object)amount.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP));
                inv.set("pricetaxtotalbase", (Object)vo.getTotalAmount().multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP));
            } else {
                inv.set("amountbase", (Object)amount.divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP));
                inv.set("pricetaxtotalbase", (Object)vo.getTotalAmount().divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP));
            }
        }
        if ("PLANE".equals(invoiceType) || "PAYLETTER".equals(invoiceType)) {
            inv.set("amount", (Object)inv.getBigDecimal("pricetaxtotal").subtract(inv.getBigDecimal("tax")));
        }
        inv.set("payorg", (Object)org);
        ComboProp paymentTypeProp = (ComboProp)this.dt.getAllFields().get("paymenttype");
        inv.set("paymenttype", paymentTypeProp.getDefValue());
        inv.set("purorg", (Object)org);
        inv.set("lastpaydate", (Object)vo.getDueDate());
        inv.set("payee", (Object)vo.getPayee());
        inv.set("checker", (Object)vo.getReviewer());
        inv.set("drawer", (Object)vo.getDrawer());
        inv.set("originalgraphurl", (Object)vo.getOriginalGraphUrl());
        inv.set("istaxdeduction", (Object)("1".equals(vo.getCanBeDeduction()) ? Boolean.TRUE : Boolean.FALSE));
        if (!inv.getBoolean("istaxdeduction")) {
            inv.set("istaxdeduction", (Object)("1".equals(vo.getDeductionFlag()) ? Boolean.TRUE : Boolean.FALSE));
        }
        inv.set("synstatus", (Object)"notsynchro");
        inv.set("isreffin", (Object)this.isSrcCollect);
        Map extFields = vo.getExtFields();
        List fields = inv.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        if (EmptyUtils.isNotEmpty((Object)extFields)) {
            for (Map.Entry entry : extFields.entrySet()) {
                if (!fields.contains(entry.getKey())) continue;
                inv.set((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private Map<String, Object> getAsstact(String taxNo, String salerName, String invoiceType) {
        QFilter qfilter;
        HashMap<String, Object> assMap = null;
        String asstActType = null;
        Long asstAct = null;
        String acctBank = null;
        if (this.asstActType != null && this.asstAct != null) {
            asstActType = this.asstActType;
            asstAct = this.asstAct.getLong("id");
        } else if (!InvoiceType.OVERSEAS.getValue().equals(invoiceType)) {
            DynamicObjectCollection suppliers;
            if (EmptyUtils.isEmpty((Object)taxNo)) {
                return assMap;
            }
            qfilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            qfilter.and("status", "=", (Object)"C");
            qfilter.and(new QFilter("tx_register_no", "=", (Object)taxNo));
            QFilter qfilter_2 = new QFilter("enable", "=", (Object)Boolean.TRUE);
            qfilter_2.and("status", "=", (Object)"C");
            qfilter_2.and(new QFilter("societycreditcode", "=", (Object)taxNo));
            qfilter_2.and(new QFilter("tx_register_no", "=", (Object)""));
            if ("PUR".equals(this.bizType)) {
                suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)this.orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
                if (ObjectUtils.isEmpty((Object)suppliers)) {
                    suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)this.orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
                }
                if (!ObjectUtils.isEmpty((Object)suppliers)) {
                    asstActType = "bd_supplier";
                    asstAct = ((DynamicObject[])suppliers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
                }
            } else {
                suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)this.orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
                if (ObjectUtils.isEmpty((Object)suppliers)) {
                    suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)this.orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
                }
                if (!ObjectUtils.isEmpty((Object)suppliers)) {
                    asstActType = "bd_supplier";
                    asstAct = ((DynamicObject[])suppliers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
                } else {
                    DynamicObjectCollection customers = BaseDataServiceHelper.queryBaseData((String)"bd_customer", (Long)this.orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
                    if (ObjectUtils.isEmpty((Object)customers)) {
                        customers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)this.orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
                    }
                    if (!ObjectUtils.isEmpty((Object)customers)) {
                        asstActType = "bd_customer";
                        asstAct = ((DynamicObject[])customers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
                    }
                }
            }
            if (asstAct == null) {
                QFilter filter = new QFilter("number", "=", (Object)taxNo);
                filter.and("asstact.status", "=", (Object)"C");
                filter.and("asstact.enable", "=", (Object)Boolean.TRUE);
                Map sellerMap = BusinessDataServiceHelper.loadFromCache((String)"ap_seller", (String)"id, asstacttype, asstact", (QFilter[])new QFilter[]{filter});
                if (!ObjectUtils.isEmpty((Object)sellerMap)) {
                    DynamicObject seller = sellerMap.values().toArray(new DynamicObject[0])[0];
                    asstActType = seller.getString("asstacttype");
                    asstAct = seller.getLong("asstact.id");
                }
            }
        } else if (salerName != null && !"".equals(salerName)) {
            qfilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            qfilter.and("status", "=", (Object)"C");
            qfilter.and("name", "=", (Object)salerName);
            DynamicObjectCollection suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)this.orgPk, (QFilter)qfilter, (String)"id, number, name, entry_bank.bankaccount");
            if (ObjectUtils.isEmpty((Object)suppliers)) {
                QFilter qfilter_2 = new QFilter("enable", "=", (Object)Boolean.TRUE);
                qfilter_2.and("status", "=", (Object)"C");
                qfilter_2.and(new QFilter("name", "ftlike", (Object)salerName));
                suppliers = BaseDataServiceHelper.queryBaseData((String)"bd_supplier", (Long)this.orgPk, (QFilter)qfilter_2, (String)"id, number, name, entry_bank.bankaccount");
            }
            if (!ObjectUtils.isEmpty((Object)suppliers)) {
                asstActType = "bd_supplier";
                asstAct = ((DynamicObject[])suppliers.toArray((Object[])new DynamicObject[0]))[0].getLong("id");
            }
        }
        if (asstActType != null || asstAct != null) {
            assMap = new HashMap<String, Object>();
            if (!"bos_user".equals(asstActType)) {
                DynamicObject asst;
                DynamicObjectCollection bankColls;
                if (asstAct != null && (bankColls = (asst = BusinessDataServiceHelper.loadSingleFromCache((Object)asstAct, (String)asstActType)).getDynamicObjectCollection("entry_bank")) != null && bankColls.size() > 0) {
                    if (bankColls.size() == 1) {
                        DynamicObject bankInfo = (DynamicObject)bankColls.get(0);
                        acctBank = bankInfo.getString("bankaccount");
                    } else {
                        for (int i = 0; i < bankColls.size(); ++i) {
                            DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                            if (bankInfo.getBoolean("isdefault_bank")) {
                                acctBank = bankInfo.getString("bankaccount");
                                break;
                            }
                            if (i != 0) continue;
                            acctBank = bankInfo.getString("bankaccount");
                        }
                    }
                }
                assMap.put("acctBank", acctBank);
            }
            assMap.put("asstActType", asstActType);
            assMap.put("asstAct", asstAct);
        }
        return assMap;
    }

    public static int getNumberMaxPosition(String txt, String containStr) {
        int max = -1;
        if (EmptyUtils.isNotEmpty((Object)txt)) {
            for (int i = txt.length() - 1; i > 0; --i) {
                boolean flag;
                String s = String.valueOf(txt.charAt(i));
                boolean bl = StringUtils.isEmpty((CharSequence)containStr) ? InvoiceCloudHelper.isNumber(s) : (flag = InvoiceCloudHelper.isNumber(s) || StringUtils.equals((CharSequence)containStr, (CharSequence)s));
                if (flag || i <= max) continue;
                max = i;
            }
        }
        return max;
    }

    public static boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("\\d+");
        return pattern.matcher(str).matches();
    }

    @Deprecated
    public static void updteInv(OperationResult operationResult, BeginOperationTransactionArgs e) {
        List invoiceIds = Arrays.stream(e.getDataEntities()).filter(inv -> !ObjectUtils.isEmpty((Object)inv.getString("serialno"))).map(inv -> inv.getLong("id")).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(invoiceIds)) {
            CallCloudHelper.updateInvoiceCloud(invoiceIds);
        }
    }

    @Deprecated
    public static void deleteInvRelation(OperationResult operationResult, BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List needReleaseInvIds = Arrays.stream(dataEntities).filter(inv -> !ObjectUtils.isEmpty((Object)inv.getString("serialno"))).map(inv -> inv.getLong("id")).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(needReleaseInvIds)) {
            CallCloudHelper.releaseInvoice(needReleaseInvIds);
        }
    }

    public static void genFinInvEntry(DynamicObject inv) {
        Object sdetailId;
        HashSet<Long> simBillIds = new HashSet<Long>(2);
        HashSet<Long> sdetailIds = new HashSet<Long>(2);
        ArrayList<InvoiceMatchVo> invoiceMatchVos = new ArrayList<InvoiceMatchVo>(2);
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id,items.id,items.seq,items.taxamount", (QFilter[])new QFilter[]{new QFilter("invoicecode", "=", (Object)inv.getString("invoicecode")), new QFilter("invoiceno", "=", (Object)inv.getString("invoiceno"))});
        ArrayList<Long> invEntryIds = new ArrayList<Long>(2);
        HashMap<Long, Integer> invEntryIdToSeqMap = new HashMap<Long, Integer>(2);
        for (Object invoice : invoices) {
            Long invEntryId = invoice.getLong("items.id");
            int invEntrySeq = invoice.getInt("items.seq");
            invEntryIdToSeqMap.put(invEntryId, invEntrySeq);
            invEntryIds.add(invEntryId);
        }
        if (invEntryIds.size() == 0) {
            return;
        }
        DynamicObjectCollection invRelations = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)"tdetailid,sdetailid,sbillid,amount,tax", (QFilter[])new QFilter[]{new QFilter("tdetailid", "in", invEntryIds)});
        for (DynamicObject relation : invRelations) {
            Long invEntryId = relation.getLong("tdetailid");
            Long simBillId = relation.getLong("sbillid");
            sdetailId = relation.getLong("sdetailid");
            InvoiceMatchVo vo = new InvoiceMatchVo();
            vo.setSdetailid((Long)sdetailId);
            vo.setInvoiceId(invEntryId);
            BigDecimal taxAmount = relation.getBigDecimal("amount").add(relation.getBigDecimal("tax"));
            vo.setPricetaxtatol(taxAmount);
            int seq = (Integer)invEntryIdToSeqMap.get(invEntryId);
            vo.setSeq(seq);
            invoiceMatchVos.add(vo);
            simBillIds.add(simBillId);
            sdetailIds.add((Long)sdetailId);
        }
        logger.info("\u7b2c\u4e00\u6b21vo\u662f" + invoiceMatchVos);
        HashSet<Long> finArEntryIds = new HashSet<Long>(2);
        Map simEntryIdTofinArEntryIds = BOTPHelper.loadSourceRowIdsMap((String)"sim_original_bill", (String)"", (Long[])simBillIds.toArray(new Long[simBillIds.size()]), (Long[])sdetailIds.toArray(new Long[sdetailIds.size()]), (String)"ar_finarbill");
        for (InvoiceMatchVo vo : invoiceMatchVos) {
            sdetailId = vo.getSdetailid();
            Long finArEntryId = (Long)simEntryIdTofinArEntryIds.get(sdetailId);
            if (finArEntryId == null) continue;
            finArEntryIds.add(finArEntryId);
            vo.setFinArEntryId(finArEntryId);
        }
        HashSet<Long> finArBillIds = new HashSet<Long>(2);
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,relationpay,entry.id,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", finArEntryIds)});
        for (Object finArBill : finArBills) {
            boolean isBizpartner = finArBill.getBoolean("relationpay");
            if (!isBizpartner) continue;
            Long finId = finArBill.getLong("id");
            Long entryId = finArBill.getLong("entry.id");
            String coreBillType = finArBill.getString("entry.e_corebilltype");
            String coreBillNo = finArBill.getString("entry.e_corebillno");
            int coreBillEntrySeq = finArBill.getInt("entry.e_corebillentryseq");
            finArBillIds.add(finId);
            for (InvoiceMatchVo vo : invoiceMatchVos) {
                Long finArEntryId = vo.getFinArEntryId();
                logger.info("\u5e94\u6536\u5355\u5206\u5f55id\u4e3a\uff1a" + entryId + "vo\u7684\u5e94\u6536\u5355\u5206\u5f55id\u4e3a\uff1a" + finArEntryId);
                if (!entryId.equals(finArEntryId)) continue;
                vo.setFinArBillId(finId);
                if (coreBillType != null) {
                    vo.setCorebilltype(coreBillType);
                }
                if (coreBillNo != null) {
                    vo.setCoreBillNo(coreBillNo);
                }
                if (coreBillEntrySeq == 0) continue;
                vo.setCoreBillEntrySeq(coreBillEntrySeq);
            }
        }
        DynamicObjectCollection invoiceEntrys = inv.getDynamicObjectCollection("entry");
        for (DynamicObject entry : invoiceEntrys) {
            int invEntrySeq = entry.getInt("e_inventryseq");
            HashSet<String> coreBillNos = new HashSet<String>(2);
            HashSet<Integer> coreBillSeqs = new HashSet<Integer>(2);
            for (InvoiceMatchVo vo : invoiceMatchVos) {
                logger.info("\u6536\u7968\u5355\u4e0a\u7684\u53d1\u7968\u5206\u5f55\u884c\u53f7\u662f" + invEntrySeq + "-\u9500\u9879\u6c60\u4e0a\u7684\u53d1\u7968\u5206\u5f55\u884c\u662f" + vo.getSeq());
                if (invEntrySeq != vo.getSeq()) continue;
                String coreBillType = vo.getCorebilltype();
                String coreBillNo = vo.getCoreBillNo();
                coreBillNos.add(coreBillNo);
                int coreBillEntrySeq = vo.getCoreBillEntrySeq();
                coreBillSeqs.add(coreBillEntrySeq);
                if (coreBillType == null) continue;
                entry.set("corebilltype", (Object)coreBillType);
            }
            if (coreBillNos.size() != 1) continue;
            entry.set("corebillno", coreBillNos.iterator().next());
            if (coreBillSeqs.size() != 1) continue;
            entry.set("corebillentryseq", coreBillSeqs.iterator().next());
        }
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", finArBillIds), new QFilter("relationpay", "=", (Object)Boolean.TRUE)});
        if (finApBills.length > 0) {
            InvoiceCloudHelper.buildInvEntry(finApBills, inv, invoiceMatchVos);
            InvoiceHelper.updateFinTaxDeductionLogic(finApBills, false);
            SaveServiceHelper.save((DynamicObject[])finApBills);
        }
    }

    private static void buildInvEntry(DynamicObject[] finApBills, DynamicObject inv, List<InvoiceMatchVo> invoiceMatchVos) {
        List auditedFins = Arrays.stream(finApBills).filter(v -> "C".equals(v.getString("billstatus"))).collect(Collectors.toList());
        if (auditedFins.size() > 0) {
            return;
        }
        DynamicObjectType dataEntityType = (DynamicObjectType)finApBills[0].getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("inventry")).getDynamicCollectionItemPropertyType();
        inv.set("receivablessupp", (Object)finApBills[0].getDynamicObject("asstact"));
        inv.set("isreffin", (Object)Boolean.TRUE);
        inv.set("businesssource", (Object)"ap_finapbill");
        for (DynamicObject finApBill : finApBills) {
            BigDecimal canUseAmt = BigDecimal.ZERO;
            Long finArBillId = finApBill.getLong("sourcebillid");
            for (InvoiceMatchVo vo : invoiceMatchVos) {
                if (!finArBillId.equals(vo.getFinArBillId())) continue;
                canUseAmt = canUseAmt.add(vo.getPricetaxtatol());
            }
            DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("inventry");
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            detailEntry.set("invid", inv.getPkValue());
            detailEntry.set("i_billno", (Object)inv.getString("billno"));
            detailEntry.set("i_invoicetype", (Object)inv.getString("invoicetype"));
            detailEntry.set("i_invoicetypef7", inv.get("invoicetypef7"));
            detailEntry.set("i_invoicecode", (Object)inv.getString("invoicecode"));
            detailEntry.set("i_invoiceno", (Object)inv.getString("invoiceno"));
            detailEntry.set("i_invoicedate", (Object)inv.getDate("issuedate"));
            detailEntry.set("i_pricetaxtotal", (Object)inv.getBigDecimal("pricetaxtotal"));
            detailEntry.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate(inv));
            detailEntry.set("i_tax", (Object)inv.getBigDecimal("tax"));
            detailEntry.set("i_amount", (Object)inv.getBigDecimal("amount"));
            String invoiceType = inv.getString("invoicetype");
            if ("PLANE".equals(invoiceType) || "PAYLETTER".equals(invoiceType)) {
                detailEntry.set("i_amount", (Object)inv.getBigDecimal("pricetaxtotal").subtract(inv.getBigDecimal("tax")));
            }
            detailEntry.set("i_asstactname", (Object)inv.getString("asstactname"));
            detailEntry.set("i_buyername", (Object)inv.getString("buyername"));
            detailEntry.set("i_istaxdeduction", (Object)inv.getBoolean("istaxdeduction"));
            detailEntry.set("i_remark", (Object)inv.getString("remark"));
            detailEntry.set("i_srctype", (Object)InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue());
            detailEntry.set("i_issupplement", (Object)"0");
            detailEntry.set("i_serialno", (Object)inv.getString("serialno"));
            detailEntry.set("i_canuseamt", (Object)canUseAmt);
            detailEntry.set("i_currency", (Object)inv.getDynamicObject("currency"));
            detailEntries.add((Object)detailEntry);
        }
    }
}

