/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.piaozone;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.piaozone.InvoiceCloudHelper;
import kd.fi.arapcommon.business.piaozone.exception.PZAuthException;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailInfo;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceCollectHelper {
    private static final Log logger = LogFactory.getLog(InvoiceCollectHelper.class);

    @Deprecated
    public static void showSelectInvoice(AbstractFormPlugin plugin, DynamicObject org) {
        CallCloudHelper.showInvoiceAssistant((AbstractFormPlugin)plugin);
    }

    @Deprecated
    public static Map<String, Object> importInvoice(IFormView view, Map<String, String> m, Long pk) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        logger.info("InvoiceCollectHelper---\u4f20\u9012\u8fc7\u6765\u7684\u53c2\u6570\u662f" + m);
        boolean success = false;
        String serialNosStr = m.get("msg");
        if (StringUtils.isEmpty((String)serialNosStr)) {
            StringBuilder buf = new StringBuilder();
            logger.info("InvoiceCollectHelper---\u4f20\u9012\u8fc7\u6765\u7684invoiceData\u662f" + JSON.toJSONString((Object)m.get("invoiceData")));
            JSONArray invoiceData = JSON.parseArray((String)JSON.toJSONString((Object)m.get("invoiceData")));
            if (invoiceData != null && invoiceData.size() > 0) {
                for (int i = 0; i < invoiceData.size(); ++i) {
                    JSONObject invoice = (JSONObject)invoiceData.get(i);
                    if (invoice == null) continue;
                    String serialNo = invoice.get((Object)"serialNo").toString();
                    buf.append(serialNo);
                    buf.append(',');
                }
                serialNosStr = buf.toString();
                m.put("state", "0");
            }
        }
        logger.info("InvoiceCollectHelper---\u524d\u6bb5\u8fd4\u56de\u7684\u53d1\u7968\u6d41\u6c34\u53f7\u662f" + serialNosStr);
        if (EmptyUtils.isEmpty((Object)serialNosStr)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u53d1\u7968", (String)"InvoiceCollectHelper_3", (String)"fi-ap-common", (Object[])new Object[0]));
            return returnMap;
        }
        if ("0".equals(m.get("state"))) {
            String[] serialNoArr = serialNosStr.split(",");
            Set serialNos = Arrays.stream(serialNoArr).collect(Collectors.toSet());
            try {
                if (serialNos == null || serialNos.isEmpty()) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u53d1\u7968", (String)"InvoiceCollectHelper_1", (String)"fi-ap-common", (Object[])new Object[0]));
                } else {
                    IDataModel model = view.getModel();
                    HashMap<String, Long> serialnoMap = new HashMap<String, Long>(8);
                    serialnoMap.put(serialNoArr[0], pk);
                    String asstacttype = null;
                    DynamicObject asstact = null;
                    boolean isSaveEntry = false;
                    if ("ap_finapbill".equals(model.getDataEntityType().getName())) {
                        asstacttype = (String)model.getValue("asstacttype");
                        asstact = (DynamicObject)model.getValue("asstact");
                        isSaveEntry = true;
                    }
                    DynamicObject org = (DynamicObject)model.getValue("org");
                    QueryInvoiceDetailInfo queryInvoiceDetail = InvoiceCollectHelper.buildQueryInvoiceDetail(org, serialNosStr);
                    returnMap.put("taxRegnum", queryInvoiceDetail.getTaxNo());
                    List invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailInfo)queryInvoiceDetail);
                    InvoiceCollectHelper.invoiceVOPostProcess(invoiceVOs, view);
                    InvoiceCloudHelper helper = new InvoiceCloudHelper((Long)org.getPkValue(), InvoiceCollectHelper.getBizType(model), isSaveEntry, serialnoMap, asstacttype, asstact, isSaveEntry);
                    helper.setAppId(view.getFormShowParameter().getAppId());
                    List<DynamicObject> downloadInvs = helper.genInvoice(invoiceVOs);
                    if (downloadInvs.isEmpty()) {
                        if (!"ap_finapbill".equals(model.getDataEntityType().getName())) {
                            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u5df2\u4e0b\u8f7d\u3002", (String)"InvoiceCollectHelper_2", (String)"fi-ap-common", (Object[])new Object[0]));
                        }
                    } else {
                        returnMap.put("downloadInvs", downloadInvs);
                    }
                    BizExtendHelper.afterImportInvoice((List)invoiceVOs, downloadInvs);
                }
                success = true;
            }
            catch (PZAuthException e) {
                view.showErrorNotification(e.getMessage());
                logger.error((Throwable)e);
            }
            logger.info("\u63a5\u6536\u5230pc\u7aef\u9009\u62e9\u5bfc\u5165\u7684\u53d1\u7968\u6570\u636e:" + serialNosStr);
        } else {
            view.showErrorNotification(serialNosStr);
        }
        returnMap.put("success", success);
        return returnMap;
    }

    @Deprecated
    public static Map<String, Object> importInvoice(AbstractFormPlugin plugin, Map<String, String> m, Long pk) {
        return InvoiceCollectHelper.importInvoice(plugin.getView(), m, pk);
    }

    private static String getBizType(IDataModel model) {
        String asstactType;
        String bizType = "";
        String entityKey = model.getDataEntityType().getName();
        bizType = "ap_finapbill".equals(entityKey) ? ("bd_supplier".equals(asstactType = (String)model.getValue("asstacttype")) ? "PUR" : "FEE") : (String)model.getValue("biztype");
        return bizType;
    }

    public static QueryInvoiceDetailInfo buildQueryInvoiceDetail(DynamicObject org, String serialNosStr) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((Long)((Long)org.getPkValue()));
        QueryInvoiceDetailInfo info = new QueryInvoiceDetailInfo();
        String taxRegnums = config.getTaxRegnum();
        info.setTaxNo(taxRegnums);
        info.setSerialNo(serialNosStr);
        String firmNames = config.getFirmname();
        info.setCompanyName(firmNames);
        info.setOrgId((Long)org.getPkValue());
        info.setBxdKey(null);
        return info;
    }

    public static BigDecimal calculateTaxRate(DynamicObject invoice) {
        BigDecimal headTaxRate = BigDecimal.ZERO;
        DynamicObjectCollection entries = invoice.getDynamicObjectCollection("entry");
        Set taxRateSet = entries.stream().map(entry -> entry.getBigDecimal("taxrate")).collect(Collectors.toSet());
        if (taxRateSet.size() == 1) {
            headTaxRate = ((DynamicObject)entries.get(0)).getBigDecimal("taxrate");
        }
        return headTaxRate;
    }

    public static void repairFinBill(BigDecimal repairAmt, DynamicObject finbill) {
        BigDecimal uninvoicedAmt = finbill.getBigDecimal("uninvoicedamt").add(repairAmt);
        finbill.set("uninvoicedamt", (Object)uninvoicedAmt);
        DynamicObjectCollection entries = finbill.getDynamicObjectCollection("detailentry");
        boolean isFullAmt = finbill.getBigDecimal("pricetaxtotal").compareTo(uninvoicedAmt) == 0;
        for (DynamicObject row : entries) {
            BigDecimal priceTaxTotal = row.getBigDecimal("e_pricetaxtotal");
            BigDecimal invoicedAmt = row.getBigDecimal("e_invoicedamt");
            if (!isFullAmt || !InvoiceCollectHelper.isNegativeRow(repairAmt, priceTaxTotal)) continue;
            row.set("e_invoicedamt", (Object)BigDecimal.ZERO);
            row.set("e_uninvoicedamt", (Object)priceTaxTotal);
            repairAmt = repairAmt.add(invoicedAmt.negate());
        }
        for (int i = entries.size() - 1; i >= 0; --i) {
            DynamicObject detail = (DynamicObject)entries.get(i);
            BigDecimal applyAmt = detail.getBigDecimal("e_invoicedamt");
            BigDecimal priceTaxTotal = detail.getBigDecimal("e_pricetaxtotal");
            if (InvoiceCollectHelper.isNegativeRow(repairAmt, priceTaxTotal)) continue;
            if (applyAmt.abs().compareTo(repairAmt.abs()) >= 0) {
                detail.set("e_invoicedamt", (Object)applyAmt.subtract(repairAmt));
                detail.set("e_uninvoicedamt", (Object)detail.getBigDecimal("e_pricetaxtotal").subtract(detail.getBigDecimal("e_invoicedamt")));
                break;
            }
            if (applyAmt.abs().compareTo(repairAmt.abs()) >= 0) continue;
            detail.set("e_invoicedamt", (Object)applyAmt.subtract(applyAmt));
            detail.set("e_uninvoicedamt", (Object)detail.getBigDecimal("e_pricetaxtotal").subtract(detail.getBigDecimal("e_invoicedamt")));
            repairAmt = repairAmt.subtract(applyAmt);
        }
    }

    public static boolean isNegativeRow(BigDecimal deductAmt, BigDecimal uninvoiceAmt) {
        return deductAmt.compareTo(BigDecimal.ZERO) > 0 && uninvoiceAmt.compareTo(BigDecimal.ZERO) < 0 || deductAmt.compareTo(BigDecimal.ZERO) < 0 && uninvoiceAmt.compareTo(BigDecimal.ZERO) > 0;
    }

    public static void repairInvoice(Map<Long, BigDecimal> invMap, DynamicObject[] invoices) {
        block0: for (DynamicObject invoice : invoices) {
            long invPk = invoice.getLong("id");
            BigDecimal repairAmt = invMap.get(invPk);
            if (repairAmt == null) continue;
            invoice.set("unrelatedamt", (Object)invoice.getBigDecimal("unrelatedamt").add(repairAmt));
            DynamicObjectCollection entries = invoice.getDynamicObjectCollection("entry");
            for (int i = entries.size() - 1; i >= 0; --i) {
                DynamicObject detail = (DynamicObject)entries.get(i);
                BigDecimal applyAmt = detail.getBigDecimal("e_relatedamt");
                if (applyAmt.abs().compareTo(repairAmt.abs()) >= 0) {
                    detail.set("e_relatedamt", (Object)applyAmt.subtract(repairAmt));
                    detail.set("e_unrelatedamt", (Object)detail.getBigDecimal("e_pricetaxtotal").subtract(detail.getBigDecimal("e_relatedamt")));
                    continue block0;
                }
                if (applyAmt.abs().compareTo(repairAmt.abs()) >= 0) continue;
                detail.set("e_relatedamt", (Object)applyAmt.subtract(applyAmt));
                detail.set("e_unrelatedamt", (Object)detail.getBigDecimal("e_pricetaxtotal").subtract(detail.getBigDecimal("e_relatedamt")));
                repairAmt = repairAmt.subtract(applyAmt);
            }
        }
    }

    private static void invoiceVOPostProcess(List<InvoiceVO> invoiceVOs, IFormView view) {
        DataEntityPropertyCollection properties = view.getModel().getDataEntityType().getProperties();
        HashMap<String, Object> extMap = new HashMap<String, Object>(8);
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!name.endsWith("ext")) continue;
            extMap.put(name, view.getModel().getValue(name));
        }
        invoiceVOs.forEach(v -> v.setExtFields(extMap));
    }
}

