/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.piaozone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class ReplaceInvoiceHelper {
    public static void viewReplaceInvoiceList(IFormView view, Set<Long> orgIds, List<Long> billIds) {
        DataSet replaceDataSet;
        if (ObjectUtils.isEmpty(billIds)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReplaceInvoiceHelper_0", (String)"fi-ap-common", (Object[])new Object[0]));
            return;
        }
        String entityName = "ap_finapbill";
        if (view instanceof ListView) {
            String entityId = ((ListView)view).getBillFormId();
            entityName = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
        } else {
            entityName = view.getModel().getDataEntity().getDataEntityType().getName();
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        if ("ap_finapbill".equals(entityName)) {
            filter.and(new QFilter("oldinventry.o_apbillid", "in", billIds));
            replaceDataSet = QueryServiceHelper.queryDataSet((String)"query_replace_inv", (String)"ap_replaceinvapply", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
        } else if ("ap_payapply".equals(entityName)) {
            filter.and(new QFilter("oldinventry.o_applybillid", "in", billIds));
            replaceDataSet = QueryServiceHelper.queryDataSet((String)"query_replace_inv", (String)"ap_replaceinvapply", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
        } else {
            DataSet oldEntryReplaceDataSet = QueryServiceHelper.queryDataSet((String)"query_replace_inv", (String)"ap_replaceinvapply", (String)"id", (QFilter[])new QFilter[]{filter, new QFilter("oldinventry.o_invid", "in", billIds)}, (String)"");
            Iterator newEntryReplaceDataSet = QueryServiceHelper.queryDataSet((String)"query_replace_inv", (String)"ap_replaceinvapply", (String)"id", (QFilter[])new QFilter[]{filter, new QFilter("newinventry.n_invid", "in", billIds)}, (String)"");
            replaceDataSet = oldEntryReplaceDataSet.union((DataSet)newEntryReplaceDataSet).distinct();
        }
        ArrayList<Long> replaceBillIds = new ArrayList<Long>(32);
        for (Row row : replaceDataSet) {
            replaceBillIds.add(row.getLong("id"));
        }
        if (replaceBillIds.isEmpty()) {
            DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"query_billno", (String)entityName, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, (String)"");
            String errorMessage = "ap_finapbill".equals(entityName) ? ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\uff1a\u672a\u6362\u7968\uff0c\u65e0\u6362\u7968\u8bb0\u5f55\u3002%2$s", (String)"ReplaceInvoiceHelper_1", (String)"fi-ap-common", (Object[])new Object[0]) : ("ap_payapply".equals(entityName) ? ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355%1$s\uff1a\u672a\u6362\u7968\uff0c\u65e0\u6362\u7968\u8bb0\u5f55\u3002%2$s", (String)"ReplaceInvoiceHelper_2", (String)"fi-ap-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6536\u7968\u5355%1$s\uff1a\u672a\u5173\u8054\u6362\u7968\u8bb0\u5f55\u3002%2$s", (String)"ReplaceInvoiceHelper_3", (String)"fi-ap-common", (Object[])new Object[0]));
            StringBuilder errorMsg = new StringBuilder();
            for (Row row : billDataSet) {
                errorMsg.append(String.format(errorMessage, row.getString("billno"), System.lineSeparator()));
            }
            view.showTipNotification(errorMsg.toString());
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("ap_replaceinvapply");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter param = new ListFilterParameter();
        param.setFilter(new QFilter("id", "in", replaceBillIds));
        parameter.setListFilterParameter(param);
        parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
        view.showForm((FormShowParameter)parameter);
    }

    public static Set<Long> returnOnTheWayBillIds(String entityName, long orgId, long billId) {
        HashSet<Long> orgIds = new HashSet<Long>(2);
        orgIds.add(orgId);
        return ReplaceInvoiceHelper.returnOnTheWayBillIds(entityName, orgIds, Collections.singletonList(billId)).getOrDefault(billId, new HashSet(2));
    }

    public static Map<Long, Set<Long>> returnOnTheWayBillIds(String entityName, Set<Long> orgIds, List<Long> billIds) {
        QFilter oldInvFilter;
        if (ObjectUtils.isEmpty(billIds) || ObjectUtils.isEmpty((Object)entityName)) {
            return new HashMap<Long, Set<Long>>(8);
        }
        HashMap<Long, Set<Long>> onTheWayBillIdsMap = new HashMap<Long, Set<Long>>(32);
        QFilter commonFilter = new QFilter("org", "in", orgIds);
        commonFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
        ArrayList<String> oldSelectors = new ArrayList<String>(8);
        oldSelectors.add("id");
        if ("ap_finapbill".equals(entityName)) {
            oldInvFilter = new QFilter("oldinventry.o_apbillid", "in", billIds);
            oldSelectors.add("oldinventry.o_apbillid billid");
        } else if ("ap_invoice".equals(entityName)) {
            oldInvFilter = new QFilter("oldinventry.o_invid", "in", billIds);
            oldSelectors.add("oldinventry.o_invid billid");
        } else {
            oldInvFilter = new QFilter("oldinventry.o_applybillid", "in", billIds);
            oldSelectors.add("oldinventry.o_applybillid billid");
        }
        DataSet oldInvEntryDataSet = QueryServiceHelper.queryDataSet((String)"query_old_inv", (String)"ap_replaceinvapply", (String)String.join((CharSequence)",", oldSelectors), (QFilter[])new QFilter[]{commonFilter, oldInvFilter}, (String)"");
        for (Row oldInvRow : oldInvEntryDataSet) {
            Long id = oldInvRow.getLong("id");
            Long billId = oldInvRow.getLong("billid");
            Set onTheWayBillIds = onTheWayBillIdsMap.getOrDefault(billId, new HashSet(8));
            onTheWayBillIds.add(id);
            onTheWayBillIdsMap.put(billId, onTheWayBillIds);
        }
        if ("ap_invoice".equals(entityName)) {
            QFilter newInvFilter = new QFilter("newinventry.n_invid", "in", billIds);
            DataSet newInvEntryDataSet = QueryServiceHelper.queryDataSet((String)"query_new_inv", (String)"ap_replaceinvapply", (String)"id,newinventry.n_invid billid", (QFilter[])new QFilter[]{commonFilter, newInvFilter}, (String)"");
            for (Row newInvRow : newInvEntryDataSet) {
                Long id = newInvRow.getLong("id");
                Long billId = newInvRow.getLong("billid");
                Set onTheWayBillIds = onTheWayBillIdsMap.getOrDefault(billId, new HashSet(8));
                onTheWayBillIds.add(id);
                onTheWayBillIdsMap.put(billId, onTheWayBillIds);
            }
        }
        return onTheWayBillIdsMap;
    }

    public static void refreshReplaceNewInvEntry(IFormView view) {
        ReplaceInvoiceHelper.refreshReplaceNewInvEntry(view, new HashSet<Long>(2), new HashSet<String>());
    }

    public static void refreshReplaceNewInvEntry(IFormView view, Set<Long> needExpandInvIds, Set<String> needExpandSerialNos) {
        view.updateView("newinventry");
        DynamicObjectCollection newInvEntry = view.getModel().getEntryEntity("newinventry");
        if (newInvEntry.isEmpty()) {
            return;
        }
        boolean isRelateFinAp = false;
        boolean isRelateApply = false;
        DynamicObjectCollection oldInvEntry = view.getModel().getEntryEntity("oldinventry");
        for (DynamicObject oldInvRow : oldInvEntry) {
            if (oldInvRow.getLong("o_apbillid") != 0L) {
                isRelateFinAp = true;
            }
            if (oldInvRow.getLong("o_applybillid") == 0L) continue;
            isRelateApply = true;
        }
        TreeEntryGrid newInvEntryGird = (TreeEntryGrid)view.getControl("newinventry");
        List expandNodeIdsObj = (List)newInvEntryGird.getExpandNodes();
        HashSet<Long> expandNodeIds = new HashSet<Long>(8);
        if (expandNodeIdsObj != null) {
            for (Iterator expandId : expandNodeIdsObj) {
                if (expandId == null || "null".equals(expandId)) continue;
                expandNodeIds.add(Long.parseLong(String.valueOf(expandId)));
            }
        }
        HashSet<Long> hasSonParentIds = new HashSet<Long>(8);
        for (DynamicObject newInvRow : newInvEntry) {
            if (newInvRow.getLong("pid") == 0L) continue;
            hasSonParentIds.add(newInvRow.getLong("pid"));
        }
        ArrayList<Integer> expandIndexList = new ArrayList<Integer>(8);
        ArrayList<Integer> collapseIndexList = new ArrayList<Integer>(8);
        for (int index = 0; index < newInvEntry.size(); ++index) {
            DynamicObject newInvRow = (DynamicObject)newInvEntry.get(index);
            long rowId = newInvRow.getLong("id");
            long pid = newInvRow.getLong("pid");
            if (pid == 0L && hasSonParentIds.contains(rowId)) {
                view.setEnable(Boolean.FALSE, index, new String[]{"n_usedamt", "n_applybillno", "n_blueinvno"});
            }
            if (!isRelateFinAp) {
                view.setEnable(Boolean.FALSE, index, new String[]{"n_usedamt"});
            }
            if (!isRelateApply) {
                view.setEnable(Boolean.FALSE, index, new String[]{"n_applybillno"});
            }
            if (newInvRow.getBigDecimal("n_pricetaxtotal").signum() > 0) {
                view.setEnable(Boolean.FALSE, index, new String[]{"n_blueinvno"});
            }
            if (pid != 0L) continue;
            if (needExpandInvIds.contains(newInvRow.getLong("n_invid")) || needExpandSerialNos.contains(newInvRow.getString("n_serialno"))) {
                expandIndexList.add(index);
                continue;
            }
            if (expandNodeIds.contains(newInvRow.getLong("id"))) {
                expandIndexList.add(index);
                continue;
            }
            collapseIndexList.add(index);
        }
        if (!expandIndexList.isEmpty()) {
            int[] expandIndexArray = new int[expandIndexList.size()];
            for (int i = 0; i < expandIndexList.size(); ++i) {
                expandIndexArray[i] = (Integer)expandIndexList.get(i);
            }
            newInvEntryGird.expand(expandIndexArray);
        }
        if (!collapseIndexList.isEmpty()) {
            int[] collapseIndexArray = new int[collapseIndexList.size()];
            for (int i = 0; i < collapseIndexList.size(); ++i) {
                collapseIndexArray[i] = (Integer)collapseIndexList.get(i);
            }
            newInvEntryGird.collapse(collapseIndexArray);
        }
    }

    public static void deleteReplaceRecord(String entityName, Set<Long> orgIds, List<Long> billIds) {
        if (ObjectUtils.isEmpty((Object)entityName) || ObjectUtils.isEmpty(orgIds) || ObjectUtils.isEmpty(billIds)) {
            return;
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        if ("ap_payapply".equals(entityName)) {
            filter.and(new QFilter("oldinventry.o_applybillid", "in", billIds));
        } else {
            filter.and(new QFilter("oldinventry.o_apbillid", "in", billIds));
        }
        Object[] replaceBills = BusinessDataServiceHelper.load((String)"ap_replaceinvapply", (String)"id,oldinventry.o_applybillid,oldinventry.o_apbillid", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object[])replaceBills)) {
            return;
        }
        HashSet<Long> finApBillIds = new HashSet<Long>(32);
        HashSet<Long> applyBillIds = new HashSet<Long>(32);
        for (Object replaceBill : replaceBills) {
            DynamicObjectCollection oldInvEntry = replaceBill.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                long apBillId = oldInvRow.getLong("o_apbillid");
                long applyId = oldInvRow.getLong("o_applybillid");
                if (apBillId != 0L) {
                    finApBillIds.add(apBillId);
                }
                if (applyId == 0L) continue;
                applyBillIds.add(applyId);
            }
        }
        HashSet<Long> hasExistFinApBillIds = new HashSet<Long>(32);
        HashSet<Long> hasExistApplyBillIds = new HashSet<Long>(32);
        if (!finApBillIds.isEmpty()) {
            DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)}, (String)"");
            for (Row row : finApDataSet) {
                hasExistFinApBillIds.add(row.getLong("id"));
            }
        }
        if (!applyBillIds.isEmpty()) {
            DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply", (String)"ap_payapply", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)}, (String)"");
            for (Row row : applyDataSet) {
                hasExistApplyBillIds.add(row.getLong("id"));
            }
        }
        ArrayList<Long> needDeleteReplaceIds = new ArrayList<Long>(32);
        for (Object replaceBill : replaceBills) {
            boolean isCanDelete = true;
            DynamicObjectCollection oldInvEntry = replaceBill.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                long apBillId = oldInvRow.getLong("o_apbillid");
                long applyId = oldInvRow.getLong("o_applybillid");
                if (apBillId != 0L && hasExistFinApBillIds.contains(apBillId)) {
                    isCanDelete = false;
                    break;
                }
                if (applyId == 0L || !hasExistApplyBillIds.contains(applyId)) continue;
                isCanDelete = false;
                break;
            }
            if (!isCanDelete) continue;
            needDeleteReplaceIds.add(replaceBill.getLong("id"));
        }
        if (!needDeleteReplaceIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", needDeleteReplaceIds);
            DeleteServiceHelper.delete((String)"ap_replaceinvapply", (QFilter[])new QFilter[]{qFilter});
        }
    }
}

