/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ap.mservice.ApArSettleService;
import kd.fi.ap.mservice.ApSelfSettleService;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApArManualSettleService
implements IManualSettleService {
    private ApArSettleService service;

    public ApArManualSettleService() {
        this.service = new ApArSettleService();
    }

    public ApArManualSettleService(ApArSettleService service) {
        this.service = service;
    }

    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("id"));
            mainEntryIdSet.add(main.getLong("entryid"));
        }
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            asstBillIdSet.add(asst.getLong("asst_id"));
            asstEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        scheme.setSettleEntryParam(manualParam.getSettleEntryParam());
        scheme.setSettleDate(manualParam.getSettleDate());
        scheme.setSettleRelation(SettleRelationEnum.APARSETTLE.getValue());
        DynamicObject[] mainArr = this.reloadMainArr(mainBillIdSet);
        DynamicObject[] asstArr = this.reloadAsstArr(asstBillIdSet);
        scheme.setAsstSettleEntryParam(ArApHelper.getArSettleParam((Object)asstArr[0].getLong("org.id")));
        List mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
        List asstListVO = FinArBillHandleHelper.getAsstListVO((DynamicObject[])asstArr, (SettleSchemeVO)scheme);
        if (manualParam.isSingleSettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            return;
        }
        if ((manualParam.isSettleSelfFirst() || manualParam.isTotal()) && !manualParam.isDiffCurrencySettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            mainArr = this.reloadMainArr(mainBillIdSet);
            asstArr = this.reloadAsstArr(asstBillIdSet);
        }
        this.processMain(mainArr, mainRows, mainEntryIdSet, manualParam);
        this.processAsst(asstArr, asstRows, asstEntryIdSet, manualParam, scheme.getAsstSettleEntryParam());
        mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
        asstListVO = FinArBillHandleHelper.getAsstListVO((DynamicObject[])asstArr, (SettleSchemeVO)scheme);
        this.service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
    }

    private void processMain(DynamicObject[] mainArr, DynamicObject[] mainRows, Set<Long> mainEntryIdSet, ManualSettleParam param) {
        int settleEntryParam = param.getSettleEntryParam();
        if (param.isTotal()) {
            for (DynamicObject main : mainRows) {
                BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                long id = main.getLong("id");
                for (DynamicObject mainObj : mainArr) {
                    if (id != mainObj.getLong("id")) continue;
                    mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                    DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(this.getApEntryUnLockKey(settleEntryParam));
                        if (curSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)entryUnLockAmt);
                            curSettleAmt = curSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject mainObj : mainArr) {
                long id = mainObj.getLong("id");
                DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal(this.getApEntryAmtKey(settleEntryParam));
                    if (mainEntryIdSet.contains(entryId)) {
                        for (DynamicObject main : mainRows) {
                            if (id != main.getLong("id") || entryId != main.getLong("entryid")) continue;
                            mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                            BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    private void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam manualParam, int asstSettleEntryParam) {
        int settleEntryParam = manualParam.getSettleEntryParam();
        if (asstSettleEntryParam != 0 && settleEntryParam != asstSettleEntryParam) {
            settleEntryParam = asstSettleEntryParam;
        }
        if (manualParam.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection(this.getArEntryKey(settleEntryParam));
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(this.getArEntryUnLockKey(settleEntryParam));
                        if (curSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(this.getArEntryAmtKey(settleEntryParam), (Object)entryUnLockAmt);
                            curSettleAmt = curSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(this.getArEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection(this.getArEntryKey(settleEntryParam));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal(this.getArEntryAmtKey(settleEntryParam));
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set(this.getArEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    private void settleSelfFirst(List<BillSettleVO> mainListVO, List<BillSettleVO> asstListVO, SettleSchemeVO scheme) {
        String oldSettleRelation = scheme.getSettleRelation();
        List mainPositiveList = this.getPositiveList(mainListVO);
        List mainNegativeList = this.getNegativeList(mainListVO);
        if (mainPositiveList.size() > 0 && mainNegativeList.size() > 0) {
            ApSelfSettleService apSelfService = new ApSelfSettleService();
            apSelfService.settleByVO(mainPositiveList, mainNegativeList, scheme, SettleTypeEnum.MANUAL.getValue());
        }
        SettleSchemeVO arSelfSettleSchemeVo = new SettleSchemeVO();
        if (scheme.getAsstSettleEntryParam() != 0 && scheme.getSettleEntryParam() != scheme.getAsstSettleEntryParam()) {
            arSelfSettleSchemeVo.setSettle(true);
            arSelfSettleSchemeVo.setManual(true);
            arSelfSettleSchemeVo.setDiffCurrencySettle(scheme.isDiffCurrencySettle());
            arSelfSettleSchemeVo.setSettleEntryParam(scheme.getAsstSettleEntryParam());
            arSelfSettleSchemeVo.setSettleDate(scheme.getSettleDate());
        } else {
            arSelfSettleSchemeVo = scheme;
        }
        List asstPositiveList = this.getPositiveList(asstListVO);
        List asstNegativeList = this.getNegativeList(asstListVO);
        if (asstPositiveList.size() > 0 && asstNegativeList.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"arself", (String)"settleByVO", (Object[])new Object[]{asstPositiveList, asstNegativeList, arSelfSettleSchemeVo, SettleTypeEnum.MANUAL.getValue()});
        }
        scheme.setSettleSelf(false);
        scheme.setSettleRelation(oldSettleRelation);
    }

    private DynamicObject[] reloadAsstArr(Set<Long> asstBillIdSet) {
        QFilter filter = new QFilter("id", "in", asstBillIdSet);
        DynamicObject[] asstArr = FinArBillHandleHelper.load((QFilter[])new QFilter[]{filter});
        return asstArr;
    }

    private DynamicObject[] reloadMainArr(Set<Long> mainBillIdSet) {
        QFilter filter = new QFilter("id", "in", mainBillIdSet);
        DynamicObject[] mainArr = FinApBillHandleHelper.load((QFilter[])new QFilter[]{filter});
        return mainArr;
    }
}

