/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;

public class ApPayApplyCloseService {
    public static final Log logger = LogFactory.getLog(ApPayApplyCloseService.class);

    public void disposePayApplySrcBill(DynamicObject[] payBills) {
        logger.info("ApPayApplyCloseService disposePayApplySrcBill begin ");
        if (ObjectUtils.isEmpty((Object[])payBills)) {
            return;
        }
        HashSet<Long> allApplyBillPks = new HashSet<Long>(payBills.length);
        for (DynamicObject bill : payBills) {
            String srcType = bill.getString("sourcebilltype");
            if (!"ap_payapply".equals(srcType)) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                allApplyBillPks.add(row.getLong("e_sourcebillid"));
            }
        }
        DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"queryCloseApply", (String)"ap_payapply", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", allApplyBillPks), new QFilter("billstatus", "=", (Object)"D")}, (String)"");
        if (!applyDataSet.hasNext()) {
            return;
        }
        HashSet<Long> needCloseApplyIds = new HashSet<Long>(64);
        for (Row apply : applyDataSet) {
            needCloseApplyIds.add(apply.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_payapply", (Object[])needCloseApplyIds.toArray(new Object[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)operationResult);
        logger.info("ApPayApplyCloseService disposePayApplySrcBill end ");
    }
}

