/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ApPaySettleService;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApPayAutoSettleService
extends AbsAutoSettleService {
    public static final String ASST_PAYBILL = "cas_paybill";
    public static final String ASST_PAIDBILL = "ap_paidbill";
    private final ApPaySettleService settleService = new ApPaySettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        DynamicObject[] objArr = new DynamicObject[]{obj};
        this.batchAutoSettle(objArr, isMain);
    }

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        this.batchAutoSettle(objArr, isMain, new SettleSchemeVO());
    }

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain, SettleSchemeVO scheme) throws KDBizException {
        DynamicObject[] assts;
        DynamicObject[] mains;
        scheme.setMainOp(isMain);
        if (isMain) {
            mains = objArr;
            assts = this.getAsstObjs(objArr, scheme);
        } else {
            assts = objArr;
            mains = this.getMainObjs(objArr, scheme);
        }
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            this.addSettleLock(mains, assts);
            List mainIdList = DynamicObjectHelper.getIdList((DynamicObject[])mains);
            mains = FinApBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", (Object)mainIdList)});
            List asstIdList = DynamicObjectHelper.getIdList((DynamicObject[])assts);
            assts = PayBillHandleHelper.loadPayById((List)asstIdList);
            if (scheme.isOnlyByBotp()) {
                this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
            } else {
                this.settleByCoreBill(mains, assts, scheme);
            }
        }
    }

    public void batchAutoSettle(Set<Long> mainIds, String asstEntity, Set<Long> asstIds, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(mainIds) || ObjectUtils.isEmpty(asstIds) || ObjectUtils.isEmpty((Object)scheme)) {
            return;
        }
        DynamicObject[] mains = FinApBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", mainIds)});
        DynamicObject[] assts = null;
        if (ASST_PAYBILL.equals(asstEntity)) {
            QFilter filter = new QFilter("id", "in", asstIds);
            filter.and(new QFilter("billstatus", "in", (Object)new String[]{"D", "F", "I"}));
            filter.and(new QFilter("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
            assts = PayBillHandleHelper.loadPay((QFilter[])new QFilter[]{filter});
        } else if (ASST_PAIDBILL.equals(asstEntity)) {
            QFilter filter = new QFilter("id", "in", asstIds);
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            filter.and(new QFilter("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
            assts = PayBillHandleHelper.loadPaid((QFilter[])new QFilter[]{filter});
        }
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            if (scheme.isOnlyByCoreBill()) {
                this.settleByCoreBill(mains, assts, scheme);
            } else if (scheme.isOnlyByConBill()) {
                this.settleByConBill(mains, assts, scheme);
            } else {
                this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
            }
        }
    }

    private void settleByCoreBill(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO scheme) {
        int apSettleParam = ArApHelper.getApSettleParam((Object)mains[0].get("org.id"));
        scheme.setSettleEntryParam(apSettleParam);
        scheme.setSettle(true);
        if (apSettleParam == 1) {
            List mainList = FinApBillHandleHelper.getMainListVO((DynamicObject[])mains, (SettleSchemeVO)scheme);
            for (BillSettleVO settleVO : mainList) {
                long entryId = settleVO.getEntryId();
                for (DynamicObject main : mains) {
                    DynamicObjectCollection detailEntrys = main.getDynamicObjectCollection("detailentry");
                    for (DynamicObject detailEntry : detailEntrys) {
                        BigDecimal prepayRate;
                        if (entryId != detailEntry.getLong("id") || (prepayRate = detailEntry.getBigDecimal("e_prepayrate")).compareTo(BigDecimal.ZERO) <= 0 || prepayRate.compareTo(new BigDecimal(100)) >= 0) continue;
                        BigDecimal preSettleAmt = settleVO.getEntryPayableAmt().multiply(prepayRate.divide(new BigDecimal(100)));
                        settleVO.setEntryUnSettleAmt(preSettleAmt);
                    }
                }
            }
            List list = PayBillHandleHelper.getAsstListVO((DynamicObject[])assts);
            this.settleService.settleByVO(mainList, list, scheme, SettleTypeEnum.AUTO.getValue());
        } else {
            ArrayList mainList = new ArrayList();
            for (DynamicObject main : mains) {
                DynamicObjectCollection detailEntrys = main.getDynamicObjectCollection("detailentry");
                HashSet<String> coreBillNoSet = new HashSet<String>();
                for (DynamicObject detailEntry : detailEntrys) {
                    String coreBillNo = detailEntry.getString("corebillno");
                    coreBillNoSet.add(coreBillNo);
                }
                List mainPlanVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])new DynamicObject[]{main}, (SettleSchemeVO)scheme);
                if (scheme.isOnlyByCoreBill() && this.isNeedRemoveListVo(main, "plancorebillno")) {
                    Iterator mainPlanVOIterator = mainPlanVO.iterator();
                    while (mainPlanVOIterator.hasNext()) {
                        BillSettleVO bill = (BillSettleVO)mainPlanVOIterator.next();
                        Map extFields = bill.getExtFields();
                        if (!ObjectUtils.isEmpty(extFields.get("corebillno"))) continue;
                        mainPlanVOIterator.remove();
                    }
                }
                for (BillSettleVO vo : mainPlanVO) {
                    vo.setCoreBillNum(coreBillNoSet);
                }
                mainList.addAll(mainPlanVO);
            }
            List list = PayBillHandleHelper.getAsstListVO((DynamicObject[])assts);
            this.settleService.settleByVO(mainList, list, scheme, SettleTypeEnum.AUTO.getValue());
        }
    }

    private void settleByConBill(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO scheme) {
        int apSettleParam = ArApHelper.getApSettleParam((Object)mains[0].get("org.id"));
        scheme.setSettleEntryParam(apSettleParam);
        scheme.setSettle(true);
        if (apSettleParam == 1) {
            this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
        } else {
            ArrayList mainList = new ArrayList();
            for (DynamicObject main : mains) {
                DynamicObjectCollection detailEntrys = main.getDynamicObjectCollection("detailentry");
                HashSet<String> conBillNoSet = new HashSet<String>();
                for (DynamicObject detailEntry : detailEntrys) {
                    String conBillNo = detailEntry.getString("e_conbillnumber");
                    conBillNoSet.add(conBillNo);
                }
                List mainPlanVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])new DynamicObject[]{main}, (SettleSchemeVO)scheme);
                if (scheme.isOnlyByConBill() && this.isNeedRemoveListVo(main, "plancontract")) {
                    Iterator mainPlanVOIterator = mainPlanVO.iterator();
                    while (mainPlanVOIterator.hasNext()) {
                        BillSettleVO bill = (BillSettleVO)mainPlanVOIterator.next();
                        Map extFields = bill.getExtFields();
                        if (!ObjectUtils.isEmpty(extFields.get("conbillnumber"))) continue;
                        mainPlanVOIterator.remove();
                    }
                }
                for (BillSettleVO vo : mainPlanVO) {
                    vo.setConBillNum(conBillNoSet);
                }
                mainList.addAll(mainPlanVO);
            }
            List asstList = PayBillHandleHelper.getAsstListVO((DynamicObject[])assts);
            this.settleService.settleByVO(mainList, asstList, scheme, SettleTypeEnum.AUTO.getValue());
        }
    }

    private boolean isNeedRemoveListVo(DynamicObject main, String fieldKey) {
        boolean isNeedRemove = false;
        DynamicObjectCollection planEntrys = main.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntrys) {
            if (ObjectUtils.isEmpty((Object)planEntry.getString(fieldKey))) continue;
            isNeedRemove = true;
            break;
        }
        return isNeedRemove;
    }

    private DynamicObject[] getAsstObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        HashSet<String> coreBillNos = new HashSet<String>();
        HashSet<String> coreBillSeqs = new HashSet<String>();
        for (DynamicObject main : objArr) {
            DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection("detailentry");
            for (DynamicObject mainEntry : mainEntrys) {
                String coreBillNo = mainEntry.getString("corebillno");
                String coreBillseq = mainEntry.getString("corebillentryseq");
                if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
                coreBillNos.add(coreBillNo);
                coreBillSeqs.add(coreBillseq);
            }
        }
        DynamicObject[] asstObjs = null;
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter[] payFilter = new QFilter[]{new QFilter("paymenttype.ispartpayment", "=", (Object)Character.valueOf('1')), new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.e_unsettledamt", "<>", (Object)0)};
            Object[] payObjs = PayBillHandleHelper.loadPay((QFilter[])payFilter);
            QFilter[] paidFilter = new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("paymenttype.ispartpayment", "=", (Object)Character.valueOf('1')), new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.e_unsettledamt", "<>", (Object)0)};
            Object[] paidObjs = PayBillHandleHelper.loadPaid((QFilter[])paidFilter);
            asstObjs = (DynamicObject[])ArrayUtils.addAll((Object[])payObjs, (Object[])paidObjs);
        }
        scheme.setOnlyByCoreBill(true);
        return asstObjs;
    }

    private DynamicObject[] getMainObjs(DynamicObject[] assts, SettleSchemeVO scheme) {
        DynamicObject[] mainBills = null;
        HashSet<Long> asstIds = new HashSet<Long>(8);
        HashSet<Long> entryIdSet = new HashSet<Long>(8);
        for (DynamicObject asst : assts) {
            asstIds.add(asst.getLong("id"));
            DynamicObjectCollection entryColl = asst.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entryIdSet.add(entry.getLong("id"));
            }
        }
        Map finApBillMap = BOTPHelper.loadNearUpBillIds((String)ASST_PAYBILL, (String)"entry", (Long[])asstIds.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)"ap_finapbill");
        if (finApBillMap.size() > 0) {
            HashSet finApBillIds = new HashSet(10);
            for (Map.Entry mapEntry : finApBillMap.entrySet()) {
                finApBillIds.addAll((Collection)mapEntry.getValue());
            }
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", finApBillIds), new QFilter("detailentry.unsettleamt", "<>", (Object)0)};
            mainBills = FinApBillHandleHelper.load((QFilter[])filter);
            scheme.setOnlyByBotp(true);
            return mainBills;
        }
        DynamicObjectCollection asstColl = QueryServiceHelper.query((String)ASST_PAYBILL, (String)"id,entry.id,entry.e_corebillno,entry.e_corebillentryseq,entry.settleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        HashSet<String> coreBillNos = new HashSet<String>(asstColl.size());
        HashSet<String> coreBillSeqs = new HashSet<String>(asstColl.size());
        HashSet<Long> settleOrgIds = new HashSet<Long>(asstColl.size());
        for (DynamicObject asstObj : asstColl) {
            String coreBillNo = asstObj.getString("entry.e_corebillno");
            String coreBillseq = asstObj.getString("entry.e_corebillentryseq");
            long settleOrgId = asstObj.getLong("entry.settleorg");
            if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
            coreBillNos.add(coreBillNo);
            coreBillSeqs.add(coreBillseq);
            if (settleOrgId == 0L) continue;
            settleOrgIds.add(settleOrgId);
        }
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter mainfilter = new QFilter("billstatus", "=", (Object)"C");
            mainfilter.and(new QFilter("detailentry.corebillno", "in", coreBillNos));
            mainfilter.and(new QFilter("detailentry.unsettleamt", "<>", (Object)0));
            if (settleOrgIds.size() > 0) {
                mainfilter.and(new QFilter("org", "in", settleOrgIds));
            }
            mainBills = FinApBillHandleHelper.load((QFilter[])mainfilter.toArray());
            scheme.setOnlyByCoreBill(true);
        }
        return mainBills;
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

