/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.ApPayAutoSettleService;
import kd.fi.ap.mservice.RefundAndRenoteConfirmHelper;
import kd.fi.ap.vo.ApPaySettleParam;
import kd.fi.ap.vo.ApPayUnSettleParam;
import kd.fi.ap.vo.PayInfo;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.freeze.RefundAndRenoteFreezeService;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.Result;
import kd.fi.arapcommon.vo.SettleSchemeVO;

@Deprecated
public class ApPaySettleApi {
    private static final Log logger = LogFactory.getLog(ApPaySettleApi.class);

    public Result settleByPayEntryId(String paramJson) {
        logger.info("ApPaySettleApi.settleByPayEntryId param:" + paramJson);
        ApPaySettleParam param = (ApPaySettleParam)JSON.parseObject((String)paramJson, ApPaySettleParam.class);
        List payInfos = param.getPayInfos();
        Set<Long> payIds = payInfos.stream().map(PayInfo::getPayId).collect(Collectors.toSet());
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"appaysettle");){
            DynamicObject[] payBills = PayBillHandleHelper.loadPay((QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
            this.resolvePayBill(payInfos, payBills);
            this.resolveApPaySettle(payIds, payBills);
            this.resolveArPaySettle(payIds, payBills);
            Result result = Result.success();
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            tx.markRollback();
            Result result = Result.ex((Throwable)e);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public Result unSettleByPayId(String paramJson) {
        logger.info("ApPaySettleApi.unSettleByPayId param:" + paramJson);
        ApPayUnSettleParam param = (ApPayUnSettleParam)JSON.parseObject((String)paramJson, ApPayUnSettleParam.class);
        boolean isRefund = param.getRefund();
        HashSet<Long> payIds = new HashSet<Long>(param.getPayIds());
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"appayunsettle");){
            List<DynamicObject> settleRecords = this.getSettleRecords(payIds);
            RefundAndRenoteConfirmHelper.payUnSettle(settleRecords, payIds);
            ArrayList<Long> recordIds = new ArrayList<Long>(settleRecords.size());
            for (DynamicObject settleRecord : settleRecords) {
                recordIds.add(settleRecord.getLong("id"));
            }
            RefundAndRenoteFreezeService service = new RefundAndRenoteFreezeService();
            service.freeze(new HashSet<Long>(payIds), true);
            logger.info("ApPaySettleApi.unSettleByPayId result:" + recordIds);
            Result result = Result.success(recordIds);
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            tx.markRollback();
            Result result = Result.ex((Throwable)e);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void resolveArPaySettle(Set<Long> payIds, DynamicObject[] payBills) {
        logger.info("ApPaySettleApi.resolveArPaySettle:" + payIds);
        HashSet<Long> entryIdSet = new HashSet<Long>(payBills.length);
        for (DynamicObject payBill : payBills) {
            DynamicObjectCollection entryColl = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entryIdSet.add(entry.getLong("id"));
            }
        }
        Map payUpArMap = BOTPHelper.loadNearUpBillIds((String)"cas_paybill", (String)"entry", (Long[])payIds.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)"ap_finapbill");
        HashSet arBillIds = new HashSet(16);
        payUpArMap.forEach((k, v) -> arBillIds.addAll(v));
        if (arBillIds.size() == 0) {
            return;
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setUnSettleByReturn(true);
        Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"arpaysettle", (String)"batchAutoSettle", (Object[])new Object[]{payBills, Boolean.FALSE, scheme});
        logger.info("ApPaySettleApi.resolveArPaySettle updateSettleDate");
        List apPaySettleRecordPks = scheme.getRecordPks();
        if (apPaySettleRecordPks != null && apPaySettleRecordPks.size() > 0) {
            this.updateSettleRecordSettleDate(apPaySettleRecordPks, payBills);
        }
        logger.info("arpaysettle.batchAutoSettle result:" + result);
        logger.info("ApPaySettleApi.resolveArPaySettle end");
    }

    private void resolveApPaySettle(Set<Long> payIds, DynamicObject[] payBills) {
        logger.info("ApPaySettleApi.resolveApPaySettle:" + payIds);
        HashSet<Long> entryIdSet = new HashSet<Long>(8);
        for (DynamicObject payBill : payBills) {
            DynamicObjectCollection entryColl = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entryIdSet.add(entry.getLong("id"));
            }
        }
        Map payUpApMap = BOTPHelper.loadNearUpBillIds((String)"cas_paybill", (String)"entry", (Long[])payIds.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)"ap_finapbill");
        HashSet apBillIds = new HashSet(16);
        payUpApMap.forEach((k, v) -> apBillIds.addAll(v));
        if (apBillIds.size() == 0) {
            return;
        }
        ApPayAutoSettleService apPayAutoSettleService = new ApPayAutoSettleService();
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setUnSettleByReturn(true);
        apPayAutoSettleService.batchAutoSettle(payBills, false, scheme);
        logger.info("ApPaySettleApi.resolveApPaySettle updateSettleDate");
        List apPaySettleRecordPks = scheme.getRecordPks();
        if (apPaySettleRecordPks != null && apPaySettleRecordPks.size() > 0) {
            this.updateSettleRecordSettleDate(apPaySettleRecordPks, payBills);
        }
        logger.info("ApPaySettleApi.resolveApPaySettle end");
    }

    private void resolvePayBill(List<PayInfo> payInfos, DynamicObject[] payBills) {
        HashMap<Long, BigDecimal> payEntryMap = new HashMap<Long, BigDecimal>(32);
        for (PayInfo payInfo : payInfos) {
            payEntryMap.put(payInfo.getEntryId(), payInfo.getEntryNeedAmt());
        }
        Set payEntryIds = payEntryMap.keySet();
        for (int i = payBills.length - 1; i >= 0; --i) {
            DynamicObject payBill = payBills[i];
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long entryId = entry.getLong("id");
                if (!payEntryIds.contains(entryId)) {
                    iterator.remove();
                    continue;
                }
                BigDecimal needSettleAmt = (BigDecimal)payEntryMap.get(entryId);
                entry.set("e_unsettledamt", (Object)needSettleAmt);
            }
        }
    }

    private List<DynamicObject> getSettleRecords(Set<Long> payIds) {
        ArrayList<String> settleRelations = new ArrayList<String>(2);
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARPAYSETTLE.getValue());
        QFilter filter = new QFilter("settlerelation", "in", settleRelations);
        filter.and("entry.billid", "in", payIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = SettleRecordQueryHelper.getSettleRecords((String)"ap_settlerecord", (String)"id,org,settletype,settledate,settlerelation,mainbillid,mainbilltype,maincurrency,mainbillentryid,totalsettleamt,localtotalsettleamt,exchangerate,swappl,autosettletype,corebillid,corebillentryid,settleentry,billentity,mainpayableamt,settlerelation,iswrittenoff,hadwrittenoff,entry.billtype,entry.currency,entry.settleamt,entry.e_billentity,entry.billid,entry.billentryid,entry.e_swappl,entry.e_exchangerate,entry.e_settleentry,entry.e_hadwrittenoff,isvoucher,entry.payableamt,entry.localsettleamt", (String)"cas_paybill", (Object[])payIds.toArray(), (QFilter)filter);
        return Arrays.stream(settleRecords).collect(Collectors.toList());
    }

    private void updateSettleRecordSettleDate(List<Object> settleRecordPks, DynamicObject[] payBills) {
        QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.PAYRECSETTLE.getValue());
        List payBillIds = Arrays.stream(payBills).map(paybill -> paybill.getLong("id")).collect(Collectors.toList());
        filter.and("mainbillid", "in", payBillIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] payRecSettleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,settledate", (QFilter[])new QFilter[]{filter});
        if (payRecSettleRecords.length > 0) {
            DynamicObject[] currenctSettleRecords;
            Date settleDate = payRecSettleRecords[0].getDate("settledate");
            for (DynamicObject currenctSettleRecord : currenctSettleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,settledate", (QFilter[])new QFilter[]{new QFilter("id", "in", settleRecordPks)})) {
                currenctSettleRecord.set("settledate", (Object)settleDate);
            }
            SaveServiceHelper.save((DynamicObject[])currenctSettleRecords);
        }
    }
}

