/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.ApRecSettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApRecManualSettleService
implements IManualSettleService {
    public static final String ASST_RECBILL = "cas_recbill";
    private ApRecSettleService service;

    public ApRecManualSettleService() {
        this.service = new ApRecSettleService();
    }

    public ApRecManualSettleService(ApRecSettleService service) {
        this.service = service;
    }

    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("id"));
            mainEntryIdSet.add(main.getLong("entryid"));
        }
        HashSet<Long> recBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> recEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            recBillIdSet.add(asst.getLong("asst_id"));
            recEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        DynamicObject[] mainArr = this.reloadMainArr(mainBillIdSet);
        DynamicObject[] recArr = this.reloadRecArr(recBillIdSet);
        this.processMain(mainArr, mainRows, mainEntryIdSet, manualParam);
        this.processAsst(recArr, asstRows, recEntryIdSet, manualParam);
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        scheme.setSettleEntryParam(manualParam.getSettleEntryParam());
        scheme.setSettleDate(manualParam.getSettleDate());
        List mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
        List asstListVO = RecBillHandlerHelper.getAsstListVO((DynamicObject[])recArr);
        this.service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
    }

    private void processMain(DynamicObject[] mainArr, DynamicObject[] mainRows, Set<Long> mainEntryIdSet, ManualSettleParam param) {
        int settleEntryParam = param.getSettleEntryParam();
        if (param.isTotal()) {
            for (DynamicObject main : mainRows) {
                BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                long id = main.getLong("id");
                for (DynamicObject mainObj : mainArr) {
                    if (id != mainObj.getLong("id")) continue;
                    mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                    DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                    Iterator iterator = entrys.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject entry = (DynamicObject)iterator.next();
                        BigDecimal entryUnLockAmt = entry.getBigDecimal(this.getApEntryUnLockKey(settleEntryParam));
                        if (entryUnLockAmt.compareTo(BigDecimal.ZERO) > 0) {
                            iterator.remove();
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnLockAmt.abs()) >= 0) {
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)entryUnLockAmt);
                            curSettleAmt = curSettleAmt.subtract(entryUnLockAmt);
                            continue;
                        }
                        entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject mainObj : mainArr) {
                long id = mainObj.getLong("id");
                DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getApEntryKey(settleEntryParam));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal(this.getApEntryAmtKey(settleEntryParam));
                    if (mainEntryIdSet.contains(entryId)) {
                        for (DynamicObject main : mainRows) {
                            if (id != main.getLong("id") || entryId != main.getLong("entryid")) continue;
                            mainObj.set("exchangerate", (Object)main.getBigDecimal("exchangerate"));
                            BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set(this.getApEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    private void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                    Iterator iterator = entrys.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject entry = (DynamicObject)iterator.next();
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (entryUnSettleAmt.compareTo(BigDecimal.ZERO) < 0) {
                            iterator.remove();
                        }
                        if (ASST_RECBILL.equals(asstObj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("e_settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_receivingtype")) || !entry.getDynamicObject("e_receivingtype").getBoolean("ispartreceivable"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    protected DynamicObject[] reloadMainArr(Set<Long> mainBillIdSet) {
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", mainBillIdSet)};
        DynamicObject[] mainObjs = FinApBillHandleHelper.load((QFilter[])filter);
        return mainObjs;
    }
}

