/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.enums.ApplypaystatusEnum;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public class ApplyOnlinePayService {
    private static final Log logger = LogFactory.getLog(ApplyOnlinePayService.class);

    public void syncBill(Object params) {
        try (TXHandle tx = TX.required((String)"ApplyOnlinePayService-syncBill");){
            try {
                List paramList = (List)params;
                logger.info("ApplyOnlinePayService.syncBill param:" + params);
                HashMap<Long, DisposerInfo> disposerInfoMap = new HashMap<Long, DisposerInfo>(paramList.size());
                HashSet<DynamicObject[]> sourceIdSet = new HashSet<DynamicObject[]>(10);
                for (Map param : paramList) {
                    Iterator disposerInfo;
                    DynamicObject[] sourceId = (DynamicObject[])param.get("sourcepk");
                    Long sourceEntryId = (Long)param.get("sourceentrypk");
                    String operate = (String)param.get("operate");
                    boolean isSuccess = (Boolean)param.get("issuccess");
                    BigDecimal disposeAmt = (BigDecimal)param.get("payableamt");
                    if ("cancelPay".equals(operate)) {
                        disposeAmt = disposeAmt.negate();
                    }
                    if ("renote".equals(operate) || "refund".equals(operate) || "cancelRenote".equals(operate) || "cancelRefund".equals(operate)) {
                        disposeAmt = ((BigDecimal)param.get("refundamt")).negate();
                    }
                    if ((disposerInfo = (DisposerInfo)disposerInfoMap.get(sourceEntryId)) != null) {
                        disposeAmt = disposeAmt.add(((DisposerInfo)((Object)disposerInfo)).disposeAmt);
                    }
                    sourceIdSet.add(sourceId);
                    disposerInfoMap.put(sourceEntryId, new DisposerInfo((Long)sourceId, disposeAmt, operate, isSuccess));
                }
                ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_payapply", (String)"WriteBackApply", sourceIdSet, (boolean)true);
                DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"id,sourcebilltype,entry.e_paidamt,paycurrency,settleorg,entry.e_asstacttype,entry.e_asstact,aprseleamount,approvalamount,paystatus,entry.lockedamt,entry.e_corebillid,entry.e_corebillentryid,entry.e_approvedseleamt,entry.e_conbillid,entry.e_conbillentryid,entry.e_corebilltype,entry.e_paymenttype,entry.isrefund,entry.e_closestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceIdSet.toArray())});
                HashMap<Long, DynamicObject> applyBillMap = new HashMap<Long, DynamicObject>(applyBills.length);
                for (DynamicObject applyBill : applyBills) {
                    applyBillMap.put(applyBill.getLong("id"), applyBill);
                }
                Map<Long, Boolean> assactInterMap = this.getAssactInterMap(applyBills);
                ArrayList<Map<String, Object>> disposeUpParam = new ArrayList<Map<String, Object>>(disposerInfoMap.size());
                HashSet<DynamicObject> sendMsgApply = new HashSet<DynamicObject>(10);
                HashSet<Long> applyrefundIds = new HashSet<Long>(10);
                boolean isCancelRenoteOrRefund = false;
                for (Map.Entry entrySet : disposerInfoMap.entrySet()) {
                    Long entryId = (Long)entrySet.getKey();
                    DisposerInfo disposerInfo = (DisposerInfo)entrySet.getValue();
                    Long sourceId = disposerInfo.getSourceId();
                    BigDecimal disposeAmt = disposerInfo.getDisposeAmt();
                    String operate = disposerInfo.getOperate();
                    boolean isSuccess = disposerInfo.isSuccess();
                    DynamicObject applyBill = (DynamicObject)applyBillMap.get(sourceId);
                    if (applyBill == null) continue;
                    DynamicObjectCollection entries = applyBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        Map<String, Object> disposeParam;
                        String rowclosestatus;
                        if (!entryId.equals(entry.getLong("id"))) continue;
                        entry.set("e_paidamt", (Object)entry.getBigDecimal("e_paidamt").add(disposeAmt));
                        if (this.isDisposeLock(operate)) {
                            entry.set("lockedamt", (Object)entry.getBigDecimal("lockedamt").add(disposeAmt));
                        }
                        if ("renote".equals(operate) && disposeAmt.compareTo(BigDecimal.ZERO) != 0) {
                            entry.set("isrefund", (Object)Boolean.TRUE);
                            sendMsgApply.add(applyBill);
                        }
                        if (("cancelRenote".equals(operate) || "cancelRefund".equals(operate)) && disposeAmt.compareTo(BigDecimal.ZERO) != 0) {
                            entry.set("isrefund", (Object)Boolean.FALSE);
                        }
                        if ("cancelRenote".equals(operate) || "cancelRefund".equals(operate)) {
                            isCancelRenoteOrRefund = true;
                        }
                        if ("renote".equals(operate) || "refund".equals(operate) || "cancelRenote".equals(operate) || "cancelRefund".equals(operate)) {
                            rowclosestatus = entry.getString("e_closestatus");
                            if (!"B".equals(rowclosestatus)) continue;
                            applyrefundIds.add(sourceId);
                            continue;
                        }
                        if ("pay".equals(operate) && "B".equals(rowclosestatus = entry.getString("e_closestatus"))) {
                            applyrefundIds.add(sourceId);
                        }
                        if (ObjectUtils.isEmpty(disposeParam = this.buildDisposeParam(disposeAmt, isSuccess, applyBill, entry, assactInterMap))) continue;
                        disposeUpParam.add(disposeParam);
                    }
                }
                for (Map.Entry entrySet : applyBillMap.entrySet()) {
                    DynamicObject applyBill = (DynamicObject)entrySet.getValue();
                    this.updateStatus(applyBill);
                }
                SaveServiceHelper.save((DynamicObject[])applyBillMap.values().toArray(new DynamicObject[0]));
                if (applyrefundIds.size() > 0) {
                    OperationResult saveResult;
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("mutex_writeback", "false");
                    if (isCancelRenoteOrRefund) {
                        saveResult = OperationServiceHelper.executeOperate((String)"valid", (String)"ap_payapply", (Object[])applyrefundIds.toArray(), (OperateOption)option);
                        OperationHelper.assertResult((OperationResult)saveResult);
                    } else {
                        saveResult = OperationServiceHelper.executeOperate((String)"savewb", (String)"ap_payapply", (Object[])applyrefundIds.toArray(), (OperateOption)option);
                        OperationHelper.assertResult((OperationResult)saveResult);
                    }
                }
                if (sendMsgApply.size() > 0) {
                    OperationServiceHelper.executeOperate((String)"refundsendmsg", (String)"ap_payapply", (DynamicObject[])sendMsgApply.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                }
                Settle4ScmcHelper.writeBackPurOrderOrContract(disposeUpParam, (boolean)false);
                BizExtendHelper.casPayBillPayCallbackExt((Object)params);
                logger.info("ApplyOnlinePayService.syncBill end");
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                tx.markRollback();
                throw e;
            }
        }
    }

    private Map<String, Object> buildDisposeParam(BigDecimal disposeAmt, boolean isSuccess, DynamicObject applyBill, DynamicObject entry, Map<Long, Boolean> assactInterMap) {
        HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>(8);
        String coreBillType = entry.getString("e_corebilltype");
        long coreBillId = entry.getLong("e_corebillid");
        long coreEntryId = entry.getLong("e_corebillentryid");
        long conBillEntryId = entry.getLong("e_conbillentryid");
        long conBillId = entry.getLong("e_conbillid");
        long asstactId = entry.getLong("e_asstact.id");
        if (0L == coreBillId && 0L == conBillId) {
            return disposeRowInfo;
        }
        disposeRowInfo.put("mainbillentity", coreBillType);
        disposeRowInfo.put("mainbillid", coreBillId);
        disposeRowInfo.put("mainbillentryid", coreEntryId);
        disposeRowInfo.put("settleorgid", applyBill.getLong("settleorg.id"));
        disposeRowInfo.put("supplierid", asstactId);
        disposeRowInfo.put("internal_company", assactInterMap.getOrDefault(asstactId, Boolean.FALSE));
        disposeRowInfo.put("mainBillEntity", coreBillType);
        disposeRowInfo.put("mainBillID", coreBillId);
        disposeRowInfo.put("mainBillEntryID", coreEntryId);
        disposeRowInfo.put("contractID", conBillId);
        disposeRowInfo.put("contractEntryID", conBillEntryId);
        disposeRowInfo.put("bizType", entry.getString("e_paymenttype.biztype"));
        disposeRowInfo.put("srcBillEntity", applyBill.getString("sourcebilltype"));
        disposeRowInfo.put("accessType", "AP");
        disposeRowInfo.put("asstactID", asstactId);
        disposeRowInfo.put("settleOrgID", applyBill.getLong("settleorg.id"));
        disposeRowInfo.put("internalAsst", assactInterMap.getOrDefault(asstactId, Boolean.FALSE));
        disposeRowInfo.put("amount", disposeAmt);
        disposeRowInfo.put("scene", "pre_pay_writeback");
        disposeRowInfo.put("ArApBillId", applyBill.getLong("id"));
        disposeRowInfo.put("issuccess", isSuccess);
        return disposeRowInfo;
    }

    private void updateStatus(DynamicObject applypay) {
        DynamicObjectCollection entries = applypay.getDynamicObjectCollection("entry");
        BigDecimal payAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            payAmt = payAmt.add(entry.getBigDecimal("e_paidamt"));
        }
        if (payAmt.compareTo(BigDecimal.ZERO) == 0) {
            applypay.set("paystatus", (Object)ApplypaystatusEnum.Unpaid);
        } else if (payAmt.compareTo(applypay.getBigDecimal("aprseleamount")) >= 0) {
            applypay.set("paystatus", (Object)ApplypaystatusEnum.Alreadypay);
        } else {
            applypay.set("paystatus", (Object)ApplypaystatusEnum.Inpayment);
        }
    }

    private boolean isDisposeLock(String operate) {
        return "renote".equals(operate) || "refund".equals(operate) || "cancelRenote".equals(operate) || "cancelRefund".equals(operate);
    }

    private void invokeScmc(DynamicObject applypay, List<Map<String, Object>> disposeData) {
        block31: {
            if (disposeData != null && disposeData.size() > 0) {
                String sourcebillType = applypay.getString("sourcebilltype");
                logger.info("ApplyOnlinePayService.invokeScmc param : sourcebillType:" + sourcebillType + ",disposeData:" + disposeData);
                if ("pm_purorderbill".equals(sourcebillType)) {
                    try (TXHandle tx = TX.requiresNew((String)"payinvokeScmc");){
                        try {
                            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurService", (String)"WbPrePaidAmount", (Object[])new Object[]{disposeData});
                            break block31;
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("context", (Throwable)e);
                            throw e;
                        }
                    }
                }
                if ("conm_purcontract".equals(sourcebillType)) {
                    try (TXHandle tx = TX.requiresNew((String)"payinvokeScmc");){
                        try {
                            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"WbPrePaidAmount", (Object[])new Object[]{disposeData});
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("context", (Throwable)e);
                            throw e;
                        }
                    }
                }
            }
        }
    }

    private Map<Long, Boolean> getAssactInterMap(DynamicObject[] applyBills) {
        Map tempMap;
        HashMap<Long, Boolean> assactInterMap = new HashMap<Long, Boolean>(64);
        HashSet<Long> supplierIds = new HashSet<Long>();
        HashSet<Long> customerIds = new HashSet<Long>();
        for (DynamicObject applyBill : applyBills) {
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                String eAsstactType = detail.getString("e_asstacttype");
                if ("bd_supplier".equals(eAsstactType)) {
                    supplierIds.add(detail.getLong("e_asstact.id"));
                }
                if (!"bd_customer".equals(eAsstactType)) continue;
                customerIds.add(detail.getLong("e_asstact.id"));
            }
        }
        if (!supplierIds.isEmpty()) {
            tempMap = AsstactHelper.isExistInternalBusinessUnit((String)"bd_supplier", (Long[])supplierIds.toArray(new Long[0]));
            assactInterMap.putAll(tempMap);
        }
        if (!customerIds.isEmpty()) {
            tempMap = AsstactHelper.isExistInternalBusinessUnit((String)"bd_customer", (Long[])customerIds.toArray(new Long[0]));
            assactInterMap.putAll(tempMap);
        }
        return assactInterMap;
    }

    private static class DisposerInfo {
        Long sourceId;
        BigDecimal disposeAmt;
        String operate;
        boolean success;

        public DisposerInfo(Long sourceId, BigDecimal disposeAmt, String operate, boolean success) {
            this.sourceId = sourceId;
            this.disposeAmt = disposeAmt;
            this.operate = operate;
            this.success = success;
        }

        public String getOperate() {
            return this.operate;
        }

        public void setOperate(String operate) {
            this.operate = operate;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public Long getSourceId() {
            return this.sourceId;
        }

        public BigDecimal getDisposeAmt() {
            return this.disposeAmt;
        }

        public void setSourceId(Long sourceId) {
            this.sourceId = sourceId;
        }

        public void setDisposeAmt(BigDecimal disposeAmt) {
            this.disposeAmt = disposeAmt;
        }
    }
}

