/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.ap.vo.CancelRefundAndRenoteParam;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.arapcommon.vo.ConmBillInfo;
import kd.fi.arapcommon.vo.CoreBillInfo;
import org.apache.commons.lang.StringUtils;

public class CancelRefundAndRenoteApplyCoreBillAmtValidate {
    private static final Log logger = LogFactory.getLog(CancelRefundAndRenoteApplyCoreBillAmtValidate.class);

    public void validate(CancelRefundAndRenoteParam param) {
        logger.info("CancelRefundAndRenoteApplyCoreBillAmtValidate start");
        HashMap<Long, BigDecimal> applyWriteBackAmt = new HashMap<Long, BigDecimal>(16);
        if (!this.isExeccontrolOpen()) {
            logger.info("execcontrol is closed");
            return;
        }
        List<DynamicObject> applyBills = this.queryNeedVaildateApplyBills(param, applyWriteBackAmt);
        if (applyBills.size() == 0) {
            logger.info("no needvalidator applybill");
            return;
        }
        logger.info("applybill prepare writeback info:" + applyWriteBackAmt);
        HashMap<Long, ConmBillInfo> conmBillInfoMap = new HashMap<Long, ConmBillInfo>(16);
        HashSet<Long> purOrderIds = new HashSet<Long>(16);
        Map<String, CoreBillInfo> coreBillInfo = this.queryCoreBill(applyBills, conmBillInfoMap, purOrderIds);
        if (coreBillInfo.size() == 0) {
            return;
        }
        logger.info("query corebillinfo:" + coreBillInfo);
        HashMap<Long, Long> orderIdToConmIds = new HashMap<Long, Long>(16);
        for (Map.Entry entrySet : conmBillInfoMap.entrySet()) {
            Long conmBillId = (Long)entrySet.getKey();
            Set orderIds = ((ConmBillInfo)entrySet.getValue()).getOrderBillIds();
            for (Long orderId : orderIds) {
                orderIdToConmIds.put(orderId, conmBillId);
            }
        }
        this.processConmPrePay(conmBillInfoMap);
        Map<Long, Long> supplierMasterIds = this.getSupplierMasterId(coreBillInfo, conmBillInfoMap);
        Map<Long, Integer> precisions = this.getPrecision(coreBillInfo);
        this.loadNeedCtrlFinBillInfos(coreBillInfo, conmBillInfoMap, purOrderIds, orderIdToConmIds, applyWriteBackAmt);
        Set<String> prePayOverToleranceIds = this.processTolerance(coreBillInfo, precisions, true);
        Set<String> sumAmtOverToleranceIds = this.processTolerance(coreBillInfo, precisions, false);
        Set<Long> conmSumAmtToleranceIds = this.processConmToleance(conmBillInfoMap, precisions);
        this.doValidate(applyBills.toArray(new DynamicObject[0]), coreBillInfo, prePayOverToleranceIds, sumAmtOverToleranceIds, conmBillInfoMap, orderIdToConmIds, conmSumAmtToleranceIds, supplierMasterIds);
    }

    private void doValidate(DynamicObject[] bills, Map<String, CoreBillInfo> coreBillInfos, Set<String> prePayOverToleranceIds, Set<String> sumAmtOverToleranceIds, Map<Long, ConmBillInfo> conmBillInfoMap, Map<Long, Long> orderIdToConmIds, Set<Long> conmSumAmtToleranceIds, Map<Long, Long> supplierMasterIds) {
        HashSet<String> messages = new HashSet<String>(16);
        for (DynamicObject applyBill : bills) {
            String msg;
            ConmBillInfo conmBillInfo;
            Long conmBillId;
            String billNo = applyBill.getString("billno");
            Long orgId = applyBill.getLong("settleorg");
            Long currencyId = applyBill.getLong("settlecurrency");
            Long payCurrencyId = applyBill.getLong("paycurrency");
            HashSet<String> orderPreOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> orderOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> orderPreOverPayCoreTolBillNo = new HashSet<String>(16);
            HashSet<String> orderOverPayCoreBillTolNo = new HashSet<String>(16);
            HashSet<String> conPreOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> conOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> conPreOverPayCoreTolBillNo = new HashSet<String>(16);
            HashSet<String> conOverPayCoreBillTolNo = new HashSet<String>(16);
            HashSet<String> scpoPreOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> scpoOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> scpoPreOverPayCoreTolBillNo = new HashSet<String>(16);
            HashSet<String> scpoOverPayCoreBillTolNo = new HashSet<String>(16);
            HashSet<String> pmomPreOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> pmomOverPayCoreBillNo = new HashSet<String>(16);
            HashSet<String> pmomPreOverPayCoreTolBillNo = new HashSet<String>(16);
            HashSet<String> pmomOverPayCoreBillTolNo = new HashSet<String>(16);
            HashSet<String> conmOverPayNo = new HashSet<String>(16);
            HashSet<String> conmOverToleranceNo = new HashSet<String>(16);
            Long coreBillId = applyBill.getLong("entry.e_corebillid");
            if (coreBillId == 0L) continue;
            Long asstactId = applyBill.getLong("entry.e_asstact");
            Long masterId = supplierMasterIds.getOrDefault(asstactId, asstactId);
            String key = coreBillId + "_" + orgId + "_" + masterId + "_" + currencyId;
            CoreBillInfo coreBillInfo = coreBillInfos.get(key);
            if (coreBillInfo == null) continue;
            String amtField = !currencyId.equals(payCurrencyId) ? ResManager.loadKDString((String)"\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_19", (String)"fi-ap-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6838\u51c6\u91d1\u989d", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_18", (String)"fi-ap-mservice", (Object[])new Object[0]);
            String coreBillType = applyBill.getString("entry.e_corebilltype");
            String coreBillNo = applyBill.getString("entry.e_corebillno");
            boolean isAllowOverPay = coreBillInfo.isAllowOverPay();
            if (isAllowOverPay) {
                if (prePayOverToleranceIds.contains(key)) {
                    if ("pm_purorderbill".equals(coreBillType)) {
                        orderPreOverPayCoreTolBillNo.add(coreBillNo);
                    } else if ("conm_purcontract".equals(coreBillType)) {
                        conPreOverPayCoreTolBillNo.add(coreBillNo);
                    } else if ("sctm_scpo".equals(coreBillType)) {
                        scpoPreOverPayCoreTolBillNo.add(coreBillNo);
                    } else if ("pm_om_purorderbill".equals(coreBillType)) {
                        pmomPreOverPayCoreTolBillNo.add(coreBillNo);
                    }
                }
                if (sumAmtOverToleranceIds.contains(key)) {
                    if ("pm_purorderbill".equals(coreBillType)) {
                        orderOverPayCoreBillTolNo.add(coreBillNo);
                    } else if ("conm_purcontract".equals(coreBillType)) {
                        conOverPayCoreBillTolNo.add(coreBillNo);
                    } else if ("sctm_scpo".equals(coreBillType)) {
                        scpoOverPayCoreBillTolNo.add(coreBillNo);
                    } else if ("pm_om_purorderbill".equals(coreBillType)) {
                        pmomOverPayCoreBillTolNo.add(coreBillNo);
                    }
                }
            } else {
                if (coreBillInfo.getSumPrePayAmt().compareTo(coreBillInfo.getPreparePayAmt()) > 0) {
                    if ("pm_purorderbill".equals(coreBillType)) {
                        orderPreOverPayCoreBillNo.add(coreBillNo);
                    } else if ("conm_purcontract".equals(coreBillType)) {
                        conPreOverPayCoreBillNo.add(coreBillNo);
                    } else if ("sctm_scpo".equals(coreBillType)) {
                        scpoPreOverPayCoreBillNo.add(coreBillNo);
                    } else if ("pm_om_purorderbill".equals(coreBillType)) {
                        pmomPreOverPayCoreBillNo.add(coreBillNo);
                    }
                }
                if (coreBillInfo.getSumAmt().compareTo(coreBillInfo.getCoreBillAmt()) > 0) {
                    if ("pm_purorderbill".equals(coreBillType)) {
                        orderOverPayCoreBillNo.add(coreBillNo);
                    } else if ("conm_purcontract".equals(coreBillType)) {
                        conOverPayCoreBillNo.add(coreBillNo);
                    } else if ("sctm_scpo".equals(coreBillType)) {
                        scpoOverPayCoreBillNo.add(coreBillNo);
                    } else if ("pm_om_purorderbill".equals(coreBillType)) {
                        pmomOverPayCoreBillNo.add(coreBillNo);
                    }
                }
            }
            if ((conmBillId = "pm_purorderbill".equals(coreBillType) ? orderIdToConmIds.get(coreBillId) : coreBillId) != null && (conmBillInfo = conmBillInfoMap.get(conmBillId)) != null) {
                boolean conmIsAllowOverPay = conmBillInfo.isAllowOverPay();
                if (conmIsAllowOverPay) {
                    if (conmSumAmtToleranceIds.contains(conmBillId)) {
                        conmOverToleranceNo.add(coreBillNo);
                    }
                } else if (conmBillInfo.getConmBillSumAmt().compareTo(conmBillInfo.getConmBillAmt()) > 0) {
                    conmOverPayNo.add(coreBillNo);
                }
            }
            if (orderPreOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355\u9884\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_0", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(orderPreOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (orderOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_1", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(orderOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (orderPreOverPayCoreTolBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u91c7\u8d2d\u8ba2\u5355\u9884\u4ed8\u91d1\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_2", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(orderPreOverPayCoreTolBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (orderOverPayCoreBillTolNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_3", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(orderOverPayCoreBillTolNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (conPreOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c\u9884\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_4", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(conPreOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (conOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_5", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(conOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (conPreOverPayCoreTolBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u91c7\u8d2d\u5408\u540c\u9884\u4ed8\u91d1\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_6", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(conPreOverPayCoreTolBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (conOverPayCoreBillTolNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_7", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(conOverPayCoreBillTolNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (scpoPreOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u9884\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_8", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(scpoPreOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (scpoOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_9", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(scpoOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (scpoPreOverPayCoreTolBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u9884\u4ed8\u91d1\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_10", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(scpoPreOverPayCoreTolBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (scpoOverPayCoreBillTolNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_11", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(scpoOverPayCoreBillTolNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (pmomPreOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u9884\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_12", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(pmomPreOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (pmomOverPayCoreBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_13", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(pmomOverPayCoreBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (pmomPreOverPayCoreTolBillNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u9884\u4ed8\u91d1\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_14", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(pmomPreOverPayCoreTolBillNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (pmomOverPayCoreBillTolNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c:%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_15", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(pmomOverPayCoreBillTolNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (conmOverPayNo.size() > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c\u4ef7\u7a0e\u5408\u8ba1\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c\uff1a%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_16", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(conmOverPayNo, (String)"\uff0c"));
                messages.add(msg);
            }
            if (conmOverToleranceNo.size() <= 0) continue;
            msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u4e0e\u91c7\u8d2d\u5408\u540c\u4ef7\u7a0e\u5408\u8ba1\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c\uff1a%3$s", (String)"CancelRefundAndRenoteApplyCoreBillAmtValidate_17", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo, amtField, StringUtils.join(conmOverToleranceNo, (String)"\uff0c"));
            messages.add(msg);
        }
        logger.info("errormessage count = " + messages.size());
        if (messages.size() > 0) {
            throw new KDBizException(StringUtils.join(messages, (String)"\n"));
        }
    }

    private List<DynamicObject> queryNeedVaildateApplyBills(CancelRefundAndRenoteParam param, Map<Long, BigDecimal> applyWriteBackAmtMap) {
        ArrayList<DynamicObject> applyBills = new ArrayList<DynamicObject>(2);
        List payEntryInfos = param.getPayInfos();
        HashSet<Long> payIds = new HashSet<Long>(2);
        HashSet<Long> payEntryIds = new HashSet<Long>(2);
        HashMap<Long, BigDecimal> payEntryRefundAmtMap = new HashMap<Long, BigDecimal>(2);
        for (PayRefundEntryInfo info : payEntryInfos) {
            payIds.add(info.getPayId());
            payEntryIds.add(info.getEntryId());
            payEntryRefundAmtMap.put(info.getEntryId(), info.getEntryRefundAmt());
        }
        logger.info("CancelRefundAndRenoteApplyCoreBillAmtValidate payid:" + payIds);
        logger.info("CancelRefundAndRenoteApplyCoreBillAmtValidate payentryid:" + payEntryIds);
        DataSet applySet = QueryServiceHelper.queryDataSet((String)"ApplyCoreBillAmtValidate", (String)"cas_paybill", (String)"entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds), new QFilter("entry.id", "in", payEntryIds), new QFilter("sourcebilltype", "=", (Object)"ap_payapply")}, null);
        HashSet<Long> applyIds = new HashSet<Long>(2);
        HashSet<Long> applyEntryIds = new HashSet<Long>(2);
        for (Row row : applySet) {
            applyIds.add(row.getLong("entry.e_sourcebillid"));
            Long applyEntryId = row.getLong("entry.e_sourcebillentryid");
            applyEntryIds.add(applyEntryId);
            Long payEntryId = row.getLong("entry.id");
            BigDecimal payEntryRefundAmt = (BigDecimal)payEntryRefundAmtMap.get(payEntryId);
            if (payEntryRefundAmt == null) continue;
            BigDecimal applyEntryWriteBackAmt = applyWriteBackAmtMap.get(applyEntryId);
            if (applyEntryWriteBackAmt == null) {
                applyWriteBackAmtMap.put(applyEntryId, payEntryRefundAmt);
                continue;
            }
            applyWriteBackAmtMap.put(applyEntryId, applyEntryWriteBackAmt.add(payEntryRefundAmt));
        }
        if (applyIds.size() == 0 || applyEntryIds.size() == 0) {
            logger.info("CancelRefundAndRenoteApplyCoreBillAmtValidate not have applybill");
            return applyBills;
        }
        logger.info("CancelRefundAndRenoteApplyCoreBillAmtValidate applyid:" + applyIds);
        logger.info("CancelRefundAndRenoteApplyCoreBillAmtValidate applyentryid:" + applyEntryIds);
        String selector = "id,billno,billstatus,sourcebilltype,settleorg,paycurrency,settlecurrency,entry.e_paymenttype.biztype,entry.e_asstact,entry.e_corebillid,entry.e_approvedseleamt,entry.e_paidamt,entry.e_corebillentryid,entry.id,entry.e_closestatus,entry.e_corebilltype,entry.e_corebillno";
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"ap_payapply", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", applyIds), new QFilter("entry.id", "in", applyEntryIds), new QFilter("entry.e_closestatus", "=", (Object)"B")});
        for (DynamicObject bill : bills) {
            String coreBillType;
            long coreBillId = bill.getLong("entry.e_corebillid");
            if (coreBillId == 0L || !"pm_purorderbill".equals(coreBillType = bill.getString("entry.e_corebilltype")) && !"conm_purcontract".equals(coreBillType) && !"pm_om_purorderbill".equals(coreBillType) && !"sctm_scpo".equals(coreBillType)) continue;
            applyBills.add(bill);
        }
        logger.info("CancelRefundAndRenoteApplyCoreBillAmtValidate need validator applybill" + applyBills.size());
        return applyBills;
    }

    private Set<Long> processConmToleance(Map<Long, ConmBillInfo> conmBillInfoMap, Map<Long, Integer> precisions) {
        HashSet<Long> overToleranceId = new HashSet<Long>(16);
        ArrayList<Map<String, Object>> conmParams = new ArrayList<Map<String, Object>>(16);
        ToleranceMatchService service = new ToleranceMatchService();
        for (Map.Entry<Long, ConmBillInfo> entrySet : conmBillInfoMap.entrySet()) {
            BigDecimal contrastValue;
            ConmBillInfo conmBillInfo = entrySet.getValue();
            HashMap<String, Number> param = new HashMap<String, Number>(16);
            BigDecimal controlValue = conmBillInfo.getConmBillSumAmt();
            if (controlValue.compareTo(contrastValue = conmBillInfo.getConmBillAmt()) == 0) continue;
            param.put("pk", entrySet.getKey());
            param.put("bd_supplier", conmBillInfo.getSupplierId());
            param.put("bos_org", conmBillInfo.getOrgId());
            param.put("controlvalue", controlValue);
            param.put("contrastvalue", contrastValue);
            param.put("bd_currency", conmBillInfo.getCurrencyId());
            param.put("precision", precisions.get(conmBillInfo.getCurrencyId()));
            conmParams.add(param);
        }
        List<Map<String, Object>> results = service.getResultByToleranceType("ap_payapply", "conm_purcontract", "aprseleamount", "totalallamount", conmParams);
        for (Map<String, Object> result : results) {
            overToleranceId.add((Long)result.get("pk"));
        }
        return overToleranceId;
    }

    private Set<String> processTolerance(Map<String, CoreBillInfo> coreBillInfo, Map<Long, Integer> precisions, boolean isPrePay) {
        HashSet<String> overToleranceId;
        block24: {
            List<Map<String, Object>> results;
            ToleranceMatchService service;
            ArrayList<Map<String, Object>> pmomParams;
            ArrayList<Map<String, Object>> scpoParams;
            ArrayList<Map<String, Object>> conmParams;
            ArrayList<Map<String, Object>> purOrderParams;
            block23: {
                List<Map<String, Object>> results2;
                overToleranceId = new HashSet<String>(16);
                purOrderParams = new ArrayList<Map<String, Object>>(16);
                conmParams = new ArrayList<Map<String, Object>>(16);
                scpoParams = new ArrayList<Map<String, Object>>(16);
                pmomParams = new ArrayList<Map<String, Object>>(16);
                service = new ToleranceMatchService();
                if (!isPrePay) break block23;
                for (Map.Entry<String, CoreBillInfo> entry : coreBillInfo.entrySet()) {
                    CoreBillInfo coreBillInfo2 = entry.getValue();
                    if (coreBillInfo2.getPreparePayAmt().compareTo(BigDecimal.ZERO) == 0 || coreBillInfo2.getSumPrePayAmt().compareTo(coreBillInfo2.getPreparePayAmt()) == 0) continue;
                    String coreBillType = coreBillInfo2.getCoreBillType();
                    HashMap<String, Object> param = new HashMap<String, Object>(16);
                    param.put("pk", entry.getKey());
                    param.put("bd_supplier", coreBillInfo2.getSupplierId());
                    param.put("controlvalue", coreBillInfo2.getSumPrePayAmt());
                    param.put("contrastvalue", coreBillInfo2.getPreparePayAmt());
                    param.put("bd_currency", coreBillInfo2.getCurrencyId());
                    param.put("precision", precisions.get(coreBillInfo2.getCurrencyId()));
                    param.put("bos_org", coreBillInfo2.getOrgId());
                    if ("pm_purorderbill".equals(coreBillType)) {
                        purOrderParams.add(param);
                        continue;
                    }
                    if ("conm_purcontract".equals(coreBillType)) {
                        conmParams.add(param);
                        continue;
                    }
                    if ("sctm_scpo".equals(coreBillType)) {
                        scpoParams.add(param);
                        continue;
                    }
                    if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                    pmomParams.add(param);
                }
                if (purOrderParams.size() > 0) {
                    List<Map<String, Object>> results22 = service.getResultByToleranceType("ap_payapply", "pm_purorderbill", "e_approvedseleamt", "payamount", purOrderParams);
                    for (Map<String, Object> map : results22) {
                        overToleranceId.add((String)map.get("pk"));
                    }
                }
                if (conmParams.size() > 0) {
                    results2 = service.getResultByToleranceType("ap_payapply", "conm_purcontract", "e_approvedseleamt", "payamount", conmParams);
                    for (Map<String, Object> map : results2) {
                        overToleranceId.add((String)map.get("pk"));
                    }
                }
                if (scpoParams.size() > 0) {
                    results2 = service.getResultByToleranceType("ap_payapply", "sctm_scpo", "e_approvedseleamt", "payamount", scpoParams);
                    for (Map<String, Object> map : results2) {
                        overToleranceId.add((String)map.get("pk"));
                    }
                }
                if (pmomParams.size() <= 0) break block24;
                results2 = service.getResultByToleranceType("ap_payapply", "pm_om_purorderbill", "e_approvedseleamt", "payamount", pmomParams);
                for (Map<String, Object> map : results2) {
                    overToleranceId.add((String)map.get("pk"));
                }
                break block24;
            }
            for (Map.Entry<String, CoreBillInfo> entry : coreBillInfo.entrySet()) {
                CoreBillInfo coreBillInfo3 = entry.getValue();
                if (coreBillInfo3.getSumAmt().compareTo(coreBillInfo3.getCoreBillAmt()) == 0) continue;
                String coreBillType = coreBillInfo3.getCoreBillType();
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("pk", entry.getKey());
                param.put("bd_supplier", coreBillInfo3.getSupplierId());
                param.put("controlvalue", coreBillInfo3.getSumAmt());
                param.put("contrastvalue", coreBillInfo3.getCoreBillAmt());
                param.put("bd_currency", coreBillInfo3.getCurrencyId());
                param.put("precision", precisions.get(coreBillInfo3.getCurrencyId()));
                param.put("bos_org", coreBillInfo3.getOrgId());
                if ("pm_purorderbill".equals(coreBillType)) {
                    purOrderParams.add(param);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    conmParams.add(param);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoParams.add(param);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomParams.add(param);
            }
            if (purOrderParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "pm_purorderbill", "e_approvedseleamt", "totalallamount", purOrderParams);
                for (Map map : results) {
                    overToleranceId.add((String)map.get("pk"));
                }
            }
            if (conmParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "conm_purcontract", "e_approvedseleamt", "totalallamount", conmParams);
                for (Map<String, Object> map : results) {
                    overToleranceId.add((String)map.get("pk"));
                }
            }
            if (scpoParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "sctm_scpo", "e_approvedseleamt", "totalallamount", scpoParams);
                for (Map<String, Object> map : results) {
                    overToleranceId.add((String)map.get("pk"));
                }
            }
            if (pmomParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "pm_om_purorderbill", "e_approvedseleamt", "totalallamount", pmomParams);
                for (Map<String, Object> map : results) {
                    overToleranceId.add((String)map.get("pk"));
                }
            }
        }
        return overToleranceId;
    }

    private void loadNeedCtrlFinBillInfos(Map<String, CoreBillInfo> coreBillInfoMap, Map<Long, ConmBillInfo> conmBillInfoMap, Set<Long> purOrderIds, Map<Long, Long> orderIdToConmIds, Map<Long, BigDecimal> applyWriteBackAmt) {
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        coreBillIds.addAll(purOrderIds);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfoMap.entrySet()) {
            CoreBillInfo info = entrySet.getValue();
            coreBillIds.add(info.getCoreBillId());
            orgIds.add(info.getOrgId());
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,billstatus,sourcebilltype,settleorg,paycurrency,settlecurrency,entry.e_paymenttype.biztype,entry.e_asstact.masterid,entry.e_corebillid,entry.e_approvedseleamt,entry.e_paidamt,entry.e_corebillentryid,entry.id,entry.e_closestatus", (QFilter[])new QFilter[]{new QFilter("entry.e_corebillid", "in", coreBillIds), new QFilter("settleorg", "in", orgIds)});
        for (DynamicObject bill : payBills) {
            String key;
            CoreBillInfo coreBillInfo;
            ConmBillInfo conmBillInfoByCore;
            Long conmBillId;
            Long coreBillId = bill.getLong("entry.e_corebillid");
            Long orgId = bill.getLong("settleorg");
            Long asstactId = bill.getLong("entry.e_asstact.masterid");
            Long curBillCurrencyId = bill.getLong("settlecurrency");
            Long payCurrencyId = bill.getLong("paycurrency");
            String closeStatus = bill.getString("entry.e_closestatus");
            Long entryId = bill.getLong("entry.id");
            BigDecimal approvedAmt = "B".equals(closeStatus) ? bill.getBigDecimal("entry.e_paidamt").add(applyWriteBackAmt.getOrDefault(entryId, BigDecimal.ZERO)) : bill.getBigDecimal("entry.e_approvedseleamt");
            String payType = bill.getString("entry.e_paymenttype.biztype");
            ConmBillInfo conmBillInfoByConm = conmBillInfoMap.get(coreBillId);
            if (conmBillInfoMap.get(coreBillId) != null && "202".equals(payType)) {
                conmBillInfoByConm.setConmBillSumAmt(conmBillInfoByConm.getConmBillSumAmt().add(approvedAmt));
            }
            if ((conmBillId = orderIdToConmIds.get(coreBillId)) != null && orgId.equals((conmBillInfoByCore = conmBillInfoMap.get(conmBillId)).getOrgId()) && asstactId.equals(conmBillInfoByCore.getSupplierId()) && curBillCurrencyId.equals(conmBillInfoByCore.getCurrencyId())) {
                conmBillInfoByCore.setConmBillSumAmt(conmBillInfoByCore.getConmBillSumAmt().add(approvedAmt));
            }
            if ((coreBillInfo = coreBillInfoMap.get(key = coreBillId + "_" + orgId + "_" + asstactId + "_" + curBillCurrencyId)) == null) continue;
            if (!payCurrencyId.equals(curBillCurrencyId)) {
                coreBillInfo.setDiffCurrency(true);
            }
            coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(approvedAmt));
            if (!"202".equals(payType)) continue;
            coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(approvedAmt));
        }
    }

    private void processConmPrePay(Map<Long, ConmBillInfo> conmBillInfoMap) {
        if (conmBillInfoMap.size() == 0) {
            return;
        }
        Set<Long> conmBillIds = conmBillInfoMap.keySet();
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"entry.e_corebillid,entry.e_approvedseleamt,entry.e_paidamt,billstatus", (QFilter[])new QFilter[]{new QFilter("entry.e_corebillid", "in", conmBillIds), new QFilter("billstatus", "!=", (Object)"A")});
        for (DynamicObject bill : applyBills) {
            Long conmBillId = bill.getLong("entry.e_corebillid");
            ConmBillInfo conmBillInfo = conmBillInfoMap.get(conmBillId);
            if ("D".equals(bill.getString("billstatus"))) {
                conmBillInfo.setConmBillSumAmt(conmBillInfo.getConmBillSumAmt().add(bill.getBigDecimal("entry.e_paidamt")));
                continue;
            }
            conmBillInfo.setConmBillSumAmt(conmBillInfo.getConmBillSumAmt().add(bill.getBigDecimal("entry.e_approvedseleamt")));
        }
    }

    private Map<String, CoreBillInfo> queryCoreBill(List<DynamicObject> applyBills, Map<Long, ConmBillInfo> conmBillAmtMap, Set<Long> purOrderIds) {
        List orderInfo;
        HashMap<String, CoreBillInfo> coreBillInfoMap = new HashMap<String, CoreBillInfo>(16);
        HashMap coreOrderBillInfo = new HashMap(16);
        HashMap coreConBillInfo = new HashMap(16);
        HashMap coreOmBillInfo = new HashMap(16);
        HashMap corePmOmBillInfo = new HashMap(16);
        for (DynamicObject bill : applyBills) {
            Long coreBillId = bill.getLong("entry.e_corebillid");
            if (coreBillId == 0L) continue;
            String coreBillType = bill.getString("entry.e_corebilltype");
            if ("pm_purorderbill".equals(coreBillType)) {
                coreOrderBillInfo.put(coreBillId, new HashSet(2));
                continue;
            }
            if ("conm_purcontract".equals(coreBillType)) {
                coreConBillInfo.put(coreBillId, new HashSet(2));
                continue;
            }
            if ("sctm_scpo".equals(coreBillType)) {
                coreOmBillInfo.put(coreBillId, new HashSet(2));
                continue;
            }
            if (!"pm_om_purorderbill".equals(coreBillType)) continue;
            corePmOmBillInfo.put(coreBillId, new HashSet(2));
        }
        if (coreOrderBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOrderBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_purorderbill", conmBillAmtMap, purOrderIds);
        }
        if (coreConBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreConBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "conm_purcontract", conmBillAmtMap, purOrderIds);
        }
        if (coreOmBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sctm", (String)"ScPoService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "sctm_scpo", conmBillAmtMap, purOrderIds);
        }
        if (corePmOmBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"OmPurOrderbillService", (String)"getOmPurOrderbillInfo", (Object[])new Object[]{corePmOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_om_purorderbill", conmBillAmtMap, purOrderIds);
        }
        return coreBillInfoMap;
    }

    private void setCoreBillInfoMap(Map<String, CoreBillInfo> coreBillInfoMap, List<Map<String, Object>> params, String coreBillType, Map<Long, ConmBillInfo> conmBillAmtMap, Set<Long> purOrderIds) {
        HashSet<Long> allConmBillIds = new HashSet<Long>(16);
        for (Map<String, Object> map : params) {
            boolean isAllowOverPay = (Boolean)map.get("isallowoverpay");
            Long id = (Long)map.get("billid");
            Iterator<Map.Entry<Long, ConmBillInfo>> asstactId = (Long)map.get("invoicesupplier");
            Long currencyId = (Long)map.get("settlecurrency");
            BigDecimal preparePayAmt = (BigDecimal)map.get("sumprepayamount");
            if (preparePayAmt == null) {
                preparePayAmt = BigDecimal.ZERO;
            }
            List list = (List)map.get("entryinfo");
            HashSet<Long> hashSet = new HashSet<Long>(16);
            boolean conmIsAllowOverPay = false;
            BigDecimal conmBillAmt = BigDecimal.ZERO;
            Long orgId = 0L;
            for (Map entry : list) {
                orgId = (Long)entry.get("settleorg");
                String key = id + "_" + orgId + "_" + asstactId + "_" + currencyId;
                CoreBillInfo info = coreBillInfoMap.get(key);
                if ("pm_purorderbill".equals(coreBillType)) {
                    boolean conhasprepay;
                    Long conmBillId = (Long)entry.get("conbillid");
                    Long conmCurrencyId = (Long)entry.get("consettlecurrency");
                    if (conmBillId != null && conmCurrencyId.equals(currencyId) && (conhasprepay = ((Boolean)entry.get("conhasprepay")).booleanValue())) {
                        allConmBillIds.add(conmBillId);
                        hashSet.add(conmBillId);
                        conmIsAllowOverPay = (Boolean)entry.get("conisallowoverpay");
                        conmBillAmt = (BigDecimal)entry.get("consumamountandtax");
                    }
                }
                if (info == null) {
                    info = new CoreBillInfo();
                    info.setCoreBillId(id);
                    info.setAllowOverPay(isAllowOverPay);
                    info.setOrgId(orgId);
                    info.setCoreBillType(coreBillType);
                    info.setSupplierId(asstactId);
                    info.setCoreBillAmt((BigDecimal)entry.get("amountandtax"));
                    info.setCurrencyId(currencyId);
                    info.setPreparePayAmt(preparePayAmt);
                    coreBillInfoMap.put(key, info);
                } else {
                    info.setCoreBillAmt(info.getCoreBillAmt().add((BigDecimal)entry.get("amountandtax")));
                }
                if (!"conm_purcontract".equals(coreBillType)) continue;
                ConmBillInfo conmBillInfo = conmBillAmtMap.get(id);
                if (preparePayAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                allConmBillIds.add(id);
                if (conmBillInfo == null) {
                    conmBillInfo = new ConmBillInfo();
                    conmBillInfo.setConmBillId(id);
                    conmBillInfo.setAllowOverPay(isAllowOverPay);
                    conmBillInfo.setOrgId(orgId.longValue());
                    conmBillInfo.setSupplierId(asstactId);
                    conmBillInfo.setCurrencyId(currencyId);
                    conmBillInfo.setConmBillAmt((BigDecimal)entry.get("amountandtax"));
                    conmBillAmtMap.put(id, conmBillInfo);
                    continue;
                }
                conmBillInfo.setConmBillAmt(conmBillInfo.getConmBillAmt().add((BigDecimal)entry.get("amountandtax")));
            }
            if (hashSet.size() != 1) continue;
            Long conmBillId = (Long)hashSet.iterator().next();
            ConmBillInfo conmBillInfo = conmBillAmtMap.get(conmBillId);
            if (conmBillInfo == null) {
                conmBillInfo = new ConmBillInfo();
                conmBillInfo.setConmBillId((Long)hashSet.iterator().next());
                conmBillInfo.setAllowOverPay(conmIsAllowOverPay);
                conmBillInfo.setConmBillAmt(conmBillAmt);
                conmBillInfo.setCurrencyId(currencyId);
                conmBillInfo.setSupplierId(asstactId);
                conmBillInfo.setOrgId(orgId.longValue());
                conmBillInfo.getOrderBillIds().add(id);
                conmBillAmtMap.put(conmBillId, conmBillInfo);
                continue;
            }
            conmBillInfo.getOrderBillIds().add(id);
        }
        if (allConmBillIds.size() > 0) {
            Long conmBillId;
            HashMap conmIdToOrderIdsMap = new HashMap(16);
            HashMap<Long, HashSet<Long>> orderIdToConmIdsMap = new HashMap<Long, HashSet<Long>>(16);
            HashSet<Long> orderIds = new HashSet<Long>(16);
            DynamicObjectCollection purOrderEntrys = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("billentry.conbillid", "in", allConmBillIds)});
            for (DynamicObject orderEntry : purOrderEntrys) {
                orderIds.add(orderEntry.getLong("id"));
                conmBillId = orderEntry.getLong("billentry.conbillid");
                Set set = (Set)conmIdToOrderIdsMap.get(conmBillId);
                if (set == null) {
                    HashSet<Long> hashSet = new HashSet<Long>(16);
                    hashSet.add(orderEntry.getLong("id"));
                    conmIdToOrderIdsMap.put(conmBillId, hashSet);
                    continue;
                }
                set.add(orderEntry.getLong("id"));
            }
            for (Map.Entry<Long, ConmBillInfo> entrySet : conmBillAmtMap.entrySet()) {
                conmBillId = entrySet.getKey();
                Set set = (Set)conmIdToOrderIdsMap.get(conmBillId);
                if (set == null) continue;
                entrySet.getValue().getOrderBillIds().addAll(set);
            }
            DynamicObjectCollection purOrderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds)});
            for (Object order : purOrderBills) {
                Long l = order.getLong("id");
                Long l2 = order.getLong("billentry.conbillid");
                HashSet<Long> upConmIds = (HashSet<Long>)orderIdToConmIdsMap.get(l);
                if (upConmIds == null) {
                    upConmIds = new HashSet<Long>(16);
                    upConmIds.add(l2);
                    orderIdToConmIdsMap.put(l, upConmIds);
                    continue;
                }
                upConmIds.add(l2);
            }
            HashSet hadMultiConmsOrderId = new HashSet(16);
            for (Map.Entry entry : orderIdToConmIdsMap.entrySet()) {
                if (((Set)entry.getValue()).size() > 1) {
                    hadMultiConmsOrderId.add(entry.getKey());
                    continue;
                }
                purOrderIds.add((Long)entry.getKey());
            }
            HashSet hadmulitConmIds = new HashSet(16);
            for (Map.Entry entry : conmIdToOrderIdsMap.entrySet()) {
                for (Long orderId : hadMultiConmsOrderId) {
                    if (!((Set)entry.getValue()).contains(orderId)) continue;
                    hadmulitConmIds.add(entry.getKey());
                }
            }
            for (Long l : hadmulitConmIds) {
                conmBillAmtMap.remove(l);
            }
            Iterator<Map.Entry<Long, ConmBillInfo>> iterator = conmBillAmtMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, ConmBillInfo> entry = iterator.next();
                ConmBillInfo conmBillInfo = entry.getValue();
                if (conmBillInfo.getOrderBillIds().size() != 0) continue;
                iterator.remove();
            }
        }
    }

    private Map<Long, Integer> getPrecision(Map<String, CoreBillInfo> coreBillInfo) {
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
            currencyIds.add(entrySet.getValue().getCurrencyId());
        }
        HashMap<Long, Integer> precisions = new HashMap<Long, Integer>(16);
        DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        for (DynamicObject currency : currencys) {
            precisions.put(currency.getLong("id"), currency.getInt("amtprecision"));
        }
        return precisions;
    }

    private Map<Long, Long> getSupplierMasterId(Map<String, CoreBillInfo> coreBillInfo, Map<Long, ConmBillInfo> conmBillInfoMap) {
        CoreBillInfo info;
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
            supplierIds.add(entrySet.getValue().getSupplierId());
        }
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        for (DynamicObject dynamicObject : suppliers) {
            supplierMasterIds.put(dynamicObject.getLong("id"), dynamicObject.getLong("masterid"));
        }
        for (Map.Entry<String, CoreBillInfo> entry : coreBillInfo.entrySet()) {
            info = entry.getValue();
            info.setSupplierId(supplierMasterIds.getOrDefault(info.getSupplierId(), info.getSupplierId()));
        }
        for (Map.Entry<Object, Object> entry : conmBillInfoMap.entrySet()) {
            info = (ConmBillInfo)entry.getValue();
            info.setSupplierId(supplierMasterIds.getOrDefault(info.getSupplierId(), info.getSupplierId()));
        }
        return supplierMasterIds;
    }

    private boolean isExeccontrolOpen() {
        DynamicObject execcontrol = QueryServiceHelper.queryOne((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0079"})});
        if (execcontrol == null) {
            return false;
        }
        return execcontrol.getBoolean("enable");
    }
}

