/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.mservice.CancelRefundAndRenoteApplyCoreBillAmtValidate;
import kd.fi.ap.mservice.helper.RefundAndRenoteServiceHelper;
import kd.fi.ap.vo.CancelRefundAndRenoteParam;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.Result;

public class CancelRefundAndRenoteValidateService {
    private static final Log logger = LogFactory.getLog(CancelRefundAndRenoteValidateService.class);

    public Result validate(String paramJson) {
        logger.info("CancelRefundAndRenoteValidateService.validate param:" + paramJson);
        CancelRefundAndRenoteParam param = RefundAndRenoteServiceHelper.cancelConvertParam(paramJson);
        logger.info("CancelRefundAndRenoteValidateService.validate param convert result:" + JSON.toJSONString((Object)param));
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"CancelRefundAndRenoteValidate");){
            boolean isExecuteNewLogic;
            Set<Long> payIds = param.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
            Long recId = param.getRecId();
            HashSet<Long> botpToPayFinApBillIds = new HashSet<Long>(1);
            HashSet<Long> botpToPayFinArBillIds = new HashSet<Long>(1);
            Map srcBotpMap = BOTPHelper.findSourceBills((String)"cas_paybill", (Long[])payIds.toArray(new Long[0]));
            if (srcBotpMap.get("ap_finapbill") != null) {
                botpToPayFinApBillIds.addAll((Collection)srcBotpMap.get("ap_finapbill"));
            }
            if (srcBotpMap.get("ar_finarbill") != null) {
                botpToPayFinArBillIds.addAll((Collection)srcBotpMap.get("ar_finarbill"));
            }
            if (isExecuteNewLogic = RefundAndRenoteServiceHelper.isExecuteNewLogic()) {
                DynamicObject[] refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"org,settlerelation,finbillid,finbillentryid,paybillid,paybillentryid,oldsettleamt,newsettleamt,settletype,autosettletype", (QFilter[])new QFilter[]{new QFilter("recbillid", "=", (Object)recId)});
                if (refundRecords.length == 0) {
                    this.validatePayBillUpIsExistFinBill(botpToPayFinApBillIds, botpToPayFinArBillIds);
                }
                this.validateFinBillIsWriteOff(botpToPayFinApBillIds, botpToPayFinArBillIds, refundRecords);
                this.validateUpApplyBillOrFinBillIsOver(param);
                this.validateIsOverPeriod(payIds, recId);
                CancelRefundAndRenoteApplyCoreBillAmtValidate validate = new CancelRefundAndRenoteApplyCoreBillAmtValidate();
                validate.validate(param);
            } else {
                this.validatePayBillUpIsExistFinBill(botpToPayFinApBillIds, botpToPayFinArBillIds);
                HashSet<DynamicObject> upApplyBills = new HashSet<DynamicObject>(1);
                DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
                HashMap<Long, Long> payEntryIdToSourceEntryId = new HashMap<Long, Long>(8);
                for (DynamicObject payBill : payBills) {
                    String sourcebilltype = payBill.getString("sourcebilltype");
                    if ("ap_payapply".equals(sourcebilltype)) {
                        upApplyBills.add(payBill);
                    }
                    DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        long sourceEntryId = entry.getLong("e_sourcebillentryid");
                        if (sourceEntryId == 0L) continue;
                        payEntryIdToSourceEntryId.put(entry.getLong("id"), sourceEntryId);
                    }
                }
                HashMap<Long, BigDecimal> sourceEntryIdToDisposeAmt = new HashMap<Long, BigDecimal>(8);
                List payInfos = param.getPayInfos();
                for (PayRefundEntryInfo payInfo : payInfos) {
                    Long entryId = payInfo.getEntryId();
                    BigDecimal entryRefundAmt = payInfo.getEntryRefundAmt();
                    Long sourceEntryId = (Long)payEntryIdToSourceEntryId.get(entryId);
                    if (sourceEntryId == null || sourceEntryId == 0L) continue;
                    sourceEntryIdToDisposeAmt.merge(sourceEntryId, entryRefundAmt, (a, b) -> b.add((BigDecimal)a));
                }
                if (upApplyBills.size() > 0) {
                    this.validateApplyBillIsOver(upApplyBills, sourceEntryIdToDisposeAmt);
                }
            }
            Result result = Result.success();
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            tx.markRollback();
            Result result = Result.ex((Throwable)e);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public void validateUpApplyBillOrFinBillIsOver(CancelRefundAndRenoteParam param) {
        HashSet<Long> finBillIds;
        DynamicObjectCollection entries;
        DynamicObject[] payBills;
        logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver start");
        Set payIds = param.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        HashSet<DynamicObject> upApplyBills = new HashSet<DynamicObject>(1);
        HashSet<DynamicObject> upFinApBills = new HashSet<DynamicObject>(1);
        HashSet<DynamicObject> upFinArBills = new HashSet<DynamicObject>(1);
        HashSet<DynamicObject> noUpBills = new HashSet<DynamicObject>(1);
        HashMap<Long, Long> payEntryIdToSourceEntryId = new HashMap<Long, Long>(8);
        for (DynamicObject payBill : payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid,sourcebilltype,paymenttype", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds)})) {
            String sourcebilltype = payBill.getString("sourcebilltype");
            if ("ap_payapply".equals(sourcebilltype)) {
                upApplyBills.add(payBill);
                DynamicObject paymentType = payBill.getDynamicObject("paymenttype");
                if (paymentType != null && EntityMetadataUtils.isExistProperty((DynamicObject)paymentType, (String)"biztype") && "202".equals(paymentType.getString("biztype"))) {
                    noUpBills.add(payBill);
                }
            } else if ("ap_finapbill".equals(sourcebilltype)) {
                upFinApBills.add(payBill);
            } else if ("ar_finarbill".equals(sourcebilltype)) {
                upFinArBills.add(payBill);
            } else {
                noUpBills.add(payBill);
            }
            entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long sourceEntryId = entry.getLong("e_sourcebillentryid");
                if (sourceEntryId == 0L) continue;
                payEntryIdToSourceEntryId.put(entry.getLong("id"), sourceEntryId);
            }
        }
        HashMap<Long, BigDecimal> sourceEntryIdToDisposeAmt = new HashMap<Long, BigDecimal>(8);
        List payInfos = param.getPayInfos();
        for (PayRefundEntryInfo payInfo : payInfos) {
            Long entryId = payInfo.getEntryId();
            BigDecimal entryRefundAmt = payInfo.getEntryRefundAmt();
            Long sourceEntryId = (Long)payEntryIdToSourceEntryId.get(entryId);
            if (sourceEntryId == null || sourceEntryId == 0L) continue;
            sourceEntryIdToDisposeAmt.merge(sourceEntryId, entryRefundAmt, (a, b) -> b.add((BigDecimal)a));
        }
        if (upApplyBills.size() > 0) {
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver upApplyBills start");
            this.validateApplyBillIsOver(upApplyBills, sourceEntryIdToDisposeAmt);
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver upApplyBills end");
        }
        if (upFinApBills.size() > 0) {
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver upFinApBills start");
            finBillIds = new HashSet<Long>(1);
            for (DynamicObject upFinApBill : upFinApBills) {
                entries = upFinApBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    finBillIds.add(entry.getLong("e_sourcebillid"));
                }
            }
            this.validateFinApBillIsOver(finBillIds, sourceEntryIdToDisposeAmt);
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver upFinApBills end");
        }
        if (upFinArBills.size() > 0) {
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver upFinArBills start");
            finBillIds = new HashSet(1);
            for (DynamicObject upFinArBill : upFinArBills) {
                entries = upFinArBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    finBillIds.add(entry.getLong("e_sourcebillid"));
                }
            }
            this.validateFinArBillIsOver(finBillIds, sourceEntryIdToDisposeAmt);
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver upFinArBills end");
        }
        if (noUpBills.size() > 0) {
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver noUpBills start");
            this.validateNoUpIsOver(noUpBills, param.getRecId());
            logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver noUpBills end");
        }
        logger.info("CancelRefundAndRenoteValidateService.validateUpApplyBillOrFinBillIsOver end");
    }

    private void validateApplyBillIsOver(Set<DynamicObject> upApplyBills, Map<Long, BigDecimal> sourceEntryIdToDisposeAmt) {
        Long finEntryId;
        BigDecimal value;
        Long key;
        HashSet<Long> applyBillIds = new HashSet<Long>(1);
        for (DynamicObject upApplyBill : upApplyBills) {
            DynamicObjectCollection entries = upApplyBill.getDynamicObjectCollection("entry");
            for (DynamicObject[] entry : entries) {
                applyBillIds.add(entry.getLong("e_sourcebillid"));
            }
        }
        DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"billno,entry.id,entry.e_approvedamt,entry.lockedamt,entry.e_closestatus,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)});
        HashMap<Long, BigDecimal> applyColseEntryIdToDisposeAmt = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> sourceTypeIsFinApApplyIds = new HashSet<Long>(1);
        HashSet<Long> sourceTypeIsFinArApplyIds = new HashSet<Long>(1);
        for (DynamicObject bill : applyBills) {
            String billNo = bill.getString("billno");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                BigDecimal disposeAmt = sourceEntryIdToDisposeAmt.get(entryId);
                if (disposeAmt == null) continue;
                BigDecimal expectAmt = entry.getBigDecimal("lockedamt").add(disposeAmt);
                if (expectAmt.abs().compareTo(entry.getBigDecimal("e_approvedamt").abs()) > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u91cd\u65b0\u5360\u7528\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\uff0c\u5bfc\u81f4\u4ed8\u6b3e\u7533\u8bf7\u5355%s\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u6838\u51c6\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u91ca\u653e\u4ed8\u6b3e\u7533\u8bf7\u5355\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_4", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
                }
                String entryCloseStatus = entry.getString("e_closestatus");
                if (!"B".equals(entryCloseStatus)) continue;
                applyColseEntryIdToDisposeAmt.put(entryId, disposeAmt);
                String sourcebilltype = bill.getString("sourcebilltype");
                if ("ap_finapbill".equals(sourcebilltype)) {
                    sourceTypeIsFinApApplyIds.add(bill.getLong("id"));
                    continue;
                }
                if (!"ar_finarbill".equals(sourcebilltype)) continue;
                sourceTypeIsFinArApplyIds.add(bill.getLong("id"));
            }
        }
        logger.info("CancelRefundAndRenoteValidateService.validateApplyBillIsOver applyColseEntryIdToDisposeAmt size : " + applyColseEntryIdToDisposeAmt.size());
        if (applyColseEntryIdToDisposeAmt.size() == 0) {
            return;
        }
        if (sourceTypeIsFinApApplyIds.size() > 0) {
            logger.info("CancelRefundAndRenoteValidateService.validateApplyBillIsOver closestatus validate finap start");
            Map applyEntryIdToFinApEntryId = BOTPNewHelper.loadNearSourceRowIds((String)"ap_payapply", (String)"entry", (Long[])sourceTypeIsFinApApplyIds.toArray(new Long[0]), (Long[])applyColseEntryIdToDisposeAmt.keySet().toArray(new Long[0]), (String)"ap_finapbill");
            Map srcBotpMap = BOTPHelper.findSourceBills((String)"ap_payapply", (Long[])sourceTypeIsFinApApplyIds.toArray(new Long[0]));
            HashSet<Long> finApBillIds = new HashSet<Long>(1);
            if (srcBotpMap.get("ap_finapbill") != null) {
                finApBillIds.addAll((Collection)srcBotpMap.get("ap_finapbill"));
            }
            HashMap<Long, BigDecimal> finApEntryIdToDisposeAmt = new HashMap<Long, BigDecimal>(8);
            for (Map.Entry entrySet : applyColseEntryIdToDisposeAmt.entrySet()) {
                key = (Long)entrySet.getKey();
                value = (BigDecimal)entrySet.getValue();
                finEntryId = (Long)applyEntryIdToFinApEntryId.get(key);
                if (finEntryId == null || value == null || value.compareTo(BigDecimal.ZERO) == 0) continue;
                finApEntryIdToDisposeAmt.put(finEntryId, value);
            }
            this.validateFinApBillIsOver(finApBillIds, finApEntryIdToDisposeAmt);
            logger.info("CancelRefundAndRenoteValidateService.validateApplyBillIsOver closestatus validate finap end");
        }
        if (sourceTypeIsFinArApplyIds.size() > 0) {
            logger.info("CancelRefundAndRenoteValidateService.validateApplyBillIsOver closestatus validate finar start");
            Map applyEntryIdToFinArEntryId = BOTPNewHelper.loadNearSourceRowIds((String)"ap_payapply", (String)"entry", (Long[])sourceTypeIsFinArApplyIds.toArray(new Long[0]), (Long[])applyColseEntryIdToDisposeAmt.keySet().toArray(new Long[0]), (String)"ar_finarbill");
            Map srcBotpMap = BOTPHelper.findSourceBills((String)"ap_payapply", (Long[])sourceTypeIsFinArApplyIds.toArray(new Long[0]));
            HashSet<Long> finArBillIds = new HashSet<Long>(1);
            if (srcBotpMap.get("ar_finarbill") != null) {
                finArBillIds.addAll((Collection)srcBotpMap.get("ar_finarbill"));
            }
            HashMap<Long, BigDecimal> finArEntryIdToDisposeAmt = new HashMap<Long, BigDecimal>(8);
            for (Map.Entry entrySet : applyColseEntryIdToDisposeAmt.entrySet()) {
                key = (Long)entrySet.getKey();
                value = (BigDecimal)entrySet.getValue();
                finEntryId = (Long)applyEntryIdToFinArEntryId.get(key);
                if (finEntryId == null || value == null || value.compareTo(BigDecimal.ZERO) == 0) continue;
                finArEntryIdToDisposeAmt.put(finEntryId, value);
            }
            this.validateFinArBillIsOver(finArBillIds, finArEntryIdToDisposeAmt);
            logger.info("CancelRefundAndRenoteValidateService.validateApplyBillIsOver closestatus validate finar end");
        }
    }

    private void validateFinApBillIsOver(Set<Long> finBillIds, Map<Long, BigDecimal> sourceEntryIdToDisposeAmt) {
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"billno,org.id,detailentry.e_pricetaxtotal,detailentry.lockedamt,planentity.planpricetax,planentity.planlockedamt,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", finBillIds)});
        HashSet<Long> orgIds = new HashSet<Long>(1);
        for (DynamicObject finApBill : finApBills) {
            orgIds.add(finApBill.getLong("org.id"));
        }
        Map orgIdToSettleParam = ArApHelper.batchGetApSettleParam(orgIds);
        for (DynamicObject finApBill : finApBills) {
            BigDecimal expectAmt;
            BigDecimal disposeAmt;
            Long entryId;
            DynamicObjectCollection entries;
            Long orgId = finApBill.getLong("org.id");
            String billNo = finApBill.getString("billno");
            Integer settleParam = (Integer)orgIdToSettleParam.get(orgId);
            String billStatus = finApBill.getString("billstatus");
            if (!"C".equals(billStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u4ed8\u5355%s\u975e\u5ba1\u6838\u6001\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_11", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
            }
            if (1 == settleParam) {
                entries = finApBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entries) {
                    entryId = entry.getLong("id");
                    disposeAmt = sourceEntryIdToDisposeAmt.get(entryId);
                    if (disposeAmt == null || (expectAmt = entry.getBigDecimal("lockedamt").add(disposeAmt)).abs().compareTo(entry.getBigDecimal("e_pricetaxtotal").abs()) <= 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u4ed8\u5355%s\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u91ca\u653e\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u9501\u5b9a\u91d1\u989d\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_5", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
                }
                continue;
            }
            entries = finApBill.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : entries) {
                entryId = entry.getLong("id");
                disposeAmt = sourceEntryIdToDisposeAmt.get(entryId);
                if (disposeAmt == null || (expectAmt = entry.getBigDecimal("planlockedamt").add(disposeAmt)).abs().compareTo(entry.getBigDecimal("planpricetax").abs()) <= 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u4ed8\u5355%s\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u91ca\u653e\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u9501\u5b9a\u91d1\u989d\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_5", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
            }
        }
    }

    private void validateFinArBillIsOver(Set<Long> finBillIds, Map<Long, BigDecimal> sourceEntryIdToDisposeAmt) {
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,org.id,entry.e_recamount,entry.e_lockedamt,planentity.planpricetax,planentity.planlockedamt,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", finBillIds)});
        HashSet<Long> orgIds = new HashSet<Long>(1);
        for (DynamicObject finArBill : finArBills) {
            orgIds.add(finArBill.getLong("org.id"));
        }
        Map orgIdToSettleParam = ArApHelper.batchGetArSettleParam(orgIds);
        for (DynamicObject finArBill : finArBills) {
            BigDecimal expectAmt;
            BigDecimal disposeAmt;
            Long entryId;
            DynamicObjectCollection entries;
            Long orgId = finArBill.getLong("org.id");
            String billNo = finArBill.getString("billno");
            Integer settleParam = (Integer)orgIdToSettleParam.get(orgId);
            String billStatus = finArBill.getString("billstatus");
            if (!"C".equals(billStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u6536\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u6536\u5355%s\u975e\u5ba1\u6838\u6001\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u5ba1\u6838\u8d22\u52a1\u5e94\u6536\u5355\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_12", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
            }
            if (1 == settleParam) {
                entries = finArBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    entryId = entry.getLong("id");
                    disposeAmt = sourceEntryIdToDisposeAmt.get(entryId);
                    if (disposeAmt == null || (expectAmt = entry.getBigDecimal("e_lockedamt").add(disposeAmt.negate())).abs().compareTo(entry.getBigDecimal("e_recamount").abs()) <= 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u6536\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u6536\u5355%s\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u91ca\u653e\u8d22\u52a1\u5e94\u6536\u5355\u672a\u9501\u5b9a\u91d1\u989d\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_7", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
                }
                continue;
            }
            entries = finArBill.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : entries) {
                entryId = entry.getLong("id");
                disposeAmt = sourceEntryIdToDisposeAmt.get(entryId);
                if (disposeAmt == null || (expectAmt = entry.getBigDecimal("planlockedamt").add(disposeAmt.negate())).abs().compareTo(entry.getBigDecimal("planpricetax").abs()) <= 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u6536\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u6536\u5355%s\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u91ca\u653e\u8d22\u52a1\u5e94\u6536\u5355\u672a\u9501\u5b9a\u91d1\u989d\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_7", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
            }
        }
    }

    private void validateNoUpIsOver(Set<DynamicObject> noUpBills, Long recId) {
        HashSet<Long> payBillIds = new HashSet<Long>(1);
        for (DynamicObject noUpBill : noUpBills) {
            payBillIds.add(noUpBill.getLong("id"));
        }
        DynamicObject[] refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"org,settlerelation,finbillid,finbillentryid,paybillid,paybillentryid,oldsettleamt,newsettleamt,settletype,autosettletype,settledate", (QFilter[])new QFilter[]{new QFilter("recbillid", "=", (Object)recId), new QFilter("paybillid", "in", payBillIds)});
        if (refundRecords.length == 0) {
            return;
        }
        HashMap<Long, BigDecimal> sourceEntryIdToDisposeAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> payEntryIdToDisposeAmt = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> finArBillIds = new HashSet<Long>(1);
        HashSet<Long> finApBillIds = new HashSet<Long>(1);
        for (DynamicObject refundRecord : refundRecords) {
            String settleRelation = refundRecord.getString("settlerelation");
            if ("appaysettle".equals(settleRelation)) {
                finApBillIds.add(refundRecord.getLong("finbillid"));
            } else {
                finArBillIds.add(refundRecord.getLong("finbillid"));
            }
            long finBillEntryId = refundRecord.getLong("finbillentryid");
            BigDecimal needDisposeAmt = refundRecord.getBigDecimal("oldsettleamt").subtract(refundRecord.getBigDecimal("newsettleamt"));
            sourceEntryIdToDisposeAmt.merge(finBillEntryId, needDisposeAmt, BigDecimal::add);
            payEntryIdToDisposeAmt.merge(finBillEntryId, needDisposeAmt, BigDecimal::add);
        }
        this.validateFinApBillIsOver(finApBillIds, sourceEntryIdToDisposeAmt);
        this.validateFinArBillIsOver(finArBillIds, sourceEntryIdToDisposeAmt);
        this.validatePayBillIsOver(payBillIds, payEntryIdToDisposeAmt);
    }

    private void validatePayBillIsOver(Set<Long> payBillIds, Map<Long, BigDecimal> payEntryIdToDisposeAmt) {
        DynamicObject[] payBills;
        for (DynamicObject bill : payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"entry.id,entry.e_payableamt,entry.e_settledamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)})) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BigDecimal expectAmt;
                Long entryId = entry.getLong("id");
                BigDecimal disposeAmt = payEntryIdToDisposeAmt.get(entryId);
                if (disposeAmt == null || (expectAmt = entry.getBigDecimal("e_settledamt").add(disposeAmt)).abs().compareTo(entry.getBigDecimal("e_payableamt").abs()) <= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406.\u5206\u5f55.\u5df2\u7ed3\u7b97\u91d1\u989d\u9700\u2264\u4ed8\u6b3e\u5904\u7406.\u5206\u5f55.\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002", (String)"CancelRefundAndRenoteValidateService_9", (String)"fi-ap-mservice", (Object[])new Object[0]));
            }
        }
    }

    public void validateIsOverPeriod(Set<Long> payIds, Long recId) {
        QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.PAYRECSETTLE.getValue());
        filter.and("mainbillid", "in", payIds);
        filter.and("entry.billid", "=", (Object)recId);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"org,settledate", (QFilter[])filter.toArray());
        if (settleRecords.length == 0) {
            return;
        }
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(1);
        for (DynamicObject result : settleRecords) {
            Date currentDate;
            long orgId = result.getLong("org.id");
            Date date = (Date)currentDateMap.get(orgId);
            if (date != null) {
                currentDate = date;
            } else {
                InitHelper init = new InitHelper(orgId, "ap_init");
                currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                currentDateMap.put(orgId, currentDate);
            }
            if (DateUtils.getDiffDays((Date)result.getDate("settledate"), (Date)currentDate) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u64cd\u4f5c\u8ddf\u786e\u8ba4\u9000\u6b3e\u9000\u7968\u4e0d\u5728\u540c\u4e00\u671f\u95f4\uff0c\u8bf7\u53cd\u5173\u8d26\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_10", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
    }

    private void validatePayBillUpIsExistFinBill(Set<Long> botpToPayFinApBillIds, Set<Long> botpToPayFinArBillIds) {
        if (botpToPayFinApBillIds.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u5b58\u5728\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u8bf7\u624b\u5de5\u5904\u7406\u7ed3\u7b97\u5173\u7cfb\u540e\u518d\u8fdb\u884c\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"CancelRefundAndRenoteValidateService_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        if (botpToPayFinArBillIds.size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0a\u6e38\u5b58\u5728\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u8bf7\u624b\u5de5\u5904\u7406\u7ed3\u7b97\u5173\u7cfb\u540e\u518d\u8fdb\u884c\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"CancelRefundAndRenoteValidateService_1", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
    }

    public void validateFinBillIsWriteOff(Set<Long> botpToPayFinApBillIds, Set<Long> botpToPayFinArBillIds, DynamicObject[] refundRecords) {
        boolean hadwrittenoff;
        if (refundRecords.length != 0) {
            for (DynamicObject refundRecord : refundRecords) {
                String settleRelation = refundRecord.getString("settlerelation");
                long finBillId = refundRecord.getLong("finbillid");
                if ("appaysettle".equals(settleRelation)) {
                    botpToPayFinApBillIds.add(finBillId);
                    continue;
                }
                botpToPayFinArBillIds.add(finBillId);
            }
        }
        if (botpToPayFinApBillIds.size() > 0) {
            DynamicObject[] finApBills;
            for (DynamicObject finApBill : finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billno,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", botpToPayFinApBillIds)})) {
                String billNo = finApBill.getString("billno");
                hadwrittenoff = finApBill.getBoolean("hadwrittenoff");
                if (!hadwrittenoff) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u4ed8\u5355%s\u5df2\u88ab\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u53cd\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u51b2\u9500\u5355\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_2", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
            }
        }
        if (botpToPayFinArBillIds.size() > 0) {
            DynamicObject[] finArBills;
            for (DynamicObject finArBill : finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,billno,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", botpToPayFinArBillIds)})) {
                String billNo = finArBill.getString("billno");
                hadwrittenoff = finArBill.getBoolean("hadwrittenoff");
                if (!hadwrittenoff) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u5c06\u89e6\u53d1\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u4e0e\u8d22\u52a1\u5e94\u6536\u5355\u91cd\u65b0\u7ed3\u7b97\uff0c\u8d22\u52a1\u5e94\u6536\u5355%s\u5df2\u88ab\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002\u82e5\u9700\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u5148\u53cd\u5ba1\u6838\u8d22\u52a1\u5e94\u6536\u51b2\u9500\u5355\u540e\u91cd\u8bd5\u3002", (String)"CancelRefundAndRenoteValidateService_3", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
            }
        }
    }
}

