/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DapVoucherWriteBackFinApService {
    private static final Log logger = LogFactory.getLog(DapVoucherWriteBackFinApService.class);

    public void writeBackFinAp(Map<Long, Set<Long>> map, Map<Long, String> voucherMap, VoucherOperation operation) {
        logger.info("DapVoucherWriteBackFinApService : in writeBackFinAp method.");
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"VoucherWriteBackService", (String)"batchFiApWriteBack", (Object[])new Object[]{operation.getValue(), map, voucherMap});
        this.updateApInvoice(map);
    }

    private void updateApInvoice(Map<Long, Set<Long>> map) {
        DynamicObject[] invoiceBills;
        DynamicObject[] finApBills;
        logger.info("DapVoucherWriteBackFinApService begin to update invoice synstatus.");
        Iterator<Map.Entry<Long, Set<Long>>> iterator = map.entrySet().iterator();
        HashSet billIds = new HashSet(64);
        while (iterator.hasNext()) {
            Map.Entry<Long, Set<Long>> next = iterator.next();
            billIds.addAll(next.getValue());
        }
        HashSet<Long> allInvoiceIds = new HashSet<Long>(64);
        for (DynamicObject finApBill : finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,inventry.i_usedamt,inventry.invid", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)})) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                if (BigDecimal.ZERO.compareTo(invRow.getBigDecimal("i_usedamt")) == 0) continue;
                allInvoiceIds.add(invRow.getLong("invid"));
            }
        }
        logger.info("DapVoucherWriteBackFinApService need to update allInvoiceIds size is : " + allInvoiceIds.size());
        if (allInvoiceIds.isEmpty()) {
            return;
        }
        for (DynamicObject invoiceBill : invoiceBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,synstatus,changesynstatustime", (QFilter[])new QFilter[]{new QFilter("id", "in", allInvoiceIds), new QFilter("serialno", "not in", Arrays.asList(" ", ""))})) {
            invoiceBill.set("synstatus", (Object)"waitsynchro");
            invoiceBill.set("changesynstatustime", (Object)new Date());
        }
        if (invoiceBills.length != 0) {
            SaveServiceHelper.update((DynamicObject[])invoiceBills);
        }
    }
}

