/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.vo.DisposeValidateParam;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.vo.Result;

@Deprecated
public class DisposeValidateApi {
    private static final Log logger = LogFactory.getLog(DisposeValidateApi.class);

    public Result validate(String paramJson) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"validateApi");){
            Result result;
            logger.info("DisposeValidateApi.validate param:" + paramJson);
            List params = JSON.parseArray((String)paramJson, DisposeValidateParam.class);
            String sourceType = ((DisposeValidateParam)params.get(0)).getSourceType();
            HashMap<Long, DisposerInfo> billMap = new HashMap<Long, DisposerInfo>(8);
            HashSet<Long> sourceIdSet = new HashSet<Long>(params.size());
            for (DisposeValidateParam param : params) {
                Long sourceEntryId = param.getSourceEntryId();
                Long sourceId = param.getSourceId();
                BigDecimal disposeAmt = param.getEntryRefundAmt();
                billMap.put(sourceEntryId, new DisposerInfo(sourceId, disposeAmt));
                sourceIdSet.add(sourceId);
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)sourceType, (String)String.join((CharSequence)",", this.getSelectors(sourceType)), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceIdSet.toArray())});
            boolean validateResult = this.validateBill(billMap, bills, sourceType);
            logger.info("DisposeValidateApi.validate result:sourceType:" + sourceType + "---validateResult");
            if (!validateResult) {
                result = Result.fail((String)"999", (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355.\u5355\u636e\u4f53.\u5df2\u4ed8\u6b3e\u91d1\u989d\u9700\u2264\u4ed8\u6b3e\u7533\u8bf7\u5355.\u5355\u636e\u4f53.\u6838\u51c6\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002", (String)"DisposeValidateApi_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
                return result;
            }
            result = Result.success();
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            tx.markRollback();
            Result result = Result.ex((Throwable)e);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private boolean validateBill(Map<Long, DisposerInfo> billMap, DynamicObject[] bills, String sourceType) {
        switch (sourceType) {
            case "ap_payapply": {
                for (DynamicObject bill : bills) {
                    DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        Long entryId = entry.getLong("id");
                        DisposerInfo disposerInfo = billMap.get(entryId);
                        if (disposerInfo == null) continue;
                        BigDecimal disposeAmt = disposerInfo.getDisposeAmt();
                        BigDecimal expectAmt = entry.getBigDecimal("lockedamt").add(disposeAmt);
                        if (expectAmt.compareTo(entry.getBigDecimal("e_approvedamt")) <= 0) continue;
                        return false;
                    }
                }
                break;
            }
            case "ar_finarbill": {
                for (DynamicObject bill : bills) {
                    BigDecimal expectAmt;
                    BigDecimal disposeAmt;
                    DisposerInfo disposerInfo;
                    Long entryId;
                    DynamicObjectCollection entries;
                    Long orgId = bill.getLong("org.id");
                    if (ArApHelper.getArSettleParam((Object)orgId) == 1) {
                        entries = bill.getDynamicObjectCollection("entry");
                        for (DynamicObject entry : entries) {
                            entryId = entry.getLong("id");
                            disposerInfo = billMap.get(entryId);
                            if (disposerInfo == null) continue;
                            disposeAmt = disposerInfo.getDisposeAmt();
                            expectAmt = entry.getBigDecimal("e_lockedamt").add(disposeAmt);
                            if (expectAmt.compareTo(entry.getBigDecimal("e_recamount")) <= 0) continue;
                            return false;
                        }
                        continue;
                    }
                    entries = bill.getDynamicObjectCollection("planentity");
                    for (DynamicObject entry : entries) {
                        entryId = entry.getLong("id");
                        disposerInfo = billMap.get(entryId);
                        if (disposerInfo == null) continue;
                        disposeAmt = disposerInfo.getDisposeAmt();
                        expectAmt = entry.getBigDecimal("planlockedamt").add(disposeAmt);
                        if (expectAmt.compareTo(entry.getBigDecimal("planpricetax")) <= 0) continue;
                        return false;
                    }
                }
                break;
            }
            case "ap_finapbill": {
                for (DynamicObject bill : bills) {
                    BigDecimal expectAmt;
                    BigDecimal disposeAmt;
                    DisposerInfo disposerInfo;
                    Long entryId;
                    DynamicObjectCollection entries;
                    Long orgId = bill.getLong("org.id");
                    if (ArApHelper.getApSettleParam((Object)orgId) == 1) {
                        entries = bill.getDynamicObjectCollection("detailentry");
                        for (DynamicObject entry : entries) {
                            entryId = entry.getLong("id");
                            disposerInfo = billMap.get(entryId);
                            if (disposerInfo == null) continue;
                            disposeAmt = disposerInfo.getDisposeAmt();
                            expectAmt = entry.getBigDecimal("lockedamt").add(disposeAmt);
                            if (expectAmt.compareTo(entry.getBigDecimal("e_pricetaxtotal")) <= 0) continue;
                            return false;
                        }
                        continue;
                    }
                    entries = bill.getDynamicObjectCollection("planentity");
                    for (DynamicObject entry : entries) {
                        entryId = entry.getLong("id");
                        disposerInfo = billMap.get(entryId);
                        if (disposerInfo == null) continue;
                        disposeAmt = disposerInfo.getDisposeAmt();
                        expectAmt = entry.getBigDecimal("planlockedamt").add(disposeAmt);
                        if (expectAmt.compareTo(entry.getBigDecimal("planpricetax")) <= 0) continue;
                        return false;
                    }
                }
                break;
            }
        }
        return true;
    }

    private List<String> getSelectors(String sourceType) {
        ArrayList<String> selectors = new ArrayList<String>(4);
        switch (sourceType) {
            case "ap_payapply": {
                selectors.add("id");
                selectors.add("entry.id");
                selectors.add("entry.e_approvedamt");
                selectors.add("entry.lockedamt");
                break;
            }
            case "ar_finarbill": {
                selectors.add("id");
                selectors.add("org.id");
                selectors.add("entry.e_recamount");
                selectors.add("entry.e_lockedamt");
                selectors.add("planentity.planpricetax");
                selectors.add("planentity.planlockedamt");
                break;
            }
            case "ap_finapbill": {
                selectors.add("id");
                selectors.add("org.id");
                selectors.add("detailentry.e_pricetaxtotal");
                selectors.add("detailentry.lockedamt");
                selectors.add("planentity.planpricetax");
                selectors.add("planentity.planlockedamt");
                break;
            }
        }
        return selectors;
    }

    private static class DisposerInfo {
        private Long sourceId;
        private BigDecimal disposeAmt;

        public DisposerInfo(Long sourceId, BigDecimal disposeAmt) {
            this.sourceId = sourceId;
            this.disposeAmt = disposeAmt;
        }

        public Long getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(Long sourceId) {
            this.sourceId = sourceId;
        }

        public BigDecimal getDisposeAmt() {
            return this.disposeAmt;
        }

        public void setDisposeAmt(BigDecimal disposeAmt) {
            this.disposeAmt = disposeAmt;
        }
    }
}

