/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.BOTPConditionHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ExecControlService {
    private static final Log logger = LogFactory.getLog(ExecControlService.class);

    public Map<Long, String> getExecControlInfo(String entityKey, String opName, Set<Long> billIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        logger.info("ExecControlService getExecControlInfo entityKey is " + entityKey + ",opName is " + opName);
        if (EmptyUtils.isEmpty((Object)entityKey) || EmptyUtils.isEmpty((Object)opName)) {
            return result;
        }
        Object[] execControls = ExecCtrlHelper.getNormalExecControl((String)entityKey, (String)opName);
        if (ObjectUtils.isEmpty((Object[])execControls)) {
            return result;
        }
        ArrayList<IOthersExecCtrlService> controlValidators = new ArrayList<IOthersExecCtrlService>(64);
        HashMap<String, String> billDataFilterJsonMap = new HashMap<String, String>(64);
        HashSet selectors = new HashSet(64);
        for (Object execControl : execControls) {
            String dataFilterJson = execControl.getString("datafilterjson_tag");
            try {
                IOthersExecCtrlService execControlValidator = (IOthersExecCtrlService)BeanFactory.getBean(Class.forName(execControl.getString("plugin")), (Object[])new Object[0]);
                controlValidators.add(execControlValidator);
                selectors.addAll(execControlValidator.preparePropertys());
                billDataFilterJsonMap.put(execControl.getString("plugin"), dataFilterJson);
                selectors.addAll(BOTPConditionHelper.getFormulaFieldsName((String)entityKey, (String)dataFilterJson));
            }
            catch (ClassNotFoundException ignored) {
                logger.info("ExecControlService getExecControlInfo ClassNotFoundException is : " + execControl.getString("bizobj.number"));
            }
        }
        logger.info("ExecControlService getExecControlInfo controlValidators size : " + controlValidators.size());
        Object[] otherBills = BusinessDataServiceHelper.load((String)entityKey, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        if (ObjectUtils.isEmpty((Object[])otherBills)) {
            return result;
        }
        for (IOthersExecCtrlService validator : controlValidators) {
            Map messageMap;
            String dataFilterJson = (String)billDataFilterJsonMap.get(validator.getClass().getName());
            ArrayList<Object> needValidatorBills = new ArrayList<Object>(64);
            for (Object otherBill : otherBills) {
                boolean isMatch;
                if (result.containsKey(otherBill.getLong("id")) || !(isMatch = BOTPConditionHelper.isMatch((DynamicObject)otherBill, (String)dataFilterJson))) continue;
                needValidatorBills.add(otherBill);
            }
            if (needValidatorBills.isEmpty() || !EmptyUtils.isNotEmpty((Object)(messageMap = validator.validate(needValidatorBills.toArray(new DynamicObject[0]))))) continue;
            result.putAll(messageMap);
        }
        return result;
    }
}

