/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class FinApReconciliationService {
    private static final Log logger = LogFactory.getLog(FinApReconciliationService.class);
    private static final String[] DAP_FIELD = new String[]{"entity", "voucherid", "sourcebillid"};
    private static final DataType[] DAP_DATATYPE = new DataType[]{DataType.StringType, DataType.LongType, DataType.LongType};
    private static final String APP_CAL_ID = "/KIUHEXROK3D";
    private long orgId;
    private final Map<String, Set<Long>> apAndBusBillIdsMap = new HashMap<String, Set<Long>>(8);
    private final Map<Long, List<Long>> inputArgForBusIdMap = new HashMap<Long, List<Long>>(8);

    public DataSet getApDapRelation(Map<String, Object> paramMap) {
        long begin = System.currentTimeMillis();
        logger.info("FinApReconciliationService getFinApRelation begin.");
        if (ObjectUtils.isEmpty(paramMap)) {
            return null;
        }
        String billType = String.valueOf(paramMap.get("billType"));
        this.orgId = (Long)paramMap.get("org");
        logger.info("FinApReconciliationService getFinApRelation billType is : " + billType + "; orgid is :" + this.orgId);
        DataSet dapDataSet = null;
        if ("ap_journal".equals(billType)) {
            dapDataSet = this.getApJournalDapDataSet(paramMap);
        } else if ("ap_busbill".equals(billType)) {
            dapDataSet = this.getApBusBillDapDataSet(paramMap);
        }
        logger.info("FinApReconciliationService getFinApRelation end,cost time is : " + (System.currentTimeMillis() - begin));
        return dapDataSet;
    }

    private DataSet getApBusBillDapDataSet(Map<String, Object> paramMap) {
        List<Object[]> callCalResult;
        Long periodId = (Long)paramMap.get("period");
        Set billIds = (Set)paramMap.get("billIds");
        ArrayList<Object[]> dapDataSetParams = new ArrayList<Object[]>(64);
        logger.info("FinApReconciliationService getApBusBillDapDataSet periodId :" + periodId);
        QFilter filter = new QFilter("sourcebillid", "in", (Object)billIds);
        filter.and("booktype.accounttype", "=", (Object)"1");
        filter.and("period", "=", (Object)periodId);
        DataSet busApDapDataSet = QueryServiceHelper.queryDataSet((String)"query_bus_dap", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter}, (String)"");
        if (busApDapDataSet.hasNext()) {
            for (Row busApDapRow : busApDapDataSet) {
                Object[] param = new Object[]{"ap_busbill", busApDapRow.getLong("voucherid"), busApDapRow.getLong("sourcebillid")};
                dapDataSetParams.add(param);
                billIds.remove(busApDapRow.getLong("sourcebillid"));
            }
        }
        if (ObjectUtils.isEmpty((Object)billIds)) {
            return this.buildDapDataSet(dapDataSetParams);
        }
        Object dischargeType = SystemParameterHelper.getAppParameter((String)APP_CAL_ID, (Long)this.orgId, (String)"dischargetype");
        QFilter filter1 = new QFilter("id", "in", (Object)billIds);
        filter1.and("org", "=", (Object)this.orgId);
        DynamicObjectCollection allBusApBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,isrevaluation,isadjust,sourcebillid,srcfinbillid,writeoffbusiness,sourcebilltype", (QFilter[])new QFilter[]{filter1});
        HashSet<Long> busSrcBillIds = new HashSet<Long>(64);
        for (DynamicObject busApBill : allBusApBills) {
            if (!"ap_busbill".equals(busApBill.getString("sourcebilltype")) || !busApBill.getBoolean("writeoffbusiness")) continue;
            busSrcBillIds.add(busApBill.getLong("sourcebillid"));
        }
        HashSet<Long> writeOffIds = new HashSet<Long>(64);
        if (!busSrcBillIds.isEmpty()) {
            DataSet writeOffBusIds = QueryServiceHelper.queryDataSet((String)"query_writeoff_bus", (String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", busSrcBillIds), new QFilter("writeoffbusiness", "=", (Object)Boolean.TRUE)}, (String)"");
            for (Row writeOffBusRow : writeOffBusIds) {
                writeOffIds.add(writeOffBusRow.getLong("id"));
            }
        }
        HashMap<Long, List<Long>> srcId4BillIdMap1 = new HashMap<Long, List<Long>>(64);
        HashMap<Long, Long> finApId4BillIdMap2 = new HashMap<Long, Long>(64);
        HashMap<Long, List<Long>> srcId4BillIdMap3 = new HashMap<Long, List<Long>>(64);
        HashMap<Long, List<Long>> srcId4BillIdForSrcFinNullMap3 = new HashMap<Long, List<Long>>(64);
        HashMap<Long, Long> finApId4BillIdMap5 = new HashMap<Long, Long>(64);
        for (DynamicObject busApRow : allBusApBills) {
            List busApBillIds;
            long busSrcBillId = 0L;
            if (!ObjectUtils.isEmpty((Object)busApRow.getString("sourcebillid"))) {
                busSrcBillId = Long.parseLong(busApRow.getString("sourcebillid"));
            }
            if (busApRow.getBoolean("writeoffbusiness") && writeOffIds.contains(busSrcBillId)) continue;
            Long busApId = busApRow.getLong("id");
            long srcFinBillId = busApRow.getLong("srcfinbillid");
            boolean isRevaluation = busApRow.getBoolean("isrevaluation");
            boolean isAdjust = busApRow.getBoolean("isadjust");
            if (!isRevaluation && !isAdjust && busSrcBillId != 0L) {
                busApBillIds = srcId4BillIdMap1.getOrDefault(busSrcBillId, new ArrayList(64));
                busApBillIds.add(busApId);
                srcId4BillIdMap1.put(busSrcBillId, busApBillIds);
            }
            if (isAdjust && "C".equals(dischargeType) && srcFinBillId != 0L) {
                finApId4BillIdMap2.put(srcFinBillId, busApId);
            }
            if (isAdjust && "C".equals(dischargeType) && isRevaluation && busSrcBillId != 0L) {
                busApBillIds = srcId4BillIdMap3.getOrDefault(busSrcBillId, new ArrayList(64));
                busApBillIds.add(busApId);
                srcId4BillIdMap3.put(busSrcBillId, busApBillIds);
                if (srcFinBillId == 0L) {
                    List tempBusApBillIds = srcId4BillIdForSrcFinNullMap3.getOrDefault(busSrcBillId, new ArrayList(64));
                    tempBusApBillIds.add(busApId);
                    srcId4BillIdForSrcFinNullMap3.put(busSrcBillId, tempBusApBillIds);
                }
            }
            if (!isAdjust || !"A".equals(dischargeType) || srcFinBillId == 0L) continue;
            finApId4BillIdMap5.put(srcFinBillId, busApId);
        }
        logger.info("FinApReconciliationService getApBusBillDapDataSet srcId4BillIdMap1 size : " + srcId4BillIdMap1.size());
        List<Object[]> sceneOneResult = this.busApSceneOne(srcId4BillIdMap1, dischargeType);
        logger.info("FinApReconciliationService getApBusBillDapDataSet sceneOneResult size : " + sceneOneResult.size());
        if (!ObjectUtils.isEmpty(sceneOneResult)) {
            dapDataSetParams.addAll(sceneOneResult);
        }
        logger.info("FinApReconciliationService getApBusBillDapDataSet finApId4BillIdMap2 size : " + finApId4BillIdMap2.size());
        List<Object[]> sceneTwoResult = this.busApSceneTwo(finApId4BillIdMap2);
        logger.info("FinApReconciliationService getApBusBillDapDataSet sceneTwoResult size : " + sceneTwoResult.size());
        if (!ObjectUtils.isEmpty(sceneTwoResult)) {
            dapDataSetParams.addAll(sceneTwoResult);
        }
        logger.info("FinApReconciliationService getApBusBillDapDataSet srcId4BillIdMap3 size : " + srcId4BillIdMap3.size());
        List<Object[]> sceneThreeResult = this.busApSceneThree(srcId4BillIdMap3, srcId4BillIdForSrcFinNullMap3);
        logger.info("FinApReconciliationService getApBusBillDapDataSet sceneThreeResult size : " + sceneThreeResult.size());
        if (!ObjectUtils.isEmpty(sceneThreeResult)) {
            dapDataSetParams.addAll(sceneThreeResult);
        }
        logger.info("FinApReconciliationService getApBusBillDapDataSet finApId4BillIdMap5 size : " + finApId4BillIdMap5.size());
        List<Object[]> sceneFiveResult = this.busApSceneFive(finApId4BillIdMap5);
        logger.info("FinApReconciliationService getApBusBillDapDataSet sceneFiveResult size : " + sceneFiveResult.size());
        if (!ObjectUtils.isEmpty(sceneFiveResult)) {
            dapDataSetParams.addAll(sceneFiveResult);
        }
        if (!ObjectUtils.isEmpty(callCalResult = this.callCalInterface())) {
            dapDataSetParams.addAll(callCalResult);
        }
        return this.buildDapDataSet(dapDataSetParams);
    }

    private List<Object[]> busApSceneOne(Map<Long, List<Long>> srcId4BillIdMap, Object dischargeType) {
        if (ObjectUtils.isEmpty(srcId4BillIdMap)) {
            return new ArrayList<Object[]>(8);
        }
        if (!"A".equals(dischargeType) && !"C".equals(dischargeType)) {
            return new ArrayList<Object[]>(8);
        }
        QFilter filter = new QFilter("calorg", "=", (Object)this.orgId);
        filter.and(new QFilter("costaccount.ismainaccount", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("bizbillid", "in", srcId4BillIdMap.keySet()));
        filter.and(new QFilter("bizentityobject.number", "!=", (Object)"im_mdc_omcmplinbill"));
        filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        DataSet calCostDataSet = QueryServiceHelper.queryDataSet((String)"query_cal_costrecord", (String)"cal_costrecord_subentity", (String)"bizbillid,fivoucherid,tempvoucherid,bizentityobject", (QFilter[])new QFilter[]{filter}, (String)"");
        ArrayList<Object[]> sceneOneResult = new ArrayList<Object[]>(64);
        for (Row calCostRow : calCostDataSet) {
            Long busApSrcId = calCostRow.getLong("bizbillid");
            List<Long> busApBillIds = srcId4BillIdMap.get(busApSrcId);
            if (ObjectUtils.isEmpty(busApBillIds)) continue;
            Long vouchId = "A".equals(dischargeType) ? calCostRow.getLong("tempvoucherid") : calCostRow.getLong("fivoucherid");
            for (Long busApBillId : busApBillIds) {
                Object[] param = new Object[]{"ap_busbill", vouchId, busApBillId};
                sceneOneResult.add(param);
            }
        }
        return sceneOneResult;
    }

    private List<Object[]> busApSceneTwo(Map<Long, Long> finApId4BillIdMap) {
        Long finApBillId;
        if (ObjectUtils.isEmpty(finApId4BillIdMap)) {
            return new ArrayList<Object[]>(8);
        }
        ArrayList<Object[]> sceneTwoResult = new ArrayList<Object[]>(64);
        QFilter filter = new QFilter("calorg", "=", (Object)this.orgId);
        filter.and("costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        filter.and("entryentity.srcbillid", "in", finApId4BillIdMap.keySet());
        filter.and("entryentity.invbizentityobject", "!=", (Object)"im_mdc_omcmplinbill");
        filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        DataSet calAdjustDataSet = QueryServiceHelper.queryDataSet((String)"query_cost_adjust", (String)"cal_costadjust_subentity", (String)"entryentity.srcbillid srcbillid,voucherid", (QFilter[])new QFilter[]{filter}, (String)"");
        for (Row calAdjustRow : calAdjustDataSet) {
            finApBillId = calAdjustRow.getLong("srcbillid");
            Long voucherId = calAdjustRow.getLong("voucherid");
            Long busBillId = finApId4BillIdMap.get(finApBillId);
            if (busBillId == null || busBillId == 0L) continue;
            Object[] param = new Object[]{"ap_busbill", voucherId, busBillId};
            sceneTwoResult.add(param);
        }
        for (Map.Entry<Long, Long> entrySet : finApId4BillIdMap.entrySet()) {
            finApBillId = entrySet.getKey();
            List busBillIds = this.inputArgForBusIdMap.getOrDefault(finApBillId, new ArrayList(8));
            busBillIds.add(entrySet.getValue());
            this.inputArgForBusIdMap.put(finApBillId, busBillIds);
            Set finApBillIds = this.apAndBusBillIdsMap.getOrDefault("ap_finapbill", new HashSet(8));
            finApBillIds.add(finApBillId);
            this.apAndBusBillIdsMap.put("ap_finapbill", finApBillIds);
        }
        return sceneTwoResult;
    }

    private List<Object[]> busApSceneThree(Map<Long, List<Long>> srcId4BillIdMap3, Map<Long, List<Long>> srcId4BillIdForSrcFinNullMap3) {
        if (ObjectUtils.isEmpty(srcId4BillIdMap3)) {
            return new ArrayList<Object[]>(8);
        }
        ArrayList<Object[]> sceneThreeResult = new ArrayList<Object[]>(64);
        HashSet busApBillIds = new HashSet(64);
        for (Map.Entry<Long, List<Long>> entrySet : srcId4BillIdMap3.entrySet()) {
            busApBillIds.addAll(entrySet.getValue());
        }
        QFilter filter = new QFilter("calorg", "=", (Object)this.orgId);
        filter.and(new QFilter("costaccount.ismainaccount", "=", (Object)Boolean.TRUE));
        QFilter filter1 = new QFilter("entryentity.srcbillid", "in", busApBillIds);
        filter1.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        DataSet calAdjustDataSet = QueryServiceHelper.queryDataSet((String)"query_cost_adjust", (String)"cal_costadjust_subentity", (String)"entryentity.srcbillid srcbillid,voucherid", (QFilter[])new QFilter[]{filter, filter1}, (String)"");
        for (Object calAdjustRow : calAdjustDataSet) {
            Long busBillId = calAdjustRow.getLong("srcbillid");
            Long voucherId = calAdjustRow.getLong("voucherid");
            Object[] param = new Object[]{"ap_busbill", voucherId, busBillId};
            sceneThreeResult.add(param);
        }
        Set busApBillIds4cal = this.apAndBusBillIdsMap.getOrDefault("ap_busbill", new HashSet(8));
        for (Long busApBillId : busApBillIds) {
            busApBillIds4cal.add(busApBillId);
            List busIds = this.inputArgForBusIdMap.getOrDefault(busApBillId, new ArrayList(8));
            busIds.add(busApBillId);
            this.inputArgForBusIdMap.put(busApBillId, busIds);
        }
        if (srcId4BillIdForSrcFinNullMap3.isEmpty()) {
            this.apAndBusBillIdsMap.put("ap_busbill", busApBillIds4cal);
            return sceneThreeResult;
        }
        QFilter qFilter = new QFilter("revaluasrcbusbillid", "in", srcId4BillIdForSrcFinNullMap3.keySet());
        qFilter.and(new QFilter("org", "=", (Object)this.orgId));
        DataSet revaluaDataSet = QueryServiceHelper.queryDataSet((String)"query_revalua_bill", (String)"ap_busbill", (String)"id,revaluasrcbusbillid", (QFilter[])new QFilter[]{qFilter}, (String)"");
        HashMap<Long, Long> revaluaMap = new HashMap<Long, Long>(32);
        for (Row revaluaRow : revaluaDataSet) {
            Long revaluaId = revaluaRow.getLong("id");
            Long revaluaSrcbusBillId = revaluaRow.getLong("revaluasrcbusbillid");
            revaluaMap.put(revaluaId, revaluaSrcbusBillId);
            List<Long> busBillIds = srcId4BillIdForSrcFinNullMap3.get(revaluaSrcbusBillId);
            if (ObjectUtils.isEmpty(busBillIds)) continue;
            busApBillIds4cal.add(revaluaId);
            List tempBusBillIds = this.inputArgForBusIdMap.getOrDefault(revaluaId, new ArrayList(8));
            tempBusBillIds.addAll(busBillIds);
            this.inputArgForBusIdMap.put(revaluaId, tempBusBillIds);
        }
        this.apAndBusBillIdsMap.put("ap_busbill", busApBillIds4cal);
        QFilter filter2 = new QFilter("entryentity.srcbillid", "in", revaluaMap.keySet());
        filter2.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        DataSet calAdjustDataSet1 = QueryServiceHelper.queryDataSet((String)"query_cost_adjust_1", (String)"cal_costadjust_subentity", (String)"entryentity.srcbillid srcbillid,voucherid", (QFilter[])new QFilter[]{filter, filter2}, (String)"");
        for (Row calAdjustRow : calAdjustDataSet1) {
            Long revaluaBillId = calAdjustRow.getLong("srcbillid");
            Long busSrcBillId = (Long)revaluaMap.get(revaluaBillId);
            if (busSrcBillId == null || busSrcBillId == 0L) continue;
            Long voucherId = calAdjustRow.getLong("voucherid");
            List<Long> busBillIds = srcId4BillIdForSrcFinNullMap3.get(busSrcBillId);
            if (ObjectUtils.isEmpty(busApBillIds)) continue;
            for (Long busBillId : busBillIds) {
                Object[] param = new Object[]{"ap_busbill", voucherId, busBillId};
                sceneThreeResult.add(param);
            }
        }
        return sceneThreeResult;
    }

    private List<Object[]> busApSceneFive(Map<Long, Long> finApId4BillIdMap) {
        if (ObjectUtils.isEmpty(finApId4BillIdMap)) {
            return new ArrayList<Object[]>(8);
        }
        QFilter filter = new QFilter("key", "=", (Object)"iswriteoffplan");
        filter.and(new QFilter("org", "=", (Object)this.orgId));
        filter.and(new QFilter("value", "=", (Object)"1"));
        DynamicObject imInvdbParam = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (String)"id,key", (QFilter[])new QFilter[]{filter});
        boolean isNewVerify = imInvdbParam != null;
        HashMap<Long, Long> verifyRecordIdMap = new HashMap<Long, Long>(64);
        QFilter filter1 = new QFilter("org", "=", (Object)this.orgId);
        filter1.and(new QFilter("entry.e_billid", "in", finApId4BillIdMap.keySet()));
        filter1.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
        String selectors = isNewVerify ? "id,entry.e_billid e_billid,billtype.number billtype" : "id,entry.e_billid e_billid,billtype";
        DataSet apVerifyRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_verify_record", (String)(isNewVerify ? "cal_purwfrecord" : "ap_verifyrecord"), (String)selectors, (QFilter[])new QFilter[]{filter1}, (String)"");
        HashSet<Long> notNeedVoucherRecordIds = new HashSet<Long>(8);
        for (Row verifyRecordRow : apVerifyRecordDataSet) {
            Long recordId = verifyRecordRow.getLong("id");
            verifyRecordIdMap.put(recordId, verifyRecordRow.getLong("e_billid"));
            if (!"im_mdc_omcmplinbill".equals(verifyRecordRow.getString("billtype"))) continue;
            notNeedVoucherRecordIds.add(recordId);
        }
        QFilter filter2 = new QFilter("calorg", "=", (Object)this.orgId);
        filter2.and("costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        filter2.and("entry.writeoffid", "in", verifyRecordIdMap.keySet());
        filter2.and(new QFilter("bizentityobject.number", "!=", (Object)"im_mdc_omcmplinbill"));
        filter2.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_cost_record", (String)"cal_costrecord_subentity", (String)"entry.writeoffid writeoffid,dischargevoucherid voucherid", (QFilter[])new QFilter[]{filter2}, (String)"");
        ArrayList<Object[]> sceneFiveResult = new ArrayList<Object[]>(64);
        for (Row costRecordRow : costRecordDataSet) {
            Long busApBillId;
            Long finApBillId;
            Long verifyRecordId = costRecordRow.getLong("writeoffid");
            Long voucherId = costRecordRow.getLong("voucherid");
            if (voucherId == null || voucherId == 0L || (finApBillId = (Long)verifyRecordIdMap.get(verifyRecordId)) == null || finApBillId == 0L || (busApBillId = finApId4BillIdMap.get(finApBillId)) == null || busApBillId == 0L) continue;
            Object[] param = new Object[]{"ap_busbill", voucherId, busApBillId};
            sceneFiveResult.add(param);
            verifyRecordIdMap.remove(verifyRecordId);
        }
        if (verifyRecordIdMap.isEmpty()) {
            return sceneFiveResult;
        }
        for (Long notNeedVoucherRecordId : notNeedVoucherRecordIds) {
            verifyRecordIdMap.remove(notNeedVoucherRecordId);
        }
        if (verifyRecordIdMap.isEmpty()) {
            return sceneFiveResult;
        }
        QFilter filter3 = new QFilter("sourcebillid", "in", verifyRecordIdMap.keySet());
        filter3.and(new QFilter("org", "=", (Object)this.orgId));
        filter3.and(new QFilter("booktype.accounttype", "=", (Object)"1"));
        DataSet aiDapTrackDataSet = QueryServiceHelper.queryDataSet((String)"query_dap_track", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter3}, (String)"");
        for (Row aiDapTrackRow : aiDapTrackDataSet) {
            Long busApBillId;
            Long verifyRecordId = aiDapTrackRow.getLong("sourcebillid");
            Long finApBillId = (Long)verifyRecordIdMap.get(verifyRecordId);
            if (finApBillId == null || finApBillId == 0L || (busApBillId = finApId4BillIdMap.get(finApBillId)) == null || busApBillId == 0L) continue;
            Object[] param = new Object[]{"ap_busbill", aiDapTrackRow.getLong("voucherid"), busApBillId};
            sceneFiveResult.add(param);
        }
        return sceneFiveResult;
    }

    private DataSet buildDapDataSet(List<Object[]> dapDataSetParams) {
        if (ObjectUtils.isEmpty(dapDataSetParams)) {
            return null;
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])DAP_FIELD, (DataType[])DAP_DATATYPE);
        DataSetBuilder builder = Algo.create((String)"FinApReconciliationService.getApBusBillDapDataSet").createDataSetBuilder(rowMeta);
        Iterator<Object[]> iterator = dapDataSetParams.iterator();
        while (iterator.hasNext()) {
            Object[] data;
            Object[] row = data = iterator.next();
            builder.append(row);
        }
        this.apAndBusBillIdsMap.clear();
        this.inputArgForBusIdMap.clear();
        return builder.build();
    }

    private List<Object[]> callCalInterface() {
        logger.info("FinApReconciliationService callCalInterface begin .");
        ArrayList<Object[]> callCalResult = new ArrayList<Object[]>(8);
        if (this.apAndBusBillIdsMap.isEmpty()) {
            return callCalResult;
        }
        String calDiffDataSetStr = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalApBill2StdBillVoucherService", (String)"getDataSetCacheId", (Object[])new Object[]{this.apAndBusBillIdsMap});
        if (ObjectUtils.isEmpty((Object)calDiffDataSetStr)) {
            return callCalResult;
        }
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)calDiffDataSetStr);
        DataSet calDiffDataSet = cacheDataSet.toDataSet(Algo.create((String)"analysis_calcache_todataset"), true);
        for (Row calDiffRow : calDiffDataSet) {
            Long apBillId = calDiffRow.getLong("apbillid");
            Long voucherId = calDiffRow.getLong("voucherid");
            List<Long> busBillIds = this.inputArgForBusIdMap.get(apBillId);
            if (ObjectUtils.isEmpty(busBillIds)) continue;
            for (Long busBillId : busBillIds) {
                Object[] param = new Object[]{"ap_busbill", voucherId, busBillId};
                callCalResult.add(param);
            }
        }
        logger.info("FinApReconciliationService callCalInterface end .");
        return callCalResult;
    }

    private DataSet getApJournalDapDataSet(Map<String, Object> paramMap) {
        Long periodId = (Long)paramMap.get("period");
        Set billIds = (Set)paramMap.get("billIds");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"begindate, enddate");
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)period.getDate("begindate"));
        dateFilter.and(new QFilter("bizdate", "<=", (Object)period.getDate("enddate")));
        dateFilter.and(new QFilter("id", "in", (Object)billIds));
        DataSet arJournalDataSet = QueryServiceHelper.queryDataSet((String)"query_ap_journal", (String)"ap_journal", (String)"id, sourcebilltype entity , sourcebillid", (QFilter[])new QFilter[]{orgFilter, dateFilter}, null);
        QFilter pFilter = new QFilter("period", "=", (Object)periodId);
        pFilter.and(new QFilter("sourcebillid", "in", (Object)billIds));
        DataSet aiDapTrackerDataSet = QueryServiceHelper.queryDataSet((String)"query_ai_daptracker", (String)"ai_daptracker", (String)"billtype.number entity1,sourcebillid sourcebillid1, voucherid voucherid1", (QFilter[])new QFilter[]{orgFilter, pFilter}, null);
        JoinDataSet dapDataSet = arJournalDataSet.join(aiDapTrackerDataSet, JoinType.INNER).on("sourcebillid", "sourcebillid1").on("entity", "entity1").select(new String[]{"id", "entity", "id sourcebillid", "voucherid1 voucherid"});
        return dapDataSet.finish();
    }
}

