/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.PayClearingSettleService;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class PayClearingAutoSettleService
extends AbsAutoSettleService {
    private final PayClearingSettleService settleService = new PayClearingSettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        this.batchAutoSettle(new DynamicObject[]{obj}, isMain);
    }

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        if (isMain) {
            String billNo = objArr[0].getString("billno");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u5df2\u7ecf\u751f\u6210\u6e05\u7b97\u5355\uff0c\u65e0\u6cd5\u53d1\u8d77\u7ed3\u7b97\u3002", (String)"PayClearingAutoSettleService_0", (String)"fi-ap-mservice", (Object[])new Object[0]), billNo));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        DynamicObject[] mains = this.getMainObjs(objArr, scheme);
        this.addSettleLock(mains, objArr);
        this.settleService.settle(mains, objArr, scheme, SettleTypeEnum.AUTO.getValue());
    }

    private DynamicObject[] getMainObjs(DynamicObject[] assts, SettleSchemeVO scheme) {
        HashSet<Long> payIdSet = new HashSet<Long>(1);
        HashSet<Long> paidIdSet = new HashSet<Long>(1);
        for (DynamicObject asst : assts) {
            long sourBillId;
            String sourcebilltype = asst.getString("sourcebilltype");
            DynamicObjectCollection entries = asst.getDynamicObjectCollection("entryentity");
            if ("cas_paybill".equals(sourcebilltype)) {
                for (DynamicObject entry : entries) {
                    sourBillId = entry.getLong("sourcebillid");
                    payIdSet.add(sourBillId);
                }
            }
            if (!"ap_paidbill".equals(sourcebilltype)) continue;
            for (DynamicObject entry : entries) {
                sourBillId = entry.getLong("sourcebillid");
                paidIdSet.add(sourBillId);
            }
        }
        Object[] payArr = new DynamicObject[]{};
        if (payIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", payIdSet)};
            payArr = PayBillHandleHelper.loadPay((QFilter[])filter);
        }
        Object[] paidArr = new DynamicObject[]{};
        if (paidIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", paidIdSet)};
            paidArr = PayBillHandleHelper.loadPaid((QFilter[])filter);
        }
        DynamicObject[] mainBills = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])paidArr);
        scheme.setLiquidateSettle(true);
        scheme.setOnlyByBotp(true);
        if (mainBills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u6e05\u7b97\u5355\u4e0e\u4ed8\u6b3e\u5355\u6216\u671f\u521d\u9884\u4ed8\u5355\u7684\u5173\u8054\u5173\u7cfb\u3002", (String)"PayClearingAutoSettleService_1", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        return mainBills;
    }

    protected void unSettle4Main(DynamicObject[] objs) {
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

